#
# TABLE STRUCTURE FOR: installer
#

DROP TABLE IF EXISTS `installer`;

CREATE TABLE `installer` (
  `id` int(1) NOT NULL,
  `installer_flag` int(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `installer` (`id`, `installer_flag`) VALUES (1, 1);


#
# TABLE STRUCTURE FOR: tbl_account_details
#

DROP TABLE IF EXISTS `tbl_account_details`;

CREATE TABLE `tbl_account_details` (
  `account_details_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `fullname` varchar(160) COLLATE utf8_unicode_ci DEFAULT NULL,
  `employment_id` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `warehouse_id` int(11) DEFAULT NULL,
  `company` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `city` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `country` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `locale` varchar(100) COLLATE utf8_unicode_ci DEFAULT 'en_US',
  `address` varchar(64) COLLATE utf8_unicode_ci DEFAULT '-',
  `phone` varchar(32) COLLATE utf8_unicode_ci DEFAULT '-',
  `mobile` varchar(32) COLLATE utf8_unicode_ci DEFAULT '',
  `skype` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `language` varchar(40) COLLATE utf8_unicode_ci DEFAULT 'english',
  `designations_id` int(11) DEFAULT '0',
  `avatar` varchar(200) COLLATE utf8_unicode_ci DEFAULT 'uploads/default_avatar.jpg',
  `joining_date` date DEFAULT NULL,
  `present_address` text COLLATE utf8_unicode_ci,
  `date_of_birth` date DEFAULT NULL,
  `gender` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `maratial_status` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `father_name` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mother_name` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `passport` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `direction` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`account_details_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ROW_FORMAT=COMPACT;

INSERT INTO `tbl_account_details` (`account_details_id`, `user_id`, `fullname`, `employment_id`, `warehouse_id`, `company`, `city`, `country`, `locale`, `address`, `phone`, `mobile`, `skype`, `language`, `designations_id`, `avatar`, `joining_date`, `present_address`, `date_of_birth`, `gender`, `maratial_status`, `father_name`, `mother_name`, `passport`, `direction`) VALUES ('5', 5, 'Erick Villeta', NULL, NULL, NULL, NULL, NULL, 'en_US', '-', '-', '', '', 'english', 0, 'uploads/default_avatar.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `tbl_account_details` (`account_details_id`, `user_id`, `fullname`, `employment_id`, `warehouse_id`, `company`, `city`, `country`, `locale`, `address`, `phone`, `mobile`, `skype`, `language`, `designations_id`, `avatar`, `joining_date`, `present_address`, `date_of_birth`, `gender`, `maratial_status`, `father_name`, `mother_name`, `passport`, `direction`) VALUES ('6', 6, 'Mark Schiffer', '', 0, '0', NULL, NULL, 'en_AU', '-', '', '', '', 'english', 1, 'uploads/default_avatar.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'ltr');


#
# TABLE STRUCTURE FOR: tbl_accounts
#

DROP TABLE IF EXISTS `tbl_accounts`;

CREATE TABLE `tbl_accounts` (
  `account_id` int(11) NOT NULL AUTO_INCREMENT,
  `account_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `balance` decimal(18,2) NOT NULL DEFAULT '0.00',
  `account_number` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `contact_person` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `contact_phone` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `bank_details` text COLLATE utf8_unicode_ci,
  `permission` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`account_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: tbl_activities
#

DROP TABLE IF EXISTS `tbl_activities`;

CREATE TABLE `tbl_activities` (
  `activities_id` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL,
  `module` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `module_field_id` int(11) DEFAULT NULL,
  `activity` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `activity_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `icon` varchar(32) COLLATE utf8_unicode_ci DEFAULT 'fa-coffee',
  `link` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `value1` text COLLATE utf8_unicode_ci,
  `value2` text COLLATE utf8_unicode_ci,
  `deleted` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`activities_id`)
) ENGINE=InnoDB AUTO_INCREMENT=98 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (46, 5, 'settings', 5, 'activity_save_general_settings', '2023-07-02 17:30:43', 'fa-coffee', NULL, 'Blick Creative Industries Pty Ltd', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (47, 5, 'settings', 5, 'activity_save_theme_settings', '2023-07-02 17:32:29', 'fa-coffee', NULL, 'Blick Creative Industries Pty Ltd', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (48, 5, 'settings', 5, 'activity_save_theme_settings', '2023-07-02 17:32:58', 'fa-coffee', NULL, 'Blick Creative Industries Pty Ltd', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (49, 5, 'settings', 5, 'activity_save_general_settings', '2023-07-02 19:00:11', 'fa-coffee', NULL, 'Blick Creative Industries', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (50, 5, 'settings', 5, 'activity_save_general_settings', '2023-07-05 14:28:48', 'fa-coffee', NULL, 'Blick Creative Industries', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (51, 5, 'settings', 5, 'activity_save_system_settings', '2023-07-05 14:29:52', 'fa-coffee', NULL, 'english', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (52, 5, 'settings', 5, 'activity_save_system_settings', '2023-07-05 14:30:13', 'fa-coffee', NULL, 'english', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (53, 5, 'settings', 5, 'activity_save_system_settings', '2023-07-05 14:30:31', 'fa-coffee', NULL, 'english', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (54, 5, 'settings', 5, 'activity_save_email_settings', '2023-07-05 14:34:08', 'fa-coffee', NULL, 'info@blickcreative.com.au', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (55, 5, 'settings', 5, 'activity_save_theme_settings', '2023-07-05 23:16:44', 'fa-coffee', NULL, 'Blick Creative Industries Pty Ltd', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (56, 5, 'settings', 5, 'activity_save_theme_settings', '2023-07-06 00:37:03', 'fa-coffee', NULL, 'Blick Creative Industries Pty Ltd', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (57, 5, 'settings', 5, 'activity_save_theme_settings', '2023-07-06 00:46:30', 'fa-coffee', NULL, 'Blick Creative Industries Pty Ltd', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (58, 5, 'settings', 5, 'activity_save_theme_settings', '2023-07-06 00:47:46', 'fa-coffee', NULL, 'Blick Creative Industries Pty Ltd', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (59, 5, 'settings', 5, 'activity_save_theme_settings', '2023-07-06 00:48:18', 'fa-coffee', NULL, 'KreativKollectiv', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (60, 5, 'settings', 5, 'activity_save_theme_settings', '2023-07-06 00:48:29', 'fa-coffee', NULL, 'KreativKollectiv', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (61, 5, 'settings', 5, 'activity_save_theme_settings', '2023-07-06 00:48:50', 'fa-coffee', NULL, 'KreativKollectiv', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (62, 5, 'settings', 5, 'activity_save_system_settings', '2023-07-06 18:15:27', 'fa-coffee', NULL, 'english', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (63, 5, 'client', 1, 'activity_update_company', '2023-07-09 19:54:09', 'fa-user', NULL, 'Fifteen Melbourne', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (64, 5, 'departments', NULL, 'activity_added_a_department', '2023-07-09 19:56:32', 'fa-coffee', NULL, '', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (65, 5, 'user', 6, 'activity_added_new_user', '2023-07-09 19:56:39', 'fa-user', NULL, 'mark', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (66, 5, 'user', 6, 'activity_added_new_user', '2023-07-09 19:57:16', 'fa-user', NULL, 'mark', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (67, 5, 'settings', 5, 'activity_save_invoice_settings', '2023-07-12 13:55:33', 'fa-coffee', NULL, 'INV', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (68, 5, 'settings', 5, 'activity_save_invoice_settings', '2023-07-12 13:59:27', 'fa-coffee', NULL, 'INV', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (69, 5, 'settings', 5, 'activity_save_credit_note_settings', '2023-07-12 14:00:15', 'fa-coffee', NULL, 'CN', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (70, 5, 'settings', 5, 'activity_save_estimate_settings', '2023-07-12 14:00:59', 'fa-coffee', NULL, 'EST', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (71, 5, 'settings', 5, 'activity_save_purchase_settings', '2023-07-12 14:13:57', 'fa-coffee', NULL, 'PUR', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (72, 5, 'settings', 5, 'activity_save_system_settings', '2023-07-12 14:14:55', 'fa-coffee', NULL, 'english', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (73, 5, 'invoice', 1, 'activity_taxt_rate_add', '2023-07-12 14:17:21', 'fa-shopping-cart', NULL, 'General Sales Tax (GST)', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (74, 5, 'knowledgebase', 1, 'activity_save_kb_category', '2023-07-12 14:18:24', 'fa-circle-o', '#', 'Installation', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (75, 5, 'knowledgebase', 2, 'activity_save_kb_category', '2023-07-12 14:18:45', 'fa-circle-o', '#', 'Settings', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (76, 5, 'knowledgebase', 3, 'activity_save_kb_category', '2023-07-12 14:19:05', 'fa-circle-o', '#', 'Stock', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (77, 5, 'knowledgebase', 4, 'activity_save_kb_category', '2023-07-12 14:19:27', 'fa-circle-o', '#', 'Attendance', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (78, 5, 'knowledgebase', 5, 'activity_save_kb_category', '2023-07-12 14:19:46', 'fa-circle-o', '#', 'Recruitment', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (79, 5, 'knowledgebase', 6, 'activity_save_kb_category', '2023-07-12 14:19:59', 'fa-circle-o', '#', 'Payroll', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (80, 5, 'knowledgebase', 7, 'activity_save_kb_category', '2023-07-12 14:20:19', 'fa-circle-o', '#', 'Performance', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (81, 5, 'knowledgebase', 8, 'activity_save_kb_category', '2023-07-12 14:20:39', 'fa-circle-o', '#', 'Utilities', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (82, 5, 'knowledgebase', 9, 'activity_save_kb_category', '2023-07-12 14:21:03', 'fa-circle-o', '#', 'Sales', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (83, 5, 'knowledgebase', 10, 'activity_save_kb_category', '2023-07-12 14:21:43', 'fa-circle-o', '#', 'Transactions', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (84, 5, 'knowledgebase', 11, 'activity_save_kb_category', '2023-07-12 14:22:14', 'fa-circle-o', '#', 'More Features', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (85, 5, 'knowledgebase', 12, 'activity_save_kb_category', '2023-07-12 14:22:43', 'fa-circle-o', '#', 'Payment Gateways', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (86, 5, 'knowledgebase', 1, 'activity_save_kb', '2023-07-12 14:24:51', 'fa-circle-o', 'admin/knowledgebase/articles_details/1', 'How to setup a cronjob in cPanel', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (87, 5, 'knowledgebase', 1, 'activity_update_kb', '2023-07-12 14:24:56', 'fa-circle-o', 'admin/knowledgebase/articles_details/1', 'How to setup a cronjob in cPanel', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (88, 5, 'knowledgebase', 2, 'activity_save_kb', '2023-07-12 14:26:49', 'fa-circle-o', 'admin/knowledgebase/articles_details/2', 'Installation Process', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (89, 5, 'knowledgebase', 2, 'activity_update_kb', '2023-07-12 14:27:24', 'fa-circle-o', 'admin/knowledgebase/articles_details/2', 'Installation Process', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (90, 5, 'knowledgebase', 3, 'activity_save_kb', '2023-07-12 14:28:08', 'fa-circle-o', 'admin/knowledgebase/articles_details/3', 'Server Requirements', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (91, 5, 'knowledgebase', 4, 'activity_save_kb', '2023-07-12 14:30:31', 'fa-circle-o', 'admin/knowledgebase/articles_details/4', 'Installing on IIS – Windows Server', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (92, 5, 'knowledgebase', 4, 'activity_update_kb', '2023-07-12 14:31:12', 'fa-circle-o', 'admin/knowledgebase/articles_details/4', 'Installing on IIS – Windows Server', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (93, 5, 'knowledgebase', 4, 'activity_update_kb', '2023-07-12 14:31:22', 'fa-circle-o', 'admin/knowledgebase/articles_details/4', 'Installing on IIS – Windows Server', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (94, 5, 'settings', 5, 'activity_save_projects_settings', '2023-07-12 14:44:19', 'fa-coffee', NULL, 'PROJ', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (95, 5, 'warehouse', 1, 'activity_save_warehouse', '2023-07-12 14:45:38', 'fa-circle-o', NULL, '0 NA', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (96, 5, 'settings', 2, 'customer_group_added', '2023-07-12 15:10:11', 'fa-coffee', NULL, 'Products', NULL, 0);
INSERT INTO `tbl_activities` (`activities_id`, `user`, `module`, `module_field_id`, `activity`, `activity_date`, `icon`, `link`, `value1`, `value2`, `deleted`) VALUES (97, 5, 'settings', 3, 'customer_group_added', '2023-07-12 15:10:43', 'fa-coffee', NULL, 'Services', NULL, 0);


#
# TABLE STRUCTURE FOR: tbl_advance_salary
#

DROP TABLE IF EXISTS `tbl_advance_salary`;

CREATE TABLE `tbl_advance_salary` (
  `advance_salary_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `advance_amount` varchar(200) NOT NULL,
  `deduct_month` varchar(30) DEFAULT NULL,
  `reason` text,
  `request_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `status` tinyint(2) NOT NULL DEFAULT '0' COMMENT '0 =pending,1=accpect , 2 = reject and 3 = paid',
  `approve_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`advance_salary_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_allowed_ip
#

DROP TABLE IF EXISTS `tbl_allowed_ip`;

CREATE TABLE `tbl_allowed_ip` (
  `allowed_ip_id` int(11) NOT NULL AUTO_INCREMENT,
  `allowed_ip` varchar(100) NOT NULL,
  `status` enum('active','reject','pending') DEFAULT 'pending',
  PRIMARY KEY (`allowed_ip_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_announcements
#

DROP TABLE IF EXISTS `tbl_announcements`;

CREATE TABLE `tbl_announcements` (
  `announcements_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` text NOT NULL,
  `description` text NOT NULL,
  `user_id` int(11) NOT NULL,
  `created_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `status` enum('published','unpublished') NOT NULL DEFAULT 'unpublished' COMMENT '0 = unpublished, 1 = published',
  `view_status` tinyint(1) NOT NULL DEFAULT '2' COMMENT '1=Read 2=Unread',
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `all_client` varchar(20) DEFAULT NULL,
  `attachment` text,
  PRIMARY KEY (`announcements_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_assign_item
#

DROP TABLE IF EXISTS `tbl_assign_item`;

CREATE TABLE `tbl_assign_item` (
  `assign_item_id` int(11) NOT NULL AUTO_INCREMENT,
  `stock_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `assign_inventory` int(5) NOT NULL,
  `assign_date` date NOT NULL,
  PRIMARY KEY (`assign_item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_attachments
#

DROP TABLE IF EXISTS `tbl_attachments`;

CREATE TABLE `tbl_attachments` (
  `attachments_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `title` varchar(200) NOT NULL,
  `description` text NOT NULL,
  `upload_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `module` varchar(50) DEFAULT NULL,
  `module_field_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`attachments_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_attachments_files
#

DROP TABLE IF EXISTS `tbl_attachments_files`;

CREATE TABLE `tbl_attachments_files` (
  `uploaded_files_id` int(11) NOT NULL AUTO_INCREMENT,
  `attachments_id` int(11) NOT NULL,
  `files` text NOT NULL,
  `uploaded_path` text NOT NULL,
  `file_name` text NOT NULL,
  `size` int(10) NOT NULL,
  `ext` varchar(100) NOT NULL,
  `is_image` int(2) NOT NULL,
  `image_width` int(5) NOT NULL,
  `image_height` int(5) NOT NULL,
  PRIMARY KEY (`uploaded_files_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_attendance
#

DROP TABLE IF EXISTS `tbl_attendance`;

CREATE TABLE `tbl_attendance` (
  `attendance_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `leave_application_id` int(11) DEFAULT '0',
  `date_in` date DEFAULT NULL,
  `date_out` date DEFAULT NULL,
  `attendance_status` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'status 0=absent 1=present 3 = onleave',
  `clocking_status` tinyint(1) NOT NULL,
  PRIMARY KEY (`attendance_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `tbl_attendance` (`attendance_id`, `user_id`, `leave_application_id`, `date_in`, `date_out`, `attendance_status`, `clocking_status`) VALUES (1, 5, 0, '2023-07-13', '2023-07-13', 0, 0);
INSERT INTO `tbl_attendance` (`attendance_id`, `user_id`, `leave_application_id`, `date_in`, `date_out`, `attendance_status`, `clocking_status`) VALUES (2, 6, 0, '2023-07-13', '2023-07-13', 0, 0);


#
# TABLE STRUCTURE FOR: tbl_award_points
#

DROP TABLE IF EXISTS `tbl_award_points`;

CREATE TABLE `tbl_award_points` (
  `award_points_id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `client_award_point` varchar(100) DEFAULT NULL,
  `user_award_point` varchar(100) DEFAULT NULL,
  `invoices_id` int(11) NOT NULL,
  `payment_status` varchar(100) NOT NULL,
  `date` varchar(40) NOT NULL,
  PRIMARY KEY (`award_points_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_award_program
#

DROP TABLE IF EXISTS `tbl_award_program`;

CREATE TABLE `tbl_award_program` (
  `award_program_id` int(11) NOT NULL AUTO_INCREMENT,
  `program_name` varchar(100) NOT NULL,
  `award_rule_id` int(11) NOT NULL,
  `client_id` int(11) NOT NULL,
  `start_date` varchar(64) NOT NULL,
  `end_date` varchar(64) NOT NULL,
  `description` varchar(200) NOT NULL,
  `status` int(11) NOT NULL,
  PRIMARY KEY (`award_program_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_award_rule
#

DROP TABLE IF EXISTS `tbl_award_rule`;

CREATE TABLE `tbl_award_rule` (
  `award_rule_id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_name` varchar(200) NOT NULL,
  `date_create` date NOT NULL,
  `client_id` int(11) NOT NULL,
  `award_point_from` varchar(20) NOT NULL,
  `award_point_to` varchar(20) NOT NULL,
  `card` int(11) NOT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`award_rule_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_bug
#

DROP TABLE IF EXISTS `tbl_bug`;

CREATE TABLE `tbl_bug` (
  `bug_id` int(11) NOT NULL AUTO_INCREMENT,
  `issue_no` varchar(50) DEFAULT NULL,
  `project_id` int(11) DEFAULT NULL,
  `opportunities_id` int(11) DEFAULT NULL,
  `task_id` int(11) NOT NULL DEFAULT '0',
  `bug_title` varchar(200) NOT NULL,
  `bug_description` text NOT NULL,
  `bug_status` varchar(30) DEFAULT NULL,
  `notes` text,
  `priority` varchar(20) NOT NULL,
  `severity` varchar(20) DEFAULT NULL,
  `reproducibility` text,
  `reporter` int(11) DEFAULT NULL,
  `created_time` timestamp NULL DEFAULT NULL,
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `permission` text,
  `client_visible` varchar(8) DEFAULT NULL,
  PRIMARY KEY (`bug_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_calls
#

DROP TABLE IF EXISTS `tbl_calls`;

CREATE TABLE `tbl_calls` (
  `calls_id` int(11) NOT NULL AUTO_INCREMENT,
  `leads_id` int(11) DEFAULT NULL,
  `opportunities_id` int(11) DEFAULT NULL,
  `client_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `module` varchar(50) DEFAULT NULL,
  `module_field_id` int(11) DEFAULT NULL,
  `date` varchar(20) CHARACTER SET latin1 NOT NULL,
  `call_summary` varchar(200) CHARACTER SET latin1 NOT NULL,
  PRIMARY KEY (`calls_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_card_config
#

DROP TABLE IF EXISTS `tbl_card_config`;

CREATE TABLE `tbl_card_config` (
  `card_config_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `date_create` date DEFAULT NULL,
  `subject_card` int(11) DEFAULT '0',
  `client_name` int(11) DEFAULT '0',
  `membership` int(11) DEFAULT '0',
  `company_name` int(11) DEFAULT '0',
  `member_since` int(11) DEFAULT '0',
  `custom_field` int(11) DEFAULT '0',
  `custom_field_content` varchar(200) DEFAULT NULL,
  `text_color` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`card_config_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_checklists
#

DROP TABLE IF EXISTS `tbl_checklists`;

CREATE TABLE `tbl_checklists` (
  `checklist_id` int(11) NOT NULL AUTO_INCREMENT,
  `module` varchar(32) DEFAULT NULL,
  `module_id` int(11) DEFAULT NULL,
  `description` text,
  `finished` int(11) DEFAULT '0',
  `create_datetime` datetime DEFAULT NULL,
  `added_from` int(11) DEFAULT NULL,
  `finished_from` int(11) DEFAULT NULL,
  `list_order` int(11) DEFAULT NULL,
  PRIMARY KEY (`checklist_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: tbl_client
#

DROP TABLE IF EXISTS `tbl_client`;

CREATE TABLE `tbl_client` (
  `client_id` int(11) NOT NULL AUTO_INCREMENT,
  `primary_contact` int(11) DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `short_note` text COLLATE utf8_unicode_ci,
  `website` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `phone` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mobile` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fax` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `address` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `city` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `zipcode` varchar(20) CHARACTER SET utf8 DEFAULT NULL,
  `currency` varchar(32) COLLATE utf8_unicode_ci DEFAULT 'USD',
  `skype_id` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `linkedin` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `facebook` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `twitter` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `language` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `country` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `vat` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `hosting_company` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `hostname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `port` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `password` text COLLATE utf8_unicode_ci,
  `username` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `client_status` tinyint(1) NOT NULL COMMENT '1 = person and 2 = company',
  `profile_photo` text COLLATE utf8_unicode_ci,
  `date_added` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `leads_id` int(11) DEFAULT NULL,
  `latitude` text COLLATE utf8_unicode_ci,
  `longitude` text COLLATE utf8_unicode_ci,
  `customer_group_id` int(11) DEFAULT NULL,
  `active` varchar(20) CHARACTER SET utf8 DEFAULT NULL,
  `sms_notification` tinyint(1) DEFAULT NULL,
  `permission` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`client_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `tbl_client` (`client_id`, `primary_contact`, `name`, `email`, `short_note`, `website`, `phone`, `mobile`, `fax`, `address`, `city`, `zipcode`, `currency`, `skype_id`, `linkedin`, `facebook`, `twitter`, `language`, `country`, `vat`, `hosting_company`, `hostname`, `port`, `password`, `username`, `client_status`, `profile_photo`, `date_added`, `leads_id`, `latitude`, `longitude`, `customer_group_id`, `active`, `sms_notification`, `permission`) VALUES (1, NULL, 'Fifteen Melbourne', 'tobieputtock@yopmail.com', '', 'http://www.fifteenmelbourne.com.au/', '', '', '', 'B115-117 Collins St', 'Melbourne', '3000', 'AUD', '', '', '', '', 'english', 'Australia', '', '', '', '', NULL, '', 0, NULL, '2023-07-09 19:54:09', NULL, '', '', 1, NULL, NULL, 'all');


#
# TABLE STRUCTURE FOR: tbl_client_menu
#

DROP TABLE IF EXISTS `tbl_client_menu`;

CREATE TABLE `tbl_client_menu` (
  `menu_id` int(11) NOT NULL AUTO_INCREMENT,
  `label` varchar(20) DEFAULT NULL,
  `link` varchar(200) DEFAULT NULL,
  `icon` varchar(50) NOT NULL,
  `parent` int(11) NOT NULL,
  `time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `sort` int(11) NOT NULL,
  `status` int(11) NOT NULL,
  PRIMARY KEY (`menu_id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8;

INSERT INTO `tbl_client_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `time`, `sort`, `status`) VALUES (1, 'projects', 'client/projects', 'fa fa-folder-open-o', 0, '2017-04-20 03:48:26', 3, 0);
INSERT INTO `tbl_client_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `time`, `sort`, `status`) VALUES (2, 'bugs', 'client/bugs', 'fa fa-bug', 0, '2017-04-20 03:48:39', 4, 0);
INSERT INTO `tbl_client_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `time`, `sort`, `status`) VALUES (3, 'invoices', 'client/invoice/manage_invoice', 'fa fa-shopping-cart', 0, '2017-04-20 03:48:42', 5, 0);
INSERT INTO `tbl_client_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `time`, `sort`, `status`) VALUES (4, 'estimates', 'client/estimates', 'fa fa-tachometer', 0, '2017-04-20 03:48:45', 6, 0);
INSERT INTO `tbl_client_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `time`, `sort`, `status`) VALUES (5, 'payments', 'client/invoice/all_payments', 'fa fa-money', 0, '2017-04-20 03:48:48', 7, 0);
INSERT INTO `tbl_client_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `time`, `sort`, `status`) VALUES (6, 'tickets', 'client/tickets', 'fa fa-ticket', 0, '2017-06-12 17:41:21', 8, 0);
INSERT INTO `tbl_client_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `time`, `sort`, `status`) VALUES (7, 'quotations', 'client/quotations', 'fa fa-paste', 0, '2017-04-20 03:48:56', 9, 0);
INSERT INTO `tbl_client_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `time`, `sort`, `status`) VALUES (8, 'users', 'client/user/user_list', 'fa fa-users', 0, '2017-04-20 03:48:59', 10, 0);
INSERT INTO `tbl_client_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `time`, `sort`, `status`) VALUES (9, 'settings', 'client/settings', 'fa fa-cogs', 0, '2017-04-20 03:49:03', 11, 0);
INSERT INTO `tbl_client_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `time`, `sort`, `status`) VALUES (12, 'answered', 'client/tickets/answered', 'fa fa-circle-o', 6, '2017-04-20 03:42:34', 1, 0);
INSERT INTO `tbl_client_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `time`, `sort`, `status`) VALUES (17, 'dashboard', 'client/dashboard', 'icon-speedometer', 0, '2017-04-20 03:47:21', 1, 0);
INSERT INTO `tbl_client_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `time`, `sort`, `status`) VALUES (18, 'mailbox', 'client/mailbox', 'fa fa-envelope', 0, '2017-04-20 03:47:21', 2, 0);
INSERT INTO `tbl_client_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `time`, `sort`, `status`) VALUES (19, 'private_chat', 'chat/conversations', 'fa fa-envelope', 0, '2017-12-10 06:33:43', 12, 0);
INSERT INTO `tbl_client_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `time`, `sort`, `status`) VALUES (20, 'filemanager', 'client/filemanager', 'fa fa-file', 0, '2017-06-03 15:38:23', 2, 1);
INSERT INTO `tbl_client_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `time`, `sort`, `status`) VALUES (21, 'proposals', 'client/proposals', 'fa fa-leaf', 0, '2017-07-21 14:51:08', 7, 1);
INSERT INTO `tbl_client_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `time`, `sort`, `status`) VALUES (22, 'knowledgebase', 'knowledgebase', 'fa fa-question-circle', 0, '2017-11-09 12:34:12', 12, 1);
INSERT INTO `tbl_client_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `time`, `sort`, `status`) VALUES (23, 'refund_items', 'client/invoice/refund_itemslist', 'icon-share-alt', 0, '2019-09-23 12:30:29', 6, 0);


#
# TABLE STRUCTURE FOR: tbl_client_role
#

DROP TABLE IF EXISTS `tbl_client_role`;

CREATE TABLE `tbl_client_role` (
  `client_role_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `menu_id` int(11) NOT NULL,
  PRIMARY KEY (`client_role_id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

INSERT INTO `tbl_client_role` (`client_role_id`, `user_id`, `menu_id`) VALUES (1, 2, 3);
INSERT INTO `tbl_client_role` (`client_role_id`, `user_id`, `menu_id`) VALUES (2, 2, 4);
INSERT INTO `tbl_client_role` (`client_role_id`, `user_id`, `menu_id`) VALUES (3, 2, 6);
INSERT INTO `tbl_client_role` (`client_role_id`, `user_id`, `menu_id`) VALUES (4, 2, 7);
INSERT INTO `tbl_client_role` (`client_role_id`, `user_id`, `menu_id`) VALUES (5, 2, 18);
INSERT INTO `tbl_client_role` (`client_role_id`, `user_id`, `menu_id`) VALUES (6, 2, 19);
INSERT INTO `tbl_client_role` (`client_role_id`, `user_id`, `menu_id`) VALUES (7, 2, 21);
INSERT INTO `tbl_client_role` (`client_role_id`, `user_id`, `menu_id`) VALUES (8, 2, 22);


#
# TABLE STRUCTURE FOR: tbl_clock
#

DROP TABLE IF EXISTS `tbl_clock`;

CREATE TABLE `tbl_clock` (
  `clock_id` int(11) NOT NULL AUTO_INCREMENT,
  `attendance_id` int(11) NOT NULL,
  `clockin_time` time DEFAULT NULL,
  `clockout_time` time DEFAULT NULL,
  `comments` text,
  `clocking_status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1= clockin_time',
  `ip_address` varchar(50) DEFAULT NULL,
  `latitude` varchar(300) DEFAULT NULL,
  `longitude` varchar(300) DEFAULT NULL,
  `location` text,
  PRIMARY KEY (`clock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_clock_history
#

DROP TABLE IF EXISTS `tbl_clock_history`;

CREATE TABLE `tbl_clock_history` (
  `clock_history_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `clock_id` int(11) NOT NULL,
  `clockin_edit` time NOT NULL,
  `clockout_edit` time DEFAULT NULL,
  `reason` varchar(300) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '1=pending and 2 = accept  3= reject',
  `notify_me` tinyint(4) NOT NULL DEFAULT '1',
  `view_status` tinyint(4) NOT NULL DEFAULT '2',
  `request_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`clock_history_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_config
#

DROP TABLE IF EXISTS `tbl_config`;

CREATE TABLE `tbl_config` (
  `config_key` varchar(255) NOT NULL,
  `value` text,
  PRIMARY KEY (`config_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('2checkout_private_key', 'CE6B7C6E-CDC4-404A-80D7-08F40CC0C65D');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('2checkout_publishable_key', 'D188F8DC-3B8A-408E-A479-15A54113C461');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('2checkout_seller_id', '901386312');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('2checkout_status', 'deactive');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('absent_color', 'rgba(247,23,36,0.92)');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('absent_on_calendar', 'on');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('accounting_snapshot', '0');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('active_background', '#1c7086');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('active_color', '#c1c1c1');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('active_cronjob', 'on');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('active_custom_color', '0');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('active_pre_loader', '1');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('advance_salary', 'true');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('advance_salary_email', '1');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('aim_api_login_id', '7F6eJh7uFyD');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('aim_authorize_live ', 'FALSE');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('aim_authorize_status', 'deactive');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('aim_authorize_transaction_key', '64uhZ93mqH6c3MWf');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('allowed_files', 'gif|png|jpeg|jpg|pdf|doc|txt|docx|xls|zip|rar|xls|mp4|ico');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('allowed_radius', '');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('allow_apply_job_from_login', 'TRUE');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('allow_client_project', 'TRUE');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('allow_client_registration', 'TRUE');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('allow_customer_edit_amount', 'No');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('allow_custom_permission', NULL);
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('allow_geo_clock_in', NULL);
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('allow_multiple_client_in_project', NULL);
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('allow_sub_tasks', 'TRUE');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('allow_weekend_excluded_from_leave', NULL);
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('amount_to_words', NULL);
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('amount_to_words_lowercase', NULL);
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('announcements_email', '1');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('api_signature', 'AZxbwZ9bPVPFFf7hCCNemacLJwlCAqoMULHXAenCuJAwtzfjGbkbaIhV');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('aside-collapsed', NULL);
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('aside-float', NULL);
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('attendance_report', '1');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('authorize', 'login id');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('authorize_net_status', 'active');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('authorize_transaction_key', 'transfer key');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('automatic_database_backup', 'on');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('automatic_email_on_recur', 'TRUE');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('auto_check_for_new_notifications', '0');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('auto_close_ticket', '72');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('award_email', '1');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('bank_cash', '0');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('bitcoin_address', NULL);
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('bitcoin_status', 'active');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('body_background', 'rgba(229,252,252,0.81)');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('body_font_size', '');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('braintree_default_account', NULL);
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('braintree_live_or_sandbox', 'TRUE');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('braintree_merchant_id', '9m2qzhrptx7wyccy');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('braintree_private_key', 'aa804bc269d4a9c8d8170ab8aed353b3');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('braintree_public_key', '62grv2dnvfpg599v');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('braintree_status', 'active');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('bugs_color', '#1f3d1c');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('bugs_on_calendar', 'on');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('build', '0');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('ccavenue_access_code', 'AVEB75FA40AM89BEMA');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('ccavenue_enable_test_mode', 'TRUE');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('ccavenue_key', '201F5203749670E18D664192B594B74E');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('ccavenue_merchant_id', '161761');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('ccavenue_status', 'active');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('chat_interval_time', '5');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('client_default_menu', 'a:1:{s:19:\"client_default_menu\";a:12:{i:0;s:2:\"17\";i:1;s:2:\"18\";i:2;s:2:\"20\";i:3;s:1:\"1\";i:4;s:1:\"2\";i:5;s:1:\"3\";i:6;s:1:\"4\";i:7;s:1:\"5\";i:8;s:2:\"21\";i:9;s:1:\"6\";i:10;s:1:\"7\";i:11;s:2:\"22\";}}');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('company_address', '30 Peel Street');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('company_city', 'Collingwood');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('company_country', 'Australia');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('company_domain', 'https://blickcreative.com.au');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('company_email', 'info@blickcreative.com.au');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('company_legal_name', 'Blick Creative Industries Pty Ltd');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('company_logo', 'uploads/KK-ERP.png');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('company_name', 'Blick Creative Industries');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('company_phone', '03 94827022');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('company_phone_2', '');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('company_vat', '30 116 643 577');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('company_zip_code', '3066');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('config_additional_flag', '/novalidate-cert');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('config_host', 'mail.coderitems.com');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('config_imap', '0');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('config_imap_or_pop', 'on');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('config_mailbox', 'INBOX');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('config_password', '1c896e7d0fcbf64bb0921dd4bec18c947d34a5397472bb13b9f9ed95e4fd10dea45f365dde644233b2eef83f34e67cfd2fcc29b99c2835b89e8ecde5cdf233081hQfQaY72VtMiijV4wlVI6nmPwdsrMgJHALC3GCDw8E=');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('config_pop3', '0');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('config_port', '993');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('config_ssl', 'on');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('config_username', 'support@coderitems.com');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('contact_person', 'Mark Schiffer');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('contract_expiration_reminder', '');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('copyright_name', 'KreativKollectiv');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('copyright_url', 'https://kreative-kollective-crm.blickdev.com.au/');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('country', '0');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('credit_note_footer', '');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('credit_note_number_format', '[][dd][mm][yyyy][number]');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('credit_note_prefix', 'CN');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('credit_note_start_no', '1');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('credit_note_terms', '');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('cron_key', '34WI2L12L87I1A65M90M9A42N41D08A26I');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('currency_position', '1');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('date_format', '%d-%m-%Y');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('date_php_format', 'd-m-Y');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('date_picker_format', 'dd-mm-yyyy');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('decimal_separator', '2');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('default_account', '1');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('default_currency', 'AUD');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('default_currency_symbol', '$');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('default_department', NULL);
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('default_language', 'english');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('default_leads_source', '1');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('default_lead_permission', 'all');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('default_lead_status', '1');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('default_payment_method', '0');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('default_priority', 'Medium');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('default_status', 'open');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('default_tax', 'N;');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('default_terms', 'Thank you for <span xss=\"removed\">your</span> busasiness. Please process this invoice within the due date.');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('delete_mail_after_import', NULL);
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('demo_mode', 'FALSE');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('deposit_email', '1');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('desktop_notifications', '1');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('developer', 'ig63Yd/+yuA8127gEyTz9TY4pnoeKq8dtocVP44+BJvtlRp8Vqcetwjk51dhSB6Rx8aVIKOPfUmNyKGWK7C/gg==');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('display_estimate_badge', '0');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('display_invoice_badge', 'FALSE');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('email_account_details', 'TRUE');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('email_estimate_message', 'Hi {CLIENT}<br>Thanks for your business inquiry. <br>The estimate EST {REF} is attached with this email. <br>Estimate Overview:<br>Estimate # : EST {REF}<br>Amount: {CURRENCY} {AMOUNT}<br> You can view the estimate online at:<br>{LINK}<br>Best Regards,<br>{COMPANY}');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('email_invoice_message', 'Hello {CLIENT}<br>Here is the invoice of {CURRENCY} {AMOUNT}<br>You can view the invoice online at:<br>{LINK}<br>Best Regards,<br>{COMPANY}');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('email_staff_tickets', 'TRUE');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('enable_languages', 'TRUE');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('encryption', 'ssl');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('estimate_color', 'rgba(160,29,171,1)');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('estimate_footer', '<span xss=removed>Estimate </span>was created on a computer and is valid without the signature and seal');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('estimate_language', 'en');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('estimate_number_format', '[INV]-[dd]-[mm]-[yyyy]-[number]');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('estimate_on_calendar', 'on');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('estimate_prefix', 'EST');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('estimate_start_no', '1');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('estimate_state', 'block');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('estimate_terms', 'Hey Looking forward to doing business with you.');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('expense_email', '1');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('favicon', 'uploads/favicon_(3).png');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('file_max_size', '80000');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('for_invoice', '0');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('for_leads', NULL);
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('for_tickets', NULL);
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('gcal_api_key', 'AIzaSyBXcmmcboEyAgtoUtXjKXe4TfpsnEtoUDQ');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('gcal_id', 'kla83orf1u7hrj6p0u5gdmpji4@group.calendar.google.com');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('goal_tracking_color', '#537015');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('goal_tracking_on_calendar', 'on');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('google_api_key', 'AIzaSyDH0Cn1U4RGzExl3IySE9X_ZlXKpyxj2Z4');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('gst_state', 'AN');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('holiday_on_calendar', 'on');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('imap_search', '0');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('imap_search_for_leads', NULL);
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('imap_search_for_tickets', NULL);
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('increment_credit_note_number', 'FALSE');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('increment_estimate_number', 'TRUE');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('increment_invoice_number', 'TRUE');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('increment_proposal_number', 'TRUE');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('installed', 'TRUE');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('invoices_due_after', '5');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('invoice_color', '#53b567');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('invoice_footer', 'Invoice was created on a computer and is valid without the signature and seal');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('invoice_language', 'en');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('invoice_layout_pdf', NULL);
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('invoice_layout_view', 'default');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('invoice_logo', 'uploads/kk-inv-logo.png');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('invoice_number_format', '[INV]-[dd]-[mm]-[yyyy]-[number]');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('invoice_on_calendar', 'on');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('invoice_prefix', 'INV');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('invoice_print_view', 'landscape');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('invoice_start_no', '1');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('invoice_state', 'block');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('invoice_view', '0');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('item_total_qty_alert', 'No');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('job_circular_email', '1');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('language', 'english');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('languages', 'spanish');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('last_autobackup', '1515398440');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('last_check', '1436363002');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('last_cronjob_run', '1689243057');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('last_postmaster_run', '1532751856');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('last_seen_activities', '0');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('last_tickets_postmaster_run', '1532750363');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('layout-boxed', NULL);
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('layout-fixed', NULL);
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('layout-h', NULL);
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('leads_color', '#783131');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('leads_keyword', NULL);
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('leads_on_calendar', 'on');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('leave_email', '1');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('locale', 'en_AU');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('login_background', 'uploads/p3.jpg');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('login_bg', 'bg-login.jpg');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('login_position', 'left');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('logofile', '0');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('logo_or_icon', 'logo');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('mark_attendance_from_login', 'Yes');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('max_file_size', '5000');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('milestone_color', '#a86495');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('milestone_on_calendar', 'on');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('mollie_api_key', 'test_tkjFqFF6fP92FDSwBDHpeCzBRMBQBD');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('mollie_partner_id', '3106644');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('mollie_status', 'active');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('money_format', '1');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('navbar_logo_background', 'rgba(104,155,162,0.95)');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('notified_user', '[\"1\"]');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('notify_bug_assignment', 'TRUE');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('notify_bug_comments', 'TRUE');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('notify_bug_status', 'TRUE');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('notify_message_received', 'TRUE');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('notify_project_assignments', 'TRUE');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('notify_project_comments', 'TRUE');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('notify_project_files', 'TRUE');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('notify_task_assignments', 'TRUE');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('notify_ticket_reopened', 'TRUE');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('office_hours', '8');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('office_lat', '');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('office_location', '');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('office_long', '');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('office_time', 'same_time');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('only_allowed_ip_can_clock', NULL);
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('on_leave_color', '#bd1a10');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('on_leave_on_calendar', 'on');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('opportunities_color', '#349685');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('opportunities_on_calendar', 'on');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('overtime_email', '1');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('payments_color', '#7f21c9');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('payments_on_calendar', 'on');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('paypal_api_password', 'e64448f3fd988dda8ad7e0b1ba21a14c3e59a959008623d9c8bcfca8ca8f73677a82bc6d14075614ea192a98fa0494259859dd0e229ff831c1cdd7751f440cb0cS8v4CPtSoiC4rDwMliNLKtf35DXaZih8pZ7W6mRM9UJg9jYeKg0wwsnFA5Kqywv');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('paypal_api_username', 'billing_api1.itsolidity.com');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('paypal_cancel_url', 'paypal/cancel');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('paypal_email', 'billing@coderitems.com');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('paypal_ipn_url', 'paypal/t_ipn/ipn');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('paypal_live', 'TRUE');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('paypal_status', 'active');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('paypal_success_url', 'paypal/success');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('payslip_email', '1');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('payumoney_enable_test_mode', NULL);
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('payumoney_key', '3424');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('payumoney_salt', '342342');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('payumoney_status', 'active');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('pdf_engine', 'invoicr');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('performance_email', '1');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('postmark_api_key', '');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('postmark_from_address', '');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('projects_notes', '');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('projects_number_format', '[][dd][mm][yyyy][number]');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('projects_prefix', 'PROJ');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('projects_start_no', '1');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('project_color', '#e61755');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('project_details_view', '1');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('project_on_calendar', 'on');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('project_prefix', 'PRO');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('proposal_footer', '<span style=\"font-weight: 700; text-align: right;\">This Proposal&nbsp;</span>was created on a computer and is valid without the signature and seal');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('proposal_number_format', '[INV]-[yyyy]-[mm]-[dd]-[number]');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('proposal_prefix', 'PRO-');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('proposal_start_no', '1');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('proposal_terms', 'Hey Looking forward to doing business with you.');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('protocol', 'smtp');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('purchase_code', '');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('purchase_notes', '');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('purchase_number_format', '[INV]-[yyyy]-[mm]-[dd]-[number]');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('purchase_prefix', 'PUR');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('purchase_start_no', '1');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('pusher_app_id', '401479');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('pusher_app_key', '4cf88668659dc9c987c3');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('pusher_app_secret', '6fce183b214d17c20dd5');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('pusher_cluster', 'ap2');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('qty_calculation_from_items', 'Yes');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('realtime_notification', '0');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('recaptcha_secret_key', '');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('recaptcha_site_key', '');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('recurring_invoice', '0');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('reminder_message', 'Hello {CLIENT}<br>This is a friendly reminder to pay your invoice of {CURRENCY} {AMOUNT}<br>You can view the invoice online at:<br>{LINK}<br>Best Regards,<br>{COMPANY}');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('reset_key', '34WI2L12L87I1A65M90M9A42N41D08A26I');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('return_stock_number_format', NULL);
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('return_stock_prefix', NULL);
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('return_stock_start_no', NULL);
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('rows_per_table', '25');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('RTL', '0');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('security_token', '5027133599');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('send_email_when_recur', 'TRUE');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('settings', 'theme');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('show-scrollbar', NULL);
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('show_credit_note_tax', 'FALSE');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('show_estimate_tax', 'TRUE');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('show_invoice_tax', 'TRUE');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('show_item_tax', '0');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('show_login_image', 'TRUE');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('show_only_logo', 'FALSE');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('show_proposal_tax', 'TRUE');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('show_watermark', 'FALSE');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('sidebar_active_background', '#0f778e');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('sidebar_active_color', '#b3b8cb');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('sidebar_background', 'rgba(2,53,60,0.95)');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('sidebar_color', '#fffafa');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('sidebar_font_size', '');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('sidebar_theme', 'bg-info');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('site_appleicon', 'logo.png');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('site_author', 'William M.');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('site_desc', 'Ultimate Project Manager CRM Pro is a Web based PHP application for Freelancers - buy it on Codecanyon');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('site_favicon', 'logo.png');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('site_icon', 'fa-flask');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('smtp_encryption', 'tls');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('smtp_host', 'smtp.gmail.com');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('smtp_pass', 'Tjc3cFRIUkVCOVFRNU5jV0RyVlg3dz09');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('smtp_port', '587');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('smtp_user', 'admin@ibuildawesomewebsite.com');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('stripe_private_key', 'sk_test_g7PUZTcwwFnxdlHrWSOicHfu');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('stripe_public_key', 'pk_test_x9as1c9jBDpODI7IbC7D0MEB');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('stripe_status', 'active');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('submenu_open_background', '#227f85');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('system_font', 'roboto_condensed');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('tables_pagination_limit', '10');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('tasks_color', '#0239c7');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('tasks_on_calendar', 'on');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('task_details_view', '1');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('thousand_separator', ',');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('tickets_keyword', NULL);
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('timezone', 'Australia/Melbourne');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('time_format', 'g:i a');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('top_bar_background', '#1f9494');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('top_bar_color', '#d9d9d9');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('training_email', '1');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('two_checkout_live ', 'FALSE');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('unread_email', 'on');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('update_stock_when_make_payment', NULL);
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('use_gravatar', 'TRUE');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('use_postmark', 'FALSE');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('valid_license', 'TRUE');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('version', '6.0.4');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('webmaster_email', 'support@example.com');
INSERT INTO `tbl_config` (`config_key`, `value`) VALUES ('website_name', 'KreativKollectiv');


#
# TABLE STRUCTURE FOR: tbl_contract_type
#

DROP TABLE IF EXISTS `tbl_contract_type`;

CREATE TABLE `tbl_contract_type` (
  `contract_type_id` int(11) NOT NULL AUTO_INCREMENT,
  `contract_type` varchar(200) CHARACTER SET latin1 DEFAULT NULL,
  `description` varchar(500) CHARACTER SET latin1 DEFAULT NULL,
  PRIMARY KEY (`contract_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_countries
#

DROP TABLE IF EXISTS `tbl_countries`;

CREATE TABLE `tbl_countries` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `value` varchar(250) CHARACTER SET latin1 NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=242 DEFAULT CHARSET=utf8;

INSERT INTO `tbl_countries` (`id`, `value`) VALUES (1, 'Afghanistan');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (2, 'Aringland Islands');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (3, 'Albania');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (4, 'Algeria');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (5, 'American Samoa');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (6, 'Andorra');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (7, 'Angola');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (8, 'Anguilla');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (9, 'Antarctica');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (10, 'Antigua and Barbuda');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (11, 'Argentina');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (12, 'Armenia');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (13, 'Aruba');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (14, 'Australia');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (15, 'Austria');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (16, 'Azerbaijan');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (17, 'Bahamas');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (18, 'Bahrain');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (19, 'Bangladesh');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (20, 'Barbados');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (21, 'Belarus');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (22, 'Belgium');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (23, 'Belize');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (24, 'Benin');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (25, 'Bermuda');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (26, 'Bhutan');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (27, 'Bolivia');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (28, 'Bosnia and Herzegovina');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (29, 'Botswana');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (30, 'Bouvet Island');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (31, 'Brazil');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (32, 'British Indian Ocean territory');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (33, 'Brunei Darussalam');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (34, 'Bulgaria');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (35, 'Burkina Faso');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (36, 'Burundi');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (37, 'Cambodia');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (38, 'Cameroon');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (39, 'Canada');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (40, 'Cape Verde');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (41, 'Cayman Islands');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (42, 'Central African Republic');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (43, 'Chad');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (44, 'Chile');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (45, 'China');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (46, 'Christmas Island');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (47, 'Cocos (Keeling) Islands');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (48, 'Colombia');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (49, 'Comoros');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (50, 'Congo');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (51, 'Congo');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (52, ' Democratic Republic');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (53, 'Cook Islands');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (54, 'Costa Rica');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (55, 'Ivory Coast (Ivory Coast)');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (56, 'Croatia (Hrvatska)');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (57, 'Cuba');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (58, 'Cyprus');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (59, 'Czech Republic');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (60, 'Denmark');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (61, 'Djibouti');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (62, 'Dominica');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (63, 'Dominican Republic');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (64, 'East Timor');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (65, 'Ecuador');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (66, 'Egypt');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (67, 'El Salvador');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (68, 'Equatorial Guinea');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (69, 'Eritrea');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (70, 'Estonia');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (71, 'Ethiopia');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (72, 'Falkland Islands');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (73, 'Faroe Islands');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (74, 'Fiji');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (75, 'Finland');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (76, 'France');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (77, 'French Guiana');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (78, 'French Polynesia');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (79, 'French Southern Territories');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (80, 'Gabon');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (81, 'Gambia');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (82, 'Georgia');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (83, 'Germany');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (84, 'Ghana');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (85, 'Gibraltar');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (86, 'Greece');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (87, 'Greenland');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (88, 'Grenada');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (89, 'Guadeloupe');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (90, 'Guam');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (91, 'Guatemala');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (92, 'Guinea');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (93, 'Guinea-Bissau');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (94, 'Guyana');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (95, 'Haiti');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (96, 'Heard and McDonald Islands');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (97, 'Honduras');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (98, 'Hong Kong');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (99, 'Hungary');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (100, 'Iceland');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (101, 'India');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (102, 'Indonesia');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (103, 'Iran');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (104, 'Iraq');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (105, 'Ireland');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (106, 'Israel');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (107, 'Italy');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (108, 'Jamaica');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (109, 'Japan');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (110, 'Jordan');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (111, 'Kazakhstan');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (112, 'Kenya');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (113, 'Kiribati');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (114, 'Korea (north)');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (115, 'Korea (south)');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (116, 'Kuwait');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (117, 'Kyrgyzstan');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (118, 'Lao People\'s Democratic Republic');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (119, 'Latvia');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (120, 'Lebanon');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (121, 'Lesotho');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (122, 'Liberia');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (123, 'Libyan Arab Jamahiriya');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (124, 'Liechtenstein');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (125, 'Lithuania');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (126, 'Luxembourg');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (127, 'Macao');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (128, 'Macedonia');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (129, 'Madagascar');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (130, 'Malawi');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (131, 'Malaysia');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (132, 'Maldives');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (133, 'Mali');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (134, 'Malta');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (135, 'Marshall Islands');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (136, 'Martinique');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (137, 'Mauritania');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (138, 'Mauritius');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (139, 'Mayotte');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (140, 'Mexico');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (141, 'Micronesia');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (142, 'Moldova');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (143, 'Monaco');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (144, 'Mongolia');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (145, 'Montserrat');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (146, 'Morocco');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (147, 'Mozambique');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (148, 'Myanmar');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (149, 'Namibia');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (150, 'Nauru');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (151, 'Nepal');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (152, 'Netherlands');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (153, 'Netherlands Antilles');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (154, 'New Caledonia');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (155, 'New Zealand');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (156, 'Nicaragua');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (157, 'Niger');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (158, 'Nigeria');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (159, 'Niue');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (160, 'Norfolk Island');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (161, 'Northern Mariana Islands');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (162, 'Norway');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (163, 'Oman');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (164, 'Pakistan');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (165, 'Palau');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (166, 'Palestinian Territories');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (167, 'Panama');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (168, 'Papua New Guinea');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (169, 'Paraguay');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (170, 'Peru');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (171, 'Philippines');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (172, 'Pitcairn');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (173, 'Poland');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (174, 'Portugal');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (175, 'Puerto Rico');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (176, 'Qatar');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (177, 'Runion');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (178, 'Romania');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (179, 'Russian Federation');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (180, 'Rwanda');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (181, 'Saint Helena');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (182, 'Saint Kitts and Nevis');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (183, 'Saint Lucia');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (184, 'Saint Pierre and Miquelon');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (185, 'Saint Vincent and the Grenadines');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (186, 'Samoa');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (187, 'San Marino');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (188, 'Sao Tome and Principe');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (189, 'Saudi Arabia');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (190, 'Senegal');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (191, 'Serbia and Montenegro');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (192, 'Seychelles');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (193, 'Sierra Leone');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (194, 'Singapore');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (195, 'Slovakia');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (196, 'Slovenia');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (197, 'Solomon Islands');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (198, 'Somalia');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (199, 'South Africa');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (200, 'South Georgia and the South Sandwich Islands');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (201, 'Spain');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (202, 'Sri Lanka');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (203, 'Sudan');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (204, 'Suriname');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (205, 'Svalbard and Jan Mayen Islands');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (206, 'Swaziland');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (207, 'Sweden');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (208, 'Switzerland');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (209, 'Syria');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (210, 'Taiwan');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (211, 'Tajikistan');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (212, 'Tanzania');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (213, 'Thailand');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (214, 'Togo');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (215, 'Tokelau');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (216, 'Tonga');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (217, 'Trinidad and Tobago');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (218, 'Tunisia');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (219, 'Turkey');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (220, 'Turkmenistan');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (221, 'Turks and Caicos Islands');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (222, 'Tuvalu');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (223, 'Uganda');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (224, 'Ukraine');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (225, 'United Arab Emirates');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (226, 'United Kingdom');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (227, 'United States of America');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (228, 'Uruguay');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (229, 'Uzbekistan');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (230, 'Vanuatu');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (231, 'Vatican City');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (232, 'Venezuela');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (233, 'Vietnam');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (234, 'Virgin Islands (British)');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (235, 'Virgin Islands (US)');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (236, 'Wallis and Futuna Islands');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (237, 'Western Sahara');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (238, 'Yemen');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (239, 'Zaire');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (240, 'Zambia');
INSERT INTO `tbl_countries` (`id`, `value`) VALUES (241, 'Zimbabwe');


#
# TABLE STRUCTURE FOR: tbl_credit_note
#

DROP TABLE IF EXISTS `tbl_credit_note`;

CREATE TABLE `tbl_credit_note` (
  `credit_note_id` int(11) NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(32) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `client_id` int(11) DEFAULT NULL,
  `project_id` int(11) DEFAULT '0',
  `credit_note_date` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `credit_note_month` varchar(20) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `credit_note_year` varchar(10) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `currency` varchar(32) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT 'USD',
  `discount_percent` int(2) DEFAULT NULL,
  `notes` text CHARACTER SET utf8 COLLATE utf8_unicode_ci,
  `tax` int(11) NOT NULL DEFAULT '0',
  `total_tax` text CHARACTER SET utf8 COLLATE utf8_unicode_ci,
  `status` varchar(20) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'open',
  `date_saved` timestamp NOT NULL DEFAULT '2018-12-12 16:00:00',
  `emailed` varchar(11) DEFAULT NULL,
  `permission` text CHARACTER SET utf8 COLLATE utf8_unicode_ci,
  `client_visible` varchar(20) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'No',
  `discount_type` enum('none','before_tax','after_tax') NOT NULL DEFAULT 'none',
  `user_id` int(11) NOT NULL DEFAULT '0' COMMENT 'sales agent',
  `adjustment` decimal(18,2) NOT NULL DEFAULT '0.00',
  `discount_total` decimal(18,2) NOT NULL DEFAULT '0.00',
  `show_quantity_as` varchar(20) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `warehouse_id` int(11) DEFAULT NULL,
  `tags` text,
  PRIMARY KEY (`credit_note_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_credit_note_items
#

DROP TABLE IF EXISTS `tbl_credit_note_items`;

CREATE TABLE `tbl_credit_note_items` (
  `credit_note_items_id` int(11) NOT NULL AUTO_INCREMENT,
  `credit_note_id` int(11) NOT NULL,
  `saved_items_id` int(11) DEFAULT '0',
  `item_tax_rate` decimal(10,2) NOT NULL DEFAULT '0.00',
  `item_tax_name` text CHARACTER SET utf8 COLLATE utf8_unicode_ci,
  `item_name` varchar(150) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT 'Item Name',
  `item_desc` longtext CHARACTER SET utf8 COLLATE utf8_unicode_ci,
  `unit_cost` decimal(10,2) DEFAULT '0.00',
  `quantity` decimal(10,2) DEFAULT '0.00',
  `item_tax_total` decimal(10,2) DEFAULT '0.00',
  `total_cost` decimal(10,2) DEFAULT '0.00',
  `date_saved` timestamp NOT NULL DEFAULT '2018-12-12 16:00:00',
  `unit` varchar(200) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `hsn_code` text CHARACTER SET utf8 COLLATE utf8_unicode_ci,
  `order` int(11) DEFAULT '0',
  PRIMARY KEY (`credit_note_items_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_credit_used
#

DROP TABLE IF EXISTS `tbl_credit_used`;

CREATE TABLE `tbl_credit_used` (
  `credit_used_id` int(11) NOT NULL AUTO_INCREMENT,
  `invoices_id` int(11) NOT NULL,
  `credit_note_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `date_applied` datetime NOT NULL,
  `amount` decimal(18,3) NOT NULL,
  `payments_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`credit_used_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_currencies
#

DROP TABLE IF EXISTS `tbl_currencies`;

CREATE TABLE `tbl_currencies` (
  `code` varchar(5) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `symbol` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `xrate` decimal(12,5) DEFAULT NULL,
  PRIMARY KEY (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `tbl_currencies` (`code`, `name`, `symbol`, `xrate`) VALUES ('AUD', 'Australian Dollar', '$', NULL);
INSERT INTO `tbl_currencies` (`code`, `name`, `symbol`, `xrate`) VALUES ('BAN', 'Bangladesh', 'BDT', NULL);
INSERT INTO `tbl_currencies` (`code`, `name`, `symbol`, `xrate`) VALUES ('BRL', 'Brazilian Real', 'R$', NULL);
INSERT INTO `tbl_currencies` (`code`, `name`, `symbol`, `xrate`) VALUES ('CAD', 'Canadian Dollar', '$', NULL);
INSERT INTO `tbl_currencies` (`code`, `name`, `symbol`, `xrate`) VALUES ('CHF', 'Swiss Franc', 'Fr', NULL);
INSERT INTO `tbl_currencies` (`code`, `name`, `symbol`, `xrate`) VALUES ('CLP', 'Chilean Peso', '$', NULL);
INSERT INTO `tbl_currencies` (`code`, `name`, `symbol`, `xrate`) VALUES ('CNY', 'Chinese Yuan', 'Ãƒâ€š', NULL);
INSERT INTO `tbl_currencies` (`code`, `name`, `symbol`, `xrate`) VALUES ('CZK', 'Czech Koruna', 'KÃƒâ€', NULL);
INSERT INTO `tbl_currencies` (`code`, `name`, `symbol`, `xrate`) VALUES ('DKK', 'Danish Krone', 'kr', NULL);
INSERT INTO `tbl_currencies` (`code`, `name`, `symbol`, `xrate`) VALUES ('EUR', 'Euro', 'ÃƒÂ¢Ã', NULL);
INSERT INTO `tbl_currencies` (`code`, `name`, `symbol`, `xrate`) VALUES ('GBP', 'British Pound', 'Ãƒâ€š', NULL);
INSERT INTO `tbl_currencies` (`code`, `name`, `symbol`, `xrate`) VALUES ('HKD', 'Hong Kong Dollar', '$', NULL);
INSERT INTO `tbl_currencies` (`code`, `name`, `symbol`, `xrate`) VALUES ('HUF', 'Hungarian Forint', 'Ft', NULL);
INSERT INTO `tbl_currencies` (`code`, `name`, `symbol`, `xrate`) VALUES ('IDR', 'Indonesian Rupiah', 'Rp', NULL);
INSERT INTO `tbl_currencies` (`code`, `name`, `symbol`, `xrate`) VALUES ('ILS', 'Israeli New Shekel', 'ÃƒÂ¢Ã', NULL);
INSERT INTO `tbl_currencies` (`code`, `name`, `symbol`, `xrate`) VALUES ('INR', 'Indian Rupee', 'â‚¹', NULL);
INSERT INTO `tbl_currencies` (`code`, `name`, `symbol`, `xrate`) VALUES ('JPY', 'Japanese Yen', 'Ãƒâ€š', NULL);
INSERT INTO `tbl_currencies` (`code`, `name`, `symbol`, `xrate`) VALUES ('KRW', 'Korean Won', 'ÃƒÂ¢Ã', NULL);
INSERT INTO `tbl_currencies` (`code`, `name`, `symbol`, `xrate`) VALUES ('MXN', 'Mexican Peso', '$', NULL);
INSERT INTO `tbl_currencies` (`code`, `name`, `symbol`, `xrate`) VALUES ('MYR', 'Malaysian Ringgit', 'RM', NULL);
INSERT INTO `tbl_currencies` (`code`, `name`, `symbol`, `xrate`) VALUES ('NOK', 'Norwegian Krone', 'kr', NULL);
INSERT INTO `tbl_currencies` (`code`, `name`, `symbol`, `xrate`) VALUES ('NZD', 'New Zealand Dollar', '$', NULL);
INSERT INTO `tbl_currencies` (`code`, `name`, `symbol`, `xrate`) VALUES ('PHP', 'Philippine Peso', 'ÃƒÂ¢Ã', NULL);
INSERT INTO `tbl_currencies` (`code`, `name`, `symbol`, `xrate`) VALUES ('PKR', 'Pakistan Rupee', 'PKR', NULL);
INSERT INTO `tbl_currencies` (`code`, `name`, `symbol`, `xrate`) VALUES ('PLN', 'Polish Zloty', 'zl', NULL);
INSERT INTO `tbl_currencies` (`code`, `name`, `symbol`, `xrate`) VALUES ('RUB', 'Russian Ruble', ' RUB', NULL);
INSERT INTO `tbl_currencies` (`code`, `name`, `symbol`, `xrate`) VALUES ('SEK', 'Swedish Krona', 'kr', NULL);
INSERT INTO `tbl_currencies` (`code`, `name`, `symbol`, `xrate`) VALUES ('SGD', 'Singapore Dollar', 'S$', NULL);
INSERT INTO `tbl_currencies` (`code`, `name`, `symbol`, `xrate`) VALUES ('THB', 'Thai Baht', 'ÃƒÂ Ã', NULL);
INSERT INTO `tbl_currencies` (`code`, `name`, `symbol`, `xrate`) VALUES ('TRY', 'Turkish Lira', ' TRY', NULL);
INSERT INTO `tbl_currencies` (`code`, `name`, `symbol`, `xrate`) VALUES ('TWD', 'Taiwan Dollar', 'NT$', NULL);
INSERT INTO `tbl_currencies` (`code`, `name`, `symbol`, `xrate`) VALUES ('USD', 'US Dollar', '$', '1.00000');
INSERT INTO `tbl_currencies` (`code`, `name`, `symbol`, `xrate`) VALUES ('VEF', 'Bol?var Fuerte', 'Bs.', NULL);
INSERT INTO `tbl_currencies` (`code`, `name`, `symbol`, `xrate`) VALUES ('ZAR', 'South African Rand', 'R', NULL);


#
# TABLE STRUCTURE FOR: tbl_custom_field
#

DROP TABLE IF EXISTS `tbl_custom_field`;

CREATE TABLE `tbl_custom_field` (
  `custom_field_id` int(11) NOT NULL AUTO_INCREMENT,
  `form_id` int(11) DEFAULT NULL,
  `field_label` varchar(100) NOT NULL,
  `default_value` text,
  `help_text` varchar(200) NOT NULL,
  `field_type` enum('text','textarea','dropdown','date','checkbox','numeric','url','email') NOT NULL,
  `required` varchar(5) NOT NULL DEFAULT 'false',
  `status` enum('active','deactive') NOT NULL DEFAULT 'deactive',
  `show_on_table` varchar(5) DEFAULT NULL,
  `visible_for_admin` varchar(5) DEFAULT NULL,
  `visible_for_client` varchar(11) DEFAULT NULL,
  `show_on_details` varchar(5) NOT NULL DEFAULT '',
  PRIMARY KEY (`custom_field_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_customer_group
#

DROP TABLE IF EXISTS `tbl_customer_group`;

CREATE TABLE `tbl_customer_group` (
  `customer_group_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `type` varchar(100) DEFAULT NULL COMMENT 'customer group,item group',
  `customer_group` varchar(200) NOT NULL,
  `description` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`customer_group_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `tbl_customer_group` (`customer_group_id`, `type`, `customer_group`, `description`) VALUES ('1', 'client', 'Customer', 'Customer Sales Group');
INSERT INTO `tbl_customer_group` (`customer_group_id`, `type`, `customer_group`, `description`) VALUES ('2', 'items', 'Products', 'This group is assigned for physical products only.');
INSERT INTO `tbl_customer_group` (`customer_group_id`, `type`, `customer_group`, `description`) VALUES ('3', 'items', 'Services', 'This group is assigned for services.');


#
# TABLE STRUCTURE FOR: tbl_dashboard
#

DROP TABLE IF EXISTS `tbl_dashboard`;

CREATE TABLE `tbl_dashboard` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) CHARACTER SET latin1 NOT NULL,
  `col` varchar(200) CHARACTER SET latin1 DEFAULT NULL,
  `order_no` int(2) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `report` tinyint(1) NOT NULL DEFAULT '0',
  `for_staff` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8;

INSERT INTO `tbl_dashboard` (`id`, `name`, `col`, `order_no`, `status`, `report`, `for_staff`) VALUES (1, 'income_expenses_report', 'col-sm-4', 1, 1, 1, 1);
INSERT INTO `tbl_dashboard` (`id`, `name`, `col`, `order_no`, `status`, `report`, `for_staff`) VALUES (2, 'invoice_payment_report', 'col-sm-4', 2, 1, 1, 1);
INSERT INTO `tbl_dashboard` (`id`, `name`, `col`, `order_no`, `status`, `report`, `for_staff`) VALUES (3, 'ticket_tasks_report', 'col-sm-4', 3, 1, 1, 1);
INSERT INTO `tbl_dashboard` (`id`, `name`, `col`, `order_no`, `status`, `report`, `for_staff`) VALUES (5, 'goal_report', 'col-md-6 ', 14, 1, 0, 1);
INSERT INTO `tbl_dashboard` (`id`, `name`, `col`, `order_no`, `status`, `report`, `for_staff`) VALUES (6, 'overdue_report', 'col-md-12', 10, 1, 0, 1);
INSERT INTO `tbl_dashboard` (`id`, `name`, `col`, `order_no`, `status`, `report`, `for_staff`) VALUES (11, 'my_project', 'col-md-6', 32, 1, 0, 1);
INSERT INTO `tbl_dashboard` (`id`, `name`, `col`, `order_no`, `status`, `report`, `for_staff`) VALUES (12, 'my_tasks', 'col-md-6', 35, 1, 0, 1);
INSERT INTO `tbl_dashboard` (`id`, `name`, `col`, `order_no`, `status`, `report`, `for_staff`) VALUES (14, 'announcements', 'col-md-6', 38, 1, 0, 1);
INSERT INTO `tbl_dashboard` (`id`, `name`, `col`, `order_no`, `status`, `report`, `for_staff`) VALUES (15, 'payments_report', 'col-md-6', 47, 1, 0, 1);
INSERT INTO `tbl_dashboard` (`id`, `name`, `col`, `order_no`, `status`, `report`, `for_staff`) VALUES (16, 'income_expense', 'col-md-6', 23, 1, 0, 1);
INSERT INTO `tbl_dashboard` (`id`, `name`, `col`, `order_no`, `status`, `report`, `for_staff`) VALUES (17, 'income_report', 'col-md-6', 50, 1, 0, 1);
INSERT INTO `tbl_dashboard` (`id`, `name`, `col`, `order_no`, `status`, `report`, `for_staff`) VALUES (18, 'expense_report', 'col-md-6', 44, 1, 0, 1);
INSERT INTO `tbl_dashboard` (`id`, `name`, `col`, `order_no`, `status`, `report`, `for_staff`) VALUES (19, 'recently_paid_invoices', 'col-md-6', 29, 1, 0, 1);
INSERT INTO `tbl_dashboard` (`id`, `name`, `col`, `order_no`, `status`, `report`, `for_staff`) VALUES (20, 'recent_activities', 'col-md-6', 26, 1, 0, 1);
INSERT INTO `tbl_dashboard` (`id`, `name`, `col`, `order_no`, `status`, `report`, `for_staff`) VALUES (21, 'finance_overview', 'col-md-6', 17, 1, 0, 1);
INSERT INTO `tbl_dashboard` (`id`, `name`, `col`, `order_no`, `status`, `report`, `for_staff`) VALUES (22, 'todo_list', 'col-md-6', 40, 1, 0, 1);
INSERT INTO `tbl_dashboard` (`id`, `name`, `col`, `order_no`, `status`, `report`, `for_staff`) VALUES (23, 'paid_amount', 'col-md-3', 2, 1, 2, 1);
INSERT INTO `tbl_dashboard` (`id`, `name`, `col`, `order_no`, `status`, `report`, `for_staff`) VALUES (24, 'due_amount', 'col-md-3', 4, 1, 2, 1);
INSERT INTO `tbl_dashboard` (`id`, `name`, `col`, `order_no`, `status`, `report`, `for_staff`) VALUES (25, 'invoice_amount', 'col-md-3', 1, 1, 2, 1);
INSERT INTO `tbl_dashboard` (`id`, `name`, `col`, `order_no`, `status`, `report`, `for_staff`) VALUES (26, 'paid_percentage', 'col-md-3', 3, 1, 2, 1);
INSERT INTO `tbl_dashboard` (`id`, `name`, `col`, `order_no`, `status`, `report`, `for_staff`) VALUES (27, 'recently_paid_invoices', 'col-sm-6', 2, 1, 3, 1);
INSERT INTO `tbl_dashboard` (`id`, `name`, `col`, `order_no`, `status`, `report`, `for_staff`) VALUES (28, 'payments', 'col-sm-6', 1, 1, 3, 1);
INSERT INTO `tbl_dashboard` (`id`, `name`, `col`, `order_no`, `status`, `report`, `for_staff`) VALUES (29, 'recent_invoice', 'col-sm-6', 3, 1, 3, 1);
INSERT INTO `tbl_dashboard` (`id`, `name`, `col`, `order_no`, `status`, `report`, `for_staff`) VALUES (30, 'recent_projects', 'col-sm-6', 4, 1, 3, 1);
INSERT INTO `tbl_dashboard` (`id`, `name`, `col`, `order_no`, `status`, `report`, `for_staff`) VALUES (31, 'recent_emails', 'col-sm-4', 5, 1, 3, 1);
INSERT INTO `tbl_dashboard` (`id`, `name`, `col`, `order_no`, `status`, `report`, `for_staff`) VALUES (32, 'recent_activities', 'col-sm-4', 6, 1, 3, 1);
INSERT INTO `tbl_dashboard` (`id`, `name`, `col`, `order_no`, `status`, `report`, `for_staff`) VALUES (33, 'announcements', 'col-sm-4', 7, 1, 3, 1);
INSERT INTO `tbl_dashboard` (`id`, `name`, `col`, `order_no`, `status`, `report`, `for_staff`) VALUES (34, 'my_calendar', 'col-md-6', 18, 1, 0, 1);


#
# TABLE STRUCTURE FOR: tbl_days
#

DROP TABLE IF EXISTS `tbl_days`;

CREATE TABLE `tbl_days` (
  `day_id` int(5) NOT NULL AUTO_INCREMENT,
  `day` varchar(100) NOT NULL,
  PRIMARY KEY (`day_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

INSERT INTO `tbl_days` (`day_id`, `day`) VALUES (1, 'Saturday');
INSERT INTO `tbl_days` (`day_id`, `day`) VALUES (2, 'Sunday');
INSERT INTO `tbl_days` (`day_id`, `day`) VALUES (3, 'Monday');
INSERT INTO `tbl_days` (`day_id`, `day`) VALUES (4, 'Tuesday');
INSERT INTO `tbl_days` (`day_id`, `day`) VALUES (5, 'Wednesday');
INSERT INTO `tbl_days` (`day_id`, `day`) VALUES (6, 'Thursday');
INSERT INTO `tbl_days` (`day_id`, `day`) VALUES (7, 'Friday');


#
# TABLE STRUCTURE FOR: tbl_departments
#

DROP TABLE IF EXISTS `tbl_departments`;

CREATE TABLE `tbl_departments` (
  `departments_id` int(10) NOT NULL AUTO_INCREMENT,
  `deptname` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `department_head_id` int(11) DEFAULT NULL COMMENT 'department_head_id == user_id',
  `email` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `encryption` varchar(10) CHARACTER SET utf8 DEFAULT NULL,
  `host` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `username` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `password` text CHARACTER SET utf8,
  `mailbox` varchar(20) CHARACTER SET utf8 DEFAULT NULL,
  `unread_email` tinyint(1) NOT NULL DEFAULT '0',
  `delete_mail_after_import` tinyint(1) NOT NULL DEFAULT '0',
  `last_postmaster_run` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`departments_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `tbl_departments` (`departments_id`, `deptname`, `department_head_id`, `email`, `encryption`, `host`, `username`, `password`, `mailbox`, `unread_email`, `delete_mail_after_import`, `last_postmaster_run`) VALUES (1, '', 6, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, NULL);


#
# TABLE STRUCTURE FOR: tbl_designations
#

DROP TABLE IF EXISTS `tbl_designations`;

CREATE TABLE `tbl_designations` (
  `designations_id` int(5) NOT NULL AUTO_INCREMENT,
  `departments_id` int(11) NOT NULL,
  `designations` varchar(100) NOT NULL,
  `permission` text,
  PRIMARY KEY (`designations_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `tbl_designations` (`designations_id`, `departments_id`, `designations`, `permission`) VALUES (1, 1, 'Director', NULL);


#
# TABLE STRUCTURE FOR: tbl_discipline
#

DROP TABLE IF EXISTS `tbl_discipline`;

CREATE TABLE `tbl_discipline` (
  `discipline_id` int(5) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `offence_id` int(5) NOT NULL,
  `penalty_id` int(5) NOT NULL,
  `discipline_break_date` varchar(100) NOT NULL,
  `discipline_action_date` varchar(100) NOT NULL,
  `discipline_remarks` varchar(200) NOT NULL,
  `discipline_comments` varchar(200) NOT NULL,
  PRIMARY KEY (`discipline_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_draft
#

DROP TABLE IF EXISTS `tbl_draft`;

CREATE TABLE `tbl_draft` (
  `draft_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `to` text NOT NULL,
  `subject` varchar(300) NOT NULL,
  `message_body` text NOT NULL,
  `attach_file` text,
  `attach_file_path` text,
  `attach_filename` text,
  `message_time` datetime NOT NULL,
  `deleted` enum('Yes','No') NOT NULL DEFAULT 'No',
  PRIMARY KEY (`draft_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_email_templates
#

DROP TABLE IF EXISTS `tbl_email_templates`;

CREATE TABLE `tbl_email_templates` (
  `email_templates_id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email_group` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `subject` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `template_body` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`email_templates_id`)
) ENGINE=InnoDB AUTO_INCREMENT=72 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (1, 'en', 'registration', 'Registration successful', '<div style=\"height: 7px; background-color: #535353;\"></div><div style=\"background-color:#E8E8E8; margin:0px; padding:55px 20px 40px 20px; font-family:Open Sans, Helvetica, sans-serif; font-size:12px; color:#535353;\"><div style=\"text-align:center; font-size:24px; font-weight:bold; color:#535353;\">Welcome to {SITE_NAME}</div><div style=\"border-radius: 5px 5px 5px 5px; padding:20px; margin-top:45px; background-color:#FFFFFF; font-family:Open Sans, Helvetica, sans-serif; font-size:13px;\">Thanks for joining {SITE_NAME}. We listed your sign in details below, make sure you keep them safe.<br>To open your {SITE_NAME} homepage, please follow this link:<br><big><b><a href=\"{SITE_URL}\">{SITE_NAME} Account!</a></b></big><br>Link doesn\'t work? Copy the following link to your browser address bar:<br><a href=\"{SITE_URL}\">{SITE_URL}</a><br>Your username: {USERNAME}<br>Your email address: {EMAIL}<br>Your password: {PASSWORD}<br>Have fun!<br>The {SITE_NAME} Team.<br><br></div></div>');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (2, 'en', 'forgot_password', 'Forgot Password', '        <div style=\"height: 7px; background-color: #535353;\"></div><div style=\"background-color:#E8E8E8; margin:0px; padding:55px 20px 40px 20px; font-family:Open Sans, Helvetica, sans-serif; font-size:12px; color:#535353;\"><div style=\"text-align:center; font-size:24px; font-weight:bold; color:#535353;\">New Password</div><div style=\"border-radius: 5px 5px 5px 5px; padding:20px; margin-top:45px; background-color:#FFFFFF; font-family:Open Sans, Helvetica, sans-serif; font-size:13px;\">Forgot your password, huh? No big deal.<br>To create a new password, just follow this link:<br><br><big><b><a href=\"{PASS_KEY_URL}\">Create a new password</a></b></big><br>Link doesn\'t work? Copy the following link to your browser address bar:<br><a href=\"{PASS_KEY_URL}\">{PASS_KEY_URL}</a><br><br><br>You received this email, because it was requested by a <a href=\"{SITE_URL}\">{SITE_NAME}</a> user. <p></p><p>This is part of the procedure to create a new password on the system. If you DID NOT request a new password then please ignore this email and your password will remain the same.</p><br>Thank you,<br>The {SITE_NAME} Team</div></div>');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (3, 'en', 'change_email', 'Change Email', '<div style=\"height: 7px; background-color: #535353;\"></div>\r\n<div style=\"background-color:#E8E8E8; margin:0px; padding:55px 20px 40px 20px; font-family:Open Sans, Helvetica, sans-serif; font-size:12px; color:#535353;\"><div style=\"text-align:center; font-size:24px; font-weight:bold; color:#535353;\">New email address on {SITE_NAME}</div>\r\n\r\n<div style=\"border-radius: 5px 5px 5px 5px; padding:20px; margin-top:45px; background-color:#FFFFFF; font-family:Open Sans, Helvetica, sans-serif; font-size:13px;\">You have changed your email address for {SITE_NAME}.<br>Follow this link to confirm your new email address:<br><big><b><a href=\"{NEW_EMAIL_KEY_URL}\">Confirm your new email</a></b></big><br>Link doesn\'t work? Copy the following link to your browser address bar:<br><a href=\"{NEW_EMAIL_KEY_URL}\">{NEW_EMAIL_KEY_URL}</a><br><br>Your email address: {NEW_EMAIL}<br><br>You received this email, because it was requested by a <a href=\"{SITE_URL}\">{SITE_NAME}</a> user. If you have received this by mistake, please DO NOT click the confirmation link, and simply delete this email. After a short time, the request will be removed from the system.<br>Thank you,<br>The {SITE_NAME} Team</div>\r\n\r\n</div>');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (4, 'en', 'activate_account', 'Activate Account', '<p>Welcome to {SITE_NAME}!</p>\r\n\r\n<p>Thanks for joining {SITE_NAME}. We listed your sign in details below, make sure you keep them safe.</p>\r\n\r\n<p>To verify your email address, please follow this link:<br />\r\n<big><strong><a href=\"{ACTIVATE_URL}\">Finish your registration...</a></strong></big><br />\r\nLink doesn&#39;t work? Copy the following link to your browser address bar:<br />\r\n<a href=\"{ACTIVATE_URL}\">{ACTIVATE_URL}</a></p>\r\n\r\n<p><br />\r\n<br />\r\nPlease verify your email within {ACTIVATION_PERIOD} hours, otherwise your registration will become invalid and you will have to register again.<br />\r\n<br />\r\n<br />\r\nYour username: {USERNAME}<br />\r\nYour email address: {EMAIL}<br />\r\nYour password: {PASSWORD}<br />\r\n<br />\r\nHave fun!<br />\r\nThe {SITE_NAME} Team</p>\r\n');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (5, 'en', 'reset_password', 'Reset Password', '<div style=\"height: 7px; background-color: #535353;\"></div>\r\n<div style=\"background-color:#E8E8E8; margin:0px; padding:55px 20px 40px 20px; font-family:Open Sans, Helvetica, sans-serif; font-size:12px; color:#535353;\"><div style=\"text-align:center; font-size:24px; font-weight:bold; color:#535353;\">New password on {SITE_NAME}</div>\r\n<div style=\"border-radius: 5px 5px 5px 5px; padding:20px; margin-top:45px; background-color:#FFFFFF; font-family:Open Sans, Helvetica, sans-serif; font-size:13px;\"><p>You have changed your password.<br>Please, keep it in your records so you don\'t forget it.<br></p>\r\nYour username: {USERNAME}<br>Your email address: {EMAIL}<br>Your new password: {NEW_PASSWORD}<br><br>Thank you,<br>The {SITE_NAME} Team</div>\r\n</div>');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (6, 'en', 'bug_assigned', 'New Bug Assigned', '<p>Hi there,</p>\r\n\r\n<p>A new bug &nbsp;{BUG_TITLE} &nbsp;has been assigned to you by {ASSIGNED_BY}.</p>\r\n\r\n<p>You can view this bug by logging in to the portal using the link below.</p>\r\n\r\n<p><br />\r\n<big><strong><a href=\"{BUG_URL}\">View Bug</a></strong></big><br />\r\n<br />\r\nRegards<br />\r\nThe {SITE_NAME} Team</p>\r\n');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (7, 'en', 'bug_updated', 'Bug status changed', '<p>Hi there,</p>\r\n\r\n<p>Bug {BUG_TITLE} has been marked as {STATUS} by {MARKED_BY}.</p>\r\n\r\n<p>You can view this bug by logging in to the portal using the link below.</p>\r\n\r\n<p><big><strong><a href=\"{BUG_URL}\">View Bug</a></strong></big><br />\r\nRegards<br />\r\nThe {SITE_NAME} Team</p>\r\n\r\n<p>&nbsp;</p>\r\n');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (8, 'en', 'bug_comments', 'New Bug Comment Received', '<p>Hi there,</p>\r\n\r\n<p>A new comment has been posted by {POSTED_BY} to bug {BUG_TITLE}.</p>\r\n\r\n<p>You can view the comment using the link below.</p>\r\n\r\n<p><em>{COMMENT_MESSAGE}</em></p>\r\n\r\n<p><br />\r\n<big><strong><a href=\"{COMMENT_URL}\">View Comment</a></strong></big><br />\r\nRegards<br />\r\nThe {SITE_NAME} Team</p>\r\n\r\n<p>&nbsp;</p>\r\n');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (9, 'en', 'bug_attachment', 'New bug attachment', '<p>Hi there,</p>\r\n\r\n<p>A new attachment&nbsp;has been uploaded by {UPLOADED_BY} to issue {BUG_TITLE}.</p>\r\n\r\n<p>You can view the bug using the link below.</p>\r\n\r\n<p><br />\r\n<big><strong><a href=\"{BUG_URL}\">View Bug</a></strong></big></p>\r\n\r\n<p><br />\r\nRegards<br />\r\nThe {SITE_NAME} Team</p>\r\n');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (10, 'en', 'bug_reported', 'New bug Reported', '<p>Hi there,</p>\r\n\r\n<p>A new bug ({BUG_TITLE}) has been reported by {ADDED_BY}.</p>\r\n\r\n<p>You can view the Bug using the Dashboard Page.</p>\r\n\r\n<p><br />\r\n<big><strong><a href=\"{BUG_URL}\">View Bug</a></strong></big></p>\r\n\r\n<p><br />\r\nRegards<br />\r\nThe {SITE_NAME} Team</p>\r\n');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (13, 'en', 'refund_confirmation', 'Refund Confirmation', '<p>Refund Confirmation</p>\r\n\r\n<p>Hello {CLIENT}</p>\r\n\r\n<p>This is confirmation that a refund has been processed for Invoice&nbsp; of {CURRENCY} {AMOUNT}&nbsp;sent on {INVOICE_DATE}.<br />\r\nYou can view the invoice online at:<br />\r\n<big><strong><a href=\"{INVOICE_LINK}\">View Invoice</a></strong></big><br />\r\n<br />\r\nBest Regards,<br />\r\nThe {SITE_NAME} Team</p>\r\n');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (14, 'en', 'payment_confirmation', 'Payment Confirmation', '<p>Payment Confirmation</p>\r\n\r\n<p>Hello {CLIENT}</p>\r\n\r\n<p>This is a payment receipt for your invoice of {CURRENCY} {AMOUNT}&nbsp;sent on {INVOICE_DATE}.<br />\r\nYou can view the invoice online at:<br />\r\n<big><strong><a href=\"{INVOICE_LINK}\">View Invoice</a></strong></big><br />\r\n<br />\r\nBest Regards,<br />\r\nThe {SITE_NAME} Team</p>\r\n');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (15, 'en', 'payment_email', 'Payment Received', '<div style=\"height: 7px; background-color: #535353;\"></div>\n<div style=\"background-color:#E8E8E8; margin:0px; padding:55px 20px 40px 20px; font-family:Open Sans, Helvetica, sans-serif; font-size:12px; color:#535353;\"><div style=\"text-align:center; font-size:24px; font-weight:bold; color:#535353;\">Payment Received</div>\n<div style=\"border-radius: 5px 5px 5px 5px; padding:20px; margin-top:45px; background-color:#FFFFFF; font-family:Open Sans, Helvetica, sans-serif; font-size:13px;\"><p>Dear Customer</p>\n<p>We have received your payment of {INVOICE_CURRENCY} {PAID_AMOUNT}. </p>\n<p>Thank you for your Payment and business. We look forward to working with you again.</p>\n--------------------------<br>Regards<br>The {SITE_NAME} Team</div>\n</div>');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (16, 'en', 'invoice_overdue_email', 'Invoice Overdue Notice', '<p>Invoice Overdue</p>\r\n\r\n<p>INVOICE {REF}</p>\r\n\r\n<p><strong>Hello {CLIENT}</strong></p>\r\n\r\n<p>This is the notice that your invoice overdue.&nbsp;The invoice {CURRENCY} {AMOUNT}. and Due Date: {DUE_DATE}</p>\r\n\r\n<p>You can view the invoice online at:<br />\r\n<big><strong><a href=\"{INVOICE_LINK}\">View Invoice</a></strong></big><br />\r\n<br />\r\nBest Regards,<br />\r\nThe {SITE_NAME} Team</p>\r\n\r\n<p>&nbsp;</p>\r\n');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (17, 'en', 'invoice_message', 'New Invoice', '<div style=\"height: 7px; background-color: #535353;\"></div><div style=\"background-color:#E8E8E8; margin:0px; padding:55px 20px 40px 20px; font-family:Open Sans, Helvetica, sans-serif; font-size:12px; color:#535353;\"><div style=\"text-align:center; font-size:24px; font-weight:bold; color:#535353;\">INVOICE {REF}</div><div style=\"border-radius: 5px 5px 5px 5px; padding:20px; margin-top:45px; background-color:#FFFFFF; font-family:Open Sans, Helvetica, sans-serif; font-size:13px;\"><span class=\"style1\"><span style=\"font-weight:bold;\">Hello {CLIENT}</span></span><br><br>Here is the invoice of {CURRENCY} {AMOUNT}.<br><br>You can view the invoice online at:<br><big><b><a href=\"{INVOICE_LINK}\">View Invoice</a></b></big><br><br>Best Regards<br><br>The {SITE_NAME} Team</div></div>');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (18, 'en', 'invoice_reminder', 'Invoice Reminder', '<div style=\"height: 7px; background-color: #535353;\"></div>\r\n<div style=\"background-color:#E8E8E8; margin:0px; padding:55px 20px 40px 20px; font-family:Open Sans, Helvetica, sans-serif; font-size:12px; color:#535353;\"><div style=\"text-align:center; font-size:24px; font-weight:bold; color:#535353;\">Invoice Reminder</div>\r\n<div style=\"border-radius: 5px 5px 5px 5px; padding:20px; margin-top:45px; background-color:#FFFFFF; font-family:Open Sans, Helvetica, sans-serif; font-size:13px;\"><p>Hello {CLIENT}</p>\r\n<br><p>This is a friendly reminder to pay your invoice of {CURRENCY} {AMOUNT}<br>You can view the invoice online at:<br><big><b><a href=\"{INVOICE_LINK}\">View Invoice</a></b></big><br><br>Best Regards,<br>The {SITE_NAME} Team</p>\r\n</div>\r\n</div>');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (19, 'en', 'message_received', 'Message Received', '<div style=\"height: 7px; background-color: #535353;\"></div>\r\n<div style=\"background-color:#E8E8E8; margin:0px; padding:55px 20px 40px 20px; font-family:Open Sans, Helvetica, sans-serif; font-size:12px; color:#535353;\"><div style=\"text-align:center; font-size:24px; font-weight:bold; color:#535353;\">Message Received</div>\r\n<div style=\"border-radius: 5px 5px 5px 5px; padding:20px; margin-top:45px; background-color:#FFFFFF; font-family:Open Sans, Helvetica, sans-serif; font-size:13px;\"><p>Hi {RECIPIENT},</p>\r\n<p>You have received a message from {SENDER}. </p>\r\n------------------------------------------------------------------<br><blockquote>\r\n{MESSAGE}</blockquote>\r\n<big><b><a href=\"{SITE_URL}\">Go to Account</a></b></big><br><br>Regards<br>The {SITE_NAME} Team</div>\r\n</div>');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (20, 'en', 'estimate_email', 'New Estimate', '<p>Estimate {ESTIMATE_REF}</p>\r\n\r\n<p>Hi {CLIENT}</p>\r\n\r\n<p>Thanks for your business inquiry.</p>\r\n\r\n<p>The estimate {ESTIMATE_REF} is attached with this email.<br />\r\nEstimate Overview:<br />\r\nEstimate # : {ESTIMATE_REF}<br />\r\nAmount: {CURRENCY} {AMOUNT}<br />\r\n<br />\r\nYou can view the estimate online at:<br />\r\n<big><strong><a href=\"{ESTIMATE_LINK}\">View Estimate</a></strong></big><br />\r\n<br />\r\nBest Regards,<br />\r\nThe {SITE_NAME} Team</p>\r\n');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (21, 'en', 'ticket_staff_email', 'New Ticket [TICKET_CODE]', '<div style=\"height: 7px; background-color: #535353;\"></div>\r\n<div style=\"background-color:#E8E8E8; margin:0px; padding:55px 20px 40px 20px; font-family:Open Sans, Helvetica, sans-serif; font-size:12px; color:#535353;\"><div style=\"text-align:center; font-size:24px; font-weight:bold; color:#535353;\">New Ticket</div>\r\n<div style=\"border-radius: 5px 5px 5px 5px; padding:20px; margin-top:45px; background-color:#FFFFFF; font-family:Open Sans, Helvetica, sans-serif; font-size:13px;\"><p>Ticket #{TICKET_CODE} has been created by the client.</p>\r\n<p>You may view the ticket by clicking on the following link <br><br>  Client Email : {REPORTER_EMAIL}<br><br> <big><b><a href=\"{TICKET_LINK}\">View Ticket</a></b></big> <br><br>Regards<br><br>{SITE_NAME}</p>\r\n</div>\r\n</div>');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (22, 'en', 'ticket_client_email', 'Ticket [TICKET_CODE] Opened', '<p>Ticket Opened</p>\r\n\r\n<p>Hello {CLIENT_EMAIL},</p>\r\n\r\n<p>Your ticket has been opened with us.<br />\r\n<br />\r\nTicket # {TICKET_CODE}<br />\r\nStatus : Open<br />\r\n<br />\r\nClick on the below link to see the ticket details and post additional comments.<br />\r\n<br />\r\n<big><strong><a href=\"{TICKET_LINK}\">View Ticket</a></strong></big><br />\r\n<br />\r\nRegards<br />\r\n<br />\r\nThe {SITE_NAME} Team</p>\r\n');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (23, 'en', 'ticket_reply_email', 'Ticket [TICKET_CODE] Response', '<div style=\"height: 7px; background-color: #535353;\"></div>\r\n<div style=\"background-color:#E8E8E8; margin:0px; padding:55px 20px 40px 20px; font-family:Open Sans, Helvetica, sans-serif; font-size:12px; color:#535353;\"><div style=\"text-align:center; font-size:24px; font-weight:bold; color:#535353;\">Ticket Response</div>\r\n<div style=\"border-radius: 5px 5px 5px 5px; padding:20px; margin-top:45px; background-color:#FFFFFF; font-family:Open Sans, Helvetica, sans-serif; font-size:13px;\"><p>A new response has been added to Ticket #{TICKET_CODE}<br><br> Ticket : #{TICKET_CODE} <br>Status : {TICKET_STATUS} <br><br></p>\r\nTo see the response and post additional comments, click on the link below.<br><br>         <big><b><a href=\"{TICKET_LINK}\">View Reply</a> </b></big><br><br>          Note: Do not reply to this email as this email is not monitored.<br><br>     Regards<br>The {SITE_NAME} Team<br></div>\r\n</div>');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (24, 'en', 'ticket_closed_email', 'Ticket [TICKET_CODE] Closed', '<div style=\"height: 7px; background-color: #535353;\"></div>\r\n<div style=\"background-color:#E8E8E8; margin:0px; padding:55px 20px 40px 20px; font-family:Open Sans, Helvetica, sans-serif; font-size:12px; color:#535353;\"><div style=\"text-align:center; font-size:24px; font-weight:bold; color:#535353;\">Ticket Closed</div>\r\n<div style=\"border-radius: 5px 5px 5px 5px; padding:20px; margin-top:45px; background-color:#FFFFFF; font-family:Open Sans, Helvetica, sans-serif; font-size:13px;\">Hi {REPORTER_EMAIL}<br><br>Ticket #{TICKET_CODE} has been closed by {STAFF_USERNAME} <br><br>          Ticket : #{TICKET_CODE} <br>     Status : {TICKET_STATUS}<br><br>Replies : {NO_OF_REPLIES}<br><br>          To see the responses or open the ticket, click on the link below.<br><br>          <big><b><a href=\"{TICKET_LINK}\">View Ticket</a></b></big> <br><br>          Note: Do not reply to this email as this email is not monitored.<br><br>    Regards<br>The {SITE_NAME} Team</div>\r\n</div>');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (26, 'en', 'task_updated', 'Task updated', '<div style=\"height: 7px; background-color: #535353;\"></div>\r\n<div style=\"background-color:#E8E8E8; margin:0px; padding:55px 20px 40px 20px; font-family:Open Sans, Helvetica, sans-serif; font-size:12px; color:#535353;\"><div style=\"text-align:center; font-size:24px; font-weight:bold; color:#535353;\">Task updated</div>\r\n<div style=\"border-radius: 5px 5px 5px 5px; padding:20px; margin-top:45px; background-color:#FFFFFF; font-family:Open Sans, Helvetica, sans-serif; font-size:13px;\"><p>Hi there,</p>\r\n<p>{TASK_NAME} in {PROJECT_TITLE} has been updated by {ASSIGNED_BY}.</p>\r\n<p>You can view this project by logging in to the portal using the link below.</p>\r\n-----------------------------------<br><big><b><a href=\"{PROJECT_URL}\">View Project</a></b></big><br><br>Regards<br>The {SITE_NAME} Team</div>\r\n</div>');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (27, 'en', 'quotations_form', 'Your Quotation Request', '<p>QUOTATION</p>\r\n\r\n<p><strong>Hello {CLIENT}</strong><br />\r\n&nbsp;</p>\r\n\r\n<p>Thank you for you for filling in our Quotation Request Form.<br />\r\n<br />\r\nPlease find below are our quotation:</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<table cellpadding=\"8\" style=\"width:100%\">\r\n  <tbody>\r\n    <tr>\r\n      <td>Quotation Date</td>\r\n      <td><strong>{DATE}</strong></td>\r\n    </tr>\r\n    <tr>\r\n      <td>Our Quotation</td>\r\n      <td><strong>{CURRENCY} {AMOUNT}</strong></td>\r\n    </tr>\r\n    <tr>\r\n      <td>Addtitional Comments</td>\r\n      <td><strong>{NOTES}</strong></td>\r\n    </tr>\r\n  </tbody>\r\n</table>\r\n\r\n<p><br />\r\nYou can view the estimate online at:<br />\r\n<big><strong><a href=\"{QUOTATION LINK}\">View Quotation</a></strong></big></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><br />\r\nThank you and we look forward to working with you.<br />\r\n<br />\r\nBest Regards,<br />\r\nThe {SITE_NAME} Team</p>\r\n\r\n<p>&nbsp;</p>\r\n');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (28, 'en', 'client_notification', 'New project created', '<p>Hello, <strong>{CLIENT_NAME}</strong>,<br />\r\nwe have created a new project with your account.<br />\r\n<br />\r\nProject name : <strong>{PROJECT_NAME}</strong><br />\r\nYou can login to see the status of your project by using this link:<br />\r\n<big><a href=\"{PROJECT_LINK}\"><strong>View Project</strong></a></big></p>\r\n\r\n<p><br />\r\nBest Regards<br />\r\n<br />\r\nThe {SITE_NAME} Team</p>\r\n\r\n<p>&nbsp;</p>\r\n');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (29, 'en', 'assigned_project', 'Assigned Project', '<p>Hi There,</p>\r\n\r\n<p>A<strong> {PROJECT_NAME}</strong> has been assigned by <strong>{ASSIGNED_BY} </strong>to you.You can view this project by logging in to the portal using the link below:<br />\r\n<big><a href=\"{PROJECT_URL}\"><strong>View Project</strong></a></big><br />\r\n<br />\r\nBest Regards<br />\r\nThe {SITE_NAME} Team</p>\r\n\r\n<p>&nbsp;</p>\r\n');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (30, 'en', 'complete_projects', 'Project Completed', '<p>Hi <strong>{CLIENT_NAME}</strong>,</p>\r\n\r\n<p>Project : <strong>{PROJECT_NAME}</strong> &nbsp;has been completed.<br />\r\nYou can view the project by logging into your portal Account:<br />\r\n<big><a href=\"{PROJECT_LINK}\"><strong>View Project</strong></a></big><br />\r\n<br />\r\nBest Regards,<br />\r\nThe {SITE_NAME} Team</p>\r\n');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (31, 'en', 'project_comments', 'New Project Comment Received', '<p>Hi There,</p>\r\n\r\n<p>A new comment has been posted by <strong>{POSTED_BY}</strong> to project <strong>{PROJECT_NAME}</strong>.</p>\r\n\r\n<p>You can view the comment using the link below:<br />\r\n<big><a href=\"{COMMENT_URL}\"><strong>View Project</strong></a></big><br />\r\n<br />\r\n<em>{COMMENT_MESSAGE}</em><br />\r\n<br />\r\nBest Regards,<br />\r\nThe {SITE_NAME} Team</p>\r\n');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (32, 'en', 'project_attachment', 'New Project  Attachment', '<p>Hi There,</p>\r\n\r\n<p>A new file has been uploaded by <strong>{UPLOADED_BY}</strong> to project <strong>{PROJECT_NAME}</strong>.<br />\r\nYou can view the Project using the link below:<br />\r\n<big><a href=\"{PROJECT_URL}\"><strong>View Project</strong></a></big><br />\r\n<br />\r\n<br />\r\nBest Regards,<br />\r\nThe {SITE_NAME} Team</p>\r\n');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (33, 'en', 'responsible_milestone', 'Responsible for a Milestone', '<p>Hi There,</p>\r\n\r\n<p>You are a responsible&nbsp;for a project milestone&nbsp;<strong>{MILESTONE_NAME}</strong>&nbsp; assigned to you by <strong>{ASSIGNED_BY}</strong> in project <strong>{PROJECT_NAME}</strong>.</p>\r\n\r\n<p>You can view this Milestone&nbsp;by logging in to the portal using the link below:<br />\r\n<big><strong><a href=\"{PROJECT_URL}\">View Project</a></strong></big><br />\r\n<br />\r\n<br />\r\nBest Regards,<br />\r\nThe {SITE_NAME} Team</p>\r\n');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (34, 'en', 'task_assigned', 'Task assigned', '<p>Hi there,</p>\r\n\r\n<p>A new task <strong>{TASK_NAME}</strong> &nbsp;has been assigned to you by <strong>{ASSIGNED_BY}</strong>.</p>\r\n\r\n<p>You can view this task by logging in to the portal using the link below.</p>\r\n\r\n<p><br />\r\n<big><strong><a href=\"{TASK_URL}\">View Task</a></strong></big><br />\r\n<br />\r\nRegards<br />\r\nThe {SITE_NAME} Team</p>\r\n');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (35, 'en', 'tasks_comments', 'New Task Comment Received', '<p>Hi There,</p>\r\n\r\n<p>A new comment has been posted by <strong>{POSTED_BY}</strong> to <strong>{TASK_NAME}</strong>.</p>\r\n\r\n<p>You can view the comment using the link below:<br />\r\n<big><strong><a href=\"{COMMENT_URL}\">View Comment</a></strong></big><br />\r\n<br />\r\n<em>{COMMENT_MESSAGE}</em><br />\r\n<br />\r\nBest Regards,<br />\r\nThe {SITE_NAME} Team</p>\r\n');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (36, 'en', 'tasks_attachment', 'New Tasks Attachment', '<p>Hi There,</p>\r\n\r\n<p>A new file has been uploaded by <strong>{UPLOADED_BY} </strong>to Task <strong>{TASK_NAME}</strong>.<br />\r\nYou can view the Task&nbsp;using the link below:</p>\r\n\r\n<p><br />\r\n<big><a href=\"{TASK_URL}\"><strong>View Task</strong></a></big><br />\r\n<br />\r\nBest Regards,<br />\r\nThe {SITE_NAME} Team</p>\r\n');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (37, 'en', 'tasks_updated', 'Task updated', '<p>Hi there,</p>\r\n\r\n<p><strong>{TASK_NAME}</strong> has been updated by <strong>{ASSIGNED_BY}</strong>.</p>\r\n\r\n<p>You can view this Task by logging in to the portal using the link below.</p>\r\n\r\n<p><br />\r\n<big><strong><a href=\"{TASK_URL}\">View Task</a></strong></big><br />\r\n<br />\r\nRegards<br />\r\nThe {SITE_NAME} Team</p>\r\n');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (38, 'en', 'goal_not_achieve', 'Not Achieve Goal', '<p><strong>Unfortunately!</strong> We failed to achieve goal!</p>\r\n\r\n<p><strong>Here is a Goal Details</strong></p>\r\n\r\n<p>Goal Type :&nbsp;<strong>{Goal_Type}</strong><br />\r\nTarget Achievement:&nbsp;<strong>{achievement}</strong><br />\r\nTotal Achievement:&nbsp;<strong>{total_achievement}</strong><br />\r\nStart Date:&nbsp;<strong>{start_date}</strong><br />\r\nEnd Date:&nbsp;<strong>{End_date}</strong><br />\r\n&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (39, 'en', 'goal_achieve', 'Achieve Goal', '<p><strong>Congratulation!</strong> We achieved new goal.</p>\r\n\r\n<p><strong>Here is a Goal Details</strong></p>\r\n\r\n<p>Goal Type :<strong>{Goal_Type}</strong><br />\r\nTarget Achievement:<strong>{achievement}</strong><br />\r\nTotal Achievement:<strong>{total_achievement}</strong><br />\r\nStart Date:<strong>{start_date}</strong><br />\r\nEnd Date:<strong>{End_date}</strong><br />\r\n&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (40, 'en', 'leave_request_email', 'A Leave Request from you', '<p>Hi there,</p>\r\n\r\n<p><strong>{NAME}</strong> &nbsp;Want to leave from you.</p>\r\n\r\n<p>You can view this leave request by logging in to the portal using the link below<br />\r\n<big><strong><a href=\"{APPLICATION_LINK}\">View Application</a></strong></big><br />\r\n<br />\r\n<br />\r\nRegards<br />\r\n<br />\r\nThe {SITE_NAME} Team</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (41, 'en', 'leave_approve_email', 'Your leave request has been approved', '<h1>Your leave request has been approved</h1>\r\n\r\n<p><strong>Congratulations!</strong> Your leave request from <strong>{START_DATE}</strong> to <strong>{END_DATE}</strong> has been approved by your company management.</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><br />\r\nRegards<br />\r\n<br />\r\nThe {SITE_NAME} Team</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (42, 'en', 'leave_reject_email', 'Your leave request has been Rejected', '<h1>Your leave request has been Rejected</h1>\r\n\r\n<p><strong>Unfortunately !</strong>&nbsp;Your leave request from&nbsp;<strong>{START_DATE}</strong>&nbsp;to&nbsp;<strong>{END_DATE}</strong>&nbsp;has been Rejected by your company management.</p>\r\n\r\n<p><br />\r\nRegards<br />\r\n<br />\r\nThe {SITE_NAME} Team</p>\r\n');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (43, 'en', 'overtime_request_email', 'Overtime Request', '<p>Hi there,</p>\r\n\r\n<p><strong>{NAME}</strong>&nbsp;&nbsp;to do an overtime.<br />\r\n<br />\r\n<br />\r\nRegards<br />\r\n<br />\r\nThe {SITE_NAME} Team</p>\r\n');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (44, 'en', 'overtime_approved_email', 'Your overtime request has been approved', '<h1>Your leave request has been approved</h1>\r\n\r\n<p><strong>Congratulations!</strong>&nbsp;Your overtime&nbsp;request at&nbsp;<strong>{DATE}</strong>&nbsp;and&nbsp;<strong>{HOUR}</strong>&nbsp;has been approved by your company management.</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><br />\r\nRegards<br />\r\n<br />\r\nThe {SITE_NAME} Team</p>\r\n');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (45, 'en', 'overtime_reject_email', 'Your Overtime request has been Rejected', '<h1>Your leave request has been Rejected</h1>\r\n\r\n<p><strong>Unfortunately&nbsp;!</strong>&nbsp;Your overtime&nbsp;request at&nbsp;<strong>{DATE}</strong>&nbsp;and&nbsp;<strong>{HOUR}</strong>&nbsp;has been Rejected by your company management.</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><br />\r\nRegards<br />\r\n<br />\r\nThe {SITE_NAME} Team</p>\r\n');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (46, 'en', 'wellcome_email', 'Welcome Email ', '<p>Hello <strong>{NAME}</strong>,</p>\r\n\r\n<p>Welcome to <strong>{COMPANY_NAME}</strong> .Thanks for joining <strong>{COMPANY_NAME}</strong>.</p>\r\n\r\n<p>We just wanted to say welcome.</p>\r\n\r\n<p>Please contact us if you need any help.</p>\r\n\r\n<p>Click here to view your profile: <strong>{COMPANY_URL}</strong></p>\r\n\r\n<p><br />\r\nHave fun!<br />\r\nThe <strong>{COMPANY_NAME}</strong> Team.</p>\r\n');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (47, 'en', 'payslip_generated_email', 'Payslip generated', '<p>Hello&nbsp;<strong>{NAME}</strong>,</p>\r\n\r\n<p>Your payslip generated for the month <strong>{MONTH_YEAR} .</strong></p>\r\n\r\n<p><br />\r\nRegards<br />\r\n<br />\r\nThe {SITE_NAME} Team</p>\r\n');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (48, 'en', 'advance_salary_email', 'Advance Salary Reqeust', '<p>Hi there,</p>\r\n\r\n<p><strong>{NAME}</strong>&nbsp;&nbsp;Want to Advance Salary from you.</p>\r\n\r\n<p>You can view this Advance Salary by logging in to the portal using the link below.<br />\r\n<br />\r\n<big><strong><a href=\"{LINK}\">View Advance Salary</a></strong></big><br />\r\n<br />\r\n<br />\r\nRegards<br />\r\n<br />\r\nThe {SITE_NAME} Team</p>\r\n');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (49, 'en', 'advance_salary_approve_email', 'Your advance salary request has been approved', '<h1>Your advance salary request has been approved</h1>\r\n\r\n<p><strong>Congratulations!</strong>&nbsp;Your advance salary&nbsp;requested &nbsp;<strong>{AMOUNT}</strong>&nbsp;has been approved by your company management.</p>\r\n\r\n<p>This advance amount will deduct the next <strong>{DEDUCT_MOTNH}</strong> .</p>\r\n\r\n<p><br />\r\nRegards<br />\r\n<br />\r\nThe {SITE_NAME} Team</p>\r\n');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (50, 'en', 'advance_salary_reject_email', 'Your advance salary request has been Rejected', '<h1>Your advance salary request has been Rejected</h1>\r\n\r\n<p><strong>Unfortunately !</strong>&nbsp;Your advance salary requested&nbsp;<strong>{AMOUNT}</strong>&nbsp;has been Rejected by your company management.</p>\r\n\r\n<p><br />\r\nRegards<br />\r\n<br />\r\nThe {SITE_NAME} Team</p>\r\n');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (51, 'en', 'award_email', 'Award Received', '<p>Hello&nbsp;<strong>{NAME}</strong>,</p>\r\n\r\n<p>You have been&nbsp;awarded <strong>{AWARD_NAME} </strong>for this<strong> {MONTH} .</strong></p>\r\n\r\n<p><br />\r\nRegards<br />\r\n<br />\r\nThe {SITE_NAME} Team</p>\r\n');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (52, 'en', 'new_job_application_email', 'New job application submitted', '<p>Hi there,</p>\r\n\r\n<p>&nbsp;<strong>{NAME}&nbsp;</strong>has submitted the job application</p>\r\n\r\n<p>Please find below are job application Details:</p>\r\n\r\n<table cellpadding=\"8\" style=\"width:100%\">\r\n  <tbody>\r\n    <tr>\r\n      <td>Job Title</td>\r\n      <td><strong>{JOB_TITLE}</strong></td>\r\n    </tr>\r\n    <tr>\r\n      <td>Email</td>\r\n      <td><strong>{EMAIL}</strong></td>\r\n    </tr>\r\n    <tr>\r\n      <td>Mobile</td>\r\n      <td><strong>{MOBILE}</strong></td>\r\n    </tr>\r\n    <tr>\r\n      <td>Cover Latter</td>\r\n      <td><strong>{COVER_LETTER}</strong></td>\r\n    </tr>\r\n  </tbody>\r\n</table>\r\n\r\n<p><br />\r\nYou can view the Job Application online at:<br />\r\n<br />\r\n<big><strong><a href=\"{LINK}\">View Job Application</a></strong></big><br />\r\n<br />\r\nBest Regards,<br />\r\n<br />\r\nThe {SITE_NAME} Team</p>\r\n');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (53, 'en', 'new_notice_published', 'New Notice published', '<p>Hello&nbsp;<strong>{NAME}</strong>,</p>\r\n\r\n<p>New Notice Published&nbsp;<strong>{TITLE}</strong></p>\r\n\r\n<p><br />\r\nYou can view the Notice online at:<br />\r\n<br />\r\n<big><strong><a href=\"{LINK}\">View Notice</a></strong></big><br />\r\n<br />\r\nBest Regards,<br />\r\n<br />\r\nThe {SITE_NAME} Team</p>\r\n');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (54, 'en', 'new_training_email', 'Training  Assigned ', '<p>Hi there,</p>\r\n\r\n<p>A new Training  &nbsp;<strong>{TRAINING_NAME}</strong>&nbsp;&nbsp;has been assigned to you by&nbsp;<strong>{ASSIGNED_BY}</strong>.</p>\r\n\r\n<p>You can view this Training  by logging in to the portal using the link below.</p>\r\n\r\n<p><br />\r\n<big><strong><a href=\"{LINK}\">View Training</a></strong></big><br />\r\n<br />\r\nRegards<br />\r\nThe {SITE_NAME} Team</p>\r\n');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (55, 'en', 'performance_appraisal_email', 'New Performance Appraisal', '');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (56, 'en', 'expense_request_email', 'A New Expense Request have been Recieved', '<p>Hi there,</p>\r\n\r\n<p><strong>{NAME}</strong> &nbsp;Create a New Expense The Amount is <strong>{AMOUNT}</strong></p>\r\n\r\n<p>You can view this expense by logging in to the portal using the link below.<br />\r\n<br />\r\n<big><strong><a href=\"{URL}\">View Expense</a></strong></big><br />\r\n<br />\r\n<br />\r\nRegards,<br />\r\n<br />\r\nThe <strong>{SITE_NAME}</strong> Team</p>\r\n');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (57, 'en', 'expense_approved_email', 'Expense Approved', '<p>Dear&nbsp;<strong>{NAME} ,</strong></p>\r\n\r\n<h1>Your Expense request has been approved</h1>\r\n\r\n<p><strong>Congratulations!</strong>&nbsp;Your Expense request from&nbsp;<strong>{AMOUNT}</strong>&nbsp;has been approved by your company management.</p>\r\n\r\n<p>Please Contact&nbsp;with our Accountant for collect the amount.</p>\r\n\r\n<p><br />\r\nRegards,<br />\r\n<br />\r\nThe {SITE_NAME} Team</p>\r\n');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (58, 'en', 'expense_paid_email', 'Expense have been Paid', '<p>Hi there,</p>\r\n\r\n<p>The&nbsp;<strong>{NAME}</strong>&nbsp;expense&nbsp;<strong>{AMOUNT}&nbsp;</strong>has been paid by <strong>{PAID_BY}.</strong></p>\r\n\r\n<p>You can view this expense by logging in to the portal using the link below.<br />\r\n<br />\r\n<big><strong><a href=\"{URL}\">View Expense</a></strong></big><br />\r\n<br />\r\n<br />\r\nRegards,<br />\r\n<br />\r\nThe&nbsp;<strong>{SITE_NAME}</strong>&nbsp;Team</p>\r\n');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (59, 'en', 'auto_close_ticket', 'Ticket Auto Closed', '<p>Ticket Closed</p>\r\n\r\n<p>Hello <strong>{REPORTER_EMAIL}</strong>,</p>\r\n\r\n<p>Ticket&nbsp;<strong>{SUBJECT}</strong>&nbsp;has been auto closed due to inactivity.&nbsp;<br />\r\n<br />\r\nTicket # <strong>{TICKET_CODE}</strong><br />\r\nStatus : &nbsp;<strong>{TICKET_STATUS}</strong><br />\r\n<br />\r\nTo see the responses or open the ticket, click on the link below:ÃƒÆ’Ã†â€™Ãƒâ€ Ã¢â‚¬â„¢ÃƒÆ’Ã¢â‚¬Â ÃƒÂ¢Ã¢â€šÂ¬Ã¢â€žÂ¢ÃƒÆ’Ã†â€™ÃƒÂ¢Ã¢â€šÂ¬Ã‚Â ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â‚¬Å¡Ã‚Â¬ÃƒÂ¢Ã¢â‚¬Å¾Ã‚Â¢ÃƒÆ’Ã†â€™Ãƒâ€ Ã¢â‚¬â„¢ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â‚¬Å¡Ã‚Â¬Ãƒâ€šÃ‚Â ÃƒÆ’Ã†â€™Ãƒâ€šÃ‚Â¢ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â€šÂ¬Ã…Â¡Ãƒâ€šÃ‚Â¬ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â€šÂ¬Ã…Â¾Ãƒâ€šÃ‚Â¢ÃƒÆ’Ã†â€™Ãƒâ€ Ã¢â‚¬â„¢ÃƒÆ’Ã¢â‚¬Â ÃƒÂ¢Ã¢â€šÂ¬Ã¢â€žÂ¢ÃƒÆ’Ã†â€™Ãƒâ€šÃ‚Â¢ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â€šÂ¬Ã…Â¡Ãƒâ€šÃ‚Â¬ÃƒÆ’Ã¢â‚¬Å¡Ãƒâ€šÃ‚Â ÃƒÆ’Ã†â€™Ãƒâ€ Ã¢â‚¬â„¢ÃƒÆ’Ã¢â‚¬Å¡Ãƒâ€šÃ‚Â¢ÃƒÆ’Ã†â€™Ãƒâ€šÃ‚Â¢ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â‚¬Å¡Ã‚Â¬Ãƒâ€¦Ã‚Â¡ÃƒÆ’Ã¢â‚¬Å¡Ãƒâ€šÃ‚Â¬ÃƒÆ’Ã†â€™Ãƒâ€šÃ‚Â¢ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â‚¬Å¡Ã‚Â¬Ãƒâ€¦Ã‚Â¾ÃƒÆ’Ã¢â‚¬Å¡Ãƒâ€šÃ‚Â¢ÃƒÆ’Ã†â€™Ãƒâ€ Ã¢â‚¬â„¢ÃƒÆ’Ã¢â‚¬Â ÃƒÂ¢Ã¢â€šÂ¬Ã¢â€žÂ¢ÃƒÆ’Ã†â€™ÃƒÂ¢Ã¢â€šÂ¬Ã‚Â ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â‚¬Å¡Ã‚Â¬ÃƒÂ¢Ã¢â‚¬Å¾Ã‚Â¢ÃƒÆ’Ã†â€™Ãƒâ€ Ã¢â‚¬â„¢ÃƒÆ’Ã¢â‚¬Å¡Ãƒâ€šÃ‚Â¢ÃƒÆ’Ã†â€™Ãƒâ€šÃ‚Â¢ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â‚¬Å¡Ã‚Â¬Ãƒâ€¦Ã‚Â¡ÃƒÆ’Ã¢â‚¬Å¡Ãƒâ€šÃ‚Â¬ÃƒÆ’Ã†â€™ÃƒÂ¢Ã¢â€šÂ¬Ã‚Â¦ÃƒÆ’Ã¢â‚¬Å¡Ãƒâ€šÃ‚Â¡ÃƒÆ’Ã†â€™Ãƒâ€ Ã¢â‚¬â„¢ÃƒÆ’Ã¢â‚¬Â ÃƒÂ¢Ã¢â€šÂ¬Ã¢â€žÂ¢ÃƒÆ’Ã†â€™Ãƒâ€šÃ‚Â¢ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â€šÂ¬Ã…Â¡Ãƒâ€šÃ‚Â¬ÃƒÆ’Ã¢â‚¬Â¦Ãƒâ€šÃ‚Â¡ÃƒÆ’Ã†â€™Ãƒâ€ Ã¢â‚¬â„¢ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â‚¬Å¡Ã‚Â¬Ãƒâ€¦Ã‚Â¡ÃƒÆ’Ã†â€™ÃƒÂ¢Ã¢â€šÂ¬Ã…Â¡ÃƒÆ’Ã¢â‚¬Å¡Ãƒâ€šÃ‚Â¢ÃƒÆ’Ã†â€™Ãƒâ€ Ã¢â‚¬â„¢ÃƒÆ’Ã¢â‚¬Â ÃƒÂ¢Ã¢â€šÂ¬Ã¢â€žÂ¢ÃƒÆ’Ã†â€™ÃƒÂ¢Ã¢â€šÂ¬Ã‚Â ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â‚¬Å¡Ã‚Â¬ÃƒÂ¢Ã¢â‚¬Å¾Ã‚Â¢ÃƒÆ’Ã†â€™Ãƒâ€ Ã¢â‚¬â„¢ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â‚¬Å¡Ã‚Â¬Ãƒâ€šÃ‚Â ÃƒÆ’Ã†â€™Ãƒâ€šÃ‚Â¢ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â€šÂ¬Ã…Â¡Ãƒâ€šÃ‚Â¬ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â€šÂ¬Ã…Â¾Ãƒâ€šÃ‚Â¢ÃƒÆ’Ã†â€™Ãƒâ€ Ã¢â‚¬â„¢ÃƒÆ’Ã¢â‚¬Â ÃƒÂ¢Ã¢â€šÂ¬Ã¢â€žÂ¢ÃƒÆ’Ã†â€™Ãƒâ€šÃ‚Â¢ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â€šÂ¬Ã…Â¡Ãƒâ€šÃ‚Â¬ÃƒÆ’Ã¢â‚¬Â¦Ãƒâ€šÃ‚Â¡ÃƒÆ’Ã†â€™Ãƒâ€ Ã¢â‚¬â„¢ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â‚¬Å¡Ã‚Â¬Ãƒâ€¦Ã‚Â¡ÃƒÆ’Ã†â€™ÃƒÂ¢Ã¢â€šÂ¬Ã…Â¡ÃƒÆ’Ã¢â‚¬Å¡Ãƒâ€šÃ‚Â¢ÃƒÆ’Ã†â€™Ãƒâ€ Ã¢â‚¬â„¢ÃƒÆ’Ã¢â‚¬Â ÃƒÂ¢Ã¢â€šÂ¬Ã¢â€žÂ¢ÃƒÆ’Ã†â€™ÃƒÂ¢Ã¢â€šÂ¬Ã‚Â ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â‚¬Å¡Ã‚Â¬ÃƒÂ¢Ã¢â‚¬Å¾Ã‚Â¢ÃƒÆ’Ã†â€™Ãƒâ€ Ã¢â‚¬â„¢ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â‚¬Å¡Ã‚Â¬Ãƒâ€¦Ã‚Â¡ÃƒÆ’Ã†â€™ÃƒÂ¢Ã¢â€šÂ¬Ã…Â¡ÃƒÆ’Ã¢â‚¬Å¡Ãƒâ€šÃ‚Â¢ÃƒÆ’Ã†â€™Ãƒâ€ Ã¢â‚¬â„¢ÃƒÆ’Ã¢â‚¬Â ÃƒÂ¢Ã¢â€šÂ¬Ã¢â€žÂ¢ÃƒÆ’Ã†â€™ÃƒÂ¢Ã¢â€šÂ¬Ã…Â¡ÃƒÆ’Ã¢â‚¬Å¡Ãƒâ€šÃ‚Â¢ÃƒÆ’Ã†â€™Ãƒâ€ Ã¢â‚¬â„¢ÃƒÆ’Ã¢â‚¬Å¡Ãƒâ€šÃ‚Â¢ÃƒÆ’Ã†â€™Ãƒâ€šÃ‚Â¢ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â‚¬Å¡Ã‚Â¬Ãƒâ€¦Ã‚Â¡ÃƒÆ’Ã¢â‚¬Å¡Ãƒâ€šÃ‚Â¬ÃƒÆ’Ã†â€™ÃƒÂ¢Ã¢â€šÂ¬Ã‚Â¦ÃƒÆ’Ã¢â‚¬Å¡Ãƒâ€šÃ‚Â¡ÃƒÆ’Ã†â€™Ãƒâ€ Ã¢â‚¬â„¢ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â‚¬Å¡Ã‚Â¬Ãƒâ€¦Ã‚Â¡ÃƒÆ’Ã†â€™ÃƒÂ¢Ã¢â€šÂ¬Ã…Â¡ÃƒÆ’Ã¢â‚¬Å¡Ãƒâ€šÃ‚Â¬ÃƒÆ’Ã†â€™Ãƒâ€ Ã¢â‚¬â„¢ÃƒÆ’Ã¢â‚¬Â ÃƒÂ¢Ã¢â€šÂ¬Ã¢â€žÂ¢ÃƒÆ’Ã†â€™Ãƒâ€šÃ‚Â¢ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â€šÂ¬Ã…Â¡Ãƒâ€šÃ‚Â¬ÃƒÆ’Ã¢â‚¬Å¡Ãƒâ€šÃ‚Â¦ÃƒÆ’Ã†â€™Ãƒâ€ Ã¢â‚¬â„¢ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â‚¬Å¡Ã‚Â¬Ãƒâ€¦Ã‚Â¡ÃƒÆ’Ã†â€™ÃƒÂ¢Ã¢â€šÂ¬Ã…Â¡ÃƒÆ’Ã¢â‚¬Å¡Ãƒâ€šÃ‚Â¡ÃƒÆ’Ã†â€™Ãƒâ€ Ã¢â‚¬â„¢ÃƒÆ’Ã¢â‚¬Â ÃƒÂ¢Ã¢â€šÂ¬Ã¢â€žÂ¢ÃƒÆ’Ã†â€™ÃƒÂ¢Ã¢â€šÂ¬Ã‚Â ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â‚¬Å¡Ã‚Â¬ÃƒÂ¢Ã¢â‚¬Å¾Ã‚Â¢ÃƒÆ’Ã†â€™Ãƒâ€ Ã¢â‚¬â„¢ÃƒÆ’Ã¢â‚¬Å¡Ãƒâ€šÃ‚Â¢ÃƒÆ’Ã†â€™Ãƒâ€šÃ‚Â¢ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â‚¬Å¡Ã‚Â¬Ãƒâ€¦Ã‚Â¡ÃƒÆ’Ã¢â‚¬Å¡Ãƒâ€šÃ‚Â¬ÃƒÆ’Ã†â€™ÃƒÂ¢Ã¢â€šÂ¬Ã‚Â¦ÃƒÆ’Ã¢â‚¬Å¡Ãƒâ€šÃ‚Â¡ÃƒÆ’Ã†â€™Ãƒâ€ Ã¢â‚¬â„¢ÃƒÆ’Ã¢â‚¬Â ÃƒÂ¢Ã¢â€šÂ¬Ã¢â€žÂ¢ÃƒÆ’Ã†â€™Ãƒâ€šÃ‚Â¢ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â€šÂ¬Ã…Â¡Ãƒâ€šÃ‚Â¬ÃƒÆ’Ã¢â‚¬Â¦Ãƒâ€šÃ‚Â¡ÃƒÆ’Ã†â€™Ãƒâ€ Ã¢â‚¬â„¢ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â‚¬Å¡Ã‚Â¬Ãƒâ€¦Ã‚Â¡ÃƒÆ’Ã†â€™ÃƒÂ¢Ã¢â€šÂ¬Ã…Â¡ÃƒÆ’Ã¢â‚¬Å¡Ãƒâ€šÃ‚Â¬ÃƒÆ’Ã†â€™Ãƒâ€ Ã¢â‚¬â„¢ÃƒÆ’Ã¢â‚¬Â ÃƒÂ¢Ã¢â€šÂ¬Ã¢â€žÂ¢ÃƒÆ’Ã†â€™ÃƒÂ¢Ã¢â€šÂ¬Ã‚Â ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â‚¬Å¡Ã‚Â¬ÃƒÂ¢Ã¢â‚¬Å¾Ã‚Â¢ÃƒÆ’Ã†â€™Ãƒâ€ Ã¢â‚¬â„¢ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â‚¬Å¡Ã‚Â¬Ãƒâ€šÃ‚Â ÃƒÆ’Ã†â€™Ãƒâ€šÃ‚Â¢ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â€šÂ¬Ã…Â¡Ãƒâ€šÃ‚Â¬ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â€šÂ¬Ã…Â¾Ãƒâ€šÃ‚Â¢ÃƒÆ’Ã†â€™Ãƒâ€ Ã¢â‚¬â„¢ÃƒÆ’Ã¢â‚¬Â ÃƒÂ¢Ã¢â€šÂ¬Ã¢â€žÂ¢ÃƒÆ’Ã†â€™Ãƒâ€šÃ‚Â¢ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â€šÂ¬Ã…Â¡Ãƒâ€šÃ‚Â¬ÃƒÆ’Ã¢â‚¬Â¦Ãƒâ€šÃ‚Â¡ÃƒÆ’Ã†â€™Ãƒâ€ Ã¢â‚¬â„¢ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â‚¬Å¡Ã‚Â¬Ãƒâ€¦Ã‚Â¡ÃƒÆ’Ã†â€™ÃƒÂ¢Ã¢â€šÂ¬Ã…Â¡ÃƒÆ’Ã¢â‚¬Å¡Ãƒâ€šÃ‚Â¢ÃƒÆ’Ã†â€™Ãƒâ€ Ã¢â‚¬â„¢ÃƒÆ’Ã¢â‚¬Â ÃƒÂ¢Ã¢â€šÂ¬Ã¢â€žÂ¢ÃƒÆ’Ã†â€™ÃƒÂ¢Ã¢â€šÂ¬Ã‚Â ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â‚¬Å¡Ã‚Â¬ÃƒÂ¢Ã¢â‚¬Å¾Ã‚Â¢ÃƒÆ’Ã†â€™Ãƒâ€ Ã¢â‚¬â„¢ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â‚¬Å¡Ã‚Â¬Ãƒâ€¦Ã‚Â¡ÃƒÆ’Ã†â€™ÃƒÂ¢Ã¢â€šÂ¬Ã…Â¡ÃƒÆ’Ã¢â‚¬Å¡Ãƒâ€šÃ‚Â¢ÃƒÆ’Ã†â€™Ãƒâ€ Ã¢â‚¬â„¢ÃƒÆ’Ã¢â‚¬Â ÃƒÂ¢Ã¢â€šÂ¬Ã¢â€žÂ¢ÃƒÆ’Ã†â€™ÃƒÂ¢Ã¢â€šÂ¬Ã…Â¡ÃƒÆ’Ã¢â‚¬Å¡Ãƒâ€šÃ‚Â¢ÃƒÆ’Ã†â€™Ãƒâ€ Ã¢â‚¬â„¢ÃƒÆ’Ã¢â‚¬Å¡Ãƒâ€šÃ‚Â¢ÃƒÆ’Ã†â€™Ãƒâ€šÃ‚Â¢ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â€šÂ¬Ã…Â¡Ãƒâ€šÃ‚Â¬ÃƒÆ’Ã¢â‚¬Â¦Ãƒâ€šÃ‚Â¡ÃƒÆ’Ã†â€™ÃƒÂ¢Ã¢â€šÂ¬Ã…Â¡ÃƒÆ’Ã¢â‚¬Å¡Ãƒâ€šÃ‚Â¬ÃƒÆ’Ã†â€™Ãƒâ€ Ã¢â‚¬â„¢ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â‚¬Å¡Ã‚Â¬Ãƒâ€šÃ‚Â¦ÃƒÆ’Ã†â€™ÃƒÂ¢Ã¢â€šÂ¬Ã…Â¡ÃƒÆ’Ã¢â‚¬Å¡Ãƒâ€šÃ‚Â¡ÃƒÆ’Ã†â€™Ãƒâ€ Ã¢â‚¬â„¢ÃƒÆ’Ã¢â‚¬Â ÃƒÂ¢Ã¢â€šÂ¬Ã¢â€žÂ¢ÃƒÆ’Ã†â€™Ãƒâ€šÃ‚Â¢ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â€šÂ¬Ã…Â¡Ãƒâ€šÃ‚Â¬ÃƒÆ’Ã¢â‚¬Â¦Ãƒâ€šÃ‚Â¡ÃƒÆ’Ã†â€™Ãƒâ€ Ã¢â‚¬â„¢ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â‚¬Å¡Ã‚Â¬Ãƒâ€¦Ã‚Â¡ÃƒÆ’Ã†â€™ÃƒÂ¢Ã¢â€šÂ¬Ã…Â¡ÃƒÆ’Ã¢â‚¬Å¡Ãƒâ€šÃ‚Â¬ÃƒÆ’Ã†â€™Ãƒâ€ Ã¢â‚¬â„¢ÃƒÆ’Ã¢â‚¬Â ÃƒÂ¢Ã¢â€šÂ¬Ã¢â€žÂ¢ÃƒÆ’Ã†â€™ÃƒÂ¢Ã¢â€šÂ¬Ã‚Â ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â‚¬Å¡Ã‚Â¬ÃƒÂ¢Ã¢â‚¬Å¾Ã‚Â¢ÃƒÆ’Ã†â€™Ãƒâ€ Ã¢â‚¬â„¢ÃƒÆ’Ã¢â‚¬Å¡Ãƒâ€šÃ‚Â¢ÃƒÆ’Ã†â€™Ãƒâ€šÃ‚Â¢ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â‚¬Å¡Ã‚Â¬Ãƒâ€¦Ã‚Â¡ÃƒÆ’Ã¢â‚¬Å¡Ãƒâ€šÃ‚Â¬ÃƒÆ’Ã†â€™ÃƒÂ¢Ã¢â€šÂ¬Ã‚Â¦ÃƒÆ’Ã¢â‚¬Å¡Ãƒâ€šÃ‚Â¡ÃƒÆ’Ã†â€™Ãƒâ€ Ã¢â‚¬â„¢ÃƒÆ’Ã¢â‚¬Â ÃƒÂ¢Ã¢â€šÂ¬Ã¢â€žÂ¢ÃƒÆ’Ã†â€™Ãƒâ€šÃ‚Â¢ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â€šÂ¬Ã…Â¡Ãƒâ€šÃ‚Â¬ÃƒÆ’Ã¢â‚¬Â¦Ãƒâ€šÃ‚Â¡ÃƒÆ’Ã†â€™Ãƒâ€ Ã¢â‚¬â„¢ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â‚¬Å¡Ã‚Â¬Ãƒâ€¦Ã‚Â¡ÃƒÆ’Ã†â€™ÃƒÂ¢Ã¢â€šÂ¬Ã…Â¡ÃƒÆ’Ã¢â‚¬Å¡Ãƒâ€šÃ‚Â¹<br />\r\n<br />\r\n<big><strong><a href=\"{TICKET_LINK}\">View Ticket</a></strong></big><br />\r\n<br />\r\nRegards<br />\r\n<br />\r\nThe <strong>{SITE_NAME}</strong> Team</p>\r\n');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (60, 'en', 'proposal_email', 'New Proposal', '<p>Proposal <strong>{PROPOSAL_REF}</strong></p> <p>Hi <strong>{CLIENT}</strong></p> <p>Thanks for your business inquiry.</p> <p>The Proposal <strong>{PROPOSAL_REF} </strong>is attached with this email.<br /> Proposal&nbsp;Overview:<br /> Proposal&nbsp;# :<strong> {PROPOSAL_REF}</strong><br /> Amount: <strong>{CURRENCY} {AMOUNT}</strong><br /> <br /> You can view the estimate online at:<br /> <big><strong><a href=\"{PROPOSAL_LINK}\">View Proposal</a></strong></big><br /> <br /> Best Regards,<br /> The <strong>{SITE_NAME}</strong> Team</p> ');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (61, 'en', 'project_overdue_email', 'Project Overdue Notice', '<p>Project Overdue</p>\r\n\r\n<p><strong>Hello {CLIENT}</strong></p>\r\n\r\n<p>This is the notice that your project overdue.&nbsp;<br />\r\n<br />\r\nProject name : <strong>{PROJECT_NAME}</strong><br />\r\nDue date : <strong>{DUE_DATE}</strong><br />\r\nYou can login to see the status of your project by using this link:<br />\r\n<big><a href=\"{PROJECT_LINK}\"><strong>View Project</strong></a></big></p>\r\n\r\n<p><br />\r\nBest Regards<br />\r\nThe {SITE_NAME} Team</p>\r\n\r\n<p>&nbsp;</p>\r\n');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (62, 'en', 'estimate_overdue_email', 'Estimate Overdue Notice', '<p>Estimate {ESTIMATE_REF}</p>\r\n\r\n<p>Hi {CLIENT}</p>\r\n\r\n<p>This is the notice that your Estimate&nbsp;overdue.&nbsp;ÃƒÆ’Ã†â€™Ãƒâ€šÃ‚Â¢ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â€šÂ¬Ã…Â¡Ãƒâ€šÃ‚Â¬ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â‚¬Å¡Ã‚Â¬Ãƒâ€šÃ‚Â¹<br />\r\n<br />\r\nEstimate Overview:<br />\r\nEstimate # : {ESTIMATE_REF}<br />\r\nAmount: {DUE_DATE}<br />\r\nAmount: {CURRENCY} {AMOUNT}<br />\r\n<br />\r\nYou can view the estimate online at:<br />\r\n<big><strong><a href=\"{ESTIMATE_LINK}\">View Estimate</a></strong></big><br />\r\n<br />\r\nBest Regards,<br />\r\nThe {SITE_NAME} Team</p>\r\n');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (63, 'en', 'proposal_overdue_email', 'New Estimate', '<p>Proposal&nbsp;<strong>{PROPOSAL_REF}</strong></p>\r\n\r\n<p>Hi&nbsp;<strong>{CLIENT}</strong></p>\r\n\r\n<p>This is the notice that your Proposal&nbsp;overdue.&nbsp;<br />\r\n<br />\r\nProposal&nbsp;Overview:<br />\r\nProposal&nbsp;# :<strong>&nbsp;{PROPOSAL_REF}</strong><br />\r\nDue Date: <strong>{DUE_DATE}</strong>ÃƒÆ’Ã†â€™Ãƒâ€šÃ‚Â¢ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â€šÂ¬Ã…Â¡Ãƒâ€šÃ‚Â¬ÃƒÆ’Ã‚Â¢ÃƒÂ¢Ã¢â‚¬Å¡Ã‚Â¬Ãƒâ€šÃ‚Â¹<br />\r\nAmount:&nbsp;<strong>{CURRENCY} {AMOUNT}</strong><br />\r\n<br />\r\nYou can view the estimate online at:<br />\r\n<big><strong><a href=\"{PROPOSAL_LINK}\">View Proposal</a></strong></big><br />\r\n<br />\r\nBest Regards,<br />\r\nThe&nbsp;<strong>{SITE_NAME}</strong>&nbsp;Team</p>\r\n');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (64, 'en', 'call_for_interview', 'You have an interview offer!!!', '<p>Hello&nbsp;<strong>{NAME}</strong>,</p>\r\n\r\n<p>You have an interview offer for you.please see the details.&nbsp;<br />\r\n<br />\r\n<strong>Job Summary</strong>:<br />\r\nJob Title # :<strong>&nbsp;{JOB_TITLE}</strong><br />\r\nDesignation # :<strong>&nbsp;{DESIGNATION}</strong><br />\r\nInterview Date: <strong>{DATE}</strong></p>\r\n\r\n<p><strong>Postal Address</strong><br />\r\nPO Box 16122 Collins Street West<br />\r\nVictoria 8007 Australia<br />\r\n121 King Street, Melbourne<br />\r\nVictoria 3000 Australia &ndash;&nbsp;<a href=\"https://www.google.com.au/maps/place/Envato/@-37.8173306,144.9534631,17z/data=!3m1!4b1!4m2!3m1!1s0x6ad65d4c2b349649:0xb6899234e561db11\" target=\"_blank\">Map</a></p>\r\n\r\n<p><br />\r\nYou can view the circular details online at:<br />\r\n<big><strong><a href=\"{LINK}\">View Job Circular</a></strong></big><br />\r\n<br />\r\nBest Regards,<br />\r\nThe&nbsp;<strong>{SITE_NAME}</strong>&nbsp;Team</p>\r\n');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (65, 'en', 'ticket_reopened_email', 'Ticket [SUBJECT] reopened', '<p>Ticket re-opened</p>\r\n\r\n<p>Hi {RECIPIENT},</p>\r\n\r\n<p>Ticket&nbsp;<strong>{SUBJECT}</strong>&nbsp;was re-opened by&nbsp;<strong>{USER}</strong>.<br />\r\nStatus :&nbsp;Open<br />\r\nClick on the below link to see the ticket details and post replies:&nbsp;<br />\r\n<a href=\"{TICKET_LINK}\"><strong>View Ticket</strong></a><br />\r\n<br />\r\n<br />\r\nBest Regards,<br />\r\n{SITE_NAME}</p>\r\n');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (66, 'en', 'deposit_email', 'A deposit have been Received', '<p>Hi there,</p> <p>The&nbsp;<strong>{NAME}</strong>&nbsp;of deposit&nbsp;<strong>{AMOUNT}&nbsp;</strong>has been Deposit into <strong>{ACCOUNT}</strong> the new balance is <strong>{BALANCE}</strong></p> <p>You can view this deposit by logging in to the portal using the link below.<br /> <br /> <big><strong><a href=\"{URL}\">View Deposit</a></strong></big><br /> <br /> <br /> Regards,<br /> <br /> The&nbsp;<strong>{SITE_NAME}</strong>&nbsp;Team</p>');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (67, 'en', 'clock_in_email', 'The {NAME} Just clock in', '<p>Hi there,</p>\r\n\r\n<p>TheÃƒâ€šÃ‚Â <strong>{NAME}</strong> justÃƒâ€šÃ‚Â Clock In by using The IP. The IP is:Ãƒâ€šÃ‚Â <strong>{IP}</strong> and the time is: Ãƒâ€šÃ‚Â <strong>{TIME}</strong><strong> </strong></p>\r\n\r\n<p>You can view this attendance by logging in to the portal using the link below.<br>\r\n<br>\r\n<big><strong><a href=\"{URL}\">View Details</a></strong></big><br>\r\n<br>\r\n<br>\r\nRegards,<br>\r\n<br>\r\nTheÃƒâ€šÃ‚Â <strong>{SITE_NAME}</strong>Ãƒâ€šÃ‚Â Team</p>\r\n');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (68, 'en', 'trying_clock_email', 'The {NAME} Trying to clock', '<p>Hi there,</p>\r\n\r\n<p>TheÃƒâ€šÃ‚Â <strong>{NAME} </strong> Trying to clockÃƒâ€šÃ‚Â in by Unknown IP.The IP is: <strong>{IP}</strong> and the time is: <strong>{TIME}</strong></p>\r\n\r\n<p>You can view this IP by logging in to the portal using the link below.<br>\r\n<br>\r\n<big><strong><a href=\"{URL}\">View Details</a></strong></big><br>\r\n<br>\r\n<br>\r\nRegards,<br>\r\n<br>\r\nTheÃƒâ€šÃ‚Â <strong>{SITE_NAME}</strong>Ãƒâ€šÃ‚Â Team</p>\r\n');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (69, 'en', 'clock_out_email', 'The {NAME} Just clock Out', '<p>Hi there,</p>\r\n\r\n<p>TheÃƒâ€šÃ‚Â <strong>{NAME}</strong>Ãƒâ€šÃ‚Â justÃƒâ€šÃ‚Â Clock Out by using The IP. The IP is:Ãƒâ€šÃ‚Â <strong>{IP}</strong>Ãƒâ€šÃ‚Â and the time is: Ãƒâ€šÃ‚Â <strong>{TIME}</strong></p>\r\n\r\n<p>You can view this attendance by logging in to the portal using the link below.<br>\r\n<br>\r\n<big><strong><a href=\"{URL}\">View Details</a></strong></big><br>\r\n<br>\r\n<br>\r\nRegards,<br>\r\n<br>\r\nTheÃƒâ€šÃ‚Â <strong>{SITE_NAME}</strong>Ãƒâ€šÃ‚Â Team</p>\r\n');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (70, 'en', 'invoice_item_refund_request', 'A new Refunded request recived for Invoice {REF}', '<p><strong>Hello </strong><br> <br> A new item refunded request received for Invoice {REF}.<br> <br> You can view the invoice online at:<br> <big><strong><a href=\"{LINK}\">View Refund Stock </a></strong></big><br> <br> Best Regards<br> <br> The {SITE_NAME} Team</p> ');
INSERT INTO `tbl_email_templates` (`email_templates_id`, `code`, `email_group`, `subject`, `template_body`) VALUES (71, 'en', 'credit_note_email', 'New Credit Note', '<p>Credit Note {credit_note_REF}</p> <p>Hi {CLIENT}</p> <p>Thanks for your business inquiry.</p> <p>The Credit Note {credit_note_REF} is attached with this email.<br /> Credit Note Overview:<br /> Credit Note # : {credit_note_REF}<br /> Amount: {CURRENCY} {AMOUNT}<br /> <br /> You can view the Credit Note online at:<br /> <big><strong><a href=\"{credit_note_LINK}\">View Credit Note</a></strong></big><br /> <br /> Best Regards,<br /> The {SITE_NAME} Team</p> ');


#
# TABLE STRUCTURE FOR: tbl_employee_award
#

DROP TABLE IF EXISTS `tbl_employee_award`;

CREATE TABLE `tbl_employee_award` (
  `employee_award_id` int(11) NOT NULL AUTO_INCREMENT,
  `award_name` varchar(100) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `gift_item` varchar(300) DEFAULT NULL,
  `award_amount` int(11) DEFAULT NULL,
  `award_date` varchar(10) DEFAULT NULL,
  `view_status` tinyint(1) DEFAULT '2' COMMENT '1=Read 2=Unread',
  `given_date` date DEFAULT NULL,
  PRIMARY KEY (`employee_award_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_employee_bank
#

DROP TABLE IF EXISTS `tbl_employee_bank`;

CREATE TABLE `tbl_employee_bank` (
  `employee_bank_id` int(5) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `bank_name` varchar(300) NOT NULL,
  `branch_name` varchar(300) NOT NULL,
  `account_name` varchar(300) NOT NULL,
  `account_number` varchar(300) NOT NULL,
  `routing_number` varchar(50) DEFAULT NULL,
  `type_of_account` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`employee_bank_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_employee_document
#

DROP TABLE IF EXISTS `tbl_employee_document`;

CREATE TABLE `tbl_employee_document` (
  `document_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `resume` text,
  `resume_path` text,
  `resume_filename` text,
  `offer_letter` text,
  `offer_letter_filename` text,
  `offer_letter_path` text,
  `joining_letter` text,
  `joining_letter_filename` text,
  `joining_letter_path` text,
  `contract_paper` text,
  `contract_paper_filename` text,
  `contract_paper_path` text,
  `id_proff` text,
  `id_proff_filename` text,
  `id_proff_path` text,
  `other_document` text,
  PRIMARY KEY (`document_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_employee_payroll
#

DROP TABLE IF EXISTS `tbl_employee_payroll`;

CREATE TABLE `tbl_employee_payroll` (
  `payroll_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `salary_template_id` int(11) DEFAULT NULL,
  `hourly_rate_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`payroll_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_estimate_items
#

DROP TABLE IF EXISTS `tbl_estimate_items`;

CREATE TABLE `tbl_estimate_items` (
  `estimate_items_id` int(11) NOT NULL AUTO_INCREMENT,
  `estimates_id` int(11) NOT NULL,
  `saved_items_id` int(11) DEFAULT '0',
  `item_tax_rate` decimal(10,2) NOT NULL DEFAULT '0.00',
  `item_tax_name` text COLLATE utf8_unicode_ci,
  `item_name` varchar(150) COLLATE utf8_unicode_ci DEFAULT 'Item Name',
  `item_desc` longtext COLLATE utf8_unicode_ci,
  `unit_cost` decimal(10,2) DEFAULT '0.00',
  `quantity` decimal(10,2) DEFAULT '0.00',
  `item_tax_total` decimal(10,2) DEFAULT '0.00',
  `total_cost` decimal(10,2) DEFAULT '0.00',
  `date_saved` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `unit` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `hsn_code` text COLLATE utf8_unicode_ci,
  `order` int(11) DEFAULT '0',
  PRIMARY KEY (`estimate_items_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: tbl_estimates
#

DROP TABLE IF EXISTS `tbl_estimates`;

CREATE TABLE `tbl_estimates` (
  `estimates_id` int(11) NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `client_id` int(11) DEFAULT NULL,
  `project_id` int(11) DEFAULT '0',
  `estimate_date` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `estimate_month` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `estimate_year` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `due_date` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `alert_overdue` tinyint(1) NOT NULL DEFAULT '0',
  `currency` varchar(32) COLLATE utf8_unicode_ci DEFAULT 'USD',
  `discount_percent` int(2) DEFAULT NULL,
  `notes` text COLLATE utf8_unicode_ci,
  `tax` int(11) NOT NULL DEFAULT '0',
  `total_tax` text COLLATE utf8_unicode_ci,
  `status` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'Pending',
  `date_sent` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `est_deleted` enum('Yes','No') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'No',
  `date_saved` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `emailed` enum('Yes','No') COLLATE utf8_unicode_ci DEFAULT 'No',
  `show_client` enum('Yes','No') COLLATE utf8_unicode_ci DEFAULT 'No',
  `invoiced` enum('Yes','No') COLLATE utf8_unicode_ci DEFAULT 'No',
  `invoices_id` int(11) NOT NULL DEFAULT '0',
  `warehouse_id` int(11) DEFAULT NULL,
  `permission` text COLLATE utf8_unicode_ci,
  `client_visible` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'No',
  `discount_type` enum('none','before_tax','after_tax') CHARACTER SET utf8 NOT NULL DEFAULT 'none',
  `user_id` int(11) NOT NULL DEFAULT '0' COMMENT 'sales agent',
  `adjustment` decimal(18,2) NOT NULL DEFAULT '0.00',
  `discount_total` decimal(18,2) NOT NULL DEFAULT '0.00',
  `show_quantity_as` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `tags` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`estimates_id`),
  UNIQUE KEY `reference_no` (`reference_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: tbl_expense_category
#

DROP TABLE IF EXISTS `tbl_expense_category`;

CREATE TABLE `tbl_expense_category` (
  `expense_category_id` int(11) NOT NULL AUTO_INCREMENT,
  `expense_category` varchar(200) NOT NULL,
  `description` varchar(200) NOT NULL,
  PRIMARY KEY (`expense_category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_files
#

DROP TABLE IF EXISTS `tbl_files`;

CREATE TABLE `tbl_files` (
  `files_id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` int(11) NOT NULL,
  `title` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `uploaded_by` int(11) NOT NULL,
  `date_posted` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`files_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: tbl_form
#

DROP TABLE IF EXISTS `tbl_form`;

CREATE TABLE `tbl_form` (
  `form_id` int(11) NOT NULL AUTO_INCREMENT,
  `form_name` varchar(100) CHARACTER SET latin1 NOT NULL,
  `tbl_name` varchar(25) CHARACTER SET latin1 DEFAULT NULL,
  `table_id` varchar(110) DEFAULT NULL,
  PRIMARY KEY (`form_id`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8;

INSERT INTO `tbl_form` (`form_id`, `form_name`, `tbl_name`, `table_id`) VALUES (1, 'deposit', 'tbl_transactions', 'transactions_id');
INSERT INTO `tbl_form` (`form_id`, `form_name`, `tbl_name`, `table_id`) VALUES (2, 'expense', 'tbl_transactions', 'transactions_id');
INSERT INTO `tbl_form` (`form_id`, `form_name`, `tbl_name`, `table_id`) VALUES (3, 'tasks', 'tbl_task', 'task_id');
INSERT INTO `tbl_form` (`form_id`, `form_name`, `tbl_name`, `table_id`) VALUES (4, 'project', 'tbl_project', 'project_id');
INSERT INTO `tbl_form` (`form_id`, `form_name`, `tbl_name`, `table_id`) VALUES (5, 'leads', 'tbl_leads', 'leads_id');
INSERT INTO `tbl_form` (`form_id`, `form_name`, `tbl_name`, `table_id`) VALUES (6, 'bugs', 'tbl_bug', 'bug_id');
INSERT INTO `tbl_form` (`form_id`, `form_name`, `tbl_name`, `table_id`) VALUES (7, 'tickets', 'tbl_tickets', 'tickets_id');
INSERT INTO `tbl_form` (`form_id`, `form_name`, `tbl_name`, `table_id`) VALUES (8, 'opportunities', 'tbl_opportunities', 'opportunities_id');
INSERT INTO `tbl_form` (`form_id`, `form_name`, `tbl_name`, `table_id`) VALUES (9, 'invoice', 'tbl_invoices', 'invoices_id');
INSERT INTO `tbl_form` (`form_id`, `form_name`, `tbl_name`, `table_id`) VALUES (10, 'estimates', 'tbl_estimates', 'estimates_id');
INSERT INTO `tbl_form` (`form_id`, `form_name`, `tbl_name`, `table_id`) VALUES (11, 'proposal', 'tbl_proposals', 'proposals_id');
INSERT INTO `tbl_form` (`form_id`, `form_name`, `tbl_name`, `table_id`) VALUES (12, 'client', 'tbl_client', 'client_id');
INSERT INTO `tbl_form` (`form_id`, `form_name`, `tbl_name`, `table_id`) VALUES (13, 'users', 'tbl_account_details', 'account_details_id');
INSERT INTO `tbl_form` (`form_id`, `form_name`, `tbl_name`, `table_id`) VALUES (14, 'job_circular', 'tbl_job_circular', 'job_circular_id');
INSERT INTO `tbl_form` (`form_id`, `form_name`, `tbl_name`, `table_id`) VALUES (15, 'training', 'tbl_training', 'training_id');
INSERT INTO `tbl_form` (`form_id`, `form_name`, `tbl_name`, `table_id`) VALUES (16, 'announcements', 'tbl_announcements', 'announcements_id');
INSERT INTO `tbl_form` (`form_id`, `form_name`, `tbl_name`, `table_id`) VALUES (17, 'leave_management', 'tbl_leave_application', 'leave_application_id');
INSERT INTO `tbl_form` (`form_id`, `form_name`, `tbl_name`, `table_id`) VALUES (18, 'items', 'tbl_saved_items', 'saved_items_id');
INSERT INTO `tbl_form` (`form_id`, `form_name`, `tbl_name`, `table_id`) VALUES (19, 'supplier', 'tbl_suppliers', 'supplier_id');
INSERT INTO `tbl_form` (`form_id`, `form_name`, `tbl_name`, `table_id`) VALUES (20, 'purchases', 'tbl_purchases', 'purchase_id');
INSERT INTO `tbl_form` (`form_id`, `form_name`, `tbl_name`, `table_id`) VALUES (21, 'Account', 'tbl_accounts', 'account_id');
INSERT INTO `tbl_form` (`form_id`, `form_name`, `tbl_name`, `table_id`) VALUES (22, 'credit_note', 'tbl_credit_note', 'credit_note_id');


#
# TABLE STRUCTURE FOR: tbl_goal_tracking
#

DROP TABLE IF EXISTS `tbl_goal_tracking`;

CREATE TABLE `tbl_goal_tracking` (
  `goal_tracking_id` int(11) NOT NULL AUTO_INCREMENT,
  `subject` varchar(200) NOT NULL,
  `goal_type_id` int(11) NOT NULL,
  `achievement` int(10) NOT NULL,
  `start_date` varchar(20) NOT NULL,
  `end_date` varchar(20) NOT NULL,
  `account_id` int(11) DEFAULT '0',
  `description` mediumtext NOT NULL,
  `notify_goal_achive` varchar(5) DEFAULT NULL,
  `notify_goal_not_achive` varchar(5) DEFAULT NULL,
  `permission` mediumtext,
  `email_send` varchar(5) NOT NULL DEFAULT 'no',
  PRIMARY KEY (`goal_tracking_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_goal_type
#

DROP TABLE IF EXISTS `tbl_goal_type`;

CREATE TABLE `tbl_goal_type` (
  `goal_type_id` int(11) NOT NULL AUTO_INCREMENT,
  `type_name` varchar(200) NOT NULL,
  `description` mediumtext NOT NULL,
  `tbl_name` varchar(200) NOT NULL,
  `query` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`goal_type_id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;

INSERT INTO `tbl_goal_type` (`goal_type_id`, `type_name`, `description`, `tbl_name`, `query`) VALUES (1, 'achive_total_income', 'to get total income report from this start and end date and notify user. ', 'tbl_transactions', 'Income');
INSERT INTO `tbl_goal_type` (`goal_type_id`, `type_name`, `description`, `tbl_name`, `query`) VALUES (2, 'achive_total_income_by_bank', 'to get total income report from this start and end date and notify user. ', 'tbl_transactions', 'Income');
INSERT INTO `tbl_goal_type` (`goal_type_id`, `type_name`, `description`, `tbl_name`, `query`) VALUES (3, 'achieve_total_expense', 'to get total expense report from this start and end date and notify user. ', 'tbl_transactions', 'Expense');
INSERT INTO `tbl_goal_type` (`goal_type_id`, `type_name`, `description`, `tbl_name`, `query`) VALUES (4, 'achive_total_expense_by_bank', 'to get total expense report from this start and end date and notify user. ', 'tbl_transactions', 'Expense');
INSERT INTO `tbl_goal_type` (`goal_type_id`, `type_name`, `description`, `tbl_name`, `query`) VALUES (5, 'make_invoice', 'to get targeted invoice from this start and end date and notify user. ', 'tbl_invoices', NULL);
INSERT INTO `tbl_goal_type` (`goal_type_id`, `type_name`, `description`, `tbl_name`, `query`) VALUES (6, 'make_estimate', 'to get targeted estimate from this start and end date and notify user.', 'tbl_estimates', NULL);
INSERT INTO `tbl_goal_type` (`goal_type_id`, `type_name`, `description`, `tbl_name`, `query`) VALUES (7, 'goal_payment', 'to get total payment report from this start and end date and notify user. ', 'tbl_payments', NULL);
INSERT INTO `tbl_goal_type` (`goal_type_id`, `type_name`, `description`, `tbl_name`, `query`) VALUES (8, 'task_done', 'to get total done tasks report from this start and end date and notify user. ', 'tbl_task', NULL);
INSERT INTO `tbl_goal_type` (`goal_type_id`, `type_name`, `description`, `tbl_name`, `query`) VALUES (9, 'resolved_bugs', 'to get total resolve bugs report from this start and end date and notify user. ', 'tbl_bug', NULL);
INSERT INTO `tbl_goal_type` (`goal_type_id`, `type_name`, `description`, `tbl_name`, `query`) VALUES (10, 'convert_leads_to_client', 'to get total Convert leads to client report from this start and end date and notify user. ', 'tbl_client', NULL);
INSERT INTO `tbl_goal_type` (`goal_type_id`, `type_name`, `description`, `tbl_name`, `query`) VALUES (11, 'direct_client', 'to get total client report from this start and end date and notify user. ', 'tbl_client', NULL);
INSERT INTO `tbl_goal_type` (`goal_type_id`, `type_name`, `description`, `tbl_name`, `query`) VALUES (12, 'complete_project_goal', 'to get total complete project report from this start and end date and notify user. ', 'tbl_project', NULL);


#
# TABLE STRUCTURE FOR: tbl_holiday
#

DROP TABLE IF EXISTS `tbl_holiday`;

CREATE TABLE `tbl_holiday` (
  `holiday_id` int(11) NOT NULL AUTO_INCREMENT,
  `event_name` varchar(200) NOT NULL,
  `description` text NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `location` varchar(200) DEFAULT NULL,
  `color` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`holiday_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_hourly_rate
#

DROP TABLE IF EXISTS `tbl_hourly_rate`;

CREATE TABLE `tbl_hourly_rate` (
  `hourly_rate_id` int(11) NOT NULL AUTO_INCREMENT,
  `hourly_grade` varchar(200) NOT NULL,
  `hourly_rate` varchar(50) NOT NULL,
  PRIMARY KEY (`hourly_rate_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_inbox
#

DROP TABLE IF EXISTS `tbl_inbox`;

CREATE TABLE `tbl_inbox` (
  `inbox_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `to` varchar(100) NOT NULL,
  `from` varchar(100) NOT NULL,
  `subject` varchar(300) NOT NULL,
  `message_body` text NOT NULL,
  `attach_file` text,
  `attach_file_path` text,
  `attach_filename` text,
  `message_time` datetime NOT NULL,
  `view_status` tinyint(1) NOT NULL DEFAULT '2' COMMENT '1=Read 2=Unread',
  `favourites` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0= no 1=yes',
  `notify_me` tinyint(1) NOT NULL DEFAULT '1' COMMENT '1=on 0=off',
  `deleted` enum('Yes','No') NOT NULL DEFAULT 'No',
  PRIMARY KEY (`inbox_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_income_category
#

DROP TABLE IF EXISTS `tbl_income_category`;

CREATE TABLE `tbl_income_category` (
  `income_category_id` int(11) NOT NULL AUTO_INCREMENT,
  `income_category` varchar(200) NOT NULL,
  `description` varchar(200) NOT NULL,
  PRIMARY KEY (`income_category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_invoices
#

DROP TABLE IF EXISTS `tbl_invoices`;

CREATE TABLE `tbl_invoices` (
  `invoices_id` int(11) NOT NULL AUTO_INCREMENT,
  `recur_start_date` varchar(20) CHARACTER SET utf8 DEFAULT NULL,
  `recur_end_date` varchar(20) CHARACTER SET utf8 DEFAULT NULL,
  `reference_no` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `client_id` int(11) NOT NULL,
  `project_id` int(11) DEFAULT '0',
  `invoice_date` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `invoice_month` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `invoice_year` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `due_date` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `alert_overdue` tinyint(1) NOT NULL DEFAULT '0',
  `notes` text COLLATE utf8_unicode_ci NOT NULL,
  `tax` decimal(10,2) NOT NULL DEFAULT '0.00',
  `total_tax` text COLLATE utf8_unicode_ci,
  `discount_percent` int(2) DEFAULT NULL,
  `recurring` enum('Yes','No') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'No',
  `recuring_frequency` int(11) NOT NULL DEFAULT '31',
  `recur_frequency` varchar(12) COLLATE utf8_unicode_ci DEFAULT NULL,
  `recur_next_date` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `currency` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'USD',
  `status` enum('Cancelled','Unpaid','Paid','draft','partially_paid') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'Unpaid',
  `archived` int(11) DEFAULT '0',
  `date_sent` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `inv_deleted` enum('Yes','No') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'No',
  `date_saved` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `emailed` enum('Yes','No') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'No',
  `show_client` enum('Yes','No') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'Yes',
  `viewed` enum('Yes','No') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'No',
  `allow_paypal` enum('Yes','No') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'Yes',
  `allow_stripe` enum('Yes','No') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'Yes',
  `allow_2checkout` enum('Yes','No') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'Yes',
  `allow_authorize_net` enum('Yes','No') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'No',
  `allow_ccavenue` enum('Yes','No') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'No',
  `allow_braintree` enum('Yes','No') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'No',
  `allow_mollie` enum('Yes','No') COLLATE utf8_unicode_ci DEFAULT 'No',
  `allow_payumoney` enum('Yes','No') COLLATE utf8_unicode_ci DEFAULT 'No',
  `allow_tappayment` enum('Yes','No') COLLATE utf8_unicode_ci DEFAULT 'Yes',
  `allow_razorpay` enum('Yes','No') COLLATE utf8_unicode_ci DEFAULT 'No',
  `permission` text COLLATE utf8_unicode_ci,
  `client_visible` enum('Yes','No') COLLATE utf8_unicode_ci DEFAULT 'No',
  `discount_type` varchar(50) CHARACTER SET utf8 DEFAULT 'none',
  `user_id` int(11) NOT NULL DEFAULT '0' COMMENT 'sales agent',
  `adjustment` decimal(18,2) NOT NULL DEFAULT '0.00',
  `discount_total` decimal(18,2) NOT NULL DEFAULT '0.00',
  `show_quantity_as` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `warehouse_id` int(11) DEFAULT NULL,
  `tags` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`invoices_id`),
  UNIQUE KEY `reference_no` (`reference_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: tbl_item_history
#

DROP TABLE IF EXISTS `tbl_item_history`;

CREATE TABLE `tbl_item_history` (
  `item_history_id` int(11) NOT NULL AUTO_INCREMENT,
  `stock_id` int(11) NOT NULL,
  `inventory` int(5) NOT NULL,
  `purchase_date` date NOT NULL,
  PRIMARY KEY (`item_history_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_items
#

DROP TABLE IF EXISTS `tbl_items`;

CREATE TABLE `tbl_items` (
  `items_id` int(11) NOT NULL AUTO_INCREMENT,
  `invoices_id` int(11) NOT NULL,
  `item_tax_rate` decimal(18,2) NOT NULL DEFAULT '0.00',
  `item_tax_name` text COLLATE utf8_unicode_ci,
  `item_tax_total` decimal(18,2) NOT NULL DEFAULT '0.00',
  `quantity` decimal(18,2) DEFAULT '0.00',
  `total_cost` decimal(18,2) DEFAULT '0.00',
  `item_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT 'Item Name',
  `item_desc` longtext COLLATE utf8_unicode_ci,
  `unit_cost` decimal(18,2) DEFAULT '0.00',
  `order` int(11) DEFAULT '0',
  `date_saved` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `unit` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `hsn_code` text COLLATE utf8_unicode_ci,
  `saved_items_id` int(11) DEFAULT '0',
  PRIMARY KEY (`items_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: tbl_job_appliactions
#

DROP TABLE IF EXISTS `tbl_job_appliactions`;

CREATE TABLE `tbl_job_appliactions` (
  `job_appliactions_id` int(11) NOT NULL AUTO_INCREMENT,
  `job_circular_id` int(11) NOT NULL,
  `name` varchar(200) NOT NULL,
  `email` varchar(100) NOT NULL,
  `mobile` varchar(15) NOT NULL,
  `cover_letter` text NOT NULL,
  `resume` text NOT NULL,
  `application_status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0=pending 1=accept 2 = reject',
  `apply_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `send_email` varchar(20) DEFAULT NULL,
  `interview_date` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`job_appliactions_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_job_circular
#

DROP TABLE IF EXISTS `tbl_job_circular`;

CREATE TABLE `tbl_job_circular` (
  `job_circular_id` int(11) NOT NULL AUTO_INCREMENT,
  `job_title` varchar(200) NOT NULL,
  `designations_id` int(11) NOT NULL,
  `vacancy_no` varchar(50) NOT NULL,
  `posted_date` date NOT NULL,
  `employment_type` enum('contractual','full_time','part_time') NOT NULL DEFAULT 'full_time',
  `experience` varchar(200) DEFAULT NULL,
  `age` varchar(200) DEFAULT NULL,
  `salary_range` varchar(200) DEFAULT NULL,
  `last_date` date NOT NULL,
  `description` text NOT NULL,
  `status` enum('published','unpublished') NOT NULL DEFAULT 'unpublished' COMMENT '1=publish 2=unpublish',
  `created_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `permission` text,
  PRIMARY KEY (`job_circular_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_kb_category
#

DROP TABLE IF EXISTS `tbl_kb_category`;

CREATE TABLE `tbl_kb_category` (
  `kb_category_id` int(11) NOT NULL AUTO_INCREMENT,
  `category` varchar(200) DEFAULT NULL,
  `description` longtext,
  `type` varchar(50) NOT NULL,
  `sort` int(2) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`kb_category_id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;

INSERT INTO `tbl_kb_category` (`kb_category_id`, `category`, `description`, `type`, `sort`, `status`) VALUES (1, 'Installation', '', 'kb', 1, 1);
INSERT INTO `tbl_kb_category` (`kb_category_id`, `category`, `description`, `type`, `sort`, `status`) VALUES (2, 'Settings', '', 'kb', 2, 1);
INSERT INTO `tbl_kb_category` (`kb_category_id`, `category`, `description`, `type`, `sort`, `status`) VALUES (3, 'Stock', '', 'kb', 3, 1);
INSERT INTO `tbl_kb_category` (`kb_category_id`, `category`, `description`, `type`, `sort`, `status`) VALUES (4, 'Attendance', '', 'kb', 4, 1);
INSERT INTO `tbl_kb_category` (`kb_category_id`, `category`, `description`, `type`, `sort`, `status`) VALUES (5, 'Recruitment', '', 'kb', 5, 1);
INSERT INTO `tbl_kb_category` (`kb_category_id`, `category`, `description`, `type`, `sort`, `status`) VALUES (6, 'Payroll', '', 'kb', 6, 1);
INSERT INTO `tbl_kb_category` (`kb_category_id`, `category`, `description`, `type`, `sort`, `status`) VALUES (7, 'Performance', '', 'kb', 7, 1);
INSERT INTO `tbl_kb_category` (`kb_category_id`, `category`, `description`, `type`, `sort`, `status`) VALUES (8, 'Utilities', '', 'kb', 8, 1);
INSERT INTO `tbl_kb_category` (`kb_category_id`, `category`, `description`, `type`, `sort`, `status`) VALUES (9, 'Sales', '', 'kb', 9, 1);
INSERT INTO `tbl_kb_category` (`kb_category_id`, `category`, `description`, `type`, `sort`, `status`) VALUES (10, 'Transactions', '', 'kb', 10, 1);
INSERT INTO `tbl_kb_category` (`kb_category_id`, `category`, `description`, `type`, `sort`, `status`) VALUES (11, 'More Features', '', 'kb', 11, 1);
INSERT INTO `tbl_kb_category` (`kb_category_id`, `category`, `description`, `type`, `sort`, `status`) VALUES (12, 'Payment Gateways', '', 'kb', 12, 1);


#
# TABLE STRUCTURE FOR: tbl_knowledgebase
#

DROP TABLE IF EXISTS `tbl_knowledgebase`;

CREATE TABLE `tbl_knowledgebase` (
  `kb_id` int(11) NOT NULL AUTO_INCREMENT,
  `kb_category_id` int(11) NOT NULL,
  `title` text,
  `slug` text,
  `description` text,
  `attachments` text,
  `for_all` enum('Yes','No') DEFAULT 'No',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `total_view` int(11) NOT NULL DEFAULT '0',
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `sort` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`kb_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `tbl_knowledgebase` (`kb_id`, `kb_category_id`, `title`, `slug`, `description`, `attachments`, `for_all`, `status`, `total_view`, `created_by`, `created_at`, `sort`) VALUES (1, 1, 'How to setup a cronjob in cPanel', 'how_to_setup_a_cronjob_in_cpanel', '<h5 xss=\"removed\">Basic Cronjob</h5><p xss=\"removed\">The basic cronjob should run at least once a day and is used in order to activate automated tasks like recurring invoices (subscriptions) and automatic database backup. Please refer to your web host providers FAQ in order to find out how to set up a cronjob/crontab (if your hosting package includes cronjobs).</p><p xss=\"removed\">The command should look like this: wget http://www.your-domain.com/cronjob</p><p xss=\"removed\">Your hosting package does not include cronjob/crontab? No problem! There are many websites who offer free cronjob services. One of them is www.setcronjob.com.</p><h5 id=\"emailticketcronjob\" xss=\"removed\">Email Ticket Cronjob</h5><p xss=\"removed\">The email ticket cronjob should run every 10 minutes and is used in order to activate email tickets.</p><p xss=\"removed\">The command should look like this (you can find your cronjob command in Settings->Ticket->Postmaster cronjob link): <span xss=\"removed\">wget http://www.your-domain.com/postmaster -O /dev/null</span></p><h5 xss=\"removed\">How to setup a cronjob in Plesk</h5><p xss=\"removed\">If your web server is running Plesk you can check out the following instruction:</p><p xss=\"removed\">1. Go to <em xss=\"removed\">Tools and Settings</em> -> <em xss=\"removed\">Scheduled Tasks</em></p><p xss=\"removed\">2. Click on <em xss=\"removed\">Add new Task</em></p><div><p xss=\"removed\">3. Enter all the details like on the screenshot below. Important – change the cronjob link (Command) to your personal one. You can find it in Ultimate Project Manager CRM PRO under <em xss=\"removed\">Settings</em> -> <em xss=\"removed\">Cronjob</em><br><span xss=\"removed\">Note that you have to enter “wget” in front of the command link.</span></p></div>', '', 'Yes', 1, 0, 5, '2023-07-12 14:24:51', 0);
INSERT INTO `tbl_knowledgebase` (`kb_id`, `kb_category_id`, `title`, `slug`, `description`, `attachments`, `for_all`, `status`, `total_view`, `created_by`, `created_at`, `sort`) VALUES (2, 1, 'Installation Process', 'installation_process', '<ul xss=\"removed\"><li xss=\"removed\">Unzip the downloaded folder</li><li xss=\"removed\">Copy the files inside the zip folder: “Ultimate Project Manager CRM PRO” into your server</li><li xss=\"removed\">The auto web installer will start</li><li xss=\"removed\">Make sure <em xss=\"removed\">application/config/database.php</em> to be writable</li><li xss=\"removed\">Enter your database settings</li><li xss=\"removed\">Press the “Install” button.</li><li xss=\"removed\">That’s it!</li></ul><p xss=\"removed\"><span xss=\"removed\">Configure database connection</span></p><p xss=\"removed\">You need to have previously setup database from the cPanel.</p><p xss=\"removed\">Here is a good tutorial on <a href=\"https://www.namecheap.com/support/knowledgebase/article.aspx/9363/2180/how-to-create-and-maintain-mysql-databases-in-cpanel\" target=\"_blank\" rel=\"noopener\" xss=\"removed\">how to setup MySQL database in cPanel</a> if you are not familiar with this.</p><ol xss=\"removed\"><li xss=\"removed\">Login to cPanel by accessing www.yourdomain.com/cpanel and navigate go MySQL Databases.</li><li xss=\"removed\">Create a database first.</li><li xss=\"removed\">Create user and setup your password.</li><li xss=\"removed\">Add the user to the database by selecting the database and the username.</li></ol><p xss=\"removed\">Make sure you have checked All privileged when adding the user to a database.</p><p xss=\"removed\"> </p>', '', 'Yes', 1, 0, 5, '2023-07-12 14:26:49', 0);
INSERT INTO `tbl_knowledgebase` (`kb_id`, `kb_category_id`, `title`, `slug`, `description`, `attachments`, `for_all`, `status`, `total_view`, `created_by`, `created_at`, `sort`) VALUES (3, 1, 'Server Requirements', 'server_requirements', '<p xss=removed><span xss=removed>Your server needs to meet the following requirements in order to run Ultimate Project Manager CRM PRO.</span></p><ul xss=removed><li xss=removed>PHP 5.6+</li><li xss=removed>MySQL 5.1+</li><li xss=removed>mod_rewrite Apache</li><li xss=removed>MySQLi PHP Extension</li><li xss=removed>PDO PHP Extension</li><li xss=removed>cURL PHP Extension</li><li xss=removed>OpenSSL PHP Extension</li><li xss=removed>MBString PHP Extension</li><li xss=removed>iconv PHP Extension</li><li xss=removed>IMAP PHP Extension</li><li xss=removed>GD PHP Extension</li><li xss=removed>Zip PHP Extension</li><li xss=removed>allow_url_fopen enabled</li></ul>', '', 'Yes', 1, 0, 5, '2023-07-12 14:28:08', 0);
INSERT INTO `tbl_knowledgebase` (`kb_id`, `kb_category_id`, `title`, `slug`, `description`, `attachments`, `for_all`, `status`, `total_view`, `created_by`, `created_at`, `sort`) VALUES (4, 1, 'Installing on IIS – Windows Server', 'installing_on_iis_windows_server', '<div class=\"alert alert-warning\" xss=\"removed\">You will <span xss=\"removed\">need mod_rewrite enabled</span> to apply the configs below</div><p xss=\"removed\">Place the<span xss=\"removed\"> web.config file</span> in the folder where you are trying to install KreativKollectiv CRM PRO.</p><p xss=\"removed\">Use the following web.config file to install on the IIS server.</p><pre xss=\"removed\">&lt;!--?xml version=\"1.0\" encoding=\"UTF-8\"?--&gt;\n<configuration>\n       \n   <system>\n              \n      <rewrite>\n                     \n         <rules>\n                            \n            <rule name=\"Imported Rule 1\" stopprocessing=\"true\">\n                                   \n               <match url=\"^(.*)$\" ignorecase=\"false\">\n                                       \n               <conditions logicalgrouping=\"MatchAll\">\n                                              \n                  <add input=\"{REQUEST_FILENAME}\" matchtype=\"IsDirectory\" negate=\"true\">\n                                              \n                  <add input=\"{REQUEST_FILENAME}\" matchtype=\"IsFile\" negate=\"true\">\n                                          \n               </add></add></conditions>\n                                       \n               <action type=\"Rewrite\" url=\"index.php?url={R:1}\" appendquerystring=\"true\">\n                               \n            </action></match></rule>\n                        \n         </rules>\n                 \n      </rewrite>\n          \n   </system>\n</configuration></pre><p xss=\"removed\">If this web.config doesn’t work try the following:</p><pre xss=\"removed\">&lt;!--?xml version=“1.0” encoding=“UTF-8”?--&gt;\n<configuration>\n   <system>\n      <asp scripterrorsenttobrowser=\"“true”\">\n      <httperrors existingresponse=\"“PassThrough”\" errormode=\"“Detailed”\"></httperrors>\n      <rewrite>\n         <rules>\n            <rule name=\"“Imported\" stopprocessing=\"“true”\">\n               <match url=\"“^(.*)$”\" ignorecase=\"“false”\">\n               <conditions logicalgrouping=\"“MatchAll”\">\n                  <add input=\"“{REQUEST_FILENAME}”\" matchtype=\"“IsDirectory”\" negate=\"“true”\">\n                  <add input=\"“{REQUEST_FILENAME}”\" matchtype=\"“IsFile”\" negate=\"“true”\">\n               </add></add></conditions>\n               <action type=\"“Rewrite”\" url=\"“index.php?url\" appendquerystring=\"“true”\">\n            </action></match></rule>\n         </rules>\n      </rewrite>\n   </asp></system>\n   <system>\n      <customerrors mode=\"“Off”\"></customerrors>\n      <compilation debug=\"“true”\"></compilation>\n   </system>\n</configuration></pre><p xss=\"removed\">If you installed KreativKollectiv CRM PRO in a subfolder or in a subdomain and both web.config files above don’t work, please try this web.config file:</p>', '', 'Yes', 1, 1, 5, '2023-07-12 14:30:31', 0);


#
# TABLE STRUCTURE FOR: tbl_languages
#

DROP TABLE IF EXISTS `tbl_languages`;

CREATE TABLE `tbl_languages` (
  `code` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `icon` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `active` int(2) DEFAULT '0',
  PRIMARY KEY (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `tbl_languages` (`code`, `name`, `icon`, `active`) VALUES ('ar', 'arabic', 'ae', 0);
INSERT INTO `tbl_languages` (`code`, `name`, `icon`, `active`) VALUES ('cs', 'czech', 'cs', 0);
INSERT INTO `tbl_languages` (`code`, `name`, `icon`, `active`) VALUES ('da', 'danish', 'dk', 0);
INSERT INTO `tbl_languages` (`code`, `name`, `icon`, `active`) VALUES ('de', 'german', 'de', 0);
INSERT INTO `tbl_languages` (`code`, `name`, `icon`, `active`) VALUES ('el', 'greek', 'gr', 0);
INSERT INTO `tbl_languages` (`code`, `name`, `icon`, `active`) VALUES ('en', 'english', 'us', 1);
INSERT INTO `tbl_languages` (`code`, `name`, `icon`, `active`) VALUES ('es', 'spanish', 'es', 0);
INSERT INTO `tbl_languages` (`code`, `name`, `icon`, `active`) VALUES ('fr', 'french', 'fr', 0);
INSERT INTO `tbl_languages` (`code`, `name`, `icon`, `active`) VALUES ('gu', 'gujarati', 'in', 0);
INSERT INTO `tbl_languages` (`code`, `name`, `icon`, `active`) VALUES ('hi', 'hindi', 'in', 0);
INSERT INTO `tbl_languages` (`code`, `name`, `icon`, `active`) VALUES ('id', 'indonesian', 'id', 0);
INSERT INTO `tbl_languages` (`code`, `name`, `icon`, `active`) VALUES ('it', 'italian', 'it', 0);
INSERT INTO `tbl_languages` (`code`, `name`, `icon`, `active`) VALUES ('ja', 'japanese', 'jp', 0);
INSERT INTO `tbl_languages` (`code`, `name`, `icon`, `active`) VALUES ('nl', 'dutch', 'nl', 0);
INSERT INTO `tbl_languages` (`code`, `name`, `icon`, `active`) VALUES ('no', 'norwegian', 'no', 0);
INSERT INTO `tbl_languages` (`code`, `name`, `icon`, `active`) VALUES ('pl', 'polish', 'pl', 0);
INSERT INTO `tbl_languages` (`code`, `name`, `icon`, `active`) VALUES ('pt', 'portuguese', 'pt', 0);
INSERT INTO `tbl_languages` (`code`, `name`, `icon`, `active`) VALUES ('ro', 'romanian', 'ro', 0);
INSERT INTO `tbl_languages` (`code`, `name`, `icon`, `active`) VALUES ('ru', 'russian', 'ru', 0);
INSERT INTO `tbl_languages` (`code`, `name`, `icon`, `active`) VALUES ('tr', 'turkish', 'tr', 0);
INSERT INTO `tbl_languages` (`code`, `name`, `icon`, `active`) VALUES ('vi', 'vietnamese', 'vn', 0);
INSERT INTO `tbl_languages` (`code`, `name`, `icon`, `active`) VALUES ('zh', 'chinese', 'cn', 0);


#
# TABLE STRUCTURE FOR: tbl_lead_form
#

DROP TABLE IF EXISTS `tbl_lead_form`;

CREATE TABLE `tbl_lead_form` (
  `lead_form_id` int(11) NOT NULL AUTO_INCREMENT,
  `form_key` varchar(32) NOT NULL,
  `form_name` varchar(200) NOT NULL,
  `lead_status_id` int(11) NOT NULL,
  `lead_source_id` int(11) NOT NULL,
  `language` varchar(40) DEFAULT NULL,
  `form_recaptcha` int(11) NOT NULL DEFAULT '0',
  `submit_btn_text` varchar(40) DEFAULT NULL,
  `submit_btn_msg` text,
  `allow_duplicate` int(11) NOT NULL DEFAULT '1',
  `track_duplicate_field` varchar(100) DEFAULT NULL,
  `form_data` mediumtext,
  `notify_lead_imported` int(11) NOT NULL DEFAULT '1',
  `permission` text,
  `create_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`lead_form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_lead_source
#

DROP TABLE IF EXISTS `tbl_lead_source`;

CREATE TABLE `tbl_lead_source` (
  `lead_source_id` int(11) NOT NULL AUTO_INCREMENT,
  `lead_source` varchar(100) NOT NULL,
  PRIMARY KEY (`lead_source_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `tbl_lead_source` (`lead_source_id`, `lead_source`) VALUES (1, 'Just Dial');
INSERT INTO `tbl_lead_source` (`lead_source_id`, `lead_source`) VALUES (2, 'Google ');


#
# TABLE STRUCTURE FOR: tbl_lead_status
#

DROP TABLE IF EXISTS `tbl_lead_status`;

CREATE TABLE `tbl_lead_status` (
  `lead_status_id` int(11) NOT NULL AUTO_INCREMENT,
  `lead_status` varchar(50) NOT NULL,
  `lead_type` varchar(20) DEFAULT NULL,
  `order_no` int(11) DEFAULT NULL,
  PRIMARY KEY (`lead_status_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `tbl_lead_status` (`lead_status_id`, `lead_status`, `lead_type`, `order_no`) VALUES (1, 'Open', 'open', 1);


#
# TABLE STRUCTURE FOR: tbl_leads
#

DROP TABLE IF EXISTS `tbl_leads`;

CREATE TABLE `tbl_leads` (
  `leads_id` int(11) NOT NULL AUTO_INCREMENT,
  `lead_name` varchar(50) NOT NULL,
  `client_id` int(11) DEFAULT NULL,
  `organization` varchar(50) NOT NULL,
  `lead_status_id` int(11) DEFAULT NULL,
  `lead_source_id` int(11) DEFAULT NULL,
  `imported_from_email` tinyint(1) DEFAULT '0',
  `email_integration_uid` varchar(30) DEFAULT NULL,
  `company_name` varchar(255) DEFAULT NULL,
  `address` text NOT NULL,
  `country` varchar(50) DEFAULT NULL,
  `state` varchar(50) DEFAULT NULL,
  `city` varchar(50) NOT NULL,
  `contact_name` varchar(255) NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `email` varchar(255) NOT NULL,
  `phone` varchar(32) NOT NULL,
  `mobile` varchar(32) NOT NULL,
  `facebook` varchar(32) NOT NULL,
  `language` varchar(100) DEFAULT NULL,
  `notes` text NOT NULL,
  `created_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `last_contact` timestamp NULL DEFAULT NULL,
  `skype` varchar(200) NOT NULL,
  `twitter` varchar(100) NOT NULL,
  `permission` text,
  `converted_client_id` int(11) NOT NULL DEFAULT '0',
  `index_no` int(11) DEFAULT '0',
  `tags` text,
  `from_form_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`leads_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_leads_notes
#

DROP TABLE IF EXISTS `tbl_leads_notes`;

CREATE TABLE `tbl_leads_notes` (
  `notes_id` int(11) NOT NULL AUTO_INCREMENT,
  `leads_id` int(11) DEFAULT NULL,
  `notes` text,
  `contacted_indicator` varchar(50) DEFAULT NULL,
  `created_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `last_contact` timestamp NULL DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `module` varchar(50) DEFAULT NULL,
  `module_field_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`notes_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_leave_application
#

DROP TABLE IF EXISTS `tbl_leave_application`;

CREATE TABLE `tbl_leave_application` (
  `leave_application_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `leave_category_id` int(2) NOT NULL,
  `reason` text NOT NULL,
  `leave_type` enum('single_day','multiple_days','hours') NOT NULL DEFAULT 'single_day',
  `hours` varchar(20) DEFAULT NULL,
  `leave_start_date` date NOT NULL,
  `leave_end_date` date DEFAULT NULL,
  `application_status` int(2) NOT NULL DEFAULT '1' COMMENT '1=pending,2=accepted 3=rejected',
  `view_status` tinyint(1) NOT NULL DEFAULT '2',
  `application_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `attachment` text,
  `comments` text,
  `approve_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`leave_application_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_leave_category
#

DROP TABLE IF EXISTS `tbl_leave_category`;

CREATE TABLE `tbl_leave_category` (
  `leave_category_id` int(2) NOT NULL AUTO_INCREMENT,
  `leave_category` varchar(100) NOT NULL,
  `leave_quota` int(2) NOT NULL,
  PRIMARY KEY (`leave_category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_locales
#

DROP TABLE IF EXISTS `tbl_locales`;

CREATE TABLE `tbl_locales` (
  `locale` varchar(10) NOT NULL,
  `code` varchar(10) DEFAULT NULL,
  `language` varchar(100) DEFAULT NULL,
  `name` varchar(250) NOT NULL DEFAULT '',
  `icon` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`locale`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('aa_DJ', 'aa', 'afar', 'Afar (Djibouti)', 'dj');
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('aa_ER', 'aa', 'afar', 'Afar (Eritrea)', 'dj');
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('aa_ET', 'aa', 'afar', 'Afar (Ethiopia)', 'dj');
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('af_ZA', 'af', 'afrikaans', 'Afrikaans (South Africa)', 'za');
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('am_ET', 'am', 'amharic', 'Amharic (Ethiopia)', 'et');
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('an_ES', 'an', 'aragonese', 'Aragonese (Spain)', 'es');
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ar_AE', 'ar', 'arabic', 'Arabic (United Arab Emirates)', 'es');
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ar_BH', 'ar', 'arabic', 'Arabic (Bahrain)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ar_DZ', 'ar', 'arabic', 'Arabic (Algeria)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ar_EG', 'ar', 'arabic', 'Arabic (Egypt)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ar_IN', 'ar', 'arabic', 'Arabic (India)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ar_IQ', 'ar', 'arabic', 'Arabic (Iraq)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ar_JO', 'ar', 'arabic', 'Arabic (Jordan)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ar_KW', 'ar', 'arabic', 'Arabic (Kuwait)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ar_LB', 'ar', 'arabic', 'Arabic (Lebanon)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ar_LY', 'ar', 'arabic', 'Arabic (Libya)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ar_MA', 'ar', 'arabic', 'Arabic (Morocco)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ar_OM', 'ar', 'arabic', 'Arabic (Oman)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ar_QA', 'ar', 'arabic', 'Arabic (Qatar)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ar_SA', 'ar', 'arabic', 'Arabic (Saudi Arabia)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ar_SD', 'ar', 'arabic', 'Arabic (Sudan)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ar_SY', 'ar', 'arabic', 'Arabic (Syria)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ar_TN', 'ar', 'arabic', 'Arabic (Tunisia)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ar_YE', 'ar', 'arabic', 'Arabic (Yemen)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ast_ES', 'ast', 'asturian', 'Asturian (Spain)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('as_IN', 'as', 'assamese', 'Assamese (India)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('az_AZ', 'az', 'azerbaijani', 'Azerbaijani (Azerbaijan)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('az_TR', 'az', 'azerbaijani', 'Azerbaijani (Turkey)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('bem_ZM', 'bem', 'bemba', 'Bemba (Zambia)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ber_DZ', 'ber', 'berber', 'Berber (Algeria)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ber_MA', 'ber', 'berber', 'Berber (Morocco)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('be_BY', 'be', 'belarusian', 'Belarusian (Belarus)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('bg_BG', 'bg', 'bulgarian', 'Bulgarian (Bulgaria)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('bn_BD', 'bn', 'bengali', 'Bengali (Bangladesh)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('bn_IN', 'bn', 'bengali', 'Bengali (India)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('bo_CN', 'bo', 'tibetan', 'Tibetan (China)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('bo_IN', 'bo', 'tibetan', 'Tibetan (India)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('br_FR', 'br', 'breton', 'Breton (France)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('bs_BA', 'bs', 'bosnian', 'Bosnian (Bosnia and Herzegovina)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('byn_ER', 'byn', 'blin', 'Blin (Eritrea)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ca_AD', 'ca', 'catalan', 'Catalan (Andorra)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ca_ES', 'ca', 'catalan', 'Catalan (Spain)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ca_FR', 'ca', 'catalan', 'Catalan (France)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ca_IT', 'ca', 'catalan', 'Catalan (Italy)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('crh_UA', 'crh', 'crimean turkish', 'Crimean Turkish (Ukraine)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('csb_PL', 'csb', 'kashubian', 'Kashubian (Poland)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('cs_CZ', 'cs', 'czech', 'Czech (Czech Republic)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('cv_RU', 'cv', 'chuvash', 'Chuvash (Russia)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('cy_GB', 'cy', 'welsh', 'Welsh (United Kingdom)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('da_DK', 'da', 'danish', 'Danish (Denmark)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('de_AT', 'de', 'german', 'German (Austria)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('de_BE', 'de', 'german', 'German (Belgium)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('de_CH', 'de', 'german', 'German (Switzerland)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('de_DE', 'de', 'german', 'German (Germany)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('de_LI', 'de', 'german', 'German (Liechtenstein)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('de_LU', 'de', 'german', 'German (Luxembourg)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('dv_MV', 'dv', 'divehi', 'Divehi (Maldives)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('dz_BT', 'dz', 'dzongkha', 'Dzongkha (Bhutan)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ee_GH', 'ee', 'ewe', 'Ewe (Ghana)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('el_CY', 'el', 'greek', 'Greek (Cyprus)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('el_GR', 'el', 'greek', 'Greek (Greece)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('en_AG', 'en', 'english', 'English (Antigua and Barbuda)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('en_AS', 'en', 'english', 'English (American Samoa)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('en_AU', 'en', 'english', 'English (Australia)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('en_BW', 'en', 'english', 'English (Botswana)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('en_CA', 'en', 'english', 'English (Canada)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('en_DK', 'en', 'english', 'English (Denmark)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('en_GB', 'en', 'english', 'English (United Kingdom)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('en_GU', 'en', 'english', 'English (Guam)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('en_HK', 'en', 'english', 'English (Hong Kong SAR China)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('en_IE', 'en', 'english', 'English (Ireland)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('en_IN', 'en', 'english', 'English (India)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('en_JM', 'en', 'english', 'English (Jamaica)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('en_MH', 'en', 'english', 'English (Marshall Islands)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('en_MP', 'en', 'english', 'English (Northern Mariana Islands)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('en_MU', 'en', 'english', 'English (Mauritius)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('en_NG', 'en', 'english', 'English (Nigeria)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('en_NZ', 'en', 'english', 'English (New Zealand)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('en_PH', 'en', 'english', 'English (Philippines)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('en_SG', 'en', 'english', 'English (Singapore)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('en_TT', 'en', 'english', 'English (Trinidad and Tobago)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('en_US', 'en', 'english', 'English (United States)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('en_VI', 'en', 'english', 'English (Virgin Islands)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('en_ZA', 'en', 'english', 'English (South Africa)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('en_ZM', 'en', 'english', 'English (Zambia)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('en_ZW', 'en', 'english', 'English (Zimbabwe)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('eo', 'eo', 'esperanto', 'Esperanto', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('es_AR', 'es', 'spanish', 'Spanish (Argentina)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('es_BO', 'es', 'spanish', 'Spanish (Bolivia)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('es_CL', 'es', 'spanish', 'Spanish (Chile)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('es_CO', 'es', 'spanish', 'Spanish (Colombia)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('es_CR', 'es', 'spanish', 'Spanish (Costa Rica)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('es_DO', 'es', 'spanish', 'Spanish (Dominican Republic)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('es_EC', 'es', 'spanish', 'Spanish (Ecuador)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('es_ES', 'es', 'spanish', 'Spanish (Spain)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('es_GT', 'es', 'spanish', 'Spanish (Guatemala)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('es_HN', 'es', 'spanish', 'Spanish (Honduras)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('es_MX', 'es', 'spanish', 'Spanish (Mexico)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('es_NI', 'es', 'spanish', 'Spanish (Nicaragua)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('es_PA', 'es', 'spanish', 'Spanish (Panama)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('es_PE', 'es', 'spanish', 'Spanish (Peru)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('es_PR', 'es', 'spanish', 'Spanish (Puerto Rico)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('es_PY', 'es', 'spanish', 'Spanish (Paraguay)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('es_SV', 'es', 'spanish', 'Spanish (El Salvador)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('es_US', 'es', 'spanish', 'Spanish (United States)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('es_UY', 'es', 'spanish', 'Spanish (Uruguay)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('es_VE', 'es', 'spanish', 'Spanish (Venezuela)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('et_EE', 'et', 'estonian', 'Estonian (Estonia)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('eu_ES', 'eu', 'basque', 'Basque (Spain)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('eu_FR', 'eu', 'basque', 'Basque (France)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('fa_AF', 'fa', 'persian', 'Persian (Afghanistan)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('fa_IR', 'fa', 'persian', 'Persian (Iran)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ff_SN', 'ff', 'fulah', 'Fulah (Senegal)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('fil_PH', 'fil', 'filipino', 'Filipino (Philippines)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('fi_FI', 'fi', 'finnish', 'Finnish (Finland)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('fo_FO', 'fo', 'faroese', 'Faroese (Faroe Islands)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('fr_BE', 'fr', 'french', 'French (Belgium)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('fr_BF', 'fr', 'french', 'French (Burkina Faso)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('fr_BI', 'fr', 'french', 'French (Burundi)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('fr_BJ', 'fr', 'french', 'French (Benin)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('fr_CA', 'fr', 'french', 'French (Canada)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('fr_CF', 'fr', 'french', 'French (Central African Republic)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('fr_CG', 'fr', 'french', 'French (Congo)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('fr_CH', 'fr', 'french', 'French (Switzerland)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('fr_CM', 'fr', 'french', 'French (Cameroon)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('fr_FR', 'fr', 'french', 'French (France)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('fr_GA', 'fr', 'french', 'French (Gabon)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('fr_GN', 'fr', 'french', 'French (Guinea)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('fr_GP', 'fr', 'french', 'French (Guadeloupe)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('fr_GQ', 'fr', 'french', 'French (Equatorial Guinea)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('fr_KM', 'fr', 'french', 'French (Comoros)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('fr_LU', 'fr', 'french', 'French (Luxembourg)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('fr_MC', 'fr', 'french', 'French (Monaco)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('fr_MG', 'fr', 'french', 'French (Madagascar)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('fr_ML', 'fr', 'french', 'French (Mali)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('fr_MQ', 'fr', 'french', 'French (Martinique)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('fr_NE', 'fr', 'french', 'French (Niger)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('fr_SN', 'fr', 'french', 'French (Senegal)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('fr_TD', 'fr', 'french', 'French (Chad)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('fr_TG', 'fr', 'french', 'French (Togo)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('fur_IT', 'fur', 'friulian', 'Friulian (Italy)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('fy_DE', 'fy', 'western frisian', 'Western Frisian (Germany)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('fy_NL', 'fy', 'western frisian', 'Western Frisian (Netherlands)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ga_IE', 'ga', 'irish', 'Irish (Ireland)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('gd_GB', 'gd', 'scottish gaelic', 'Scottish Gaelic (United Kingdom)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('gez_ER', 'gez', 'geez', 'Geez (Eritrea)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('gez_ET', 'gez', 'geez', 'Geez (Ethiopia)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('gl_ES', 'gl', 'galician', 'Galician (Spain)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('gu_IN', 'gu', 'gujarati', 'Gujarati (India)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('gv_GB', 'gv', 'manx', 'Manx (United Kingdom)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ha_NG', 'ha', 'hausa', 'Hausa (Nigeria)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('he_IL', 'he', 'hebrew', 'Hebrew (Israel)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('hi_IN', 'hi', 'hindi', 'Hindi (India)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('hr_HR', 'hr', 'croatian', 'Croatian (Croatia)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('hsb_DE', 'hsb', 'upper sorbian', 'Upper Sorbian (Germany)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ht_HT', 'ht', 'haitian', 'Haitian (Haiti)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('hu_HU', 'hu', 'hungarian', 'Hungarian (Hungary)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('hy_AM', 'hy', 'armenian', 'Armenian (Armenia)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ia', 'ia', 'interlingua', 'Interlingua', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('id_ID', 'id', 'indonesian', 'Indonesian (Indonesia)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ig_NG', 'ig', 'igbo', 'Igbo (Nigeria)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ik_CA', 'ik', 'inupiaq', 'Inupiaq (Canada)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('is_IS', 'is', 'icelandic', 'Icelandic (Iceland)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('it_CH', 'it', 'italian', 'Italian (Switzerland)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('it_IT', 'it', 'italian', 'Italian (Italy)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('iu_CA', 'iu', 'inuktitut', 'Inuktitut (Canada)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ja_JP', 'ja', 'japanese', 'Japanese (Japan)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ka_GE', 'ka', 'georgian', 'Georgian (Georgia)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('kk_KZ', 'kk', 'kazakh', 'Kazakh (Kazakhstan)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('kl_GL', 'kl', 'kalaallisut', 'Kalaallisut (Greenland)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('km_KH', 'km', 'khmer', 'Khmer (Cambodia)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('kn_IN', 'kn', 'kannada', 'Kannada (India)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('kok_IN', 'kok', 'konkani', 'Konkani (India)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ko_KR', 'ko', 'korean', 'Korean (South Korea)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ks_IN', 'ks', 'kashmiri', 'Kashmiri (India)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ku_TR', 'ku', 'kurdish', 'Kurdish (Turkey)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('kw_GB', 'kw', 'cornish', 'Cornish (United Kingdom)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ky_KG', 'ky', 'kirghiz', 'Kirghiz (Kyrgyzstan)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('lg_UG', 'lg', 'ganda', 'Ganda (Uganda)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('li_BE', 'li', 'limburgish', 'Limburgish (Belgium)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('li_NL', 'li', 'limburgish', 'Limburgish (Netherlands)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('lo_LA', 'lo', 'lao', 'Lao (Laos)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('lt_LT', 'lt', 'lithuanian', 'Lithuanian (Lithuania)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('lv_LV', 'lv', 'latvian', 'Latvian (Latvia)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('mai_IN', 'mai', 'maithili', 'Maithili (India)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('mg_MG', 'mg', 'malagasy', 'Malagasy (Madagascar)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('mi_NZ', 'mi', 'maori', 'Maori (New Zealand)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('mk_MK', 'mk', 'macedonian', 'Macedonian (Macedonia)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ml_IN', 'ml', 'malayalam', 'Malayalam (India)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('mn_MN', 'mn', 'mongolian', 'Mongolian (Mongolia)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('mr_IN', 'mr', 'marathi', 'Marathi (India)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ms_BN', 'ms', 'malay', 'Malay (Brunei)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ms_MY', 'ms', 'malay', 'Malay (Malaysia)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('mt_MT', 'mt', 'maltese', 'Maltese (Malta)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('my_MM', 'my', 'burmese', 'Burmese (Myanmar)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('naq_NA', 'naq', 'namibia', 'Namibia', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('nb_NO', 'nb', 'norwegian bokm?l', 'Norwegian Bokm?l (Norway)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('nds_DE', 'nds', 'low german', 'Low German (Germany)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('nds_NL', 'nds', 'low german', 'Low German (Netherlands)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ne_NP', 'ne', 'nepali', 'Nepali (Nepal)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('nl_AW', 'nl', 'dutch', 'Dutch (Aruba)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('nl_BE', 'nl', 'dutch', 'Dutch (Belgium)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('nl_NL', 'nl', 'dutch', 'Dutch (Netherlands)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('nn_NO', 'nn', 'norwegian nynorsk', 'Norwegian Nynorsk (Norway)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('no_NO', 'no', 'norwegian', 'Norwegian (Norway)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('nr_ZA', 'nr', 'south ndebele', 'South Ndebele (South Africa)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('nso_ZA', 'nso', 'northern sotho', 'Northern Sotho (South Africa)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('oc_FR', 'oc', 'occitan', 'Occitan (France)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('om_ET', 'om', 'oromo', 'Oromo (Ethiopia)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('om_KE', 'om', 'oromo', 'Oromo (Kenya)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('or_IN', 'or', 'oriya', 'Oriya (India)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('os_RU', 'os', 'ossetic', 'Ossetic (Russia)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('pap_AN', 'pap', 'papiamento', 'Papiamento (Netherlands Antilles)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('pa_IN', 'pa', 'punjabi', 'Punjabi (India)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('pa_PK', 'pa', 'punjabi', 'Punjabi (Pakistan)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('pl_PL', 'pl', 'polish', 'Polish (Poland)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ps_AF', 'ps', 'pashto', 'Pashto (Afghanistan)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('pt_BR', 'pt', 'portuguese', 'Portuguese (Brazil)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('pt_GW', 'pt', 'portuguese', 'Portuguese (Guinea-Bissau)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('pt_PT', 'pt', 'portuguese', 'Portuguese (Portugal)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ro_MD', 'ro', 'romanian', 'Romanian (Moldova)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ro_RO', 'ro', 'romanian', 'Romanian (Romania)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ru_RU', 'ru', 'russian', 'Russian (Russia)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ru_UA', 'ru', 'russian', 'Russian (Ukraine)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('rw_RW', 'rw', 'kinyarwanda', 'Kinyarwanda (Rwanda)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('sa_IN', 'sa', 'sanskrit', 'Sanskrit (India)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('sc_IT', 'sc', 'sardinian', 'Sardinian (Italy)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('sd_IN', 'sd', 'sindhi', 'Sindhi (India)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('seh_MZ', 'seh', 'sena', 'Sena (Mozambique)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('se_NO', 'se', 'northern sami', 'Northern Sami (Norway)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('sid_ET', 'sid', 'sidamo', 'Sidamo (Ethiopia)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('si_LK', 'si', 'sinhala', 'Sinhala (Sri Lanka)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('sk_SK', 'sk', 'slovak', 'Slovak (Slovakia)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('sl_SI', 'sl', 'slovenian', 'Slovenian (Slovenia)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('sn_ZW', 'sn', 'shona', 'Shona (Zimbabwe)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('so_DJ', 'so', 'somali', 'Somali (Djibouti)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('so_ET', 'so', 'somali', 'Somali (Ethiopia)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('so_KE', 'so', 'somali', 'Somali (Kenya)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('so_SO', 'so', 'somali', 'Somali (Somalia)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('sq_AL', 'sq', 'albanian', 'Albanian (Albania)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('sq_MK', 'sq', 'albanian', 'Albanian (Macedonia)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('sr_BA', 'sr', 'serbian', 'Serbian (Bosnia and Herzegovina)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('sr_ME', 'sr', 'serbian', 'Serbian (Montenegro)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('sr_RS', 'sr', 'serbian', 'Serbian (Serbia)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ss_ZA', 'ss', 'swati', 'Swati (South Africa)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('st_ZA', 'st', 'southern sotho', 'Southern Sotho (South Africa)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('sv_FI', 'sv', 'swedish', 'Swedish (Finland)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('sv_SE', 'sv', 'swedish', 'Swedish (Sweden)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('sw_KE', 'sw', 'swahili', 'Swahili (Kenya)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('sw_TZ', 'sw', 'swahili', 'Swahili (Tanzania)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ta_IN', 'ta', 'tamil', 'Tamil (India)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('teo_UG', 'teo', 'teso', 'Teso (Uganda)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('te_IN', 'te', 'telugu', 'Telugu (India)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('tg_TJ', 'tg', 'tajik', 'Tajik (Tajikistan)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('th_TH', 'th', 'thai', 'Thai (Thailand)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('tig_ER', 'tig', 'tigre', 'Tigre (Eritrea)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ti_ER', 'ti', 'tigrinya', 'Tigrinya (Eritrea)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ti_ET', 'ti', 'tigrinya', 'Tigrinya (Ethiopia)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('tk_TM', 'tk', 'turkmen', 'Turkmen (Turkmenistan)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('tl_PH', 'tl', 'tagalog', 'Tagalog (Philippines)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('tn_ZA', 'tn', 'tswana', 'Tswana (South Africa)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('to_TO', 'to', 'tongan', 'Tongan (Tonga)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('tr_CY', 'tr', 'turkish', 'Turkish (Cyprus)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('tr_TR', 'tr', 'turkish', 'Turkish (Turkey)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ts_ZA', 'ts', 'tsonga', 'Tsonga (South Africa)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('tt_RU', 'tt', 'tatar', 'Tatar (Russia)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ug_CN', 'ug', 'uighur', 'Uighur (China)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('uk_UA', 'uk', 'ukrainian', 'Ukrainian (Ukraine)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ur_PK', 'ur', 'urdu', 'Urdu (Pakistan)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('uz_UZ', 'uz', 'uzbek', 'Uzbek (Uzbekistan)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('ve_ZA', 've', 'venda', 'Venda (South Africa)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('vi_VN', 'vi', 'vietnamese', 'Vietnamese (Vietnam)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('wa_BE', 'wa', 'walloon', 'Walloon (Belgium)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('wo_SN', 'wo', 'wolof', 'Wolof (Senegal)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('xh_ZA', 'xh', 'xhosa', 'Xhosa (South Africa)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('yi_US', 'yi', 'yiddish', 'Yiddish (United States)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('yo_NG', 'yo', 'yoruba', 'Yoruba (Nigeria)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('zh_CN', 'zh', 'chinese', 'Chinese (China)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('zh_HK', 'zh', 'chinese', 'Chinese (Hong Kong SAR China)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('zh_SG', 'zh', 'chinese', 'Chinese (Singapore)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('zh_TW', 'zh', 'chinese', 'Chinese (Taiwan)', NULL);
INSERT INTO `tbl_locales` (`locale`, `code`, `language`, `name`, `icon`) VALUES ('zu_ZA', 'zu', 'zulu', 'Zulu (South Africa)', NULL);


#
# TABLE STRUCTURE FOR: tbl_manufacturer
#

DROP TABLE IF EXISTS `tbl_manufacturer`;

CREATE TABLE `tbl_manufacturer` (
  `manufacturer_id` int(11) NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(100) NOT NULL,
  `description` text,
  PRIMARY KEY (`manufacturer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_menu
#

DROP TABLE IF EXISTS `tbl_menu`;

CREATE TABLE `tbl_menu` (
  `menu_id` int(11) NOT NULL AUTO_INCREMENT,
  `label` varchar(100) NOT NULL,
  `link` varchar(100) NOT NULL,
  `icon` varchar(100) NOT NULL,
  `parent` int(11) NOT NULL DEFAULT '0',
  `sort` int(11) NOT NULL DEFAULT '0',
  `time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `status` tinyint(1) DEFAULT '1' COMMENT '1= active 0=inactive',
  PRIMARY KEY (`menu_id`)
) ENGINE=InnoDB AUTO_INCREMENT=213 DEFAULT CHARSET=utf8;

INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (1, 'dashboard', 'admin/dashboard', 'fa fa-dashboard', 0, 0, '2017-04-23 01:39:36', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (2, 'calendar', 'admin/calendar', 'fa fa-calendar', 0, 1, '2017-04-23 19:57:23', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (4, 'client', 'admin/client/manage_client', 'fa fa-users', 0, 13, '2018-01-07 07:05:17', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (5, 'mailbox', 'admin/mailbox', 'fa fa-envelope-o', 0, 2, '2017-06-10 14:16:25', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (6, 'tickets', 'admin/tickets', 'fa fa-ticket', 0, 10, '2018-06-08 13:39:39', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (12, 'sales', '#', 'fa fa-shopping-cart', 0, 9, '2017-06-10 14:02:58', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (13, 'invoice', 'admin/invoice/manage_invoice', 'fa fa-circle-o', 12, 0, '2017-04-23 19:57:23', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (14, 'estimates', 'admin/estimates', 'fa fa-circle-o', 12, 1, '2017-06-10 14:02:05', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (15, 'payments_received', 'admin/invoice/all_payments', 'fa fa-circle-o', 12, 3, '2017-04-23 19:57:24', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (16, 'tax_rates', 'admin/invoice/tax_rates', 'fa fa-circle-o', 12, 5, '2018-01-07 07:05:16', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (21, 'quotations', '#', 'fa fa-paste', 12, 7, '2018-01-07 07:05:17', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (22, 'quotations_list', 'admin/quotations', 'fa fa-circle-o', 21, 0, '2017-05-18 16:49:03', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (23, 'quotations_form', 'admin/quotations/quotations_form', 'fa fa-circle-o', 21, 1, '2016-05-30 08:50:23', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (24, 'user', 'admin/user/user_list', 'fa fa-users', 0, 25, '2018-01-07 07:05:18', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (25, 'settings', 'admin/settings', 'fa fa-cogs', 0, 26, '2018-01-07 07:05:18', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (26, 'database_backup', 'admin/settings/database_backup', 'fa fa-database', 0, 27, '2018-01-07 07:05:18', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (29, 'transactions_menu', '#', 'fa fa-building-o', 0, 12, '2018-05-13 12:27:58', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (30, 'deposit', 'admin/transactions/deposit', 'fa fa-circle-o', 29, 1, '2018-05-13 12:28:33', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (31, 'expense', 'admin/transactions/expense', 'fa fa-circle-o', 29, 0, '2018-05-13 12:28:37', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (32, 'transfer', 'admin/transactions/transfer', 'fa fa-circle-o', 29, 2, '2018-05-13 12:28:40', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (33, 'transactions_report', 'admin/transactions/transactions_report', 'fa fa-circle-o', 29, 3, '2018-05-13 12:28:44', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (34, 'balance_sheet', 'admin/transactions/balance_sheet', 'fa fa-circle-o', 29, 5, '2018-05-13 12:28:47', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (36, 'bank_cash', 'admin/account/manage_account', 'fa fa-money', 29, 6, '2018-05-13 12:28:51', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (39, 'items', 'admin/items/items_list', 'fa fa-cube', 150, 0, '2019-05-04 18:49:50', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (42, 'report', '#', 'fa fa-bar-chart', 0, 24, '2018-01-07 07:05:17', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (43, 'account_statement', 'admin/report/account_statement', 'fa fa-circle-o', 146, 0, '2018-01-07 07:05:17', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (44, 'income_report', 'admin/report/income_report', 'fa fa-circle-o', 146, 2, '2018-01-07 07:05:17', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (45, 'expense_report', 'admin/report/expense_report', 'fa fa-circle-o', 146, 1, '2018-01-07 07:05:17', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (46, 'income_expense', 'admin/report/income_expense', 'fa fa-circle-o', 146, 3, '2018-01-07 07:05:18', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (47, 'date_wise_report', 'admin/report/date_wise_report', 'fa fa-circle-o', 146, 4, '2018-01-07 07:05:18', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (48, 'all_income', 'admin/report/all_income', 'fa fa-circle-o', 146, 6, '2018-01-07 07:05:18', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (49, 'all_expense', 'admin/report/all_expense', 'fa fa-circle-o', 146, 7, '2018-01-07 07:05:18', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (50, 'all_transaction', 'admin/report/all_transaction', 'fa fa-circle-o', 146, 8, '2018-01-07 07:05:18', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (51, 'recurring_invoice', 'admin/invoice/recurring_invoice', 'fa fa-circle-o', 12, 2, '2017-06-10 14:02:05', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (52, 'transfer_report', 'admin/transactions/transfer_report', 'fa fa-circle-o', 29, 4, '2018-05-13 12:28:59', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (53, 'report_by_month', 'admin/report/report_by_month', 'fa fa-circle-o', 146, 5, '2018-01-07 07:05:18', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (54, 'tasks', 'admin/tasks/all_task', 'fa fa-tasks', 0, 5, '2017-06-10 14:16:25', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (55, 'leads', 'admin/leads', 'fa fa-rocket', 0, 8, '2017-06-10 14:16:25', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (56, 'opportunities', 'admin/opportunities', 'fa fa-filter', 0, 7, '2017-06-10 14:16:25', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (57, 'projects', 'admin/projects', 'fa fa-folder-open-o', 0, 4, '2017-06-10 14:16:25', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (58, 'bugs', 'admin/bugs', 'fa fa-bug', 0, 6, '2017-06-10 14:16:25', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (59, 'project', '#', 'fa fa-folder-open-o', 42, 2, '2018-01-07 07:09:39', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (60, 'tasks_report', 'admin/report/tasks_report', 'fa fa-circle-o', 42, 3, '2018-01-07 07:09:39', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (61, 'bugs_report', 'admin/report/bugs_report', 'fa fa-circle-o', 42, 4, '2018-01-07 07:09:39', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (62, 'tickets_report', 'admin/report/tickets_report', 'fa fa-circle-o', 42, 5, '2018-01-07 07:09:39', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (63, 'client_report', 'admin/report/client_report', 'fa fa-circle-o', 42, 6, '2018-01-07 07:09:40', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (66, 'tasks_assignment', 'admin/report/tasks_assignment', 'fa fa-dot-circle-o', 59, 0, '2016-05-30 08:55:02', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (67, 'bugs_assignment', 'admin/report/bugs_assignment', 'fa fa-dot-circle-o', 59, 1, '2016-05-30 08:55:02', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (68, 'project_report', 'admin/report/project_report', 'fa fa-dot-circle-o', 59, 2, '2016-05-30 08:55:02', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (69, 'goal_tracking', 'admin/goal_tracking', 'fa fa-shield', 73, 1, '2017-06-10 14:05:47', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (70, 'departments', 'admin/departments', 'fa fa-user-secret', 0, 14, '2018-01-07 07:05:17', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (71, 'holiday', 'admin/holiday', 'fa fa-calendar-plus-o', 73, 0, '2017-06-10 14:05:47', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (72, 'leave_management', 'admin/leave_management', 'fa fa-plane', 0, 20, '2018-01-07 07:05:17', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (73, 'utilities', '#', 'fa fa-gift', 0, 23, '2018-01-07 07:05:17', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (74, 'overtime', 'admin/utilities/overtime', 'fa fa-clock-o', 89, 9, '2017-06-10 14:04:23', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (75, 'office_stock', '#', 'fa fa-codepen', 0, 15, '2019-05-01 16:22:56', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (76, 'stock_category', 'admin/stock/stock_category', 'fa fa-sliders', 75, 0, '2016-05-30 08:50:23', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (77, 'manage_stock', '#', 'fa fa-archive', 75, 2, '2017-04-26 16:11:10', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (78, 'assign_stock', '#', 'fa fa-align-left', 75, 3, '2017-04-26 16:11:10', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (79, 'stock_report', 'admin/stock/report', 'fa fa-line-chart', 75, 4, '2017-04-25 18:48:25', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (81, 'stock_list', 'admin/stock/stock_list', 'fa fa-stack-exchange', 75, 1, '2017-04-26 16:11:10', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (82, 'assign_stock', 'admin/stock/assign_stock', 'fa fa-align-left', 78, 0, '2016-05-30 08:55:02', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (83, 'assign_stock_report', 'admin/stock/assign_stock_report', 'fa fa-bar-chart', 78, 1, '2016-05-30 08:55:02', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (84, 'stock_history', 'admin/stock/stock_history', 'fa fa-file-text-o', 77, 0, '2016-05-30 08:55:02', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (85, 'performance', '#', 'fa fa-dribbble', 0, 19, '2018-01-07 07:05:17', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (86, 'performance_indicator', 'admin/performance/performance_indicator', 'fa fa-random', 85, 0, '2016-05-30 08:50:23', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (87, 'performance_report', 'admin/performance/performance_report', 'fa fa-calendar-o', 85, 2, '2016-05-30 08:50:23', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (88, 'give_appraisal', 'admin/performance/give_performance_appraisal', 'fa fa-plus', 85, 1, '2016-05-30 08:50:23', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (89, 'payroll', '#', 'fa fa-usd', 0, 18, '2018-01-07 07:05:17', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (90, 'manage_salary_details', 'admin/payroll/manage_salary_details', 'fa fa-usd', 89, 2, '2017-04-23 08:06:37', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (91, 'employee_salary_list', 'admin/payroll/employee_salary_list', 'fa fa-user-secret', 89, 3, '2017-04-23 08:06:37', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (92, 'make_payment', 'admin/payroll/make_payment', 'fa fa-tasks', 89, 4, '2017-04-23 08:06:37', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (93, 'generate_payslip', 'admin/payroll/generate_payslip', 'fa fa-list-ul', 89, 5, '2017-04-23 08:06:37', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (94, 'salary_template', 'admin/payroll/salary_template', 'fa fa-money', 89, 0, '2017-04-23 08:06:37', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (95, 'hourly_rate', 'admin/payroll/hourly_rate', 'fa fa-clock-o', 89, 1, '2017-04-23 08:06:37', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (96, 'payroll_summary', 'admin/payroll/payroll_summary', 'fa fa-camera-retro', 89, 6, '2017-04-23 08:06:37', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (97, 'provident_fund', 'admin/payroll/provident_fund', 'fa fa-briefcase', 89, 8, '2017-06-10 14:04:23', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (98, 'advance_salary', 'admin/payroll/advance_salary', 'fa fa-cc-mastercard', 89, 7, '2017-06-10 14:04:23', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (99, 'employee_award', 'admin/award', 'fa fa-trophy', 89, 10, '2017-06-10 14:05:47', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (100, 'announcements', 'admin/announcements', 'fa fa-bullhorn icon', 0, 22, '2018-01-07 07:05:17', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (101, 'training', 'admin/training', 'fa fa-suitcase', 0, 21, '2018-01-07 07:05:17', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (102, 'job_circular', '#', 'fa fa-globe', 0, 17, '2018-01-07 07:05:17', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (103, 'jobs_posted', 'admin/job_circular/jobs_posted', 'fa fa-ticket', 102, 0, '2016-05-30 08:50:21', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (104, 'jobs_applications', 'admin/job_circular/jobs_applications', 'fa fa-compass', 102, 1, '2016-05-30 08:50:21', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (105, 'attendance', '#', 'fa fa-file-text', 0, 16, '2018-01-07 07:05:17', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (106, 'timechange_request', 'admin/attendance/timechange_request', 'fa fa-calendar-o', 105, 1, '2016-05-30 08:50:21', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (107, 'attendance_report', 'admin/attendance/attendance_report', 'fa fa-file-text', 105, 2, '2016-05-30 08:50:21', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (108, 'time_history', 'admin/attendance/time_history', 'fa fa-clock-o', 105, 0, '2016-05-30 08:50:21', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (109, 'pull-down', '', '', 0, 0, '2016-05-31 12:43:20', 0);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (110, 'filemanager', 'admin/filemanager', 'fa fa-file', 0, 3, '2017-06-10 14:16:25', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (111, 'company_details', 'admin/settings', 'fa fa-fw fa-info-circle', 25, 1, '2017-04-25 17:08:46', 2);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (112, 'system_settings', 'admin/settings/system', 'fa fa-fw fa-desktop', 25, 2, '2017-04-25 17:08:46', 2);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (113, 'email_settings', 'admin/settings/email', 'fa fa-fw fa-envelope', 25, 3, '2017-04-25 17:08:46', 2);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (114, 'email_templates', 'admin/settings/templates', 'fa fa-fw fa-pencil-square', 25, 5, '2021-07-30 06:18:08', 2);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (115, 'email_integration', 'admin/settings/email_integration', 'fa fa-fw fa-envelope-o', 25, 6, '2021-07-30 06:18:08', 2);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (116, 'payment_settings', 'admin/settings/payments', 'fa fa-fw fa-dollar', 25, 7, '2021-07-30 06:18:09', 2);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (117, 'invoice_settings', 'admin/settings/invoice', 'fa fa-fw fa-money', 25, 8, '2021-07-30 06:18:09', 2);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (118, 'estimate_settings', 'admin/settings/estimate', 'fa fa-fw fa-file-o', 25, 10, '2021-07-30 06:18:09', 2);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (119, 'tickets_leads_settings', 'admin/settings/tickets', 'fa fa-fw fa-ticket', 25, 14, '2021-07-30 06:18:09', 2);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (120, 'theme_settings', 'admin/settings/theme', 'fa fa-fw fa-code', 25, 20, '2021-07-30 06:18:09', 2);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (121, 'working_days', 'admin/settings/working_days', 'fa fa-fw fa-calendar', 25, 22, '2021-07-30 06:18:09', 2);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (122, 'leave_category', 'admin/settings/leave_category', 'fa fa-fw fa-pagelines', 25, 23, '2021-07-30 06:18:09', 2);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (123, 'income_category', 'admin/settings/income_category', 'fa fa-fw fa-certificate', 25, 24, '2021-07-30 06:18:09', 2);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (124, 'expense_category', 'admin/settings/expense_category', 'fa fa-fw fa-tasks', 25, 25, '2021-07-30 06:18:09', 2);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (125, 'customer_group', 'admin/settings/customer_group', 'fa fa-fw fa-users', 25, 26, '2021-07-30 06:18:09', 2);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (127, 'lead_status', 'admin/settings/lead_status', 'fa fa-fw fa-list-ul', 25, 16, '2021-07-30 06:18:09', 2);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (128, 'lead_source', 'admin/settings/lead_source', 'fa fa-fw fa-arrow-down', 25, 17, '2021-07-30 06:18:09', 2);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (129, 'opportunities_state_reason', 'admin/settings/opportunities_state_reason', 'fa fa-fw fa-dot-circle-o', 25, 19, '2021-07-30 06:18:09', 2);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (130, 'custom_field', 'admin/settings/custom_field', 'fa fa-fw fa-star-o', 25, 28, '2021-07-30 06:18:09', 2);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (131, 'payment_method', 'admin/settings/payment_method', 'fa fa-fw fa-money', 25, 29, '2021-07-30 06:18:09', 2);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (132, 'cronjob', 'admin/settings/cronjob', 'fa fa-fw fa-contao', 25, 31, '2021-07-30 06:18:09', 2);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (133, 'menu_allocation', 'admin/settings/menu_allocation', 'fa fa-fw fa fa-compass', 25, 32, '2021-07-30 06:18:09', 2);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (134, 'notification', 'admin/settings/notification', 'fa fa-fw fa-bell-o', 25, 33, '2021-07-30 06:18:09', 2);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (135, 'email_notification', 'admin/settings/email_notification', 'fa fa-fw fa-bell-o', 25, 34, '2021-07-30 06:18:09', 2);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (136, 'database_backup', 'admin/settings/database_backup', 'fa fa-fw fa-database', 25, 35, '2021-07-30 06:18:09', 2);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (137, 'translations', 'admin/settings/translations', 'fa fa-fw fa-language', 25, 36, '2021-07-30 06:18:09', 2);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (138, 'system_update', 'admin/settings/system_update', 'fa fa-fw fa-pencil-square-o', 25, 37, '2021-07-30 06:18:09', 2);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (139, 'private_chat', 'chat/conversations', 'fa fa-envelope', 0, 28, '2018-01-07 07:05:18', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (140, 'proposals', 'admin/proposals', 'fa fa-circle-o', 12, 4, '2018-01-07 07:05:16', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (141, 'knowledgebase', '#', 'fa fa-question-circle', 0, 11, '2018-01-07 07:05:17', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (142, 'categories', 'admin/knowledgebase/categories', 'fa fa-circle-o', 141, 2, '2018-01-07 07:05:17', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (143, 'articles', 'admin/knowledgebase/articles', 'fa fa-circle-o', 141, 1, '2018-01-07 07:05:17', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (144, 'knowledgebase', 'admin/knowledgebase', 'fa fa-circle-o', 141, 0, '2018-01-07 07:05:17', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (145, 'dashboard_settings', 'admin/settings/dashboard', 'fa fa-fw fa-dashboard', 25, 21, '2021-07-30 06:18:09', 2);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (146, 'transactions_reports', '#', 'fa fa-building-o', 42, 1, '2018-05-13 12:29:51', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (147, 'sales', 'admin/report/sales_report', 'fa fa-shopping-cart', 42, 0, '2018-01-07 01:12:23', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (148, 'mark_attendance', 'admin/mark_attendance', 'fa fa-file-text', 105, 2, '2018-03-07 06:45:25', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (149, 'allowed_ip', 'admin/settings/allowed_ip', 'fa fa-server', 25, 27, '2021-07-30 06:18:09', 2);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (150, 'stock', '#', 'icon-layers', 0, 8, '2019-05-01 18:10:52', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (151, 'supplier', 'admin/supplier', 'icon-briefcase', 150, 1, '2019-05-01 18:10:52', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (152, 'purchase', 'admin/purchase', 'icon-handbag', 150, 2, '2019-05-01 18:10:52', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (153, 'return_stock', 'admin/return_stock', 'icon-share-alt', 150, 3, '2019-05-05 16:19:30', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (154, 'purchase_payment', 'admin/purchase/all_payments', 'icon-credit-card', 150, 4, '2019-05-05 13:53:11', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (155, 'purchase_settings', 'admin/settings/purchase', 'fa-fw icon-handbag', 25, 12, '2021-07-30 06:18:09', 2);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (156, 'credit_note', 'admin/credit_note', 'fa fa-circle-o', 12, 1, '2017-06-10 02:32:05', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (157, 'credit_note_settings', 'admin/settings/credit_note', 'fa fa-fw fa-money', 25, 9, '2021-07-30 06:18:09', 2);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (158, 'proposals_settings', 'admin/settings/proposals', 'fa fa-fw fa-leaf', 25, 11, '2021-07-30 06:18:09', 2);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (159, 'projects_settings', 'admin/settings/projects', 'fa fa-fw fa-folder-open-o', 25, 13, '2021-07-30 06:18:09', 2);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (160, 'tags', 'admin/settings/tags', 'fa fa-fw fa-tags', 25, 30, '2021-07-30 06:18:09', 2);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (161, 'lead_form', 'admin/leads/all_lead_form', 'fa fa-fw fa-rocket', 25, 18, '2021-07-30 06:18:09', 2);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (162, 'transactions_settings', 'admin/settings/transactions', 'fa fa-fw fa-building-o', 25, 15, '2021-07-30 06:18:09', 2);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (163, 'sms_settings', 'admin/settings/sms_settings', 'fa fa-fw fa-envelope', 25, 4, '2021-07-30 06:18:08', 2);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (164, 'pos_sales', 'admin/invoice/pos_sales', 'fa fa-circle-o', 12, 0, '2021-10-16 00:53:10', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (186, 'warehouse', 'admin/warehouse/manage', 'fa fa-building-o', 150, 3, '2021-10-18 09:24:24', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (187, 'transferItem', 'admin/items/transferItem', 'fa fa-circle-o', 150, 4, '2021-10-14 11:56:08', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (203, 'award_setting', 'admin/settings/award', 'fa fa-star', 25, 30, '2022-01-19 05:51:40', 2);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (204, 'award_rule_setting', 'admin/settings/award_rule_settingh', 'fa fa-star', 25, 31, '2022-01-19 09:53:50', 2);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (205, 'award_program_settings', 'admin/settings/award_program_settings', 'fa fa-cog', 25, 32, '2022-01-20 09:17:30', 2);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (206, 'client_award_points', 'admin/invoice/client_awards', 'fa fa-circle-o', 12, 10, '2022-01-21 01:39:41', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (207, 'best_selling_product', 'admin/best_selling', 'fa fa-circle-o', 12, 11, '2022-01-21 06:43:52', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (209, 'warning', 'admin/warning', 'fa fa-warning', 0, 3, '2022-08-07 12:47:01', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (210, 'promotion', 'admin/promotion', 'fa fa-arrow-circle-up', 0, 4, '2022-08-07 12:49:28', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (211, 'termination', 'admin/termination', 'fa fa-eraser', 0, 5, '2022-08-07 12:50:45', 1);
INSERT INTO `tbl_menu` (`menu_id`, `label`, `link`, `icon`, `parent`, `sort`, `time`, `status`) VALUES (212, 'resignation', 'admin/resignation', 'fa fa-scissors', 0, 6, '2022-08-07 12:54:31', 1);


#
# TABLE STRUCTURE FOR: tbl_mettings
#

DROP TABLE IF EXISTS `tbl_mettings`;

CREATE TABLE `tbl_mettings` (
  `mettings_id` int(11) NOT NULL AUTO_INCREMENT,
  `leads_id` int(11) DEFAULT NULL,
  `opportunities_id` int(11) DEFAULT NULL,
  `meeting_subject` varchar(200) NOT NULL,
  `attendees` varchar(300) NOT NULL,
  `user_id` int(11) NOT NULL,
  `module` varchar(50) DEFAULT NULL,
  `module_field_id` int(11) DEFAULT NULL,
  `start_date` varchar(100) NOT NULL,
  `end_date` varchar(100) NOT NULL,
  `location` varchar(100) NOT NULL,
  `description` mediumtext NOT NULL,
  PRIMARY KEY (`mettings_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_migrations
#

DROP TABLE IF EXISTS `tbl_migrations`;

CREATE TABLE `tbl_migrations` (
  `version` bigint(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `tbl_migrations` (`version`) VALUES ('604');


#
# TABLE STRUCTURE FOR: tbl_milestones
#

DROP TABLE IF EXISTS `tbl_milestones`;

CREATE TABLE `tbl_milestones` (
  `milestones_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `project_id` int(11) NOT NULL,
  `milestone_name` varchar(100) NOT NULL,
  `description` varchar(200) NOT NULL,
  `start_date` varchar(20) NOT NULL,
  `end_date` varchar(20) NOT NULL,
  `client_visible` text,
  PRIMARY KEY (`milestones_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_modules
#

DROP TABLE IF EXISTS `tbl_modules`;

CREATE TABLE `tbl_modules` (
  `module_id` int(11) NOT NULL AUTO_INCREMENT,
  `module_name` varchar(55) NOT NULL,
  `installed_version` varchar(11) NOT NULL,
  `active` tinyint(1) NOT NULL,
  PRIMARY KEY (`module_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_notes
#

DROP TABLE IF EXISTS `tbl_notes`;

CREATE TABLE `tbl_notes` (
  `notes_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `is_client` enum('Yes','No') NOT NULL DEFAULT 'No',
  `notes` mediumtext,
  `added_by` int(11) NOT NULL,
  `added_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`notes_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_notifications
#

DROP TABLE IF EXISTS `tbl_notifications`;

CREATE TABLE `tbl_notifications` (
  `notifications_id` int(11) NOT NULL AUTO_INCREMENT,
  `read` int(11) NOT NULL DEFAULT '0',
  `read_inline` tinyint(1) NOT NULL DEFAULT '0',
  `date` datetime NOT NULL,
  `description` text NOT NULL,
  `from_user_id` int(11) NOT NULL DEFAULT '0',
  `to_user_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(200) DEFAULT NULL,
  `link` text,
  `icon` varchar(200) DEFAULT NULL,
  `value` text,
  PRIMARY KEY (`notifications_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_offence_category
#

DROP TABLE IF EXISTS `tbl_offence_category`;

CREATE TABLE `tbl_offence_category` (
  `offence_id` int(2) NOT NULL AUTO_INCREMENT,
  `offence_category` varchar(100) NOT NULL,
  PRIMARY KEY (`offence_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_online_payment
#

DROP TABLE IF EXISTS `tbl_online_payment`;

CREATE TABLE `tbl_online_payment` (
  `online_payment_id` int(11) NOT NULL AUTO_INCREMENT,
  `gateway_name` varchar(20) NOT NULL,
  `icon` text NOT NULL,
  `field_1` varchar(100) DEFAULT NULL,
  `field_2` varchar(100) DEFAULT NULL,
  `field_3` varchar(100) DEFAULT NULL,
  `field_4` varchar(100) DEFAULT NULL,
  `field_5` varchar(100) DEFAULT NULL,
  `link` varchar(100) DEFAULT NULL,
  `modal` enum('Yes','No') DEFAULT NULL,
  PRIMARY KEY (`online_payment_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

INSERT INTO `tbl_online_payment` (`online_payment_id`, `gateway_name`, `icon`, `field_1`, `field_2`, `field_3`, `field_4`, `field_5`, `link`, `modal`) VALUES (1, 'paypal', 'asset/images/payment_logo/paypal.png', 'paypal_api_username', 'paypal_api_password|password', 'api_signature', 'paypal_live|checkbox', '', 'payment/paypal', 'Yes');
INSERT INTO `tbl_online_payment` (`online_payment_id`, `gateway_name`, `icon`, `field_1`, `field_2`, `field_3`, `field_4`, `field_5`, `link`, `modal`) VALUES (2, 'Stripe', 'asset/images/payment_logo/stripe.jpg', 'stripe_private_key', 'stripe_public_key', NULL, NULL, NULL, 'payment/stripe', 'Yes');
INSERT INTO `tbl_online_payment` (`online_payment_id`, `gateway_name`, `icon`, `field_1`, `field_2`, `field_3`, `field_4`, `field_5`, `link`, `modal`) VALUES (3, '2checkout', 'asset/images/payment_logo/2checkout.jpg', '2checkout_live|checkbox', '2checkout_publishable_key', '2checkout_private_key', '2checkout_seller_id', NULL, 'payment/checkout', 'No');
INSERT INTO `tbl_online_payment` (`online_payment_id`, `gateway_name`, `icon`, `field_1`, `field_2`, `field_3`, `field_4`, `field_5`, `link`, `modal`) VALUES (4, 'Authorize.net', 'asset/images/payment_logo/Authorizenet.png', 'aim_api_login_id', 'aim_authorize_transaction_key', 'aim_authorize_live|checkbox', '', '', 'payment/authorize', 'No');
INSERT INTO `tbl_online_payment` (`online_payment_id`, `gateway_name`, `icon`, `field_1`, `field_2`, `field_3`, `field_4`, `field_5`, `link`, `modal`) VALUES (5, 'CCAvenue', 'asset/images/payment_logo/CCAvenue.jpg', 'ccavenue_merchant_id', 'ccavenue_key', 'ccavenue_access_code', 'ccavenue_enable_test_mode|checkbox', '', 'payment/ccavenue', 'No');
INSERT INTO `tbl_online_payment` (`online_payment_id`, `gateway_name`, `icon`, `field_1`, `field_2`, `field_3`, `field_4`, `field_5`, `link`, `modal`) VALUES (6, 'Braintree', 'asset/images/payment_logo/Braintree.png', 'braintree_merchant_id', 'braintree_private_key', 'braintree_public_key', 'braintree_live_or_sandbox|checkbox', '', 'payment/braintree', 'No');
INSERT INTO `tbl_online_payment` (`online_payment_id`, `gateway_name`, `icon`, `field_1`, `field_2`, `field_3`, `field_4`, `field_5`, `link`, `modal`) VALUES (7, 'Mollie', 'asset/images/payment_logo/ideal_mollie.png', 'mollie_api_key', 'mollie_partner_id', NULL, NULL, NULL, 'payment/mollie', 'Yes');
INSERT INTO `tbl_online_payment` (`online_payment_id`, `gateway_name`, `icon`, `field_1`, `field_2`, `field_3`, `field_4`, `field_5`, `link`, `modal`) VALUES (8, 'PayUmoney', 'asset/images/payment_logo/payumoney.jpg', 'payumoney_key', 'payumoney_salt', 'payumoney_enable_test_mode|checkbox', '', NULL, 'payment/payumoney', 'No');
INSERT INTO `tbl_online_payment` (`online_payment_id`, `gateway_name`, `icon`, `field_1`, `field_2`, `field_3`, `field_4`, `field_5`, `link`, `modal`) VALUES (9, 'Razorpay', 'asset/images/payment_logo/razorpay.png', 'razorpay_key', NULL, NULL, NULL, NULL, 'payment/razorpay', 'Yes');
INSERT INTO `tbl_online_payment` (`online_payment_id`, `gateway_name`, `icon`, `field_1`, `field_2`, `field_3`, `field_4`, `field_5`, `link`, `modal`) VALUES (10, 'TapPayment', 'asset/images/payment_logo/tappayment.jpg', 'tap_api_key', 'tap_user_name', 'tap_password|password', 'tap_merchantID', '', 'payment/TapPayment', 'Yes');


#
# TABLE STRUCTURE FOR: tbl_opportunities
#

DROP TABLE IF EXISTS `tbl_opportunities`;

CREATE TABLE `tbl_opportunities` (
  `opportunities_id` int(11) NOT NULL AUTO_INCREMENT,
  `opportunity_name` varchar(100) NOT NULL,
  `stages` varchar(20) NOT NULL,
  `probability` varchar(20) NOT NULL,
  `close_date` varchar(20) NOT NULL,
  `opportunities_state_reason_id` int(2) NOT NULL,
  `expected_revenue` varchar(300) DEFAULT NULL,
  `new_link` varchar(20) NOT NULL,
  `next_action` varchar(100) NOT NULL,
  `next_action_date` varchar(20) NOT NULL,
  `notes` text,
  `permission` text,
  PRIMARY KEY (`opportunities_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_opportunities_state_reason
#

DROP TABLE IF EXISTS `tbl_opportunities_state_reason`;

CREATE TABLE `tbl_opportunities_state_reason` (
  `opportunities_state_reason_id` int(2) NOT NULL AUTO_INCREMENT,
  `opportunities_state` varchar(20) NOT NULL,
  `opportunities_state_reason` varchar(100) NOT NULL,
  PRIMARY KEY (`opportunities_state_reason_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_outgoing_emails
#

DROP TABLE IF EXISTS `tbl_outgoing_emails`;

CREATE TABLE `tbl_outgoing_emails` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `sent_to` varchar(64) DEFAULT NULL,
  `sent_from` varchar(64) DEFAULT NULL,
  `subject` text,
  `message` longtext,
  `date_sent` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `delivered` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_overtime
#

DROP TABLE IF EXISTS `tbl_overtime`;

CREATE TABLE `tbl_overtime` (
  `overtime_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `overtime_date` date NOT NULL,
  `overtime_hours` varchar(20) NOT NULL,
  `notes` text,
  `status` enum('pending','approved','rejected') NOT NULL DEFAULT 'pending',
  PRIMARY KEY (`overtime_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_payment_methods
#

DROP TABLE IF EXISTS `tbl_payment_methods`;

CREATE TABLE `tbl_payment_methods` (
  `payment_methods_id` int(11) NOT NULL AUTO_INCREMENT,
  `method_name` varchar(64) NOT NULL DEFAULT 'Paypal',
  PRIMARY KEY (`payment_methods_id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8;

INSERT INTO `tbl_payment_methods` (`payment_methods_id`, `method_name`) VALUES (1, 'Online');
INSERT INTO `tbl_payment_methods` (`payment_methods_id`, `method_name`) VALUES (2, 'PayPal');
INSERT INTO `tbl_payment_methods` (`payment_methods_id`, `method_name`) VALUES (3, 'Payoneer');
INSERT INTO `tbl_payment_methods` (`payment_methods_id`, `method_name`) VALUES (4, 'Bank Transfer');
INSERT INTO `tbl_payment_methods` (`payment_methods_id`, `method_name`) VALUES (5, 'Cash ');
INSERT INTO `tbl_payment_methods` (`payment_methods_id`, `method_name`) VALUES (6, 'NO');
INSERT INTO `tbl_payment_methods` (`payment_methods_id`, `method_name`) VALUES (7, 'NOa');
INSERT INTO `tbl_payment_methods` (`payment_methods_id`, `method_name`) VALUES (8, 'a');
INSERT INTO `tbl_payment_methods` (`payment_methods_id`, `method_name`) VALUES (9, 'by hand');
INSERT INTO `tbl_payment_methods` (`payment_methods_id`, `method_name`) VALUES (10, 'OKSSSS');
INSERT INTO `tbl_payment_methods` (`payment_methods_id`, `method_name`) VALUES (11, 'ass');
INSERT INTO `tbl_payment_methods` (`payment_methods_id`, `method_name`) VALUES (12, 'aaaaa');
INSERT INTO `tbl_payment_methods` (`payment_methods_id`, `method_name`) VALUES (13, 'asss');
INSERT INTO `tbl_payment_methods` (`payment_methods_id`, `method_name`) VALUES (14, 'ASE');


#
# TABLE STRUCTURE FOR: tbl_payments
#

DROP TABLE IF EXISTS `tbl_payments`;

CREATE TABLE `tbl_payments` (
  `payments_id` int(11) NOT NULL AUTO_INCREMENT,
  `invoices_id` int(11) NOT NULL,
  `trans_id` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `payer_email` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `payment_method` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `amount` longtext COLLATE utf8_unicode_ci,
  `currency` varchar(64) COLLATE utf8_unicode_ci DEFAULT 'USD',
  `notes` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `payment_date` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `month_paid` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `year_paid` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `paid_by` int(11) NOT NULL,
  `created_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `account_id` int(11) NOT NULL DEFAULT '0' COMMENT 'account_id means tracking deposit from which account',
  PRIMARY KEY (`payments_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: tbl_penalty_category
#

DROP TABLE IF EXISTS `tbl_penalty_category`;

CREATE TABLE `tbl_penalty_category` (
  `penalty_id` int(2) NOT NULL AUTO_INCREMENT,
  `penalty_type` varchar(100) NOT NULL,
  `fine_amount` int(11) NOT NULL,
  `penalty_days` varchar(10) NOT NULL,
  PRIMARY KEY (`penalty_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_performance_apprisal
#

DROP TABLE IF EXISTS `tbl_performance_apprisal`;

CREATE TABLE `tbl_performance_apprisal` (
  `performance_appraisal_id` int(5) NOT NULL AUTO_INCREMENT,
  `user_id` int(2) NOT NULL,
  `general_remarks` text NOT NULL,
  `appraisal_month` varchar(100) NOT NULL,
  `customer_experiece_management` tinyint(1) DEFAULT NULL COMMENT 'Technical - 1 = Beginner, 2 = Intermediate, 3 = Advanced, 4 = Expert / Leader',
  `marketing` tinyint(1) DEFAULT NULL COMMENT 'Technical - 1 = Beginner, 2 = Intermediate, 3 = Advanced, 4 = Expert / Leader',
  `management` tinyint(1) DEFAULT NULL COMMENT 'Technical - 1 = Beginner, 2 = Intermediate, 3 = Advanced, 4 = Expert / Leader',
  `administration` tinyint(1) DEFAULT NULL COMMENT 'Technical - 1 = Beginner, 2 = Intermediate, 3 = Advanced, 4 = Expert / Leader',
  `presentation_skill` tinyint(1) DEFAULT NULL COMMENT 'Technical - 1 = Beginner, 2 = Intermediate, 3 = Advanced, 4 = Expert / Leader',
  `quality_of_work` tinyint(1) DEFAULT NULL COMMENT 'Technical - 1 = Beginner, 2 = Intermediate, 3 = Advanced, 4 = Expert / Leader',
  `efficiency` tinyint(1) DEFAULT NULL COMMENT 'Technical - 1 = Beginner, 2 = Intermediate, 3 = Advanced, 4 = Expert / Leader',
  `integrity` tinyint(1) DEFAULT NULL COMMENT 'Behavioural - 1 (S) = Satisfactory, 2 (U) = Unsatisfactory, 3 (N) = Needs Improvement',
  `professionalism` tinyint(1) DEFAULT NULL COMMENT 'Behavioural - 1 (S) = Satisfactory, 2 (U) = Unsatisfactory, 3 (N) = Needs Improvement',
  `team_work` tinyint(1) DEFAULT NULL COMMENT 'Behavioural - 1 (S) = Satisfactory, 2 (U) = Unsatisfactory, 3 (N) = Needs Improvement',
  `critical_thinking` tinyint(1) DEFAULT NULL COMMENT 'Behavioural - 1 (S) = Satisfactory, 2 (U) = Unsatisfactory, 3 (N) = Needs Improvement',
  `conflict_management` tinyint(1) DEFAULT NULL COMMENT 'Behavioural - 1 (S) = Satisfactory, 2 (U) = Unsatisfactory, 3 (N) = Needs Improvement',
  `attendance` tinyint(1) DEFAULT NULL COMMENT 'Behavioural - 1 (S) = Satisfactory, 2 (U) = Unsatisfactory, 3 (N) = Needs Improvement',
  `ability_to_meed_deadline` tinyint(1) DEFAULT NULL COMMENT 'Behavioural - 1 (S) = Satisfactory, 2 (U) = Unsatisfactory, 3 (N) = Needs Improvement',
  PRIMARY KEY (`performance_appraisal_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_performance_indicator
#

DROP TABLE IF EXISTS `tbl_performance_indicator`;

CREATE TABLE `tbl_performance_indicator` (
  `performance_indicator_id` int(5) NOT NULL AUTO_INCREMENT,
  `designations_id` int(2) NOT NULL,
  `customer_experiece_management` tinyint(1) DEFAULT NULL COMMENT 'Technical - 1 = Beginner, 2 = Intermediate, 3 = Advanced, 4 = Expert / Leader',
  `marketing` tinyint(1) DEFAULT NULL COMMENT 'Technical - 1 = Beginner, 2 = Intermediate, 3 = Advanced, 4 = Expert / Leader',
  `management` tinyint(1) DEFAULT NULL COMMENT 'Technical - 1 = Beginner, 2 = Intermediate, 3 = Advanced, 4 = Expert / Leader',
  `administration` tinyint(1) DEFAULT NULL COMMENT 'Technical - 1 = Beginner, 2 = Intermediate, 3 = Advanced, 4 = Expert / Leader',
  `presentation_skill` tinyint(1) DEFAULT NULL COMMENT 'Technical - 1 = Beginner, 2 = Intermediate, 3 = Advanced, 4 = Expert / Leader',
  `quality_of_work` tinyint(1) DEFAULT NULL COMMENT 'Technical - 1 = Beginner, 2 = Intermediate, 3 = Advanced, 4 = Expert / Leader',
  `efficiency` tinyint(1) DEFAULT NULL COMMENT 'Technical - 1 = Beginner, 2 = Intermediate, 3 = Advanced, 4 = Expert / Leader',
  `integrity` tinyint(1) DEFAULT NULL COMMENT 'Behavioural - 1 = Beginner, 2 = Intermediate, 3 = Advanced',
  `professionalism` tinyint(1) DEFAULT NULL COMMENT 'Behavioural - 1 = Beginner, 2 = Intermediate, 3 = Advanced',
  `team_work` tinyint(1) DEFAULT NULL COMMENT 'Behavioural - 1 = Beginner, 2 = Intermediate, 3 = Advanced',
  `critical_thinking` tinyint(1) DEFAULT NULL COMMENT 'Behavioural - 1 = Beginner, 2 = Intermediate, 3 = Advanced',
  `conflict_management` tinyint(1) DEFAULT NULL COMMENT 'Behavioural - 1 = Beginner, 2 = Intermediate, 3 = Advanced',
  `attendance` tinyint(1) DEFAULT NULL COMMENT 'Behavioural - 1 = Beginner, 2 = Intermediate, 3 = Advanced',
  `ability_to_meed_deadline` tinyint(1) DEFAULT NULL COMMENT 'Behavioural - 1 = Beginner, 2 = Intermediate, 3 = Advanced',
  PRIMARY KEY (`performance_indicator_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_pinaction
#

DROP TABLE IF EXISTS `tbl_pinaction`;

CREATE TABLE `tbl_pinaction` (
  `pinaction_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `module_id` int(11) NOT NULL,
  `module_name` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`pinaction_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_priorities
#

DROP TABLE IF EXISTS `tbl_priorities`;

CREATE TABLE `tbl_priorities` (
  `priority` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `tbl_priorities` (`priority`) VALUES ('High');
INSERT INTO `tbl_priorities` (`priority`) VALUES ('medium');
INSERT INTO `tbl_priorities` (`priority`) VALUES ('low');


#
# TABLE STRUCTURE FOR: tbl_priority
#

DROP TABLE IF EXISTS `tbl_priority`;

CREATE TABLE `tbl_priority` (
  `priority_id` int(11) NOT NULL AUTO_INCREMENT,
  `priority` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`priority_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `tbl_priority` (`priority_id`, `priority`) VALUES (1, 'High');
INSERT INTO `tbl_priority` (`priority_id`, `priority`) VALUES (2, 'Medium');
INSERT INTO `tbl_priority` (`priority_id`, `priority`) VALUES (3, 'Low');
INSERT INTO `tbl_priority` (`priority_id`, `priority`) VALUES (4, 'ok');


#
# TABLE STRUCTURE FOR: tbl_private_chat
#

DROP TABLE IF EXISTS `tbl_private_chat`;

CREATE TABLE `tbl_private_chat` (
  `private_chat_id` int(11) NOT NULL AUTO_INCREMENT,
  `chat_title` varchar(500) COLLATE utf8_unicode_ci NOT NULL,
  `user_id` int(11) NOT NULL,
  `time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`private_chat_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: tbl_private_chat_messages
#

DROP TABLE IF EXISTS `tbl_private_chat_messages`;

CREATE TABLE `tbl_private_chat_messages` (
  `private_chat_messages_id` int(11) NOT NULL AUTO_INCREMENT,
  `private_chat_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `message` text COLLATE utf8_unicode_ci NOT NULL,
  `message_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`private_chat_messages_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: tbl_private_chat_users
#

DROP TABLE IF EXISTS `tbl_private_chat_users`;

CREATE TABLE `tbl_private_chat_users` (
  `private_chat_users_id` int(11) NOT NULL AUTO_INCREMENT,
  `private_chat_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `to_user_id` int(11) NOT NULL,
  `active` int(11) NOT NULL COMMENT '0 == minimize chat,1 == open chat and  2 == close chat ',
  `unread` int(11) NOT NULL,
  `title` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `deleted` int(11) NOT NULL DEFAULT '0' COMMENT 'keep last message id',
  PRIMARY KEY (`private_chat_users_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: tbl_project
#

DROP TABLE IF EXISTS `tbl_project`;

CREATE TABLE `tbl_project` (
  `project_id` int(11) NOT NULL AUTO_INCREMENT,
  `project_no` varchar(100) DEFAULT NULL,
  `project_name` varchar(100) NOT NULL,
  `category_id` int(11) DEFAULT NULL,
  `client_id` text,
  `progress` varchar(50) NOT NULL,
  `calculate_progress` varchar(50) DEFAULT NULL,
  `start_date` varchar(20) NOT NULL,
  `end_date` varchar(20) NOT NULL,
  `alert_overdue` tinyint(1) NOT NULL DEFAULT '0',
  `project_cost` decimal(18,2) NOT NULL DEFAULT '0.00',
  `demo_url` varchar(100) NOT NULL,
  `project_status` varchar(20) NOT NULL,
  `description` text,
  `notify_client` enum('Yes','No') NOT NULL,
  `timer_status` enum('on','off') DEFAULT NULL,
  `timer_started_by` int(11) DEFAULT NULL,
  `start_time` int(11) DEFAULT NULL,
  `logged_time` int(11) DEFAULT NULL,
  `permission` text,
  `notes` text,
  `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `hourly_rate` varchar(200) DEFAULT NULL,
  `fixed_rate` varchar(200) DEFAULT NULL,
  `project_settings` text,
  `with_tasks` enum('yes','no') NOT NULL DEFAULT 'no',
  `estimate_hours` varchar(50) DEFAULT NULL,
  `billing_type` varchar(50) DEFAULT NULL,
  `tags` text,
  PRIMARY KEY (`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_project_settings
#

DROP TABLE IF EXISTS `tbl_project_settings`;

CREATE TABLE `tbl_project_settings` (
  `settings_id` int(11) NOT NULL AUTO_INCREMENT,
  `settings` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`settings_id`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `tbl_project_settings` (`settings_id`, `settings`, `description`) VALUES (1, 'show_team_members', 'view team members');
INSERT INTO `tbl_project_settings` (`settings_id`, `settings`, `description`) VALUES (2, 'show_milestones', 'view project milestones');
INSERT INTO `tbl_project_settings` (`settings_id`, `settings`, `description`) VALUES (5, 'show_project_tasks', 'view project tasks');
INSERT INTO `tbl_project_settings` (`settings_id`, `settings`, `description`) VALUES (6, 'show_project_attachments', 'view project attachments');
INSERT INTO `tbl_project_settings` (`settings_id`, `settings`, `description`) VALUES (7, 'show_timesheets', 'view project timesheets');
INSERT INTO `tbl_project_settings` (`settings_id`, `settings`, `description`) VALUES (8, 'show_project_bugs', 'view project bugs');
INSERT INTO `tbl_project_settings` (`settings_id`, `settings`, `description`) VALUES (9, 'show_project_history', 'view project history');
INSERT INTO `tbl_project_settings` (`settings_id`, `settings`, `description`) VALUES (10, 'show_project_calendar', 'view project calendars');
INSERT INTO `tbl_project_settings` (`settings_id`, `settings`, `description`) VALUES (11, 'show_project_comments', 'view project comments');
INSERT INTO `tbl_project_settings` (`settings_id`, `settings`, `description`) VALUES (13, 'show_gantt_chart', 'view Gantt chart');
INSERT INTO `tbl_project_settings` (`settings_id`, `settings`, `description`) VALUES (14, 'show_project_hours', 'view project hours');
INSERT INTO `tbl_project_settings` (`settings_id`, `settings`, `description`) VALUES (15, 'comment_on_project_tasks', 'access To comment on project tasks');
INSERT INTO `tbl_project_settings` (`settings_id`, `settings`, `description`) VALUES (16, 'show_project_tasks_attachments', 'view task attachments');
INSERT INTO `tbl_project_settings` (`settings_id`, `settings`, `description`) VALUES (20, 'show_tasks_hours', 'show_tasks_hours');
INSERT INTO `tbl_project_settings` (`settings_id`, `settings`, `description`) VALUES (21, 'show_finance_overview', 'show_finance_overview');
INSERT INTO `tbl_project_settings` (`settings_id`, `settings`, `description`) VALUES (22, 'show_staff_finance_overview', 'admin and staff can see the price');


#
# TABLE STRUCTURE FOR: tbl_promotions
#

DROP TABLE IF EXISTS `tbl_promotions`;

CREATE TABLE `tbl_promotions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `designation_id` int(11) NOT NULL,
  `from_designations` int(11) NOT NULL,
  `promotion_title` varchar(190) NOT NULL,
  `promotion_date` date NOT NULL,
  `description` varchar(190) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_proposals
#

DROP TABLE IF EXISTS `tbl_proposals`;

CREATE TABLE `tbl_proposals` (
  `proposals_id` int(11) NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `subject` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `module` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `module_id` int(11) DEFAULT '0',
  `proposal_date` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `proposal_month` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `proposal_year` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `due_date` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `alert_overdue` tinyint(1) DEFAULT '0',
  `currency` varchar(32) COLLATE utf8_unicode_ci DEFAULT 'USD',
  `notes` text COLLATE utf8_unicode_ci NOT NULL,
  `tax` int(11) NOT NULL DEFAULT '0',
  `total_tax` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `status` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'draft',
  `date_sent` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `proposal_deleted` enum('Yes','No') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'No',
  `emailed` enum('Yes','No') COLLATE utf8_unicode_ci DEFAULT 'No',
  `show_client` enum('Yes','No') COLLATE utf8_unicode_ci DEFAULT 'No',
  `convert` enum('Yes','No') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'No',
  `convert_module` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `convert_module_id` int(11) DEFAULT '0',
  `converted_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `permission` text COLLATE utf8_unicode_ci,
  `discount_type` enum('none','before_tax','after_tax') CHARACTER SET utf8 NOT NULL DEFAULT 'none',
  `discount_percent` int(2) NOT NULL DEFAULT '0',
  `discount_total` decimal(18,2) NOT NULL DEFAULT '0.00',
  `warehouse_id` int(11) DEFAULT NULL,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `adjustment` decimal(18,2) NOT NULL DEFAULT '0.00',
  `show_quantity_as` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tags` text COLLATE utf8_unicode_ci,
  `allowed_cmments` enum('Yes','No') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'Yes',
  PRIMARY KEY (`proposals_id`),
  UNIQUE KEY `reference_no` (`reference_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: tbl_proposals_items
#

DROP TABLE IF EXISTS `tbl_proposals_items`;

CREATE TABLE `tbl_proposals_items` (
  `proposals_items_id` int(11) NOT NULL AUTO_INCREMENT,
  `proposals_id` int(11) NOT NULL,
  `saved_items_id` int(11) DEFAULT '0',
  `item_name` varchar(150) COLLATE utf8_unicode_ci DEFAULT 'Item Name',
  `item_desc` longtext COLLATE utf8_unicode_ci,
  `quantity` decimal(10,2) DEFAULT '0.00',
  `unit_cost` decimal(10,2) DEFAULT '0.00',
  `item_tax_rate` decimal(10,2) NOT NULL DEFAULT '0.00',
  `item_tax_name` text COLLATE utf8_unicode_ci,
  `item_tax_total` decimal(10,2) DEFAULT '0.00',
  `total_cost` decimal(10,2) DEFAULT '0.00',
  `date_saved` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `order` int(11) DEFAULT '0',
  `unit` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `hsn_code` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`proposals_items_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: tbl_purchase_items
#

DROP TABLE IF EXISTS `tbl_purchase_items`;

CREATE TABLE `tbl_purchase_items` (
  `items_id` int(11) NOT NULL AUTO_INCREMENT,
  `purchase_id` int(11) NOT NULL,
  `item_tax_rate` decimal(10,2) NOT NULL DEFAULT '0.00',
  `item_tax_name` text COLLATE utf8_unicode_ci,
  `item_tax_total` decimal(10,2) NOT NULL DEFAULT '0.00',
  `quantity` decimal(10,2) DEFAULT '0.00',
  `total_cost` decimal(10,2) DEFAULT '0.00',
  `item_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT 'Item Name',
  `item_desc` longtext COLLATE utf8_unicode_ci,
  `unit_cost` decimal(10,2) DEFAULT '0.00',
  `order` int(11) DEFAULT '0',
  `date_saved` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `unit` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `hsn_code` text COLLATE utf8_unicode_ci,
  `saved_items_id` int(11) DEFAULT '0',
  PRIMARY KEY (`items_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: tbl_purchase_payments
#

DROP TABLE IF EXISTS `tbl_purchase_payments`;

CREATE TABLE `tbl_purchase_payments` (
  `payments_id` int(11) NOT NULL AUTO_INCREMENT,
  `purchase_id` int(11) DEFAULT NULL,
  `trans_id` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `payment_method` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `amount` longtext COLLATE utf8_unicode_ci,
  `currency` varchar(64) COLLATE utf8_unicode_ci DEFAULT 'USD',
  `notes` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `payment_date` date DEFAULT NULL,
  `month_paid` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `year_paid` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `paid_to` int(11) NOT NULL,
  `paid_by` int(11) DEFAULT NULL,
  `created_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `account_id` int(11) NOT NULL DEFAULT '0' COMMENT 'account_id means tracking deduct from which account',
  PRIMARY KEY (`payments_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: tbl_purchases
#

DROP TABLE IF EXISTS `tbl_purchases`;

CREATE TABLE `tbl_purchases` (
  `purchase_id` int(11) NOT NULL AUTO_INCREMENT,
  `supplier_id` int(11) DEFAULT NULL,
  `reference_no` varchar(100) DEFAULT NULL,
  `total` decimal(20,2) DEFAULT NULL,
  `update_stock` enum('Yes','No') DEFAULT 'Yes',
  `stock_updated` enum('Yes','No') NOT NULL DEFAULT 'No',
  `status` varchar(20) DEFAULT NULL,
  `emailed` enum('Yes','No') DEFAULT NULL,
  `date_sent` varchar(20) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `warehouse_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `purchase_date` date DEFAULT NULL,
  `due_date` date DEFAULT NULL,
  `discount_type` enum('none','before_tax','after_tax') DEFAULT 'none',
  `discount_percent` decimal(10,2) DEFAULT NULL,
  `adjustment` decimal(18,2) DEFAULT NULL,
  `discount_total` decimal(18,2) DEFAULT NULL,
  `show_quantity_as` varchar(10) DEFAULT NULL,
  `permission` text,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `total_tax` text,
  `tax` decimal(20,2) DEFAULT NULL,
  `notes` text,
  `tags` text,
  PRIMARY KEY (`purchase_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_quotation_details
#

DROP TABLE IF EXISTS `tbl_quotation_details`;

CREATE TABLE `tbl_quotation_details` (
  `quotation_details_id` int(11) NOT NULL AUTO_INCREMENT,
  `quotations_id` int(11) NOT NULL,
  `quotation_form_data` text,
  `quotation_data` text,
  PRIMARY KEY (`quotation_details_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_quotationforms
#

DROP TABLE IF EXISTS `tbl_quotationforms`;

CREATE TABLE `tbl_quotationforms` (
  `quotationforms_id` int(11) NOT NULL AUTO_INCREMENT,
  `quotationforms_title` varchar(200) NOT NULL,
  `quotationforms_code` text NOT NULL,
  `quotationforms_status` varchar(20) NOT NULL DEFAULT 'enabled' COMMENT 'enabled/disabled',
  `quotations_created_by_id` int(11) NOT NULL,
  `quotationforms_date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`quotationforms_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_quotations
#

DROP TABLE IF EXISTS `tbl_quotations`;

CREATE TABLE `tbl_quotations` (
  `quotations_id` int(11) NOT NULL AUTO_INCREMENT,
  `quotations_form_title` varchar(250) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `client_id` int(11) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `mobile` varchar(100) DEFAULT NULL,
  `quotations_amount` decimal(10,2) DEFAULT NULL,
  `notes` text,
  `reviewer_id` int(11) DEFAULT NULL,
  `reviewed_date` date DEFAULT NULL,
  `quotations_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `quotations_status` varchar(15) DEFAULT 'pending' COMMENT 'completed/pending',
  `is_convert` enum('Yes','No') NOT NULL DEFAULT 'No',
  `convert_module` varchar(20) DEFAULT NULL,
  `convert_module_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`quotations_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_reminders
#

DROP TABLE IF EXISTS `tbl_reminders`;

CREATE TABLE `tbl_reminders` (
  `reminder_id` int(11) NOT NULL AUTO_INCREMENT,
  `description` text,
  `date` datetime NOT NULL,
  `notified` enum('Yes','No') NOT NULL DEFAULT 'No',
  `module` varchar(200) NOT NULL,
  `module_id` int(11) NOT NULL,
  `user_id` varchar(40) NOT NULL,
  `notify_by_email` enum('Yes','No') NOT NULL DEFAULT 'No',
  `created_by` int(11) NOT NULL,
  PRIMARY KEY (`reminder_id`),
  KEY `rel_id` (`module`),
  KEY `rel_type` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_resignations
#

DROP TABLE IF EXISTS `tbl_resignations`;

CREATE TABLE `tbl_resignations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` int(11) NOT NULL,
  `notice_date` date NOT NULL,
  `resignation_date` date NOT NULL,
  `description` varchar(190) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_return_stock
#

DROP TABLE IF EXISTS `tbl_return_stock`;

CREATE TABLE `tbl_return_stock` (
  `return_stock_id` int(11) NOT NULL AUTO_INCREMENT,
  `module` enum('client','supplier') DEFAULT NULL,
  `module_id` int(11) DEFAULT NULL,
  `main_status` varchar(200) DEFAULT NULL,
  `invoices_id` int(11) DEFAULT NULL,
  `warehouse_id` int(11) DEFAULT NULL,
  `reference_no` varchar(100) CHARACTER SET utf8 DEFAULT NULL,
  `total` decimal(20,2) DEFAULT NULL,
  `update_stock` enum('Yes','No') CHARACTER SET utf8 DEFAULT 'Yes',
  `status` varchar(20) CHARACTER SET utf8 DEFAULT NULL,
  `emailed` enum('Yes','No') CHARACTER SET utf8 DEFAULT NULL,
  `date_sent` varchar(20) CHARACTER SET utf8 DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `return_stock_date` date DEFAULT NULL,
  `due_date` date DEFAULT NULL,
  `discount_type` enum('none','before_tax','after_tax') CHARACTER SET utf8 DEFAULT 'none',
  `discount_percent` decimal(10,2) DEFAULT NULL,
  `adjustment` decimal(18,2) DEFAULT NULL,
  `discount_total` decimal(18,2) DEFAULT NULL,
  `show_quantity_as` varchar(10) CHARACTER SET utf8 DEFAULT NULL,
  `permission` text CHARACTER SET utf8,
  `created` timestamp NOT NULL DEFAULT '2019-05-05 16:30:00',
  `total_tax` text CHARACTER SET utf8,
  `tax` decimal(20,2) DEFAULT NULL,
  `notes` text CHARACTER SET utf8,
  PRIMARY KEY (`return_stock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: tbl_return_stock_items
#

DROP TABLE IF EXISTS `tbl_return_stock_items`;

CREATE TABLE `tbl_return_stock_items` (
  `items_id` int(11) NOT NULL AUTO_INCREMENT,
  `return_stock_id` int(11) NOT NULL,
  `invoice_items_id` int(11) DEFAULT NULL,
  `item_tax_rate` decimal(10,2) NOT NULL DEFAULT '0.00',
  `item_tax_name` text CHARACTER SET utf8 COLLATE utf8_unicode_ci,
  `item_tax_total` decimal(10,2) NOT NULL DEFAULT '0.00',
  `quantity` decimal(10,2) DEFAULT '0.00',
  `total_cost` decimal(10,2) DEFAULT '0.00',
  `item_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT 'Item Name',
  `item_desc` longtext CHARACTER SET utf8 COLLATE utf8_unicode_ci,
  `unit_cost` decimal(10,2) DEFAULT '0.00',
  `order` int(11) DEFAULT '0',
  `date_saved` timestamp NOT NULL DEFAULT '2019-05-05 16:30:00',
  `unit` varchar(200) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `hsn_code` text CHARACTER SET utf8 COLLATE utf8_unicode_ci,
  `saved_items_id` int(11) DEFAULT '0',
  PRIMARY KEY (`items_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: tbl_return_stock_payments
#

DROP TABLE IF EXISTS `tbl_return_stock_payments`;

CREATE TABLE `tbl_return_stock_payments` (
  `payments_id` int(11) NOT NULL AUTO_INCREMENT,
  `return_stock_id` int(11) DEFAULT NULL,
  `trans_id` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `payment_method` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `amount` longtext COLLATE utf8_unicode_ci,
  `currency` varchar(64) COLLATE utf8_unicode_ci DEFAULT 'USD',
  `notes` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `payment_date` date DEFAULT NULL,
  `month_paid` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `year_paid` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `module` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `paid_to` int(11) DEFAULT NULL,
  `paid_by` int(11) DEFAULT NULL,
  `created_date` timestamp NULL DEFAULT '0000-00-00 00:00:00',
  `account_id` int(11) NOT NULL DEFAULT '0' COMMENT 'account_id means tracking deduct from which account',
  PRIMARY KEY (`payments_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: tbl_salary_allowance
#

DROP TABLE IF EXISTS `tbl_salary_allowance`;

CREATE TABLE `tbl_salary_allowance` (
  `salary_allowance_id` int(11) NOT NULL AUTO_INCREMENT,
  `salary_template_id` int(11) NOT NULL,
  `allowance_label` varchar(200) NOT NULL,
  `allowance_value` varchar(200) NOT NULL,
  PRIMARY KEY (`salary_allowance_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_salary_deduction
#

DROP TABLE IF EXISTS `tbl_salary_deduction`;

CREATE TABLE `tbl_salary_deduction` (
  `salary_deduction_id` int(11) NOT NULL AUTO_INCREMENT,
  `salary_template_id` int(11) NOT NULL,
  `deduction_label` varchar(200) NOT NULL,
  `deduction_value` varchar(200) NOT NULL,
  PRIMARY KEY (`salary_deduction_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_salary_payment
#

DROP TABLE IF EXISTS `tbl_salary_payment`;

CREATE TABLE `tbl_salary_payment` (
  `salary_payment_id` int(5) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `payment_month` varchar(20) NOT NULL,
  `fine_deduction` varchar(200) NOT NULL,
  `payment_type` varchar(20) NOT NULL,
  `comments` text,
  `paid_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `deduct_from` int(11) NOT NULL DEFAULT '0' COMMENT 'deduct from means tracking deduct from which account',
  PRIMARY KEY (`salary_payment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_salary_payment_allowance
#

DROP TABLE IF EXISTS `tbl_salary_payment_allowance`;

CREATE TABLE `tbl_salary_payment_allowance` (
  `salary_payment_allowance_id` int(11) NOT NULL AUTO_INCREMENT,
  `salary_payment_id` int(11) NOT NULL,
  `salary_payment_allowance_label` varchar(200) NOT NULL,
  `salary_payment_allowance_value` varchar(200) NOT NULL,
  PRIMARY KEY (`salary_payment_allowance_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_salary_payment_deduction
#

DROP TABLE IF EXISTS `tbl_salary_payment_deduction`;

CREATE TABLE `tbl_salary_payment_deduction` (
  `salary_payment_deduction` int(11) NOT NULL AUTO_INCREMENT,
  `salary_payment_id` int(11) NOT NULL,
  `salary_payment_deduction_label` varchar(200) NOT NULL,
  `salary_payment_deduction_value` varchar(200) NOT NULL,
  PRIMARY KEY (`salary_payment_deduction`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_salary_payment_details
#

DROP TABLE IF EXISTS `tbl_salary_payment_details`;

CREATE TABLE `tbl_salary_payment_details` (
  `salary_payment_details_id` int(11) NOT NULL AUTO_INCREMENT,
  `salary_payment_id` int(11) NOT NULL,
  `salary_payment_details_label` varchar(200) NOT NULL,
  `salary_payment_details_value` varchar(200) NOT NULL,
  PRIMARY KEY (`salary_payment_details_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_salary_payslip
#

DROP TABLE IF EXISTS `tbl_salary_payslip`;

CREATE TABLE `tbl_salary_payslip` (
  `payslip_id` int(5) NOT NULL AUTO_INCREMENT,
  `payslip_number` varchar(100) DEFAULT NULL,
  `salary_payment_id` int(5) NOT NULL,
  `payslip_generate_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`payslip_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_salary_template
#

DROP TABLE IF EXISTS `tbl_salary_template`;

CREATE TABLE `tbl_salary_template` (
  `salary_template_id` int(11) NOT NULL AUTO_INCREMENT,
  `salary_grade` varchar(200) NOT NULL,
  `basic_salary` varchar(200) NOT NULL,
  `overtime_salary` varchar(100) NOT NULL,
  PRIMARY KEY (`salary_template_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_saved_items
#

DROP TABLE IF EXISTS `tbl_saved_items`;

CREATE TABLE `tbl_saved_items` (
  `saved_items_id` int(11) NOT NULL AUTO_INCREMENT,
  `item_name` varchar(200) COLLATE utf8_unicode_ci DEFAULT 'Item Name',
  `code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `manufacturer_id` int(11) DEFAULT NULL,
  `barcode_symbology` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `upload_file` text COLLATE utf8_unicode_ci,
  `cost_price` decimal(20,2) NOT NULL DEFAULT '0.00',
  `item_desc` longtext COLLATE utf8_unicode_ci,
  `unit_cost` decimal(18,2) DEFAULT '0.00',
  `customer_group_id` int(11) NOT NULL DEFAULT '0',
  `unit_type` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tax_rates_id` text COLLATE utf8_unicode_ci,
  `item_tax_rate` decimal(18,2) DEFAULT '0.00',
  `item_tax_total` decimal(18,2) DEFAULT '0.00',
  `quantity` decimal(18,2) DEFAULT '0.00',
  `total_cost` decimal(18,2) DEFAULT '0.00',
  `hsn_code` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`saved_items_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: tbl_sent
#

DROP TABLE IF EXISTS `tbl_sent`;

CREATE TABLE `tbl_sent` (
  `sent_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `to` varchar(100) NOT NULL,
  `subject` varchar(300) NOT NULL,
  `message_body` text NOT NULL,
  `attach_file` text,
  `attach_file_path` text,
  `attach_filename` text,
  `message_time` datetime NOT NULL,
  `deleted` enum('Yes','No') NOT NULL DEFAULT 'No',
  PRIMARY KEY (`sent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_sessions
#

DROP TABLE IF EXISTS `tbl_sessions`;

CREATE TABLE `tbl_sessions` (
  `id` varchar(40) NOT NULL,
  `ip_address` varchar(45) NOT NULL,
  `timestamp` int(10) unsigned NOT NULL DEFAULT '0',
  `data` blob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ci_sessions_timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `tbl_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('03afcf4373f8cefdad2190ad1d53d7ed0f8d5d08', '54.78.98.72', 1689166860, '__ci_last_regenerate|i:1689166860;menu_active_id|a:2:{i:0;s:3:\"109\";i:1;s:1:\"0\";}');
INSERT INTO `tbl_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('05388fa98d0f59558860e35e808b1eca756612be', '136.158.120.226', 1688537680, '__ci_last_regenerate|i:1688537680;menu_active_id|a:3:{i:0;s:3:\"113\";i:1;s:2:\"25\";i:2;s:1:\"0\";}user_name|s:5:\"nimda\";email|s:26:\"erick@blickcreative.com.au\";name|s:13:\"Erick Villeta\";photo|s:26:\"uploads/default_avatar.jpg\";user_id|s:1:\"5\";last_login|N;online_time|i:1688531159;loggedin|b:1;user_type|s:1:\"1\";user_flag|s:1:\"1\";direction|s:3:\"ltr\";warehouse_id|N;designations_id|s:1:\"0\";url|s:33:\"admin/dashboard/pinned_menu_items\";user_roll|a:154:{i:0;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"1\";s:5:\"label\";s:9:\"dashboard\";s:4:\"link\";s:15:\"admin/dashboard\";s:4:\"icon\";s:15:\"fa fa-dashboard\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-04-23 01:39:36\";s:6:\"status\";s:1:\"1\";}i:1;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"2\";s:5:\"label\";s:8:\"calendar\";s:4:\"link\";s:14:\"admin/calendar\";s:4:\"icon\";s:14:\"fa fa-calendar\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-23 19:57:23\";s:6:\"status\";s:1:\"1\";}i:2;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"4\";s:5:\"label\";s:6:\"client\";s:4:\"link\";s:26:\"admin/client/manage_client\";s:4:\"icon\";s:11:\"fa fa-users\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"13\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:3;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"5\";s:5:\"label\";s:7:\"mailbox\";s:4:\"link\";s:13:\"admin/mailbox\";s:4:\"icon\";s:16:\"fa fa-envelope-o\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:4;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"6\";s:5:\"label\";s:7:\"tickets\";s:4:\"link\";s:13:\"admin/tickets\";s:4:\"icon\";s:12:\"fa fa-ticket\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2018-06-08 13:39:39\";s:6:\"status\";s:1:\"1\";}i:5;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"12\";s:5:\"label\";s:5:\"sales\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:19:\"fa fa-shopping-cart\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"9\";s:4:\"time\";s:19:\"2017-06-10 14:02:58\";s:6:\"status\";s:1:\"1\";}i:6;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"13\";s:5:\"label\";s:7:\"invoice\";s:4:\"link\";s:28:\"admin/invoice/manage_invoice\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-04-23 19:57:23\";s:6:\"status\";s:1:\"1\";}i:7;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"14\";s:5:\"label\";s:9:\"estimates\";s:4:\"link\";s:15:\"admin/estimates\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-06-10 14:02:05\";s:6:\"status\";s:1:\"1\";}i:8;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"15\";s:5:\"label\";s:17:\"payments_received\";s:4:\"link\";s:26:\"admin/invoice/all_payments\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-23 19:57:24\";s:6:\"status\";s:1:\"1\";}i:9;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"16\";s:5:\"label\";s:9:\"tax_rates\";s:4:\"link\";s:23:\"admin/invoice/tax_rates\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-01-07 07:05:16\";s:6:\"status\";s:1:\"1\";}i:10;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"21\";s:5:\"label\";s:10:\"quotations\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:11:\"fa fa-paste\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:11;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"22\";s:5:\"label\";s:15:\"quotations_list\";s:4:\"link\";s:16:\"admin/quotations\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"21\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-05-18 16:49:03\";s:6:\"status\";s:1:\"1\";}i:12;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"23\";s:5:\"label\";s:15:\"quotations_form\";s:4:\"link\";s:32:\"admin/quotations/quotations_form\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"21\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:13;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"24\";s:5:\"label\";s:4:\"user\";s:4:\"link\";s:20:\"admin/user/user_list\";s:4:\"icon\";s:11:\"fa fa-users\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"25\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:14;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"25\";s:5:\"label\";s:8:\"settings\";s:4:\"link\";s:14:\"admin/settings\";s:4:\"icon\";s:10:\"fa fa-cogs\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"26\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:15;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"26\";s:5:\"label\";s:15:\"database_backup\";s:4:\"link\";s:30:\"admin/settings/database_backup\";s:4:\"icon\";s:14:\"fa fa-database\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"27\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:16;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"29\";s:5:\"label\";s:17:\"transactions_menu\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:16:\"fa fa-building-o\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"12\";s:4:\"time\";s:19:\"2018-05-13 12:27:58\";s:6:\"status\";s:1:\"1\";}i:17;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"30\";s:5:\"label\";s:7:\"deposit\";s:4:\"link\";s:26:\"admin/transactions/deposit\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-05-13 12:28:33\";s:6:\"status\";s:1:\"1\";}i:18;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"31\";s:5:\"label\";s:7:\"expense\";s:4:\"link\";s:26:\"admin/transactions/expense\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-05-13 12:28:37\";s:6:\"status\";s:1:\"1\";}i:19;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"32\";s:5:\"label\";s:8:\"transfer\";s:4:\"link\";s:27:\"admin/transactions/transfer\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-05-13 12:28:40\";s:6:\"status\";s:1:\"1\";}i:20;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"33\";s:5:\"label\";s:19:\"transactions_report\";s:4:\"link\";s:38:\"admin/transactions/transactions_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2018-05-13 12:28:44\";s:6:\"status\";s:1:\"1\";}i:21;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"34\";s:5:\"label\";s:13:\"balance_sheet\";s:4:\"link\";s:32:\"admin/transactions/balance_sheet\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-05-13 12:28:47\";s:6:\"status\";s:1:\"1\";}i:22;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"36\";s:5:\"label\";s:9:\"bank_cash\";s:4:\"link\";s:28:\"admin/account/manage_account\";s:4:\"icon\";s:11:\"fa fa-money\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2018-05-13 12:28:51\";s:6:\"status\";s:1:\"1\";}i:23;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"39\";s:5:\"label\";s:5:\"items\";s:4:\"link\";s:22:\"admin/items/items_list\";s:4:\"icon\";s:10:\"fa fa-cube\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2019-05-04 18:49:50\";s:6:\"status\";s:1:\"1\";}i:24;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"42\";s:5:\"label\";s:6:\"report\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:15:\"fa fa-bar-chart\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"24\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:25;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"43\";s:5:\"label\";s:17:\"account_statement\";s:4:\"link\";s:30:\"admin/report/account_statement\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:26;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"44\";s:5:\"label\";s:13:\"income_report\";s:4:\"link\";s:26:\"admin/report/income_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:27;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"45\";s:5:\"label\";s:14:\"expense_report\";s:4:\"link\";s:27:\"admin/report/expense_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:28;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"46\";s:5:\"label\";s:14:\"income_expense\";s:4:\"link\";s:27:\"admin/report/income_expense\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:29;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"47\";s:5:\"label\";s:16:\"date_wise_report\";s:4:\"link\";s:29:\"admin/report/date_wise_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:30;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"48\";s:5:\"label\";s:10:\"all_income\";s:4:\"link\";s:23:\"admin/report/all_income\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:31;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"49\";s:5:\"label\";s:11:\"all_expense\";s:4:\"link\";s:24:\"admin/report/all_expense\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:32;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"50\";s:5:\"label\";s:15:\"all_transaction\";s:4:\"link\";s:28:\"admin/report/all_transaction\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:33;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"51\";s:5:\"label\";s:17:\"recurring_invoice\";s:4:\"link\";s:31:\"admin/invoice/recurring_invoice\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-06-10 14:02:05\";s:6:\"status\";s:1:\"1\";}i:34;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"52\";s:5:\"label\";s:15:\"transfer_report\";s:4:\"link\";s:34:\"admin/transactions/transfer_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-05-13 12:28:59\";s:6:\"status\";s:1:\"1\";}i:35;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"53\";s:5:\"label\";s:15:\"report_by_month\";s:4:\"link\";s:28:\"admin/report/report_by_month\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:36;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"54\";s:5:\"label\";s:5:\"tasks\";s:4:\"link\";s:20:\"admin/tasks/all_task\";s:4:\"icon\";s:11:\"fa fa-tasks\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:37;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"55\";s:5:\"label\";s:5:\"leads\";s:4:\"link\";s:11:\"admin/leads\";s:4:\"icon\";s:12:\"fa fa-rocket\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:38;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"56\";s:5:\"label\";s:13:\"opportunities\";s:4:\"link\";s:19:\"admin/opportunities\";s:4:\"icon\";s:12:\"fa fa-filter\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:39;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"57\";s:5:\"label\";s:8:\"projects\";s:4:\"link\";s:14:\"admin/projects\";s:4:\"icon\";s:19:\"fa fa-folder-open-o\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:40;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"58\";s:5:\"label\";s:4:\"bugs\";s:4:\"link\";s:10:\"admin/bugs\";s:4:\"icon\";s:9:\"fa fa-bug\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:41;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"59\";s:5:\"label\";s:7:\"project\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:19:\"fa fa-folder-open-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:42;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"60\";s:5:\"label\";s:12:\"tasks_report\";s:4:\"link\";s:25:\"admin/report/tasks_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:43;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"61\";s:5:\"label\";s:11:\"bugs_report\";s:4:\"link\";s:24:\"admin/report/bugs_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:44;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"62\";s:5:\"label\";s:14:\"tickets_report\";s:4:\"link\";s:27:\"admin/report/tickets_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:45;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"63\";s:5:\"label\";s:13:\"client_report\";s:4:\"link\";s:26:\"admin/report/client_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2018-01-07 07:09:40\";s:6:\"status\";s:1:\"1\";}i:46;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"66\";s:5:\"label\";s:16:\"tasks_assignment\";s:4:\"link\";s:29:\"admin/report/tasks_assignment\";s:4:\"icon\";s:18:\"fa fa-dot-circle-o\";s:6:\"parent\";s:2:\"59\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:47;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"67\";s:5:\"label\";s:15:\"bugs_assignment\";s:4:\"link\";s:28:\"admin/report/bugs_assignment\";s:4:\"icon\";s:18:\"fa fa-dot-circle-o\";s:6:\"parent\";s:2:\"59\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:48;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"68\";s:5:\"label\";s:14:\"project_report\";s:4:\"link\";s:27:\"admin/report/project_report\";s:4:\"icon\";s:18:\"fa fa-dot-circle-o\";s:6:\"parent\";s:2:\"59\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:49;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"69\";s:5:\"label\";s:13:\"goal_tracking\";s:4:\"link\";s:19:\"admin/goal_tracking\";s:4:\"icon\";s:12:\"fa fa-shield\";s:6:\"parent\";s:2:\"73\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-06-10 14:05:47\";s:6:\"status\";s:1:\"1\";}i:50;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"70\";s:5:\"label\";s:11:\"departments\";s:4:\"link\";s:17:\"admin/departments\";s:4:\"icon\";s:17:\"fa fa-user-secret\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"14\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:51;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"71\";s:5:\"label\";s:7:\"holiday\";s:4:\"link\";s:13:\"admin/holiday\";s:4:\"icon\";s:21:\"fa fa-calendar-plus-o\";s:6:\"parent\";s:2:\"73\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-06-10 14:05:47\";s:6:\"status\";s:1:\"1\";}i:52;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"72\";s:5:\"label\";s:16:\"leave_management\";s:4:\"link\";s:22:\"admin/leave_management\";s:4:\"icon\";s:11:\"fa fa-plane\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"20\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:53;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"73\";s:5:\"label\";s:9:\"utilities\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:10:\"fa fa-gift\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"23\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:54;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"74\";s:5:\"label\";s:8:\"overtime\";s:4:\"link\";s:24:\"admin/utilities/overtime\";s:4:\"icon\";s:13:\"fa fa-clock-o\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"9\";s:4:\"time\";s:19:\"2017-06-10 14:04:23\";s:6:\"status\";s:1:\"1\";}i:55;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"75\";s:5:\"label\";s:12:\"office_stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:13:\"fa fa-codepen\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"15\";s:4:\"time\";s:19:\"2019-05-01 16:22:56\";s:6:\"status\";s:1:\"1\";}i:56;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"76\";s:5:\"label\";s:14:\"stock_category\";s:4:\"link\";s:26:\"admin/stock/stock_category\";s:4:\"icon\";s:13:\"fa fa-sliders\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:57;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"77\";s:5:\"label\";s:12:\"manage_stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:13:\"fa fa-archive\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-04-26 16:11:10\";s:6:\"status\";s:1:\"1\";}i:58;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"78\";s:5:\"label\";s:12:\"assign_stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:16:\"fa fa-align-left\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-26 16:11:10\";s:6:\"status\";s:1:\"1\";}i:59;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"79\";s:5:\"label\";s:12:\"stock_report\";s:4:\"link\";s:18:\"admin/stock/report\";s:4:\"icon\";s:16:\"fa fa-line-chart\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2017-04-25 18:48:25\";s:6:\"status\";s:1:\"1\";}i:60;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"81\";s:5:\"label\";s:10:\"stock_list\";s:4:\"link\";s:22:\"admin/stock/stock_list\";s:4:\"icon\";s:20:\"fa fa-stack-exchange\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-26 16:11:10\";s:6:\"status\";s:1:\"1\";}i:61;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"82\";s:5:\"label\";s:12:\"assign_stock\";s:4:\"link\";s:24:\"admin/stock/assign_stock\";s:4:\"icon\";s:16:\"fa fa-align-left\";s:6:\"parent\";s:2:\"78\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:62;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"83\";s:5:\"label\";s:19:\"assign_stock_report\";s:4:\"link\";s:31:\"admin/stock/assign_stock_report\";s:4:\"icon\";s:15:\"fa fa-bar-chart\";s:6:\"parent\";s:2:\"78\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:63;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"84\";s:5:\"label\";s:13:\"stock_history\";s:4:\"link\";s:25:\"admin/stock/stock_history\";s:4:\"icon\";s:17:\"fa fa-file-text-o\";s:6:\"parent\";s:2:\"77\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:64;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"85\";s:5:\"label\";s:11:\"performance\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:14:\"fa fa-dribbble\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"19\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:65;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"86\";s:5:\"label\";s:21:\"performance_indicator\";s:4:\"link\";s:39:\"admin/performance/performance_indicator\";s:4:\"icon\";s:12:\"fa fa-random\";s:6:\"parent\";s:2:\"85\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:66;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"87\";s:5:\"label\";s:18:\"performance_report\";s:4:\"link\";s:36:\"admin/performance/performance_report\";s:4:\"icon\";s:16:\"fa fa-calendar-o\";s:6:\"parent\";s:2:\"85\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:67;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"88\";s:5:\"label\";s:14:\"give_appraisal\";s:4:\"link\";s:44:\"admin/performance/give_performance_appraisal\";s:4:\"icon\";s:10:\"fa fa-plus\";s:6:\"parent\";s:2:\"85\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:68;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"89\";s:5:\"label\";s:7:\"payroll\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:9:\"fa fa-usd\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"18\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:69;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"90\";s:5:\"label\";s:21:\"manage_salary_details\";s:4:\"link\";s:35:\"admin/payroll/manage_salary_details\";s:4:\"icon\";s:9:\"fa fa-usd\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:70;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"91\";s:5:\"label\";s:20:\"employee_salary_list\";s:4:\"link\";s:34:\"admin/payroll/employee_salary_list\";s:4:\"icon\";s:17:\"fa fa-user-secret\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:71;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"92\";s:5:\"label\";s:12:\"make_payment\";s:4:\"link\";s:26:\"admin/payroll/make_payment\";s:4:\"icon\";s:11:\"fa fa-tasks\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:72;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"93\";s:5:\"label\";s:16:\"generate_payslip\";s:4:\"link\";s:30:\"admin/payroll/generate_payslip\";s:4:\"icon\";s:13:\"fa fa-list-ul\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:73;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"94\";s:5:\"label\";s:15:\"salary_template\";s:4:\"link\";s:29:\"admin/payroll/salary_template\";s:4:\"icon\";s:11:\"fa fa-money\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:74;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"95\";s:5:\"label\";s:11:\"hourly_rate\";s:4:\"link\";s:25:\"admin/payroll/hourly_rate\";s:4:\"icon\";s:13:\"fa fa-clock-o\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:75;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"96\";s:5:\"label\";s:15:\"payroll_summary\";s:4:\"link\";s:29:\"admin/payroll/payroll_summary\";s:4:\"icon\";s:18:\"fa fa-camera-retro\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:76;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"97\";s:5:\"label\";s:14:\"provident_fund\";s:4:\"link\";s:28:\"admin/payroll/provident_fund\";s:4:\"icon\";s:15:\"fa fa-briefcase\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2017-06-10 14:04:23\";s:6:\"status\";s:1:\"1\";}i:77;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"98\";s:5:\"label\";s:14:\"advance_salary\";s:4:\"link\";s:28:\"admin/payroll/advance_salary\";s:4:\"icon\";s:19:\"fa fa-cc-mastercard\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2017-06-10 14:04:23\";s:6:\"status\";s:1:\"1\";}i:78;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"99\";s:5:\"label\";s:14:\"employee_award\";s:4:\"link\";s:11:\"admin/award\";s:4:\"icon\";s:12:\"fa fa-trophy\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2017-06-10 14:05:47\";s:6:\"status\";s:1:\"1\";}i:79;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"100\";s:5:\"label\";s:13:\"announcements\";s:4:\"link\";s:19:\"admin/announcements\";s:4:\"icon\";s:19:\"fa fa-bullhorn icon\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"22\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:80;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"101\";s:5:\"label\";s:8:\"training\";s:4:\"link\";s:14:\"admin/training\";s:4:\"icon\";s:14:\"fa fa-suitcase\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"21\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:81;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"102\";s:5:\"label\";s:12:\"job_circular\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:11:\"fa fa-globe\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"17\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:82;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"103\";s:5:\"label\";s:11:\"jobs_posted\";s:4:\"link\";s:30:\"admin/job_circular/jobs_posted\";s:4:\"icon\";s:12:\"fa fa-ticket\";s:6:\"parent\";s:3:\"102\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:83;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"104\";s:5:\"label\";s:17:\"jobs_applications\";s:4:\"link\";s:36:\"admin/job_circular/jobs_applications\";s:4:\"icon\";s:13:\"fa fa-compass\";s:6:\"parent\";s:3:\"102\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:84;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"105\";s:5:\"label\";s:10:\"attendance\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:15:\"fa fa-file-text\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"16\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:85;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"106\";s:5:\"label\";s:18:\"timechange_request\";s:4:\"link\";s:35:\"admin/attendance/timechange_request\";s:4:\"icon\";s:16:\"fa fa-calendar-o\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:86;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"107\";s:5:\"label\";s:17:\"attendance_report\";s:4:\"link\";s:34:\"admin/attendance/attendance_report\";s:4:\"icon\";s:15:\"fa fa-file-text\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:87;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"108\";s:5:\"label\";s:12:\"time_history\";s:4:\"link\";s:29:\"admin/attendance/time_history\";s:4:\"icon\";s:13:\"fa fa-clock-o\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:88;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"109\";s:5:\"label\";s:9:\"pull-down\";s:4:\"link\";s:0:\"\";s:4:\"icon\";s:0:\"\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-31 12:43:20\";s:6:\"status\";s:1:\"0\";}i:89;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"110\";s:5:\"label\";s:11:\"filemanager\";s:4:\"link\";s:17:\"admin/filemanager\";s:4:\"icon\";s:10:\"fa fa-file\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:90;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"111\";s:5:\"label\";s:15:\"company_details\";s:4:\"link\";s:14:\"admin/settings\";s:4:\"icon\";s:23:\"fa fa-fw fa-info-circle\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-25 17:08:46\";s:6:\"status\";s:1:\"2\";}i:91;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"112\";s:5:\"label\";s:15:\"system_settings\";s:4:\"link\";s:21:\"admin/settings/system\";s:4:\"icon\";s:19:\"fa fa-fw fa-desktop\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-04-25 17:08:46\";s:6:\"status\";s:1:\"2\";}i:92;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"113\";s:5:\"label\";s:14:\"email_settings\";s:4:\"link\";s:20:\"admin/settings/email\";s:4:\"icon\";s:20:\"fa fa-fw fa-envelope\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-25 17:08:46\";s:6:\"status\";s:1:\"2\";}i:93;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"114\";s:5:\"label\";s:15:\"email_templates\";s:4:\"link\";s:24:\"admin/settings/templates\";s:4:\"icon\";s:25:\"fa fa-fw fa-pencil-square\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2021-07-30 06:18:08\";s:6:\"status\";s:1:\"2\";}i:94;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"115\";s:5:\"label\";s:17:\"email_integration\";s:4:\"link\";s:32:\"admin/settings/email_integration\";s:4:\"icon\";s:22:\"fa fa-fw fa-envelope-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2021-07-30 06:18:08\";s:6:\"status\";s:1:\"2\";}i:95;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"116\";s:5:\"label\";s:16:\"payment_settings\";s:4:\"link\";s:23:\"admin/settings/payments\";s:4:\"icon\";s:18:\"fa fa-fw fa-dollar\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:96;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"117\";s:5:\"label\";s:16:\"invoice_settings\";s:4:\"link\";s:22:\"admin/settings/invoice\";s:4:\"icon\";s:17:\"fa fa-fw fa-money\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:97;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"118\";s:5:\"label\";s:17:\"estimate_settings\";s:4:\"link\";s:23:\"admin/settings/estimate\";s:4:\"icon\";s:18:\"fa fa-fw fa-file-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:98;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"119\";s:5:\"label\";s:22:\"tickets_leads_settings\";s:4:\"link\";s:22:\"admin/settings/tickets\";s:4:\"icon\";s:18:\"fa fa-fw fa-ticket\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"14\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:99;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"120\";s:5:\"label\";s:14:\"theme_settings\";s:4:\"link\";s:20:\"admin/settings/theme\";s:4:\"icon\";s:16:\"fa fa-fw fa-code\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"20\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:100;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"121\";s:5:\"label\";s:12:\"working_days\";s:4:\"link\";s:27:\"admin/settings/working_days\";s:4:\"icon\";s:20:\"fa fa-fw fa-calendar\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"22\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:101;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"122\";s:5:\"label\";s:14:\"leave_category\";s:4:\"link\";s:29:\"admin/settings/leave_category\";s:4:\"icon\";s:21:\"fa fa-fw fa-pagelines\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"23\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:102;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"123\";s:5:\"label\";s:15:\"income_category\";s:4:\"link\";s:30:\"admin/settings/income_category\";s:4:\"icon\";s:23:\"fa fa-fw fa-certificate\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"24\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:103;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"124\";s:5:\"label\";s:16:\"expense_category\";s:4:\"link\";s:31:\"admin/settings/expense_category\";s:4:\"icon\";s:17:\"fa fa-fw fa-tasks\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"25\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:104;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"125\";s:5:\"label\";s:14:\"customer_group\";s:4:\"link\";s:29:\"admin/settings/customer_group\";s:4:\"icon\";s:17:\"fa fa-fw fa-users\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"26\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:105;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"127\";s:5:\"label\";s:11:\"lead_status\";s:4:\"link\";s:26:\"admin/settings/lead_status\";s:4:\"icon\";s:19:\"fa fa-fw fa-list-ul\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"16\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:106;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"128\";s:5:\"label\";s:11:\"lead_source\";s:4:\"link\";s:26:\"admin/settings/lead_source\";s:4:\"icon\";s:22:\"fa fa-fw fa-arrow-down\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"17\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:107;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"129\";s:5:\"label\";s:26:\"opportunities_state_reason\";s:4:\"link\";s:41:\"admin/settings/opportunities_state_reason\";s:4:\"icon\";s:24:\"fa fa-fw fa-dot-circle-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"19\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:108;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"130\";s:5:\"label\";s:12:\"custom_field\";s:4:\"link\";s:27:\"admin/settings/custom_field\";s:4:\"icon\";s:18:\"fa fa-fw fa-star-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"28\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:109;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"131\";s:5:\"label\";s:14:\"payment_method\";s:4:\"link\";s:29:\"admin/settings/payment_method\";s:4:\"icon\";s:17:\"fa fa-fw fa-money\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"29\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:110;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"132\";s:5:\"label\";s:7:\"cronjob\";s:4:\"link\";s:22:\"admin/settings/cronjob\";s:4:\"icon\";s:18:\"fa fa-fw fa-contao\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"31\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:111;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"133\";s:5:\"label\";s:15:\"menu_allocation\";s:4:\"link\";s:30:\"admin/settings/menu_allocation\";s:4:\"icon\";s:22:\"fa fa-fw fa fa-compass\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"32\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:112;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"134\";s:5:\"label\";s:12:\"notification\";s:4:\"link\";s:27:\"admin/settings/notification\";s:4:\"icon\";s:18:\"fa fa-fw fa-bell-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"33\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:113;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"135\";s:5:\"label\";s:18:\"email_notification\";s:4:\"link\";s:33:\"admin/settings/email_notification\";s:4:\"icon\";s:18:\"fa fa-fw fa-bell-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"34\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:114;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"136\";s:5:\"label\";s:15:\"database_backup\";s:4:\"link\";s:30:\"admin/settings/database_backup\";s:4:\"icon\";s:20:\"fa fa-fw fa-database\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"35\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:115;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"137\";s:5:\"label\";s:12:\"translations\";s:4:\"link\";s:27:\"admin/settings/translations\";s:4:\"icon\";s:20:\"fa fa-fw fa-language\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"36\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:116;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"138\";s:5:\"label\";s:13:\"system_update\";s:4:\"link\";s:28:\"admin/settings/system_update\";s:4:\"icon\";s:27:\"fa fa-fw fa-pencil-square-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"37\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:117;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"139\";s:5:\"label\";s:12:\"private_chat\";s:4:\"link\";s:18:\"chat/conversations\";s:4:\"icon\";s:14:\"fa fa-envelope\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"28\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:118;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"140\";s:5:\"label\";s:9:\"proposals\";s:4:\"link\";s:15:\"admin/proposals\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-01-07 07:05:16\";s:6:\"status\";s:1:\"1\";}i:119;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"141\";s:5:\"label\";s:13:\"knowledgebase\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:21:\"fa fa-question-circle\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"11\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:120;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"142\";s:5:\"label\";s:10:\"categories\";s:4:\"link\";s:30:\"admin/knowledgebase/categories\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"141\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:121;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"143\";s:5:\"label\";s:8:\"articles\";s:4:\"link\";s:28:\"admin/knowledgebase/articles\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"141\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:122;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"144\";s:5:\"label\";s:13:\"knowledgebase\";s:4:\"link\";s:19:\"admin/knowledgebase\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"141\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:123;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"145\";s:5:\"label\";s:18:\"dashboard_settings\";s:4:\"link\";s:24:\"admin/settings/dashboard\";s:4:\"icon\";s:21:\"fa fa-fw fa-dashboard\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"21\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:124;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"146\";s:5:\"label\";s:20:\"transactions_reports\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:16:\"fa fa-building-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-05-13 12:29:51\";s:6:\"status\";s:1:\"1\";}i:125;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"147\";s:5:\"label\";s:5:\"sales\";s:4:\"link\";s:25:\"admin/report/sales_report\";s:4:\"icon\";s:19:\"fa fa-shopping-cart\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-01-07 01:12:23\";s:6:\"status\";s:1:\"1\";}i:126;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"148\";s:5:\"label\";s:15:\"mark_attendance\";s:4:\"link\";s:21:\"admin/mark_attendance\";s:4:\"icon\";s:15:\"fa fa-file-text\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-03-07 06:45:25\";s:6:\"status\";s:1:\"1\";}i:127;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"149\";s:5:\"label\";s:10:\"allowed_ip\";s:4:\"link\";s:25:\"admin/settings/allowed_ip\";s:4:\"icon\";s:12:\"fa fa-server\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"27\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:128;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"150\";s:5:\"label\";s:5:\"stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:11:\"icon-layers\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2019-05-01 18:10:52\";s:6:\"status\";s:1:\"1\";}i:129;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"151\";s:5:\"label\";s:8:\"supplier\";s:4:\"link\";s:14:\"admin/supplier\";s:4:\"icon\";s:14:\"icon-briefcase\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2019-05-01 18:10:52\";s:6:\"status\";s:1:\"1\";}i:130;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"152\";s:5:\"label\";s:8:\"purchase\";s:4:\"link\";s:14:\"admin/purchase\";s:4:\"icon\";s:12:\"icon-handbag\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2019-05-01 18:10:52\";s:6:\"status\";s:1:\"1\";}i:131;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"153\";s:5:\"label\";s:12:\"return_stock\";s:4:\"link\";s:18:\"admin/return_stock\";s:4:\"icon\";s:14:\"icon-share-alt\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2019-05-05 16:19:30\";s:6:\"status\";s:1:\"1\";}i:132;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"154\";s:5:\"label\";s:16:\"purchase_payment\";s:4:\"link\";s:27:\"admin/purchase/all_payments\";s:4:\"icon\";s:16:\"icon-credit-card\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2019-05-05 13:53:11\";s:6:\"status\";s:1:\"1\";}i:133;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"155\";s:5:\"label\";s:17:\"purchase_settings\";s:4:\"link\";s:23:\"admin/settings/purchase\";s:4:\"icon\";s:18:\"fa-fw icon-handbag\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"12\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:134;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"156\";s:5:\"label\";s:11:\"credit_note\";s:4:\"link\";s:17:\"admin/credit_note\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-06-10 02:32:05\";s:6:\"status\";s:1:\"1\";}i:135;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"157\";s:5:\"label\";s:20:\"credit_note_settings\";s:4:\"link\";s:26:\"admin/settings/credit_note\";s:4:\"icon\";s:17:\"fa fa-fw fa-money\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"9\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:136;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"158\";s:5:\"label\";s:18:\"proposals_settings\";s:4:\"link\";s:24:\"admin/settings/proposals\";s:4:\"icon\";s:16:\"fa fa-fw fa-leaf\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"11\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:137;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"159\";s:5:\"label\";s:17:\"projects_settings\";s:4:\"link\";s:23:\"admin/settings/projects\";s:4:\"icon\";s:25:\"fa fa-fw fa-folder-open-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"13\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:138;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"160\";s:5:\"label\";s:4:\"tags\";s:4:\"link\";s:19:\"admin/settings/tags\";s:4:\"icon\";s:16:\"fa fa-fw fa-tags\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"30\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:139;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"161\";s:5:\"label\";s:9:\"lead_form\";s:4:\"link\";s:25:\"admin/leads/all_lead_form\";s:4:\"icon\";s:18:\"fa fa-fw fa-rocket\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"18\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:140;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"162\";s:5:\"label\";s:21:\"transactions_settings\";s:4:\"link\";s:27:\"admin/settings/transactions\";s:4:\"icon\";s:22:\"fa fa-fw fa-building-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"15\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:141;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"163\";s:5:\"label\";s:12:\"sms_settings\";s:4:\"link\";s:27:\"admin/settings/sms_settings\";s:4:\"icon\";s:20:\"fa fa-fw fa-envelope\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2021-07-30 06:18:08\";s:6:\"status\";s:1:\"2\";}i:142;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"164\";s:5:\"label\";s:9:\"pos_sales\";s:4:\"link\";s:23:\"admin/invoice/pos_sales\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2021-10-16 00:53:10\";s:6:\"status\";s:1:\"1\";}i:143;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"186\";s:5:\"label\";s:9:\"warehouse\";s:4:\"link\";s:22:\"admin/warehouse/manage\";s:4:\"icon\";s:16:\"fa fa-building-o\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2021-10-18 09:24:24\";s:6:\"status\";s:1:\"1\";}i:144;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"187\";s:5:\"label\";s:12:\"transferItem\";s:4:\"link\";s:24:\"admin/items/transferItem\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2021-10-14 11:56:08\";s:6:\"status\";s:1:\"1\";}i:145;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"203\";s:5:\"label\";s:13:\"award_setting\";s:4:\"link\";s:20:\"admin/settings/award\";s:4:\"icon\";s:10:\"fa fa-star\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"30\";s:4:\"time\";s:19:\"2022-01-19 05:51:40\";s:6:\"status\";s:1:\"2\";}i:146;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"204\";s:5:\"label\";s:18:\"award_rule_setting\";s:4:\"link\";s:34:\"admin/settings/award_rule_settingh\";s:4:\"icon\";s:10:\"fa fa-star\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"31\";s:4:\"time\";s:19:\"2022-01-19 09:53:50\";s:6:\"status\";s:1:\"2\";}i:147;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"205\";s:5:\"label\";s:22:\"award_program_settings\";s:4:\"link\";s:37:\"admin/settings/award_program_settings\";s:4:\"icon\";s:9:\"fa fa-cog\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"32\";s:4:\"time\";s:19:\"2022-01-20 09:17:30\";s:6:\"status\";s:1:\"2\";}i:148;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"206\";s:5:\"label\";s:19:\"client_award_points\";s:4:\"link\";s:27:\"admin/invoice/client_awards\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2022-01-21 01:39:41\";s:6:\"status\";s:1:\"1\";}i:149;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"207\";s:5:\"label\";s:20:\"best_selling_product\";s:4:\"link\";s:18:\"admin/best_selling\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:2:\"11\";s:4:\"time\";s:19:\"2022-01-21 06:43:52\";s:6:\"status\";s:1:\"1\";}i:150;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"209\";s:5:\"label\";s:7:\"warning\";s:4:\"link\";s:13:\"admin/warning\";s:4:\"icon\";s:13:\"fa fa-warning\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2022-08-07 12:47:01\";s:6:\"status\";s:1:\"1\";}i:151;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"210\";s:5:\"label\";s:9:\"promotion\";s:4:\"link\";s:15:\"admin/promotion\";s:4:\"icon\";s:21:\"fa fa-arrow-circle-up\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2022-08-07 12:49:28\";s:6:\"status\";s:1:\"1\";}i:152;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"211\";s:5:\"label\";s:11:\"termination\";s:4:\"link\";s:17:\"admin/termination\";s:4:\"icon\";s:12:\"fa fa-eraser\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2022-08-07 12:50:45\";s:6:\"status\";s:1:\"1\";}i:153;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"212\";s:5:\"label\";s:11:\"resignation\";s:4:\"link\";s:17:\"admin/resignation\";s:4:\"icon\";s:14:\"fa fa-scissors\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2022-08-07 12:54:31\";s:6:\"status\";s:1:\"1\";}}');
INSERT INTO `tbl_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0900a908c3f18b70f1ec956633296f1c582e4467', '136.158.120.226', 1688563004, '__ci_last_regenerate|i:1688563004;menu_active_id|a:3:{i:0;s:3:\"120\";i:1;s:2:\"25\";i:2;s:1:\"0\";}user_name|s:5:\"nimda\";email|s:26:\"erick@blickcreative.com.au\";name|s:13:\"Erick Villeta\";photo|s:26:\"uploads/default_avatar.jpg\";user_id|s:1:\"5\";last_login|N;online_time|i:1688531159;loggedin|b:1;user_type|s:1:\"1\";user_flag|s:1:\"1\";direction|s:3:\"ltr\";warehouse_id|N;designations_id|s:1:\"0\";url|s:33:\"admin/dashboard/pinned_menu_items\";user_roll|a:154:{i:0;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"1\";s:5:\"label\";s:9:\"dashboard\";s:4:\"link\";s:15:\"admin/dashboard\";s:4:\"icon\";s:15:\"fa fa-dashboard\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-04-23 01:39:36\";s:6:\"status\";s:1:\"1\";}i:1;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"2\";s:5:\"label\";s:8:\"calendar\";s:4:\"link\";s:14:\"admin/calendar\";s:4:\"icon\";s:14:\"fa fa-calendar\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-23 19:57:23\";s:6:\"status\";s:1:\"1\";}i:2;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"4\";s:5:\"label\";s:6:\"client\";s:4:\"link\";s:26:\"admin/client/manage_client\";s:4:\"icon\";s:11:\"fa fa-users\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"13\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:3;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"5\";s:5:\"label\";s:7:\"mailbox\";s:4:\"link\";s:13:\"admin/mailbox\";s:4:\"icon\";s:16:\"fa fa-envelope-o\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:4;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"6\";s:5:\"label\";s:7:\"tickets\";s:4:\"link\";s:13:\"admin/tickets\";s:4:\"icon\";s:12:\"fa fa-ticket\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2018-06-08 13:39:39\";s:6:\"status\";s:1:\"1\";}i:5;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"12\";s:5:\"label\";s:5:\"sales\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:19:\"fa fa-shopping-cart\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"9\";s:4:\"time\";s:19:\"2017-06-10 14:02:58\";s:6:\"status\";s:1:\"1\";}i:6;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"13\";s:5:\"label\";s:7:\"invoice\";s:4:\"link\";s:28:\"admin/invoice/manage_invoice\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-04-23 19:57:23\";s:6:\"status\";s:1:\"1\";}i:7;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"14\";s:5:\"label\";s:9:\"estimates\";s:4:\"link\";s:15:\"admin/estimates\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-06-10 14:02:05\";s:6:\"status\";s:1:\"1\";}i:8;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"15\";s:5:\"label\";s:17:\"payments_received\";s:4:\"link\";s:26:\"admin/invoice/all_payments\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-23 19:57:24\";s:6:\"status\";s:1:\"1\";}i:9;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"16\";s:5:\"label\";s:9:\"tax_rates\";s:4:\"link\";s:23:\"admin/invoice/tax_rates\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-01-07 07:05:16\";s:6:\"status\";s:1:\"1\";}i:10;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"21\";s:5:\"label\";s:10:\"quotations\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:11:\"fa fa-paste\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:11;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"22\";s:5:\"label\";s:15:\"quotations_list\";s:4:\"link\";s:16:\"admin/quotations\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"21\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-05-18 16:49:03\";s:6:\"status\";s:1:\"1\";}i:12;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"23\";s:5:\"label\";s:15:\"quotations_form\";s:4:\"link\";s:32:\"admin/quotations/quotations_form\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"21\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:13;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"24\";s:5:\"label\";s:4:\"user\";s:4:\"link\";s:20:\"admin/user/user_list\";s:4:\"icon\";s:11:\"fa fa-users\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"25\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:14;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"25\";s:5:\"label\";s:8:\"settings\";s:4:\"link\";s:14:\"admin/settings\";s:4:\"icon\";s:10:\"fa fa-cogs\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"26\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:15;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"26\";s:5:\"label\";s:15:\"database_backup\";s:4:\"link\";s:30:\"admin/settings/database_backup\";s:4:\"icon\";s:14:\"fa fa-database\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"27\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:16;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"29\";s:5:\"label\";s:17:\"transactions_menu\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:16:\"fa fa-building-o\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"12\";s:4:\"time\";s:19:\"2018-05-13 12:27:58\";s:6:\"status\";s:1:\"1\";}i:17;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"30\";s:5:\"label\";s:7:\"deposit\";s:4:\"link\";s:26:\"admin/transactions/deposit\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-05-13 12:28:33\";s:6:\"status\";s:1:\"1\";}i:18;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"31\";s:5:\"label\";s:7:\"expense\";s:4:\"link\";s:26:\"admin/transactions/expense\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-05-13 12:28:37\";s:6:\"status\";s:1:\"1\";}i:19;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"32\";s:5:\"label\";s:8:\"transfer\";s:4:\"link\";s:27:\"admin/transactions/transfer\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-05-13 12:28:40\";s:6:\"status\";s:1:\"1\";}i:20;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"33\";s:5:\"label\";s:19:\"transactions_report\";s:4:\"link\";s:38:\"admin/transactions/transactions_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2018-05-13 12:28:44\";s:6:\"status\";s:1:\"1\";}i:21;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"34\";s:5:\"label\";s:13:\"balance_sheet\";s:4:\"link\";s:32:\"admin/transactions/balance_sheet\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-05-13 12:28:47\";s:6:\"status\";s:1:\"1\";}i:22;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"36\";s:5:\"label\";s:9:\"bank_cash\";s:4:\"link\";s:28:\"admin/account/manage_account\";s:4:\"icon\";s:11:\"fa fa-money\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2018-05-13 12:28:51\";s:6:\"status\";s:1:\"1\";}i:23;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"39\";s:5:\"label\";s:5:\"items\";s:4:\"link\";s:22:\"admin/items/items_list\";s:4:\"icon\";s:10:\"fa fa-cube\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2019-05-04 18:49:50\";s:6:\"status\";s:1:\"1\";}i:24;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"42\";s:5:\"label\";s:6:\"report\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:15:\"fa fa-bar-chart\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"24\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:25;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"43\";s:5:\"label\";s:17:\"account_statement\";s:4:\"link\";s:30:\"admin/report/account_statement\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:26;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"44\";s:5:\"label\";s:13:\"income_report\";s:4:\"link\";s:26:\"admin/report/income_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:27;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"45\";s:5:\"label\";s:14:\"expense_report\";s:4:\"link\";s:27:\"admin/report/expense_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:28;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"46\";s:5:\"label\";s:14:\"income_expense\";s:4:\"link\";s:27:\"admin/report/income_expense\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:29;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"47\";s:5:\"label\";s:16:\"date_wise_report\";s:4:\"link\";s:29:\"admin/report/date_wise_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:30;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"48\";s:5:\"label\";s:10:\"all_income\";s:4:\"link\";s:23:\"admin/report/all_income\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:31;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"49\";s:5:\"label\";s:11:\"all_expense\";s:4:\"link\";s:24:\"admin/report/all_expense\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:32;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"50\";s:5:\"label\";s:15:\"all_transaction\";s:4:\"link\";s:28:\"admin/report/all_transaction\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:33;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"51\";s:5:\"label\";s:17:\"recurring_invoice\";s:4:\"link\";s:31:\"admin/invoice/recurring_invoice\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-06-10 14:02:05\";s:6:\"status\";s:1:\"1\";}i:34;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"52\";s:5:\"label\";s:15:\"transfer_report\";s:4:\"link\";s:34:\"admin/transactions/transfer_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-05-13 12:28:59\";s:6:\"status\";s:1:\"1\";}i:35;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"53\";s:5:\"label\";s:15:\"report_by_month\";s:4:\"link\";s:28:\"admin/report/report_by_month\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:36;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"54\";s:5:\"label\";s:5:\"tasks\";s:4:\"link\";s:20:\"admin/tasks/all_task\";s:4:\"icon\";s:11:\"fa fa-tasks\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:37;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"55\";s:5:\"label\";s:5:\"leads\";s:4:\"link\";s:11:\"admin/leads\";s:4:\"icon\";s:12:\"fa fa-rocket\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:38;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"56\";s:5:\"label\";s:13:\"opportunities\";s:4:\"link\";s:19:\"admin/opportunities\";s:4:\"icon\";s:12:\"fa fa-filter\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:39;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"57\";s:5:\"label\";s:8:\"projects\";s:4:\"link\";s:14:\"admin/projects\";s:4:\"icon\";s:19:\"fa fa-folder-open-o\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:40;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"58\";s:5:\"label\";s:4:\"bugs\";s:4:\"link\";s:10:\"admin/bugs\";s:4:\"icon\";s:9:\"fa fa-bug\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:41;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"59\";s:5:\"label\";s:7:\"project\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:19:\"fa fa-folder-open-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:42;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"60\";s:5:\"label\";s:12:\"tasks_report\";s:4:\"link\";s:25:\"admin/report/tasks_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:43;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"61\";s:5:\"label\";s:11:\"bugs_report\";s:4:\"link\";s:24:\"admin/report/bugs_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:44;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"62\";s:5:\"label\";s:14:\"tickets_report\";s:4:\"link\";s:27:\"admin/report/tickets_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:45;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"63\";s:5:\"label\";s:13:\"client_report\";s:4:\"link\";s:26:\"admin/report/client_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2018-01-07 07:09:40\";s:6:\"status\";s:1:\"1\";}i:46;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"66\";s:5:\"label\";s:16:\"tasks_assignment\";s:4:\"link\";s:29:\"admin/report/tasks_assignment\";s:4:\"icon\";s:18:\"fa fa-dot-circle-o\";s:6:\"parent\";s:2:\"59\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:47;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"67\";s:5:\"label\";s:15:\"bugs_assignment\";s:4:\"link\";s:28:\"admin/report/bugs_assignment\";s:4:\"icon\";s:18:\"fa fa-dot-circle-o\";s:6:\"parent\";s:2:\"59\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:48;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"68\";s:5:\"label\";s:14:\"project_report\";s:4:\"link\";s:27:\"admin/report/project_report\";s:4:\"icon\";s:18:\"fa fa-dot-circle-o\";s:6:\"parent\";s:2:\"59\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:49;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"69\";s:5:\"label\";s:13:\"goal_tracking\";s:4:\"link\";s:19:\"admin/goal_tracking\";s:4:\"icon\";s:12:\"fa fa-shield\";s:6:\"parent\";s:2:\"73\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-06-10 14:05:47\";s:6:\"status\";s:1:\"1\";}i:50;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"70\";s:5:\"label\";s:11:\"departments\";s:4:\"link\";s:17:\"admin/departments\";s:4:\"icon\";s:17:\"fa fa-user-secret\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"14\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:51;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"71\";s:5:\"label\";s:7:\"holiday\";s:4:\"link\";s:13:\"admin/holiday\";s:4:\"icon\";s:21:\"fa fa-calendar-plus-o\";s:6:\"parent\";s:2:\"73\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-06-10 14:05:47\";s:6:\"status\";s:1:\"1\";}i:52;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"72\";s:5:\"label\";s:16:\"leave_management\";s:4:\"link\";s:22:\"admin/leave_management\";s:4:\"icon\";s:11:\"fa fa-plane\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"20\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:53;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"73\";s:5:\"label\";s:9:\"utilities\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:10:\"fa fa-gift\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"23\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:54;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"74\";s:5:\"label\";s:8:\"overtime\";s:4:\"link\";s:24:\"admin/utilities/overtime\";s:4:\"icon\";s:13:\"fa fa-clock-o\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"9\";s:4:\"time\";s:19:\"2017-06-10 14:04:23\";s:6:\"status\";s:1:\"1\";}i:55;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"75\";s:5:\"label\";s:12:\"office_stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:13:\"fa fa-codepen\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"15\";s:4:\"time\";s:19:\"2019-05-01 16:22:56\";s:6:\"status\";s:1:\"1\";}i:56;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"76\";s:5:\"label\";s:14:\"stock_category\";s:4:\"link\";s:26:\"admin/stock/stock_category\";s:4:\"icon\";s:13:\"fa fa-sliders\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:57;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"77\";s:5:\"label\";s:12:\"manage_stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:13:\"fa fa-archive\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-04-26 16:11:10\";s:6:\"status\";s:1:\"1\";}i:58;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"78\";s:5:\"label\";s:12:\"assign_stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:16:\"fa fa-align-left\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-26 16:11:10\";s:6:\"status\";s:1:\"1\";}i:59;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"79\";s:5:\"label\";s:12:\"stock_report\";s:4:\"link\";s:18:\"admin/stock/report\";s:4:\"icon\";s:16:\"fa fa-line-chart\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2017-04-25 18:48:25\";s:6:\"status\";s:1:\"1\";}i:60;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"81\";s:5:\"label\";s:10:\"stock_list\";s:4:\"link\";s:22:\"admin/stock/stock_list\";s:4:\"icon\";s:20:\"fa fa-stack-exchange\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-26 16:11:10\";s:6:\"status\";s:1:\"1\";}i:61;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"82\";s:5:\"label\";s:12:\"assign_stock\";s:4:\"link\";s:24:\"admin/stock/assign_stock\";s:4:\"icon\";s:16:\"fa fa-align-left\";s:6:\"parent\";s:2:\"78\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:62;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"83\";s:5:\"label\";s:19:\"assign_stock_report\";s:4:\"link\";s:31:\"admin/stock/assign_stock_report\";s:4:\"icon\";s:15:\"fa fa-bar-chart\";s:6:\"parent\";s:2:\"78\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:63;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"84\";s:5:\"label\";s:13:\"stock_history\";s:4:\"link\";s:25:\"admin/stock/stock_history\";s:4:\"icon\";s:17:\"fa fa-file-text-o\";s:6:\"parent\";s:2:\"77\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:64;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"85\";s:5:\"label\";s:11:\"performance\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:14:\"fa fa-dribbble\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"19\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:65;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"86\";s:5:\"label\";s:21:\"performance_indicator\";s:4:\"link\";s:39:\"admin/performance/performance_indicator\";s:4:\"icon\";s:12:\"fa fa-random\";s:6:\"parent\";s:2:\"85\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:66;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"87\";s:5:\"label\";s:18:\"performance_report\";s:4:\"link\";s:36:\"admin/performance/performance_report\";s:4:\"icon\";s:16:\"fa fa-calendar-o\";s:6:\"parent\";s:2:\"85\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:67;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"88\";s:5:\"label\";s:14:\"give_appraisal\";s:4:\"link\";s:44:\"admin/performance/give_performance_appraisal\";s:4:\"icon\";s:10:\"fa fa-plus\";s:6:\"parent\";s:2:\"85\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:68;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"89\";s:5:\"label\";s:7:\"payroll\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:9:\"fa fa-usd\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"18\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:69;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"90\";s:5:\"label\";s:21:\"manage_salary_details\";s:4:\"link\";s:35:\"admin/payroll/manage_salary_details\";s:4:\"icon\";s:9:\"fa fa-usd\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:70;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"91\";s:5:\"label\";s:20:\"employee_salary_list\";s:4:\"link\";s:34:\"admin/payroll/employee_salary_list\";s:4:\"icon\";s:17:\"fa fa-user-secret\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:71;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"92\";s:5:\"label\";s:12:\"make_payment\";s:4:\"link\";s:26:\"admin/payroll/make_payment\";s:4:\"icon\";s:11:\"fa fa-tasks\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:72;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"93\";s:5:\"label\";s:16:\"generate_payslip\";s:4:\"link\";s:30:\"admin/payroll/generate_payslip\";s:4:\"icon\";s:13:\"fa fa-list-ul\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:73;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"94\";s:5:\"label\";s:15:\"salary_template\";s:4:\"link\";s:29:\"admin/payroll/salary_template\";s:4:\"icon\";s:11:\"fa fa-money\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:74;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"95\";s:5:\"label\";s:11:\"hourly_rate\";s:4:\"link\";s:25:\"admin/payroll/hourly_rate\";s:4:\"icon\";s:13:\"fa fa-clock-o\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:75;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"96\";s:5:\"label\";s:15:\"payroll_summary\";s:4:\"link\";s:29:\"admin/payroll/payroll_summary\";s:4:\"icon\";s:18:\"fa fa-camera-retro\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:76;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"97\";s:5:\"label\";s:14:\"provident_fund\";s:4:\"link\";s:28:\"admin/payroll/provident_fund\";s:4:\"icon\";s:15:\"fa fa-briefcase\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2017-06-10 14:04:23\";s:6:\"status\";s:1:\"1\";}i:77;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"98\";s:5:\"label\";s:14:\"advance_salary\";s:4:\"link\";s:28:\"admin/payroll/advance_salary\";s:4:\"icon\";s:19:\"fa fa-cc-mastercard\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2017-06-10 14:04:23\";s:6:\"status\";s:1:\"1\";}i:78;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"99\";s:5:\"label\";s:14:\"employee_award\";s:4:\"link\";s:11:\"admin/award\";s:4:\"icon\";s:12:\"fa fa-trophy\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2017-06-10 14:05:47\";s:6:\"status\";s:1:\"1\";}i:79;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"100\";s:5:\"label\";s:13:\"announcements\";s:4:\"link\";s:19:\"admin/announcements\";s:4:\"icon\";s:19:\"fa fa-bullhorn icon\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"22\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:80;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"101\";s:5:\"label\";s:8:\"training\";s:4:\"link\";s:14:\"admin/training\";s:4:\"icon\";s:14:\"fa fa-suitcase\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"21\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:81;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"102\";s:5:\"label\";s:12:\"job_circular\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:11:\"fa fa-globe\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"17\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:82;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"103\";s:5:\"label\";s:11:\"jobs_posted\";s:4:\"link\";s:30:\"admin/job_circular/jobs_posted\";s:4:\"icon\";s:12:\"fa fa-ticket\";s:6:\"parent\";s:3:\"102\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:83;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"104\";s:5:\"label\";s:17:\"jobs_applications\";s:4:\"link\";s:36:\"admin/job_circular/jobs_applications\";s:4:\"icon\";s:13:\"fa fa-compass\";s:6:\"parent\";s:3:\"102\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:84;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"105\";s:5:\"label\";s:10:\"attendance\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:15:\"fa fa-file-text\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"16\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:85;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"106\";s:5:\"label\";s:18:\"timechange_request\";s:4:\"link\";s:35:\"admin/attendance/timechange_request\";s:4:\"icon\";s:16:\"fa fa-calendar-o\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:86;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"107\";s:5:\"label\";s:17:\"attendance_report\";s:4:\"link\";s:34:\"admin/attendance/attendance_report\";s:4:\"icon\";s:15:\"fa fa-file-text\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:87;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"108\";s:5:\"label\";s:12:\"time_history\";s:4:\"link\";s:29:\"admin/attendance/time_history\";s:4:\"icon\";s:13:\"fa fa-clock-o\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:88;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"109\";s:5:\"label\";s:9:\"pull-down\";s:4:\"link\";s:0:\"\";s:4:\"icon\";s:0:\"\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-31 12:43:20\";s:6:\"status\";s:1:\"0\";}i:89;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"110\";s:5:\"label\";s:11:\"filemanager\";s:4:\"link\";s:17:\"admin/filemanager\";s:4:\"icon\";s:10:\"fa fa-file\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:90;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"111\";s:5:\"label\";s:15:\"company_details\";s:4:\"link\";s:14:\"admin/settings\";s:4:\"icon\";s:23:\"fa fa-fw fa-info-circle\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-25 17:08:46\";s:6:\"status\";s:1:\"2\";}i:91;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"112\";s:5:\"label\";s:15:\"system_settings\";s:4:\"link\";s:21:\"admin/settings/system\";s:4:\"icon\";s:19:\"fa fa-fw fa-desktop\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-04-25 17:08:46\";s:6:\"status\";s:1:\"2\";}i:92;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"113\";s:5:\"label\";s:14:\"email_settings\";s:4:\"link\";s:20:\"admin/settings/email\";s:4:\"icon\";s:20:\"fa fa-fw fa-envelope\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-25 17:08:46\";s:6:\"status\";s:1:\"2\";}i:93;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"114\";s:5:\"label\";s:15:\"email_templates\";s:4:\"link\";s:24:\"admin/settings/templates\";s:4:\"icon\";s:25:\"fa fa-fw fa-pencil-square\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2021-07-30 06:18:08\";s:6:\"status\";s:1:\"2\";}i:94;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"115\";s:5:\"label\";s:17:\"email_integration\";s:4:\"link\";s:32:\"admin/settings/email_integration\";s:4:\"icon\";s:22:\"fa fa-fw fa-envelope-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2021-07-30 06:18:08\";s:6:\"status\";s:1:\"2\";}i:95;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"116\";s:5:\"label\";s:16:\"payment_settings\";s:4:\"link\";s:23:\"admin/settings/payments\";s:4:\"icon\";s:18:\"fa fa-fw fa-dollar\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:96;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"117\";s:5:\"label\";s:16:\"invoice_settings\";s:4:\"link\";s:22:\"admin/settings/invoice\";s:4:\"icon\";s:17:\"fa fa-fw fa-money\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:97;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"118\";s:5:\"label\";s:17:\"estimate_settings\";s:4:\"link\";s:23:\"admin/settings/estimate\";s:4:\"icon\";s:18:\"fa fa-fw fa-file-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:98;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"119\";s:5:\"label\";s:22:\"tickets_leads_settings\";s:4:\"link\";s:22:\"admin/settings/tickets\";s:4:\"icon\";s:18:\"fa fa-fw fa-ticket\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"14\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:99;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"120\";s:5:\"label\";s:14:\"theme_settings\";s:4:\"link\";s:20:\"admin/settings/theme\";s:4:\"icon\";s:16:\"fa fa-fw fa-code\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"20\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:100;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"121\";s:5:\"label\";s:12:\"working_days\";s:4:\"link\";s:27:\"admin/settings/working_days\";s:4:\"icon\";s:20:\"fa fa-fw fa-calendar\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"22\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:101;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"122\";s:5:\"label\";s:14:\"leave_category\";s:4:\"link\";s:29:\"admin/settings/leave_category\";s:4:\"icon\";s:21:\"fa fa-fw fa-pagelines\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"23\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:102;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"123\";s:5:\"label\";s:15:\"income_category\";s:4:\"link\";s:30:\"admin/settings/income_category\";s:4:\"icon\";s:23:\"fa fa-fw fa-certificate\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"24\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:103;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"124\";s:5:\"label\";s:16:\"expense_category\";s:4:\"link\";s:31:\"admin/settings/expense_category\";s:4:\"icon\";s:17:\"fa fa-fw fa-tasks\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"25\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:104;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"125\";s:5:\"label\";s:14:\"customer_group\";s:4:\"link\";s:29:\"admin/settings/customer_group\";s:4:\"icon\";s:17:\"fa fa-fw fa-users\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"26\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:105;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"127\";s:5:\"label\";s:11:\"lead_status\";s:4:\"link\";s:26:\"admin/settings/lead_status\";s:4:\"icon\";s:19:\"fa fa-fw fa-list-ul\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"16\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:106;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"128\";s:5:\"label\";s:11:\"lead_source\";s:4:\"link\";s:26:\"admin/settings/lead_source\";s:4:\"icon\";s:22:\"fa fa-fw fa-arrow-down\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"17\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:107;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"129\";s:5:\"label\";s:26:\"opportunities_state_reason\";s:4:\"link\";s:41:\"admin/settings/opportunities_state_reason\";s:4:\"icon\";s:24:\"fa fa-fw fa-dot-circle-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"19\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:108;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"130\";s:5:\"label\";s:12:\"custom_field\";s:4:\"link\";s:27:\"admin/settings/custom_field\";s:4:\"icon\";s:18:\"fa fa-fw fa-star-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"28\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:109;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"131\";s:5:\"label\";s:14:\"payment_method\";s:4:\"link\";s:29:\"admin/settings/payment_method\";s:4:\"icon\";s:17:\"fa fa-fw fa-money\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"29\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:110;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"132\";s:5:\"label\";s:7:\"cronjob\";s:4:\"link\";s:22:\"admin/settings/cronjob\";s:4:\"icon\";s:18:\"fa fa-fw fa-contao\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"31\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:111;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"133\";s:5:\"label\";s:15:\"menu_allocation\";s:4:\"link\";s:30:\"admin/settings/menu_allocation\";s:4:\"icon\";s:22:\"fa fa-fw fa fa-compass\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"32\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:112;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"134\";s:5:\"label\";s:12:\"notification\";s:4:\"link\";s:27:\"admin/settings/notification\";s:4:\"icon\";s:18:\"fa fa-fw fa-bell-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"33\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:113;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"135\";s:5:\"label\";s:18:\"email_notification\";s:4:\"link\";s:33:\"admin/settings/email_notification\";s:4:\"icon\";s:18:\"fa fa-fw fa-bell-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"34\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:114;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"136\";s:5:\"label\";s:15:\"database_backup\";s:4:\"link\";s:30:\"admin/settings/database_backup\";s:4:\"icon\";s:20:\"fa fa-fw fa-database\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"35\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:115;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"137\";s:5:\"label\";s:12:\"translations\";s:4:\"link\";s:27:\"admin/settings/translations\";s:4:\"icon\";s:20:\"fa fa-fw fa-language\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"36\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:116;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"138\";s:5:\"label\";s:13:\"system_update\";s:4:\"link\";s:28:\"admin/settings/system_update\";s:4:\"icon\";s:27:\"fa fa-fw fa-pencil-square-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"37\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:117;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"139\";s:5:\"label\";s:12:\"private_chat\";s:4:\"link\";s:18:\"chat/conversations\";s:4:\"icon\";s:14:\"fa fa-envelope\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"28\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:118;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"140\";s:5:\"label\";s:9:\"proposals\";s:4:\"link\";s:15:\"admin/proposals\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-01-07 07:05:16\";s:6:\"status\";s:1:\"1\";}i:119;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"141\";s:5:\"label\";s:13:\"knowledgebase\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:21:\"fa fa-question-circle\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"11\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:120;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"142\";s:5:\"label\";s:10:\"categories\";s:4:\"link\";s:30:\"admin/knowledgebase/categories\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"141\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:121;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"143\";s:5:\"label\";s:8:\"articles\";s:4:\"link\";s:28:\"admin/knowledgebase/articles\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"141\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:122;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"144\";s:5:\"label\";s:13:\"knowledgebase\";s:4:\"link\";s:19:\"admin/knowledgebase\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"141\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:123;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"145\";s:5:\"label\";s:18:\"dashboard_settings\";s:4:\"link\";s:24:\"admin/settings/dashboard\";s:4:\"icon\";s:21:\"fa fa-fw fa-dashboard\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"21\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:124;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"146\";s:5:\"label\";s:20:\"transactions_reports\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:16:\"fa fa-building-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-05-13 12:29:51\";s:6:\"status\";s:1:\"1\";}i:125;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"147\";s:5:\"label\";s:5:\"sales\";s:4:\"link\";s:25:\"admin/report/sales_report\";s:4:\"icon\";s:19:\"fa fa-shopping-cart\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-01-07 01:12:23\";s:6:\"status\";s:1:\"1\";}i:126;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"148\";s:5:\"label\";s:15:\"mark_attendance\";s:4:\"link\";s:21:\"admin/mark_attendance\";s:4:\"icon\";s:15:\"fa fa-file-text\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-03-07 06:45:25\";s:6:\"status\";s:1:\"1\";}i:127;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"149\";s:5:\"label\";s:10:\"allowed_ip\";s:4:\"link\";s:25:\"admin/settings/allowed_ip\";s:4:\"icon\";s:12:\"fa fa-server\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"27\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:128;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"150\";s:5:\"label\";s:5:\"stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:11:\"icon-layers\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2019-05-01 18:10:52\";s:6:\"status\";s:1:\"1\";}i:129;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"151\";s:5:\"label\";s:8:\"supplier\";s:4:\"link\";s:14:\"admin/supplier\";s:4:\"icon\";s:14:\"icon-briefcase\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2019-05-01 18:10:52\";s:6:\"status\";s:1:\"1\";}i:130;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"152\";s:5:\"label\";s:8:\"purchase\";s:4:\"link\";s:14:\"admin/purchase\";s:4:\"icon\";s:12:\"icon-handbag\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2019-05-01 18:10:52\";s:6:\"status\";s:1:\"1\";}i:131;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"153\";s:5:\"label\";s:12:\"return_stock\";s:4:\"link\";s:18:\"admin/return_stock\";s:4:\"icon\";s:14:\"icon-share-alt\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2019-05-05 16:19:30\";s:6:\"status\";s:1:\"1\";}i:132;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"154\";s:5:\"label\";s:16:\"purchase_payment\";s:4:\"link\";s:27:\"admin/purchase/all_payments\";s:4:\"icon\";s:16:\"icon-credit-card\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2019-05-05 13:53:11\";s:6:\"status\";s:1:\"1\";}i:133;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"155\";s:5:\"label\";s:17:\"purchase_settings\";s:4:\"link\";s:23:\"admin/settings/purchase\";s:4:\"icon\";s:18:\"fa-fw icon-handbag\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"12\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:134;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"156\";s:5:\"label\";s:11:\"credit_note\";s:4:\"link\";s:17:\"admin/credit_note\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-06-10 02:32:05\";s:6:\"status\";s:1:\"1\";}i:135;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"157\";s:5:\"label\";s:20:\"credit_note_settings\";s:4:\"link\";s:26:\"admin/settings/credit_note\";s:4:\"icon\";s:17:\"fa fa-fw fa-money\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"9\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:136;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"158\";s:5:\"label\";s:18:\"proposals_settings\";s:4:\"link\";s:24:\"admin/settings/proposals\";s:4:\"icon\";s:16:\"fa fa-fw fa-leaf\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"11\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:137;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"159\";s:5:\"label\";s:17:\"projects_settings\";s:4:\"link\";s:23:\"admin/settings/projects\";s:4:\"icon\";s:25:\"fa fa-fw fa-folder-open-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"13\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:138;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"160\";s:5:\"label\";s:4:\"tags\";s:4:\"link\";s:19:\"admin/settings/tags\";s:4:\"icon\";s:16:\"fa fa-fw fa-tags\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"30\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:139;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"161\";s:5:\"label\";s:9:\"lead_form\";s:4:\"link\";s:25:\"admin/leads/all_lead_form\";s:4:\"icon\";s:18:\"fa fa-fw fa-rocket\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"18\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:140;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"162\";s:5:\"label\";s:21:\"transactions_settings\";s:4:\"link\";s:27:\"admin/settings/transactions\";s:4:\"icon\";s:22:\"fa fa-fw fa-building-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"15\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:141;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"163\";s:5:\"label\";s:12:\"sms_settings\";s:4:\"link\";s:27:\"admin/settings/sms_settings\";s:4:\"icon\";s:20:\"fa fa-fw fa-envelope\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2021-07-30 06:18:08\";s:6:\"status\";s:1:\"2\";}i:142;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"164\";s:5:\"label\";s:9:\"pos_sales\";s:4:\"link\";s:23:\"admin/invoice/pos_sales\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2021-10-16 00:53:10\";s:6:\"status\";s:1:\"1\";}i:143;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"186\";s:5:\"label\";s:9:\"warehouse\";s:4:\"link\";s:22:\"admin/warehouse/manage\";s:4:\"icon\";s:16:\"fa fa-building-o\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2021-10-18 09:24:24\";s:6:\"status\";s:1:\"1\";}i:144;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"187\";s:5:\"label\";s:12:\"transferItem\";s:4:\"link\";s:24:\"admin/items/transferItem\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2021-10-14 11:56:08\";s:6:\"status\";s:1:\"1\";}i:145;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"203\";s:5:\"label\";s:13:\"award_setting\";s:4:\"link\";s:20:\"admin/settings/award\";s:4:\"icon\";s:10:\"fa fa-star\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"30\";s:4:\"time\";s:19:\"2022-01-19 05:51:40\";s:6:\"status\";s:1:\"2\";}i:146;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"204\";s:5:\"label\";s:18:\"award_rule_setting\";s:4:\"link\";s:34:\"admin/settings/award_rule_settingh\";s:4:\"icon\";s:10:\"fa fa-star\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"31\";s:4:\"time\";s:19:\"2022-01-19 09:53:50\";s:6:\"status\";s:1:\"2\";}i:147;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"205\";s:5:\"label\";s:22:\"award_program_settings\";s:4:\"link\";s:37:\"admin/settings/award_program_settings\";s:4:\"icon\";s:9:\"fa fa-cog\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"32\";s:4:\"time\";s:19:\"2022-01-20 09:17:30\";s:6:\"status\";s:1:\"2\";}i:148;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"206\";s:5:\"label\";s:19:\"client_award_points\";s:4:\"link\";s:27:\"admin/invoice/client_awards\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2022-01-21 01:39:41\";s:6:\"status\";s:1:\"1\";}i:149;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"207\";s:5:\"label\";s:20:\"best_selling_product\";s:4:\"link\";s:18:\"admin/best_selling\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:2:\"11\";s:4:\"time\";s:19:\"2022-01-21 06:43:52\";s:6:\"status\";s:1:\"1\";}i:150;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"209\";s:5:\"label\";s:7:\"warning\";s:4:\"link\";s:13:\"admin/warning\";s:4:\"icon\";s:13:\"fa fa-warning\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2022-08-07 12:47:01\";s:6:\"status\";s:1:\"1\";}i:151;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"210\";s:5:\"label\";s:9:\"promotion\";s:4:\"link\";s:15:\"admin/promotion\";s:4:\"icon\";s:21:\"fa fa-arrow-circle-up\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2022-08-07 12:49:28\";s:6:\"status\";s:1:\"1\";}i:152;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"211\";s:5:\"label\";s:11:\"termination\";s:4:\"link\";s:17:\"admin/termination\";s:4:\"icon\";s:12:\"fa fa-eraser\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2022-08-07 12:50:45\";s:6:\"status\";s:1:\"1\";}i:153;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"212\";s:5:\"label\";s:11:\"resignation\";s:4:\"link\";s:17:\"admin/resignation\";s:4:\"icon\";s:14:\"fa fa-scissors\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2022-08-07 12:54:31\";s:6:\"status\";s:1:\"1\";}}');
INSERT INTO `tbl_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0912cd364775efa4cd248786d1034a45379b8607', '203.217.28.133', 1689139014, '__ci_last_regenerate|i:1689138996;menu_active_id|a:2:{i:0;s:1:\"1\";i:1;s:1:\"0\";}user_name|s:4:\"mark\";email|s:25:\"mark@blickcreative.com.au\";name|s:13:\"Mark Schiffer\";photo|s:26:\"uploads/default_avatar.jpg\";user_id|s:1:\"6\";last_login|N;online_time|i:1689139012;loggedin|b:1;user_type|s:1:\"3\";user_flag|s:1:\"3\";direction|s:3:\"ltr\";warehouse_id|s:1:\"0\";designations_id|s:1:\"1\";url|s:33:\"admin/dashboard/recent_activities\";user_roll|a:154:{i:0;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"1\";s:5:\"label\";s:9:\"dashboard\";s:4:\"link\";s:15:\"admin/dashboard\";s:4:\"icon\";s:15:\"fa fa-dashboard\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-04-23 01:39:36\";s:6:\"status\";s:1:\"1\";}i:1;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"2\";s:5:\"label\";s:8:\"calendar\";s:4:\"link\";s:14:\"admin/calendar\";s:4:\"icon\";s:14:\"fa fa-calendar\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-23 19:57:23\";s:6:\"status\";s:1:\"1\";}i:2;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"4\";s:5:\"label\";s:6:\"client\";s:4:\"link\";s:26:\"admin/client/manage_client\";s:4:\"icon\";s:11:\"fa fa-users\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"13\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:3;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"5\";s:5:\"label\";s:7:\"mailbox\";s:4:\"link\";s:13:\"admin/mailbox\";s:4:\"icon\";s:16:\"fa fa-envelope-o\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:4;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"6\";s:5:\"label\";s:7:\"tickets\";s:4:\"link\";s:13:\"admin/tickets\";s:4:\"icon\";s:12:\"fa fa-ticket\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2018-06-08 13:39:39\";s:6:\"status\";s:1:\"1\";}i:5;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"12\";s:5:\"label\";s:5:\"sales\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:19:\"fa fa-shopping-cart\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"9\";s:4:\"time\";s:19:\"2017-06-10 14:02:58\";s:6:\"status\";s:1:\"1\";}i:6;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"13\";s:5:\"label\";s:7:\"invoice\";s:4:\"link\";s:28:\"admin/invoice/manage_invoice\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-04-23 19:57:23\";s:6:\"status\";s:1:\"1\";}i:7;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"14\";s:5:\"label\";s:9:\"estimates\";s:4:\"link\";s:15:\"admin/estimates\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-06-10 14:02:05\";s:6:\"status\";s:1:\"1\";}i:8;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"15\";s:5:\"label\";s:17:\"payments_received\";s:4:\"link\";s:26:\"admin/invoice/all_payments\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-23 19:57:24\";s:6:\"status\";s:1:\"1\";}i:9;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"16\";s:5:\"label\";s:9:\"tax_rates\";s:4:\"link\";s:23:\"admin/invoice/tax_rates\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-01-07 07:05:16\";s:6:\"status\";s:1:\"1\";}i:10;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"21\";s:5:\"label\";s:10:\"quotations\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:11:\"fa fa-paste\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:11;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"22\";s:5:\"label\";s:15:\"quotations_list\";s:4:\"link\";s:16:\"admin/quotations\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"21\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-05-18 16:49:03\";s:6:\"status\";s:1:\"1\";}i:12;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"23\";s:5:\"label\";s:15:\"quotations_form\";s:4:\"link\";s:32:\"admin/quotations/quotations_form\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"21\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:13;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"24\";s:5:\"label\";s:4:\"user\";s:4:\"link\";s:20:\"admin/user/user_list\";s:4:\"icon\";s:11:\"fa fa-users\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"25\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:14;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"25\";s:5:\"label\";s:8:\"settings\";s:4:\"link\";s:14:\"admin/settings\";s:4:\"icon\";s:10:\"fa fa-cogs\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"26\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:15;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"26\";s:5:\"label\";s:15:\"database_backup\";s:4:\"link\";s:30:\"admin/settings/database_backup\";s:4:\"icon\";s:14:\"fa fa-database\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"27\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:16;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"29\";s:5:\"label\";s:17:\"transactions_menu\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:16:\"fa fa-building-o\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"12\";s:4:\"time\";s:19:\"2018-05-13 12:27:58\";s:6:\"status\";s:1:\"1\";}i:17;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"30\";s:5:\"label\";s:7:\"deposit\";s:4:\"link\";s:26:\"admin/transactions/deposit\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-05-13 12:28:33\";s:6:\"status\";s:1:\"1\";}i:18;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"31\";s:5:\"label\";s:7:\"expense\";s:4:\"link\";s:26:\"admin/transactions/expense\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-05-13 12:28:37\";s:6:\"status\";s:1:\"1\";}i:19;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"32\";s:5:\"label\";s:8:\"transfer\";s:4:\"link\";s:27:\"admin/transactions/transfer\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-05-13 12:28:40\";s:6:\"status\";s:1:\"1\";}i:20;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"33\";s:5:\"label\";s:19:\"transactions_report\";s:4:\"link\";s:38:\"admin/transactions/transactions_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2018-05-13 12:28:44\";s:6:\"status\";s:1:\"1\";}i:21;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"34\";s:5:\"label\";s:13:\"balance_sheet\";s:4:\"link\";s:32:\"admin/transactions/balance_sheet\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-05-13 12:28:47\";s:6:\"status\";s:1:\"1\";}i:22;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"36\";s:5:\"label\";s:9:\"bank_cash\";s:4:\"link\";s:28:\"admin/account/manage_account\";s:4:\"icon\";s:11:\"fa fa-money\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2018-05-13 12:28:51\";s:6:\"status\";s:1:\"1\";}i:23;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"39\";s:5:\"label\";s:5:\"items\";s:4:\"link\";s:22:\"admin/items/items_list\";s:4:\"icon\";s:10:\"fa fa-cube\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2019-05-04 18:49:50\";s:6:\"status\";s:1:\"1\";}i:24;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"42\";s:5:\"label\";s:6:\"report\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:15:\"fa fa-bar-chart\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"24\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:25;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"43\";s:5:\"label\";s:17:\"account_statement\";s:4:\"link\";s:30:\"admin/report/account_statement\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:26;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"44\";s:5:\"label\";s:13:\"income_report\";s:4:\"link\";s:26:\"admin/report/income_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:27;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"45\";s:5:\"label\";s:14:\"expense_report\";s:4:\"link\";s:27:\"admin/report/expense_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:28;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"46\";s:5:\"label\";s:14:\"income_expense\";s:4:\"link\";s:27:\"admin/report/income_expense\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:29;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"47\";s:5:\"label\";s:16:\"date_wise_report\";s:4:\"link\";s:29:\"admin/report/date_wise_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:30;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"48\";s:5:\"label\";s:10:\"all_income\";s:4:\"link\";s:23:\"admin/report/all_income\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:31;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"49\";s:5:\"label\";s:11:\"all_expense\";s:4:\"link\";s:24:\"admin/report/all_expense\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:32;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"50\";s:5:\"label\";s:15:\"all_transaction\";s:4:\"link\";s:28:\"admin/report/all_transaction\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:33;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"51\";s:5:\"label\";s:17:\"recurring_invoice\";s:4:\"link\";s:31:\"admin/invoice/recurring_invoice\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-06-10 14:02:05\";s:6:\"status\";s:1:\"1\";}i:34;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"52\";s:5:\"label\";s:15:\"transfer_report\";s:4:\"link\";s:34:\"admin/transactions/transfer_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-05-13 12:28:59\";s:6:\"status\";s:1:\"1\";}i:35;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"53\";s:5:\"label\";s:15:\"report_by_month\";s:4:\"link\";s:28:\"admin/report/report_by_month\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:36;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"54\";s:5:\"label\";s:5:\"tasks\";s:4:\"link\";s:20:\"admin/tasks/all_task\";s:4:\"icon\";s:11:\"fa fa-tasks\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:37;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"55\";s:5:\"label\";s:5:\"leads\";s:4:\"link\";s:11:\"admin/leads\";s:4:\"icon\";s:12:\"fa fa-rocket\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:38;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"56\";s:5:\"label\";s:13:\"opportunities\";s:4:\"link\";s:19:\"admin/opportunities\";s:4:\"icon\";s:12:\"fa fa-filter\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:39;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"57\";s:5:\"label\";s:8:\"projects\";s:4:\"link\";s:14:\"admin/projects\";s:4:\"icon\";s:19:\"fa fa-folder-open-o\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:40;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"58\";s:5:\"label\";s:4:\"bugs\";s:4:\"link\";s:10:\"admin/bugs\";s:4:\"icon\";s:9:\"fa fa-bug\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:41;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"59\";s:5:\"label\";s:7:\"project\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:19:\"fa fa-folder-open-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:42;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"60\";s:5:\"label\";s:12:\"tasks_report\";s:4:\"link\";s:25:\"admin/report/tasks_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:43;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"61\";s:5:\"label\";s:11:\"bugs_report\";s:4:\"link\";s:24:\"admin/report/bugs_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:44;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"62\";s:5:\"label\";s:14:\"tickets_report\";s:4:\"link\";s:27:\"admin/report/tickets_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:45;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"63\";s:5:\"label\";s:13:\"client_report\";s:4:\"link\";s:26:\"admin/report/client_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2018-01-07 07:09:40\";s:6:\"status\";s:1:\"1\";}i:46;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"66\";s:5:\"label\";s:16:\"tasks_assignment\";s:4:\"link\";s:29:\"admin/report/tasks_assignment\";s:4:\"icon\";s:18:\"fa fa-dot-circle-o\";s:6:\"parent\";s:2:\"59\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:47;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"67\";s:5:\"label\";s:15:\"bugs_assignment\";s:4:\"link\";s:28:\"admin/report/bugs_assignment\";s:4:\"icon\";s:18:\"fa fa-dot-circle-o\";s:6:\"parent\";s:2:\"59\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:48;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"68\";s:5:\"label\";s:14:\"project_report\";s:4:\"link\";s:27:\"admin/report/project_report\";s:4:\"icon\";s:18:\"fa fa-dot-circle-o\";s:6:\"parent\";s:2:\"59\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:49;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"69\";s:5:\"label\";s:13:\"goal_tracking\";s:4:\"link\";s:19:\"admin/goal_tracking\";s:4:\"icon\";s:12:\"fa fa-shield\";s:6:\"parent\";s:2:\"73\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-06-10 14:05:47\";s:6:\"status\";s:1:\"1\";}i:50;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"70\";s:5:\"label\";s:11:\"departments\";s:4:\"link\";s:17:\"admin/departments\";s:4:\"icon\";s:17:\"fa fa-user-secret\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"14\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:51;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"71\";s:5:\"label\";s:7:\"holiday\";s:4:\"link\";s:13:\"admin/holiday\";s:4:\"icon\";s:21:\"fa fa-calendar-plus-o\";s:6:\"parent\";s:2:\"73\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-06-10 14:05:47\";s:6:\"status\";s:1:\"1\";}i:52;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"72\";s:5:\"label\";s:16:\"leave_management\";s:4:\"link\";s:22:\"admin/leave_management\";s:4:\"icon\";s:11:\"fa fa-plane\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"20\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:53;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"73\";s:5:\"label\";s:9:\"utilities\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:10:\"fa fa-gift\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"23\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:54;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"74\";s:5:\"label\";s:8:\"overtime\";s:4:\"link\";s:24:\"admin/utilities/overtime\";s:4:\"icon\";s:13:\"fa fa-clock-o\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"9\";s:4:\"time\";s:19:\"2017-06-10 14:04:23\";s:6:\"status\";s:1:\"1\";}i:55;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"75\";s:5:\"label\";s:12:\"office_stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:13:\"fa fa-codepen\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"15\";s:4:\"time\";s:19:\"2019-05-01 16:22:56\";s:6:\"status\";s:1:\"1\";}i:56;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"76\";s:5:\"label\";s:14:\"stock_category\";s:4:\"link\";s:26:\"admin/stock/stock_category\";s:4:\"icon\";s:13:\"fa fa-sliders\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:57;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"77\";s:5:\"label\";s:12:\"manage_stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:13:\"fa fa-archive\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-04-26 16:11:10\";s:6:\"status\";s:1:\"1\";}i:58;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"78\";s:5:\"label\";s:12:\"assign_stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:16:\"fa fa-align-left\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-26 16:11:10\";s:6:\"status\";s:1:\"1\";}i:59;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"79\";s:5:\"label\";s:12:\"stock_report\";s:4:\"link\";s:18:\"admin/stock/report\";s:4:\"icon\";s:16:\"fa fa-line-chart\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2017-04-25 18:48:25\";s:6:\"status\";s:1:\"1\";}i:60;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"81\";s:5:\"label\";s:10:\"stock_list\";s:4:\"link\";s:22:\"admin/stock/stock_list\";s:4:\"icon\";s:20:\"fa fa-stack-exchange\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-26 16:11:10\";s:6:\"status\";s:1:\"1\";}i:61;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"82\";s:5:\"label\";s:12:\"assign_stock\";s:4:\"link\";s:24:\"admin/stock/assign_stock\";s:4:\"icon\";s:16:\"fa fa-align-left\";s:6:\"parent\";s:2:\"78\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:62;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"83\";s:5:\"label\";s:19:\"assign_stock_report\";s:4:\"link\";s:31:\"admin/stock/assign_stock_report\";s:4:\"icon\";s:15:\"fa fa-bar-chart\";s:6:\"parent\";s:2:\"78\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:63;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"84\";s:5:\"label\";s:13:\"stock_history\";s:4:\"link\";s:25:\"admin/stock/stock_history\";s:4:\"icon\";s:17:\"fa fa-file-text-o\";s:6:\"parent\";s:2:\"77\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:64;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"85\";s:5:\"label\";s:11:\"performance\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:14:\"fa fa-dribbble\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"19\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:65;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"86\";s:5:\"label\";s:21:\"performance_indicator\";s:4:\"link\";s:39:\"admin/performance/performance_indicator\";s:4:\"icon\";s:12:\"fa fa-random\";s:6:\"parent\";s:2:\"85\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:66;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"87\";s:5:\"label\";s:18:\"performance_report\";s:4:\"link\";s:36:\"admin/performance/performance_report\";s:4:\"icon\";s:16:\"fa fa-calendar-o\";s:6:\"parent\";s:2:\"85\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:67;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"88\";s:5:\"label\";s:14:\"give_appraisal\";s:4:\"link\";s:44:\"admin/performance/give_performance_appraisal\";s:4:\"icon\";s:10:\"fa fa-plus\";s:6:\"parent\";s:2:\"85\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:68;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"89\";s:5:\"label\";s:7:\"payroll\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:9:\"fa fa-usd\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"18\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:69;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"90\";s:5:\"label\";s:21:\"manage_salary_details\";s:4:\"link\";s:35:\"admin/payroll/manage_salary_details\";s:4:\"icon\";s:9:\"fa fa-usd\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:70;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"91\";s:5:\"label\";s:20:\"employee_salary_list\";s:4:\"link\";s:34:\"admin/payroll/employee_salary_list\";s:4:\"icon\";s:17:\"fa fa-user-secret\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:71;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"92\";s:5:\"label\";s:12:\"make_payment\";s:4:\"link\";s:26:\"admin/payroll/make_payment\";s:4:\"icon\";s:11:\"fa fa-tasks\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:72;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"93\";s:5:\"label\";s:16:\"generate_payslip\";s:4:\"link\";s:30:\"admin/payroll/generate_payslip\";s:4:\"icon\";s:13:\"fa fa-list-ul\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:73;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"94\";s:5:\"label\";s:15:\"salary_template\";s:4:\"link\";s:29:\"admin/payroll/salary_template\";s:4:\"icon\";s:11:\"fa fa-money\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:74;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"95\";s:5:\"label\";s:11:\"hourly_rate\";s:4:\"link\";s:25:\"admin/payroll/hourly_rate\";s:4:\"icon\";s:13:\"fa fa-clock-o\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:75;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"96\";s:5:\"label\";s:15:\"payroll_summary\";s:4:\"link\";s:29:\"admin/payroll/payroll_summary\";s:4:\"icon\";s:18:\"fa fa-camera-retro\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:76;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"97\";s:5:\"label\";s:14:\"provident_fund\";s:4:\"link\";s:28:\"admin/payroll/provident_fund\";s:4:\"icon\";s:15:\"fa fa-briefcase\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2017-06-10 14:04:23\";s:6:\"status\";s:1:\"1\";}i:77;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"98\";s:5:\"label\";s:14:\"advance_salary\";s:4:\"link\";s:28:\"admin/payroll/advance_salary\";s:4:\"icon\";s:19:\"fa fa-cc-mastercard\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2017-06-10 14:04:23\";s:6:\"status\";s:1:\"1\";}i:78;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"99\";s:5:\"label\";s:14:\"employee_award\";s:4:\"link\";s:11:\"admin/award\";s:4:\"icon\";s:12:\"fa fa-trophy\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2017-06-10 14:05:47\";s:6:\"status\";s:1:\"1\";}i:79;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"100\";s:5:\"label\";s:13:\"announcements\";s:4:\"link\";s:19:\"admin/announcements\";s:4:\"icon\";s:19:\"fa fa-bullhorn icon\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"22\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:80;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"101\";s:5:\"label\";s:8:\"training\";s:4:\"link\";s:14:\"admin/training\";s:4:\"icon\";s:14:\"fa fa-suitcase\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"21\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:81;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"102\";s:5:\"label\";s:12:\"job_circular\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:11:\"fa fa-globe\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"17\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:82;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"103\";s:5:\"label\";s:11:\"jobs_posted\";s:4:\"link\";s:30:\"admin/job_circular/jobs_posted\";s:4:\"icon\";s:12:\"fa fa-ticket\";s:6:\"parent\";s:3:\"102\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:83;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"104\";s:5:\"label\";s:17:\"jobs_applications\";s:4:\"link\";s:36:\"admin/job_circular/jobs_applications\";s:4:\"icon\";s:13:\"fa fa-compass\";s:6:\"parent\";s:3:\"102\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:84;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"105\";s:5:\"label\";s:10:\"attendance\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:15:\"fa fa-file-text\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"16\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:85;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"106\";s:5:\"label\";s:18:\"timechange_request\";s:4:\"link\";s:35:\"admin/attendance/timechange_request\";s:4:\"icon\";s:16:\"fa fa-calendar-o\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:86;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"107\";s:5:\"label\";s:17:\"attendance_report\";s:4:\"link\";s:34:\"admin/attendance/attendance_report\";s:4:\"icon\";s:15:\"fa fa-file-text\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:87;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"108\";s:5:\"label\";s:12:\"time_history\";s:4:\"link\";s:29:\"admin/attendance/time_history\";s:4:\"icon\";s:13:\"fa fa-clock-o\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:88;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"109\";s:5:\"label\";s:9:\"pull-down\";s:4:\"link\";s:0:\"\";s:4:\"icon\";s:0:\"\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-31 12:43:20\";s:6:\"status\";s:1:\"0\";}i:89;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"110\";s:5:\"label\";s:11:\"filemanager\";s:4:\"link\";s:17:\"admin/filemanager\";s:4:\"icon\";s:10:\"fa fa-file\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:90;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"111\";s:5:\"label\";s:15:\"company_details\";s:4:\"link\";s:14:\"admin/settings\";s:4:\"icon\";s:23:\"fa fa-fw fa-info-circle\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-25 17:08:46\";s:6:\"status\";s:1:\"2\";}i:91;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"112\";s:5:\"label\";s:15:\"system_settings\";s:4:\"link\";s:21:\"admin/settings/system\";s:4:\"icon\";s:19:\"fa fa-fw fa-desktop\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-04-25 17:08:46\";s:6:\"status\";s:1:\"2\";}i:92;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"113\";s:5:\"label\";s:14:\"email_settings\";s:4:\"link\";s:20:\"admin/settings/email\";s:4:\"icon\";s:20:\"fa fa-fw fa-envelope\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-25 17:08:46\";s:6:\"status\";s:1:\"2\";}i:93;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"114\";s:5:\"label\";s:15:\"email_templates\";s:4:\"link\";s:24:\"admin/settings/templates\";s:4:\"icon\";s:25:\"fa fa-fw fa-pencil-square\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2021-07-30 06:18:08\";s:6:\"status\";s:1:\"2\";}i:94;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"115\";s:5:\"label\";s:17:\"email_integration\";s:4:\"link\";s:32:\"admin/settings/email_integration\";s:4:\"icon\";s:22:\"fa fa-fw fa-envelope-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2021-07-30 06:18:08\";s:6:\"status\";s:1:\"2\";}i:95;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"116\";s:5:\"label\";s:16:\"payment_settings\";s:4:\"link\";s:23:\"admin/settings/payments\";s:4:\"icon\";s:18:\"fa fa-fw fa-dollar\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:96;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"117\";s:5:\"label\";s:16:\"invoice_settings\";s:4:\"link\";s:22:\"admin/settings/invoice\";s:4:\"icon\";s:17:\"fa fa-fw fa-money\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:97;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"118\";s:5:\"label\";s:17:\"estimate_settings\";s:4:\"link\";s:23:\"admin/settings/estimate\";s:4:\"icon\";s:18:\"fa fa-fw fa-file-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:98;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"119\";s:5:\"label\";s:22:\"tickets_leads_settings\";s:4:\"link\";s:22:\"admin/settings/tickets\";s:4:\"icon\";s:18:\"fa fa-fw fa-ticket\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"14\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:99;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"120\";s:5:\"label\";s:14:\"theme_settings\";s:4:\"link\";s:20:\"admin/settings/theme\";s:4:\"icon\";s:16:\"fa fa-fw fa-code\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"20\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:100;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"121\";s:5:\"label\";s:12:\"working_days\";s:4:\"link\";s:27:\"admin/settings/working_days\";s:4:\"icon\";s:20:\"fa fa-fw fa-calendar\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"22\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:101;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"122\";s:5:\"label\";s:14:\"leave_category\";s:4:\"link\";s:29:\"admin/settings/leave_category\";s:4:\"icon\";s:21:\"fa fa-fw fa-pagelines\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"23\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:102;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"123\";s:5:\"label\";s:15:\"income_category\";s:4:\"link\";s:30:\"admin/settings/income_category\";s:4:\"icon\";s:23:\"fa fa-fw fa-certificate\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"24\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:103;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"124\";s:5:\"label\";s:16:\"expense_category\";s:4:\"link\";s:31:\"admin/settings/expense_category\";s:4:\"icon\";s:17:\"fa fa-fw fa-tasks\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"25\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:104;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"125\";s:5:\"label\";s:14:\"customer_group\";s:4:\"link\";s:29:\"admin/settings/customer_group\";s:4:\"icon\";s:17:\"fa fa-fw fa-users\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"26\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:105;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"127\";s:5:\"label\";s:11:\"lead_status\";s:4:\"link\";s:26:\"admin/settings/lead_status\";s:4:\"icon\";s:19:\"fa fa-fw fa-list-ul\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"16\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:106;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"128\";s:5:\"label\";s:11:\"lead_source\";s:4:\"link\";s:26:\"admin/settings/lead_source\";s:4:\"icon\";s:22:\"fa fa-fw fa-arrow-down\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"17\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:107;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"129\";s:5:\"label\";s:26:\"opportunities_state_reason\";s:4:\"link\";s:41:\"admin/settings/opportunities_state_reason\";s:4:\"icon\";s:24:\"fa fa-fw fa-dot-circle-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"19\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:108;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"130\";s:5:\"label\";s:12:\"custom_field\";s:4:\"link\";s:27:\"admin/settings/custom_field\";s:4:\"icon\";s:18:\"fa fa-fw fa-star-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"28\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:109;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"131\";s:5:\"label\";s:14:\"payment_method\";s:4:\"link\";s:29:\"admin/settings/payment_method\";s:4:\"icon\";s:17:\"fa fa-fw fa-money\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"29\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:110;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"132\";s:5:\"label\";s:7:\"cronjob\";s:4:\"link\";s:22:\"admin/settings/cronjob\";s:4:\"icon\";s:18:\"fa fa-fw fa-contao\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"31\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:111;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"133\";s:5:\"label\";s:15:\"menu_allocation\";s:4:\"link\";s:30:\"admin/settings/menu_allocation\";s:4:\"icon\";s:22:\"fa fa-fw fa fa-compass\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"32\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:112;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"134\";s:5:\"label\";s:12:\"notification\";s:4:\"link\";s:27:\"admin/settings/notification\";s:4:\"icon\";s:18:\"fa fa-fw fa-bell-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"33\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:113;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"135\";s:5:\"label\";s:18:\"email_notification\";s:4:\"link\";s:33:\"admin/settings/email_notification\";s:4:\"icon\";s:18:\"fa fa-fw fa-bell-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"34\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:114;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"136\";s:5:\"label\";s:15:\"database_backup\";s:4:\"link\";s:30:\"admin/settings/database_backup\";s:4:\"icon\";s:20:\"fa fa-fw fa-database\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"35\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:115;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"137\";s:5:\"label\";s:12:\"translations\";s:4:\"link\";s:27:\"admin/settings/translations\";s:4:\"icon\";s:20:\"fa fa-fw fa-language\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"36\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:116;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"138\";s:5:\"label\";s:13:\"system_update\";s:4:\"link\";s:28:\"admin/settings/system_update\";s:4:\"icon\";s:27:\"fa fa-fw fa-pencil-square-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"37\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:117;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"139\";s:5:\"label\";s:12:\"private_chat\";s:4:\"link\";s:18:\"chat/conversations\";s:4:\"icon\";s:14:\"fa fa-envelope\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"28\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:118;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"140\";s:5:\"label\";s:9:\"proposals\";s:4:\"link\";s:15:\"admin/proposals\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-01-07 07:05:16\";s:6:\"status\";s:1:\"1\";}i:119;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"141\";s:5:\"label\";s:13:\"knowledgebase\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:21:\"fa fa-question-circle\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"11\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:120;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"142\";s:5:\"label\";s:10:\"categories\";s:4:\"link\";s:30:\"admin/knowledgebase/categories\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"141\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:121;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"143\";s:5:\"label\";s:8:\"articles\";s:4:\"link\";s:28:\"admin/knowledgebase/articles\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"141\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:122;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"144\";s:5:\"label\";s:13:\"knowledgebase\";s:4:\"link\";s:19:\"admin/knowledgebase\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"141\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:123;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"145\";s:5:\"label\";s:18:\"dashboard_settings\";s:4:\"link\";s:24:\"admin/settings/dashboard\";s:4:\"icon\";s:21:\"fa fa-fw fa-dashboard\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"21\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:124;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"146\";s:5:\"label\";s:20:\"transactions_reports\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:16:\"fa fa-building-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-05-13 12:29:51\";s:6:\"status\";s:1:\"1\";}i:125;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"147\";s:5:\"label\";s:5:\"sales\";s:4:\"link\";s:25:\"admin/report/sales_report\";s:4:\"icon\";s:19:\"fa fa-shopping-cart\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-01-07 01:12:23\";s:6:\"status\";s:1:\"1\";}i:126;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"148\";s:5:\"label\";s:15:\"mark_attendance\";s:4:\"link\";s:21:\"admin/mark_attendance\";s:4:\"icon\";s:15:\"fa fa-file-text\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-03-07 06:45:25\";s:6:\"status\";s:1:\"1\";}i:127;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"149\";s:5:\"label\";s:10:\"allowed_ip\";s:4:\"link\";s:25:\"admin/settings/allowed_ip\";s:4:\"icon\";s:12:\"fa fa-server\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"27\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:128;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"150\";s:5:\"label\";s:5:\"stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:11:\"icon-layers\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2019-05-01 18:10:52\";s:6:\"status\";s:1:\"1\";}i:129;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"151\";s:5:\"label\";s:8:\"supplier\";s:4:\"link\";s:14:\"admin/supplier\";s:4:\"icon\";s:14:\"icon-briefcase\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2019-05-01 18:10:52\";s:6:\"status\";s:1:\"1\";}i:130;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"152\";s:5:\"label\";s:8:\"purchase\";s:4:\"link\";s:14:\"admin/purchase\";s:4:\"icon\";s:12:\"icon-handbag\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2019-05-01 18:10:52\";s:6:\"status\";s:1:\"1\";}i:131;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"153\";s:5:\"label\";s:12:\"return_stock\";s:4:\"link\";s:18:\"admin/return_stock\";s:4:\"icon\";s:14:\"icon-share-alt\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2019-05-05 16:19:30\";s:6:\"status\";s:1:\"1\";}i:132;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"154\";s:5:\"label\";s:16:\"purchase_payment\";s:4:\"link\";s:27:\"admin/purchase/all_payments\";s:4:\"icon\";s:16:\"icon-credit-card\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2019-05-05 13:53:11\";s:6:\"status\";s:1:\"1\";}i:133;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"155\";s:5:\"label\";s:17:\"purchase_settings\";s:4:\"link\";s:23:\"admin/settings/purchase\";s:4:\"icon\";s:18:\"fa-fw icon-handbag\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"12\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:134;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"156\";s:5:\"label\";s:11:\"credit_note\";s:4:\"link\";s:17:\"admin/credit_note\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-06-10 02:32:05\";s:6:\"status\";s:1:\"1\";}i:135;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"157\";s:5:\"label\";s:20:\"credit_note_settings\";s:4:\"link\";s:26:\"admin/settings/credit_note\";s:4:\"icon\";s:17:\"fa fa-fw fa-money\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"9\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:136;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"158\";s:5:\"label\";s:18:\"proposals_settings\";s:4:\"link\";s:24:\"admin/settings/proposals\";s:4:\"icon\";s:16:\"fa fa-fw fa-leaf\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"11\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:137;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"159\";s:5:\"label\";s:17:\"projects_settings\";s:4:\"link\";s:23:\"admin/settings/projects\";s:4:\"icon\";s:25:\"fa fa-fw fa-folder-open-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"13\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:138;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"160\";s:5:\"label\";s:4:\"tags\";s:4:\"link\";s:19:\"admin/settings/tags\";s:4:\"icon\";s:16:\"fa fa-fw fa-tags\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"30\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:139;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"161\";s:5:\"label\";s:9:\"lead_form\";s:4:\"link\";s:25:\"admin/leads/all_lead_form\";s:4:\"icon\";s:18:\"fa fa-fw fa-rocket\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"18\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:140;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"162\";s:5:\"label\";s:21:\"transactions_settings\";s:4:\"link\";s:27:\"admin/settings/transactions\";s:4:\"icon\";s:22:\"fa fa-fw fa-building-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"15\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:141;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"163\";s:5:\"label\";s:12:\"sms_settings\";s:4:\"link\";s:27:\"admin/settings/sms_settings\";s:4:\"icon\";s:20:\"fa fa-fw fa-envelope\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2021-07-30 06:18:08\";s:6:\"status\";s:1:\"2\";}i:142;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"164\";s:5:\"label\";s:9:\"pos_sales\";s:4:\"link\";s:23:\"admin/invoice/pos_sales\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2021-10-16 00:53:10\";s:6:\"status\";s:1:\"1\";}i:143;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"186\";s:5:\"label\";s:9:\"warehouse\";s:4:\"link\";s:22:\"admin/warehouse/manage\";s:4:\"icon\";s:16:\"fa fa-building-o\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2021-10-18 09:24:24\";s:6:\"status\";s:1:\"1\";}i:144;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"187\";s:5:\"label\";s:12:\"transferItem\";s:4:\"link\";s:24:\"admin/items/transferItem\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2021-10-14 11:56:08\";s:6:\"status\";s:1:\"1\";}i:145;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"203\";s:5:\"label\";s:13:\"award_setting\";s:4:\"link\";s:20:\"admin/settings/award\";s:4:\"icon\";s:10:\"fa fa-star\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"30\";s:4:\"time\";s:19:\"2022-01-19 05:51:40\";s:6:\"status\";s:1:\"2\";}i:146;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"204\";s:5:\"label\";s:18:\"award_rule_setting\";s:4:\"link\";s:34:\"admin/settings/award_rule_settingh\";s:4:\"icon\";s:10:\"fa fa-star\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"31\";s:4:\"time\";s:19:\"2022-01-19 09:53:50\";s:6:\"status\";s:1:\"2\";}i:147;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"205\";s:5:\"label\";s:22:\"award_program_settings\";s:4:\"link\";s:37:\"admin/settings/award_program_settings\";s:4:\"icon\";s:9:\"fa fa-cog\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"32\";s:4:\"time\";s:19:\"2022-01-20 09:17:30\";s:6:\"status\";s:1:\"2\";}i:148;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"206\";s:5:\"label\";s:19:\"client_award_points\";s:4:\"link\";s:27:\"admin/invoice/client_awards\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2022-01-21 01:39:41\";s:6:\"status\";s:1:\"1\";}i:149;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"207\";s:5:\"label\";s:20:\"best_selling_product\";s:4:\"link\";s:18:\"admin/best_selling\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:2:\"11\";s:4:\"time\";s:19:\"2022-01-21 06:43:52\";s:6:\"status\";s:1:\"1\";}i:150;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"209\";s:5:\"label\";s:7:\"warning\";s:4:\"link\";s:13:\"admin/warning\";s:4:\"icon\";s:13:\"fa fa-warning\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2022-08-07 12:47:01\";s:6:\"status\";s:1:\"1\";}i:151;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"210\";s:5:\"label\";s:9:\"promotion\";s:4:\"link\";s:15:\"admin/promotion\";s:4:\"icon\";s:21:\"fa fa-arrow-circle-up\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2022-08-07 12:49:28\";s:6:\"status\";s:1:\"1\";}i:152;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"211\";s:5:\"label\";s:11:\"termination\";s:4:\"link\";s:17:\"admin/termination\";s:4:\"icon\";s:12:\"fa fa-eraser\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2022-08-07 12:50:45\";s:6:\"status\";s:1:\"1\";}i:153;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"212\";s:5:\"label\";s:11:\"resignation\";s:4:\"link\";s:17:\"admin/resignation\";s:4:\"icon\";s:14:\"fa fa-scissors\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2022-08-07 12:54:31\";s:6:\"status\";s:1:\"1\";}}');
INSERT INTO `tbl_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0b6484ac97ac3238c1ffcac66a9217716f03583f', '136.158.121.2', 1689138543, '__ci_last_regenerate|i:1689138543;menu_active_id|a:3:{i:0;s:3:\"151\";i:1;s:3:\"150\";i:2;s:1:\"0\";}user_name|s:5:\"nimda\";email|s:26:\"erick@blickcreative.com.au\";name|s:13:\"Erick Villeta\";photo|s:26:\"uploads/default_avatar.jpg\";user_id|s:1:\"5\";last_login|s:19:\"2023-07-10 11:54:34\";online_time|i:1689133478;loggedin|b:1;user_type|s:1:\"1\";user_flag|s:1:\"1\";direction|s:3:\"ltr\";warehouse_id|N;designations_id|s:1:\"0\";url|s:27:\"admin/supplier/supplierList\";user_roll|a:10:{i:0;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"1\";s:5:\"label\";s:9:\"dashboard\";s:4:\"link\";s:15:\"admin/dashboard\";s:4:\"icon\";s:15:\"fa fa-dashboard\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-04-23 01:39:36\";s:6:\"status\";s:1:\"1\";}i:1;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"2\";s:5:\"label\";s:8:\"calendar\";s:4:\"link\";s:14:\"admin/calendar\";s:4:\"icon\";s:14:\"fa fa-calendar\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-23 19:57:23\";s:6:\"status\";s:1:\"1\";}i:2;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"4\";s:5:\"label\";s:6:\"client\";s:4:\"link\";s:26:\"admin/client/manage_client\";s:4:\"icon\";s:11:\"fa fa-users\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"13\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:3;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"5\";s:5:\"label\";s:7:\"mailbox\";s:4:\"link\";s:13:\"admin/mailbox\";s:4:\"icon\";s:16:\"fa fa-envelope-o\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:4;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"6\";s:5:\"label\";s:7:\"tickets\";s:4:\"link\";s:13:\"admin/tickets\";s:4:\"icon\";s:12:\"fa fa-ticket\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2018-06-08 13:39:39\";s:6:\"status\";s:1:\"1\";}i:5;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"12\";s:5:\"label\";s:5:\"sales\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:19:\"fa fa-shopping-cart\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"9\";s:4:\"time\";s:19:\"2017-06-10 14:02:58\";s:6:\"status\";s:1:\"1\";}i:6;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"13\";s:5:\"label\";s:7:\"invoice\";s:4:\"link\";s:28:\"admin/invoice/manage_invoice\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-04-23 19:57:23\";s:6:\"status\";s:1:\"1\";}i:7;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"14\";s:5:\"label\";s:9:\"estimates\";s:4:\"link\";s:15:\"admin/estimates\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-06-10 14:02:05\";s:6:\"status\";s:1:\"1\";}i:8;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"15\";s:5:\"label\";s:17:\"payments_received\";s:4:\"link\";s:26:\"admin/invoice/all_payments\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-23 19:57:24\";s:6:\"status\";s:1:\"1\";}i:9;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"16\";s:5:\"label\";s:9:\"tax_rates\";s:4:\"link\";s:23:\"admin/invoice/tax_rates\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-01-07 07:05:16\";s:6:\"status\";s:1:\"1\";}}');
INSERT INTO `tbl_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('103e0af7947c2a78129f3284275a9b3c77c96107', '136.158.120.226', 1688741160, '__ci_last_regenerate|i:1688741160;menu_active_id|a:2:{i:0;s:1:\"1\";i:1;s:1:\"0\";}url|s:15:\"admin/dashboard\";user_roll|a:154:{i:0;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"1\";s:5:\"label\";s:9:\"dashboard\";s:4:\"link\";s:15:\"admin/dashboard\";s:4:\"icon\";s:15:\"fa fa-dashboard\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-04-23 01:39:36\";s:6:\"status\";s:1:\"1\";}i:1;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"2\";s:5:\"label\";s:8:\"calendar\";s:4:\"link\";s:14:\"admin/calendar\";s:4:\"icon\";s:14:\"fa fa-calendar\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-23 19:57:23\";s:6:\"status\";s:1:\"1\";}i:2;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"4\";s:5:\"label\";s:6:\"client\";s:4:\"link\";s:26:\"admin/client/manage_client\";s:4:\"icon\";s:11:\"fa fa-users\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"13\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:3;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"5\";s:5:\"label\";s:7:\"mailbox\";s:4:\"link\";s:13:\"admin/mailbox\";s:4:\"icon\";s:16:\"fa fa-envelope-o\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:4;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"6\";s:5:\"label\";s:7:\"tickets\";s:4:\"link\";s:13:\"admin/tickets\";s:4:\"icon\";s:12:\"fa fa-ticket\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2018-06-08 13:39:39\";s:6:\"status\";s:1:\"1\";}i:5;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"12\";s:5:\"label\";s:5:\"sales\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:19:\"fa fa-shopping-cart\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"9\";s:4:\"time\";s:19:\"2017-06-10 14:02:58\";s:6:\"status\";s:1:\"1\";}i:6;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"13\";s:5:\"label\";s:7:\"invoice\";s:4:\"link\";s:28:\"admin/invoice/manage_invoice\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-04-23 19:57:23\";s:6:\"status\";s:1:\"1\";}i:7;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"14\";s:5:\"label\";s:9:\"estimates\";s:4:\"link\";s:15:\"admin/estimates\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-06-10 14:02:05\";s:6:\"status\";s:1:\"1\";}i:8;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"15\";s:5:\"label\";s:17:\"payments_received\";s:4:\"link\";s:26:\"admin/invoice/all_payments\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-23 19:57:24\";s:6:\"status\";s:1:\"1\";}i:9;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"16\";s:5:\"label\";s:9:\"tax_rates\";s:4:\"link\";s:23:\"admin/invoice/tax_rates\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-01-07 07:05:16\";s:6:\"status\";s:1:\"1\";}i:10;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"21\";s:5:\"label\";s:10:\"quotations\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:11:\"fa fa-paste\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:11;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"22\";s:5:\"label\";s:15:\"quotations_list\";s:4:\"link\";s:16:\"admin/quotations\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"21\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-05-18 16:49:03\";s:6:\"status\";s:1:\"1\";}i:12;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"23\";s:5:\"label\";s:15:\"quotations_form\";s:4:\"link\";s:32:\"admin/quotations/quotations_form\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"21\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:13;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"24\";s:5:\"label\";s:4:\"user\";s:4:\"link\";s:20:\"admin/user/user_list\";s:4:\"icon\";s:11:\"fa fa-users\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"25\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:14;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"25\";s:5:\"label\";s:8:\"settings\";s:4:\"link\";s:14:\"admin/settings\";s:4:\"icon\";s:10:\"fa fa-cogs\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"26\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:15;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"26\";s:5:\"label\";s:15:\"database_backup\";s:4:\"link\";s:30:\"admin/settings/database_backup\";s:4:\"icon\";s:14:\"fa fa-database\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"27\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:16;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"29\";s:5:\"label\";s:17:\"transactions_menu\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:16:\"fa fa-building-o\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"12\";s:4:\"time\";s:19:\"2018-05-13 12:27:58\";s:6:\"status\";s:1:\"1\";}i:17;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"30\";s:5:\"label\";s:7:\"deposit\";s:4:\"link\";s:26:\"admin/transactions/deposit\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-05-13 12:28:33\";s:6:\"status\";s:1:\"1\";}i:18;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"31\";s:5:\"label\";s:7:\"expense\";s:4:\"link\";s:26:\"admin/transactions/expense\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-05-13 12:28:37\";s:6:\"status\";s:1:\"1\";}i:19;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"32\";s:5:\"label\";s:8:\"transfer\";s:4:\"link\";s:27:\"admin/transactions/transfer\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-05-13 12:28:40\";s:6:\"status\";s:1:\"1\";}i:20;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"33\";s:5:\"label\";s:19:\"transactions_report\";s:4:\"link\";s:38:\"admin/transactions/transactions_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2018-05-13 12:28:44\";s:6:\"status\";s:1:\"1\";}i:21;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"34\";s:5:\"label\";s:13:\"balance_sheet\";s:4:\"link\";s:32:\"admin/transactions/balance_sheet\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-05-13 12:28:47\";s:6:\"status\";s:1:\"1\";}i:22;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"36\";s:5:\"label\";s:9:\"bank_cash\";s:4:\"link\";s:28:\"admin/account/manage_account\";s:4:\"icon\";s:11:\"fa fa-money\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2018-05-13 12:28:51\";s:6:\"status\";s:1:\"1\";}i:23;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"39\";s:5:\"label\";s:5:\"items\";s:4:\"link\";s:22:\"admin/items/items_list\";s:4:\"icon\";s:10:\"fa fa-cube\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2019-05-04 18:49:50\";s:6:\"status\";s:1:\"1\";}i:24;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"42\";s:5:\"label\";s:6:\"report\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:15:\"fa fa-bar-chart\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"24\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:25;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"43\";s:5:\"label\";s:17:\"account_statement\";s:4:\"link\";s:30:\"admin/report/account_statement\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:26;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"44\";s:5:\"label\";s:13:\"income_report\";s:4:\"link\";s:26:\"admin/report/income_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:27;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"45\";s:5:\"label\";s:14:\"expense_report\";s:4:\"link\";s:27:\"admin/report/expense_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:28;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"46\";s:5:\"label\";s:14:\"income_expense\";s:4:\"link\";s:27:\"admin/report/income_expense\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:29;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"47\";s:5:\"label\";s:16:\"date_wise_report\";s:4:\"link\";s:29:\"admin/report/date_wise_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:30;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"48\";s:5:\"label\";s:10:\"all_income\";s:4:\"link\";s:23:\"admin/report/all_income\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:31;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"49\";s:5:\"label\";s:11:\"all_expense\";s:4:\"link\";s:24:\"admin/report/all_expense\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:32;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"50\";s:5:\"label\";s:15:\"all_transaction\";s:4:\"link\";s:28:\"admin/report/all_transaction\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:33;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"51\";s:5:\"label\";s:17:\"recurring_invoice\";s:4:\"link\";s:31:\"admin/invoice/recurring_invoice\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-06-10 14:02:05\";s:6:\"status\";s:1:\"1\";}i:34;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"52\";s:5:\"label\";s:15:\"transfer_report\";s:4:\"link\";s:34:\"admin/transactions/transfer_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-05-13 12:28:59\";s:6:\"status\";s:1:\"1\";}i:35;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"53\";s:5:\"label\";s:15:\"report_by_month\";s:4:\"link\";s:28:\"admin/report/report_by_month\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:36;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"54\";s:5:\"label\";s:5:\"tasks\";s:4:\"link\";s:20:\"admin/tasks/all_task\";s:4:\"icon\";s:11:\"fa fa-tasks\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:37;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"55\";s:5:\"label\";s:5:\"leads\";s:4:\"link\";s:11:\"admin/leads\";s:4:\"icon\";s:12:\"fa fa-rocket\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:38;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"56\";s:5:\"label\";s:13:\"opportunities\";s:4:\"link\";s:19:\"admin/opportunities\";s:4:\"icon\";s:12:\"fa fa-filter\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:39;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"57\";s:5:\"label\";s:8:\"projects\";s:4:\"link\";s:14:\"admin/projects\";s:4:\"icon\";s:19:\"fa fa-folder-open-o\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:40;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"58\";s:5:\"label\";s:4:\"bugs\";s:4:\"link\";s:10:\"admin/bugs\";s:4:\"icon\";s:9:\"fa fa-bug\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:41;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"59\";s:5:\"label\";s:7:\"project\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:19:\"fa fa-folder-open-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:42;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"60\";s:5:\"label\";s:12:\"tasks_report\";s:4:\"link\";s:25:\"admin/report/tasks_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:43;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"61\";s:5:\"label\";s:11:\"bugs_report\";s:4:\"link\";s:24:\"admin/report/bugs_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:44;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"62\";s:5:\"label\";s:14:\"tickets_report\";s:4:\"link\";s:27:\"admin/report/tickets_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:45;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"63\";s:5:\"label\";s:13:\"client_report\";s:4:\"link\";s:26:\"admin/report/client_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2018-01-07 07:09:40\";s:6:\"status\";s:1:\"1\";}i:46;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"66\";s:5:\"label\";s:16:\"tasks_assignment\";s:4:\"link\";s:29:\"admin/report/tasks_assignment\";s:4:\"icon\";s:18:\"fa fa-dot-circle-o\";s:6:\"parent\";s:2:\"59\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:47;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"67\";s:5:\"label\";s:15:\"bugs_assignment\";s:4:\"link\";s:28:\"admin/report/bugs_assignment\";s:4:\"icon\";s:18:\"fa fa-dot-circle-o\";s:6:\"parent\";s:2:\"59\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:48;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"68\";s:5:\"label\";s:14:\"project_report\";s:4:\"link\";s:27:\"admin/report/project_report\";s:4:\"icon\";s:18:\"fa fa-dot-circle-o\";s:6:\"parent\";s:2:\"59\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:49;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"69\";s:5:\"label\";s:13:\"goal_tracking\";s:4:\"link\";s:19:\"admin/goal_tracking\";s:4:\"icon\";s:12:\"fa fa-shield\";s:6:\"parent\";s:2:\"73\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-06-10 14:05:47\";s:6:\"status\";s:1:\"1\";}i:50;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"70\";s:5:\"label\";s:11:\"departments\";s:4:\"link\";s:17:\"admin/departments\";s:4:\"icon\";s:17:\"fa fa-user-secret\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"14\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:51;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"71\";s:5:\"label\";s:7:\"holiday\";s:4:\"link\";s:13:\"admin/holiday\";s:4:\"icon\";s:21:\"fa fa-calendar-plus-o\";s:6:\"parent\";s:2:\"73\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-06-10 14:05:47\";s:6:\"status\";s:1:\"1\";}i:52;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"72\";s:5:\"label\";s:16:\"leave_management\";s:4:\"link\";s:22:\"admin/leave_management\";s:4:\"icon\";s:11:\"fa fa-plane\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"20\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:53;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"73\";s:5:\"label\";s:9:\"utilities\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:10:\"fa fa-gift\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"23\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:54;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"74\";s:5:\"label\";s:8:\"overtime\";s:4:\"link\";s:24:\"admin/utilities/overtime\";s:4:\"icon\";s:13:\"fa fa-clock-o\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"9\";s:4:\"time\";s:19:\"2017-06-10 14:04:23\";s:6:\"status\";s:1:\"1\";}i:55;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"75\";s:5:\"label\";s:12:\"office_stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:13:\"fa fa-codepen\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"15\";s:4:\"time\";s:19:\"2019-05-01 16:22:56\";s:6:\"status\";s:1:\"1\";}i:56;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"76\";s:5:\"label\";s:14:\"stock_category\";s:4:\"link\";s:26:\"admin/stock/stock_category\";s:4:\"icon\";s:13:\"fa fa-sliders\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:57;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"77\";s:5:\"label\";s:12:\"manage_stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:13:\"fa fa-archive\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-04-26 16:11:10\";s:6:\"status\";s:1:\"1\";}i:58;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"78\";s:5:\"label\";s:12:\"assign_stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:16:\"fa fa-align-left\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-26 16:11:10\";s:6:\"status\";s:1:\"1\";}i:59;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"79\";s:5:\"label\";s:12:\"stock_report\";s:4:\"link\";s:18:\"admin/stock/report\";s:4:\"icon\";s:16:\"fa fa-line-chart\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2017-04-25 18:48:25\";s:6:\"status\";s:1:\"1\";}i:60;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"81\";s:5:\"label\";s:10:\"stock_list\";s:4:\"link\";s:22:\"admin/stock/stock_list\";s:4:\"icon\";s:20:\"fa fa-stack-exchange\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-26 16:11:10\";s:6:\"status\";s:1:\"1\";}i:61;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"82\";s:5:\"label\";s:12:\"assign_stock\";s:4:\"link\";s:24:\"admin/stock/assign_stock\";s:4:\"icon\";s:16:\"fa fa-align-left\";s:6:\"parent\";s:2:\"78\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:62;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"83\";s:5:\"label\";s:19:\"assign_stock_report\";s:4:\"link\";s:31:\"admin/stock/assign_stock_report\";s:4:\"icon\";s:15:\"fa fa-bar-chart\";s:6:\"parent\";s:2:\"78\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:63;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"84\";s:5:\"label\";s:13:\"stock_history\";s:4:\"link\";s:25:\"admin/stock/stock_history\";s:4:\"icon\";s:17:\"fa fa-file-text-o\";s:6:\"parent\";s:2:\"77\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:64;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"85\";s:5:\"label\";s:11:\"performance\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:14:\"fa fa-dribbble\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"19\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:65;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"86\";s:5:\"label\";s:21:\"performance_indicator\";s:4:\"link\";s:39:\"admin/performance/performance_indicator\";s:4:\"icon\";s:12:\"fa fa-random\";s:6:\"parent\";s:2:\"85\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:66;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"87\";s:5:\"label\";s:18:\"performance_report\";s:4:\"link\";s:36:\"admin/performance/performance_report\";s:4:\"icon\";s:16:\"fa fa-calendar-o\";s:6:\"parent\";s:2:\"85\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:67;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"88\";s:5:\"label\";s:14:\"give_appraisal\";s:4:\"link\";s:44:\"admin/performance/give_performance_appraisal\";s:4:\"icon\";s:10:\"fa fa-plus\";s:6:\"parent\";s:2:\"85\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:68;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"89\";s:5:\"label\";s:7:\"payroll\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:9:\"fa fa-usd\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"18\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:69;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"90\";s:5:\"label\";s:21:\"manage_salary_details\";s:4:\"link\";s:35:\"admin/payroll/manage_salary_details\";s:4:\"icon\";s:9:\"fa fa-usd\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:70;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"91\";s:5:\"label\";s:20:\"employee_salary_list\";s:4:\"link\";s:34:\"admin/payroll/employee_salary_list\";s:4:\"icon\";s:17:\"fa fa-user-secret\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:71;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"92\";s:5:\"label\";s:12:\"make_payment\";s:4:\"link\";s:26:\"admin/payroll/make_payment\";s:4:\"icon\";s:11:\"fa fa-tasks\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:72;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"93\";s:5:\"label\";s:16:\"generate_payslip\";s:4:\"link\";s:30:\"admin/payroll/generate_payslip\";s:4:\"icon\";s:13:\"fa fa-list-ul\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:73;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"94\";s:5:\"label\";s:15:\"salary_template\";s:4:\"link\";s:29:\"admin/payroll/salary_template\";s:4:\"icon\";s:11:\"fa fa-money\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:74;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"95\";s:5:\"label\";s:11:\"hourly_rate\";s:4:\"link\";s:25:\"admin/payroll/hourly_rate\";s:4:\"icon\";s:13:\"fa fa-clock-o\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:75;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"96\";s:5:\"label\";s:15:\"payroll_summary\";s:4:\"link\";s:29:\"admin/payroll/payroll_summary\";s:4:\"icon\";s:18:\"fa fa-camera-retro\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:76;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"97\";s:5:\"label\";s:14:\"provident_fund\";s:4:\"link\";s:28:\"admin/payroll/provident_fund\";s:4:\"icon\";s:15:\"fa fa-briefcase\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2017-06-10 14:04:23\";s:6:\"status\";s:1:\"1\";}i:77;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"98\";s:5:\"label\";s:14:\"advance_salary\";s:4:\"link\";s:28:\"admin/payroll/advance_salary\";s:4:\"icon\";s:19:\"fa fa-cc-mastercard\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2017-06-10 14:04:23\";s:6:\"status\";s:1:\"1\";}i:78;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"99\";s:5:\"label\";s:14:\"employee_award\";s:4:\"link\";s:11:\"admin/award\";s:4:\"icon\";s:12:\"fa fa-trophy\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2017-06-10 14:05:47\";s:6:\"status\";s:1:\"1\";}i:79;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"100\";s:5:\"label\";s:13:\"announcements\";s:4:\"link\";s:19:\"admin/announcements\";s:4:\"icon\";s:19:\"fa fa-bullhorn icon\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"22\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:80;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"101\";s:5:\"label\";s:8:\"training\";s:4:\"link\";s:14:\"admin/training\";s:4:\"icon\";s:14:\"fa fa-suitcase\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"21\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:81;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"102\";s:5:\"label\";s:12:\"job_circular\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:11:\"fa fa-globe\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"17\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:82;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"103\";s:5:\"label\";s:11:\"jobs_posted\";s:4:\"link\";s:30:\"admin/job_circular/jobs_posted\";s:4:\"icon\";s:12:\"fa fa-ticket\";s:6:\"parent\";s:3:\"102\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:83;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"104\";s:5:\"label\";s:17:\"jobs_applications\";s:4:\"link\";s:36:\"admin/job_circular/jobs_applications\";s:4:\"icon\";s:13:\"fa fa-compass\";s:6:\"parent\";s:3:\"102\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:84;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"105\";s:5:\"label\";s:10:\"attendance\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:15:\"fa fa-file-text\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"16\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:85;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"106\";s:5:\"label\";s:18:\"timechange_request\";s:4:\"link\";s:35:\"admin/attendance/timechange_request\";s:4:\"icon\";s:16:\"fa fa-calendar-o\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:86;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"107\";s:5:\"label\";s:17:\"attendance_report\";s:4:\"link\";s:34:\"admin/attendance/attendance_report\";s:4:\"icon\";s:15:\"fa fa-file-text\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:87;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"108\";s:5:\"label\";s:12:\"time_history\";s:4:\"link\";s:29:\"admin/attendance/time_history\";s:4:\"icon\";s:13:\"fa fa-clock-o\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:88;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"109\";s:5:\"label\";s:9:\"pull-down\";s:4:\"link\";s:0:\"\";s:4:\"icon\";s:0:\"\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-31 12:43:20\";s:6:\"status\";s:1:\"0\";}i:89;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"110\";s:5:\"label\";s:11:\"filemanager\";s:4:\"link\";s:17:\"admin/filemanager\";s:4:\"icon\";s:10:\"fa fa-file\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:90;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"111\";s:5:\"label\";s:15:\"company_details\";s:4:\"link\";s:14:\"admin/settings\";s:4:\"icon\";s:23:\"fa fa-fw fa-info-circle\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-25 17:08:46\";s:6:\"status\";s:1:\"2\";}i:91;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"112\";s:5:\"label\";s:15:\"system_settings\";s:4:\"link\";s:21:\"admin/settings/system\";s:4:\"icon\";s:19:\"fa fa-fw fa-desktop\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-04-25 17:08:46\";s:6:\"status\";s:1:\"2\";}i:92;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"113\";s:5:\"label\";s:14:\"email_settings\";s:4:\"link\";s:20:\"admin/settings/email\";s:4:\"icon\";s:20:\"fa fa-fw fa-envelope\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-25 17:08:46\";s:6:\"status\";s:1:\"2\";}i:93;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"114\";s:5:\"label\";s:15:\"email_templates\";s:4:\"link\";s:24:\"admin/settings/templates\";s:4:\"icon\";s:25:\"fa fa-fw fa-pencil-square\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2021-07-30 06:18:08\";s:6:\"status\";s:1:\"2\";}i:94;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"115\";s:5:\"label\";s:17:\"email_integration\";s:4:\"link\";s:32:\"admin/settings/email_integration\";s:4:\"icon\";s:22:\"fa fa-fw fa-envelope-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2021-07-30 06:18:08\";s:6:\"status\";s:1:\"2\";}i:95;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"116\";s:5:\"label\";s:16:\"payment_settings\";s:4:\"link\";s:23:\"admin/settings/payments\";s:4:\"icon\";s:18:\"fa fa-fw fa-dollar\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:96;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"117\";s:5:\"label\";s:16:\"invoice_settings\";s:4:\"link\";s:22:\"admin/settings/invoice\";s:4:\"icon\";s:17:\"fa fa-fw fa-money\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:97;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"118\";s:5:\"label\";s:17:\"estimate_settings\";s:4:\"link\";s:23:\"admin/settings/estimate\";s:4:\"icon\";s:18:\"fa fa-fw fa-file-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:98;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"119\";s:5:\"label\";s:22:\"tickets_leads_settings\";s:4:\"link\";s:22:\"admin/settings/tickets\";s:4:\"icon\";s:18:\"fa fa-fw fa-ticket\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"14\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:99;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"120\";s:5:\"label\";s:14:\"theme_settings\";s:4:\"link\";s:20:\"admin/settings/theme\";s:4:\"icon\";s:16:\"fa fa-fw fa-code\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"20\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:100;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"121\";s:5:\"label\";s:12:\"working_days\";s:4:\"link\";s:27:\"admin/settings/working_days\";s:4:\"icon\";s:20:\"fa fa-fw fa-calendar\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"22\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:101;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"122\";s:5:\"label\";s:14:\"leave_category\";s:4:\"link\";s:29:\"admin/settings/leave_category\";s:4:\"icon\";s:21:\"fa fa-fw fa-pagelines\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"23\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:102;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"123\";s:5:\"label\";s:15:\"income_category\";s:4:\"link\";s:30:\"admin/settings/income_category\";s:4:\"icon\";s:23:\"fa fa-fw fa-certificate\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"24\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:103;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"124\";s:5:\"label\";s:16:\"expense_category\";s:4:\"link\";s:31:\"admin/settings/expense_category\";s:4:\"icon\";s:17:\"fa fa-fw fa-tasks\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"25\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:104;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"125\";s:5:\"label\";s:14:\"customer_group\";s:4:\"link\";s:29:\"admin/settings/customer_group\";s:4:\"icon\";s:17:\"fa fa-fw fa-users\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"26\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:105;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"127\";s:5:\"label\";s:11:\"lead_status\";s:4:\"link\";s:26:\"admin/settings/lead_status\";s:4:\"icon\";s:19:\"fa fa-fw fa-list-ul\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"16\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:106;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"128\";s:5:\"label\";s:11:\"lead_source\";s:4:\"link\";s:26:\"admin/settings/lead_source\";s:4:\"icon\";s:22:\"fa fa-fw fa-arrow-down\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"17\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:107;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"129\";s:5:\"label\";s:26:\"opportunities_state_reason\";s:4:\"link\";s:41:\"admin/settings/opportunities_state_reason\";s:4:\"icon\";s:24:\"fa fa-fw fa-dot-circle-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"19\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:108;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"130\";s:5:\"label\";s:12:\"custom_field\";s:4:\"link\";s:27:\"admin/settings/custom_field\";s:4:\"icon\";s:18:\"fa fa-fw fa-star-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"28\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:109;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"131\";s:5:\"label\";s:14:\"payment_method\";s:4:\"link\";s:29:\"admin/settings/payment_method\";s:4:\"icon\";s:17:\"fa fa-fw fa-money\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"29\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:110;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"132\";s:5:\"label\";s:7:\"cronjob\";s:4:\"link\";s:22:\"admin/settings/cronjob\";s:4:\"icon\";s:18:\"fa fa-fw fa-contao\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"31\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:111;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"133\";s:5:\"label\";s:15:\"menu_allocation\";s:4:\"link\";s:30:\"admin/settings/menu_allocation\";s:4:\"icon\";s:22:\"fa fa-fw fa fa-compass\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"32\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:112;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"134\";s:5:\"label\";s:12:\"notification\";s:4:\"link\";s:27:\"admin/settings/notification\";s:4:\"icon\";s:18:\"fa fa-fw fa-bell-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"33\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:113;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"135\";s:5:\"label\";s:18:\"email_notification\";s:4:\"link\";s:33:\"admin/settings/email_notification\";s:4:\"icon\";s:18:\"fa fa-fw fa-bell-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"34\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:114;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"136\";s:5:\"label\";s:15:\"database_backup\";s:4:\"link\";s:30:\"admin/settings/database_backup\";s:4:\"icon\";s:20:\"fa fa-fw fa-database\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"35\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:115;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"137\";s:5:\"label\";s:12:\"translations\";s:4:\"link\";s:27:\"admin/settings/translations\";s:4:\"icon\";s:20:\"fa fa-fw fa-language\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"36\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:116;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"138\";s:5:\"label\";s:13:\"system_update\";s:4:\"link\";s:28:\"admin/settings/system_update\";s:4:\"icon\";s:27:\"fa fa-fw fa-pencil-square-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"37\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:117;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"139\";s:5:\"label\";s:12:\"private_chat\";s:4:\"link\";s:18:\"chat/conversations\";s:4:\"icon\";s:14:\"fa fa-envelope\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"28\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:118;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"140\";s:5:\"label\";s:9:\"proposals\";s:4:\"link\";s:15:\"admin/proposals\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-01-07 07:05:16\";s:6:\"status\";s:1:\"1\";}i:119;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"141\";s:5:\"label\";s:13:\"knowledgebase\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:21:\"fa fa-question-circle\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"11\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:120;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"142\";s:5:\"label\";s:10:\"categories\";s:4:\"link\";s:30:\"admin/knowledgebase/categories\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"141\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:121;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"143\";s:5:\"label\";s:8:\"articles\";s:4:\"link\";s:28:\"admin/knowledgebase/articles\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"141\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:122;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"144\";s:5:\"label\";s:13:\"knowledgebase\";s:4:\"link\";s:19:\"admin/knowledgebase\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"141\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:123;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"145\";s:5:\"label\";s:18:\"dashboard_settings\";s:4:\"link\";s:24:\"admin/settings/dashboard\";s:4:\"icon\";s:21:\"fa fa-fw fa-dashboard\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"21\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:124;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"146\";s:5:\"label\";s:20:\"transactions_reports\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:16:\"fa fa-building-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-05-13 12:29:51\";s:6:\"status\";s:1:\"1\";}i:125;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"147\";s:5:\"label\";s:5:\"sales\";s:4:\"link\";s:25:\"admin/report/sales_report\";s:4:\"icon\";s:19:\"fa fa-shopping-cart\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-01-07 01:12:23\";s:6:\"status\";s:1:\"1\";}i:126;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"148\";s:5:\"label\";s:15:\"mark_attendance\";s:4:\"link\";s:21:\"admin/mark_attendance\";s:4:\"icon\";s:15:\"fa fa-file-text\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-03-07 06:45:25\";s:6:\"status\";s:1:\"1\";}i:127;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"149\";s:5:\"label\";s:10:\"allowed_ip\";s:4:\"link\";s:25:\"admin/settings/allowed_ip\";s:4:\"icon\";s:12:\"fa fa-server\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"27\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:128;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"150\";s:5:\"label\";s:5:\"stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:11:\"icon-layers\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2019-05-01 18:10:52\";s:6:\"status\";s:1:\"1\";}i:129;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"151\";s:5:\"label\";s:8:\"supplier\";s:4:\"link\";s:14:\"admin/supplier\";s:4:\"icon\";s:14:\"icon-briefcase\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2019-05-01 18:10:52\";s:6:\"status\";s:1:\"1\";}i:130;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"152\";s:5:\"label\";s:8:\"purchase\";s:4:\"link\";s:14:\"admin/purchase\";s:4:\"icon\";s:12:\"icon-handbag\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2019-05-01 18:10:52\";s:6:\"status\";s:1:\"1\";}i:131;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"153\";s:5:\"label\";s:12:\"return_stock\";s:4:\"link\";s:18:\"admin/return_stock\";s:4:\"icon\";s:14:\"icon-share-alt\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2019-05-05 16:19:30\";s:6:\"status\";s:1:\"1\";}i:132;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"154\";s:5:\"label\";s:16:\"purchase_payment\";s:4:\"link\";s:27:\"admin/purchase/all_payments\";s:4:\"icon\";s:16:\"icon-credit-card\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2019-05-05 13:53:11\";s:6:\"status\";s:1:\"1\";}i:133;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"155\";s:5:\"label\";s:17:\"purchase_settings\";s:4:\"link\";s:23:\"admin/settings/purchase\";s:4:\"icon\";s:18:\"fa-fw icon-handbag\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"12\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:134;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"156\";s:5:\"label\";s:11:\"credit_note\";s:4:\"link\";s:17:\"admin/credit_note\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-06-10 02:32:05\";s:6:\"status\";s:1:\"1\";}i:135;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"157\";s:5:\"label\";s:20:\"credit_note_settings\";s:4:\"link\";s:26:\"admin/settings/credit_note\";s:4:\"icon\";s:17:\"fa fa-fw fa-money\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"9\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:136;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"158\";s:5:\"label\";s:18:\"proposals_settings\";s:4:\"link\";s:24:\"admin/settings/proposals\";s:4:\"icon\";s:16:\"fa fa-fw fa-leaf\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"11\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:137;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"159\";s:5:\"label\";s:17:\"projects_settings\";s:4:\"link\";s:23:\"admin/settings/projects\";s:4:\"icon\";s:25:\"fa fa-fw fa-folder-open-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"13\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:138;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"160\";s:5:\"label\";s:4:\"tags\";s:4:\"link\";s:19:\"admin/settings/tags\";s:4:\"icon\";s:16:\"fa fa-fw fa-tags\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"30\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:139;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"161\";s:5:\"label\";s:9:\"lead_form\";s:4:\"link\";s:25:\"admin/leads/all_lead_form\";s:4:\"icon\";s:18:\"fa fa-fw fa-rocket\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"18\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:140;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"162\";s:5:\"label\";s:21:\"transactions_settings\";s:4:\"link\";s:27:\"admin/settings/transactions\";s:4:\"icon\";s:22:\"fa fa-fw fa-building-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"15\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:141;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"163\";s:5:\"label\";s:12:\"sms_settings\";s:4:\"link\";s:27:\"admin/settings/sms_settings\";s:4:\"icon\";s:20:\"fa fa-fw fa-envelope\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2021-07-30 06:18:08\";s:6:\"status\";s:1:\"2\";}i:142;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"164\";s:5:\"label\";s:9:\"pos_sales\";s:4:\"link\";s:23:\"admin/invoice/pos_sales\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2021-10-16 00:53:10\";s:6:\"status\";s:1:\"1\";}i:143;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"186\";s:5:\"label\";s:9:\"warehouse\";s:4:\"link\";s:22:\"admin/warehouse/manage\";s:4:\"icon\";s:16:\"fa fa-building-o\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2021-10-18 09:24:24\";s:6:\"status\";s:1:\"1\";}i:144;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"187\";s:5:\"label\";s:12:\"transferItem\";s:4:\"link\";s:24:\"admin/items/transferItem\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2021-10-14 11:56:08\";s:6:\"status\";s:1:\"1\";}i:145;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"203\";s:5:\"label\";s:13:\"award_setting\";s:4:\"link\";s:20:\"admin/settings/award\";s:4:\"icon\";s:10:\"fa fa-star\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"30\";s:4:\"time\";s:19:\"2022-01-19 05:51:40\";s:6:\"status\";s:1:\"2\";}i:146;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"204\";s:5:\"label\";s:18:\"award_rule_setting\";s:4:\"link\";s:34:\"admin/settings/award_rule_settingh\";s:4:\"icon\";s:10:\"fa fa-star\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"31\";s:4:\"time\";s:19:\"2022-01-19 09:53:50\";s:6:\"status\";s:1:\"2\";}i:147;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"205\";s:5:\"label\";s:22:\"award_program_settings\";s:4:\"link\";s:37:\"admin/settings/award_program_settings\";s:4:\"icon\";s:9:\"fa fa-cog\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"32\";s:4:\"time\";s:19:\"2022-01-20 09:17:30\";s:6:\"status\";s:1:\"2\";}i:148;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"206\";s:5:\"label\";s:19:\"client_award_points\";s:4:\"link\";s:27:\"admin/invoice/client_awards\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2022-01-21 01:39:41\";s:6:\"status\";s:1:\"1\";}i:149;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"207\";s:5:\"label\";s:20:\"best_selling_product\";s:4:\"link\";s:18:\"admin/best_selling\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:2:\"11\";s:4:\"time\";s:19:\"2022-01-21 06:43:52\";s:6:\"status\";s:1:\"1\";}i:150;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"209\";s:5:\"label\";s:7:\"warning\";s:4:\"link\";s:13:\"admin/warning\";s:4:\"icon\";s:13:\"fa fa-warning\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2022-08-07 12:47:01\";s:6:\"status\";s:1:\"1\";}i:151;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"210\";s:5:\"label\";s:9:\"promotion\";s:4:\"link\";s:15:\"admin/promotion\";s:4:\"icon\";s:21:\"fa fa-arrow-circle-up\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2022-08-07 12:49:28\";s:6:\"status\";s:1:\"1\";}i:152;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"211\";s:5:\"label\";s:11:\"termination\";s:4:\"link\";s:17:\"admin/termination\";s:4:\"icon\";s:12:\"fa fa-eraser\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2022-08-07 12:50:45\";s:6:\"status\";s:1:\"1\";}i:153;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"212\";s:5:\"label\";s:11:\"resignation\";s:4:\"link\";s:17:\"admin/resignation\";s:4:\"icon\";s:14:\"fa fa-scissors\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2022-08-07 12:54:31\";s:6:\"status\";s:1:\"1\";}}');
INSERT INTO `tbl_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('13297d556296c8772799354294286f21ea9db05c', '44.203.16.55', 1688895699, '__ci_last_regenerate|i:1688895699;menu_active_id|a:2:{i:0;s:3:\"109\";i:1;s:1:\"0\";}');
INSERT INTO `tbl_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1c54d5c779c5a3d53cc4df7553df2908973799ef', '136.158.121.2', 1689211462, '__ci_last_regenerate|i:1689152842;user_name|s:5:\"nimda\";email|s:26:\"erick@blickcreative.com.au\";name|s:13:\"Erick Villeta\";photo|s:26:\"uploads/default_avatar.jpg\";user_id|s:1:\"5\";last_login|s:19:\"2023-07-12 15:15:45\";online_time|i:1689139101;loggedin|b:1;user_type|s:1:\"1\";user_flag|s:1:\"1\";direction|s:3:\"ltr\";warehouse_id|N;designations_id|s:1:\"0\";url|s:35:\"admin/invoice/clientawardpointslist\";menu_active_id|a:3:{i:0;s:3:\"206\";i:1;s:2:\"12\";i:2;s:1:\"0\";}user_roll|a:10:{i:0;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"1\";s:5:\"label\";s:9:\"dashboard\";s:4:\"link\";s:15:\"admin/dashboard\";s:4:\"icon\";s:15:\"fa fa-dashboard\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-04-23 01:39:36\";s:6:\"status\";s:1:\"1\";}i:1;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"2\";s:5:\"label\";s:8:\"calendar\";s:4:\"link\";s:14:\"admin/calendar\";s:4:\"icon\";s:14:\"fa fa-calendar\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-23 19:57:23\";s:6:\"status\";s:1:\"1\";}i:2;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"4\";s:5:\"label\";s:6:\"client\";s:4:\"link\";s:26:\"admin/client/manage_client\";s:4:\"icon\";s:11:\"fa fa-users\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"13\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:3;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"5\";s:5:\"label\";s:7:\"mailbox\";s:4:\"link\";s:13:\"admin/mailbox\";s:4:\"icon\";s:16:\"fa fa-envelope-o\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:4;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"6\";s:5:\"label\";s:7:\"tickets\";s:4:\"link\";s:13:\"admin/tickets\";s:4:\"icon\";s:12:\"fa fa-ticket\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2018-06-08 13:39:39\";s:6:\"status\";s:1:\"1\";}i:5;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"12\";s:5:\"label\";s:5:\"sales\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:19:\"fa fa-shopping-cart\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"9\";s:4:\"time\";s:19:\"2017-06-10 14:02:58\";s:6:\"status\";s:1:\"1\";}i:6;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"13\";s:5:\"label\";s:7:\"invoice\";s:4:\"link\";s:28:\"admin/invoice/manage_invoice\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-04-23 19:57:23\";s:6:\"status\";s:1:\"1\";}i:7;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"14\";s:5:\"label\";s:9:\"estimates\";s:4:\"link\";s:15:\"admin/estimates\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-06-10 14:02:05\";s:6:\"status\";s:1:\"1\";}i:8;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"15\";s:5:\"label\";s:17:\"payments_received\";s:4:\"link\";s:26:\"admin/invoice/all_payments\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-23 19:57:24\";s:6:\"status\";s:1:\"1\";}i:9;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"16\";s:5:\"label\";s:9:\"tax_rates\";s:4:\"link\";s:23:\"admin/invoice/tax_rates\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-01-07 07:05:16\";s:6:\"status\";s:1:\"1\";}}');
INSERT INTO `tbl_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1e9abe3fd111fc779c706d4ef39fd54d5eb6bdab', '136.158.120.226', 1688544329, '__ci_last_regenerate|i:1688544329;menu_active_id|a:2:{i:0;s:3:\"109\";i:1;s:1:\"0\";}');
INSERT INTO `tbl_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('22b6f24a58106fd2f9ebefd7477d0c7b79a9bb13', '51.255.62.4', 1689123389, '__ci_last_regenerate|i:1689123389;menu_active_id|a:2:{i:0;s:3:\"109\";i:1;s:1:\"0\";}');
INSERT INTO `tbl_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('241a675e69d7cd01d19f56840aaa1a40997da4d9', '136.158.121.2', 1689152842, '__ci_last_regenerate|i:1689152842;user_name|s:5:\"nimda\";email|s:26:\"erick@blickcreative.com.au\";name|s:13:\"Erick Villeta\";photo|s:26:\"uploads/default_avatar.jpg\";user_id|s:1:\"5\";last_login|s:19:\"2023-07-12 15:15:45\";online_time|i:1689139101;loggedin|b:1;user_type|s:1:\"1\";user_flag|s:1:\"1\";direction|s:3:\"ltr\";warehouse_id|N;designations_id|s:1:\"0\";url|s:33:\"admin/dashboard/recent_activities\";menu_active_id|a:2:{i:0;s:1:\"1\";i:1;s:1:\"0\";}user_roll|a:154:{i:0;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"1\";s:5:\"label\";s:9:\"dashboard\";s:4:\"link\";s:15:\"admin/dashboard\";s:4:\"icon\";s:15:\"fa fa-dashboard\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-04-23 01:39:36\";s:6:\"status\";s:1:\"1\";}i:1;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"2\";s:5:\"label\";s:8:\"calendar\";s:4:\"link\";s:14:\"admin/calendar\";s:4:\"icon\";s:14:\"fa fa-calendar\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-23 19:57:23\";s:6:\"status\";s:1:\"1\";}i:2;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"4\";s:5:\"label\";s:6:\"client\";s:4:\"link\";s:26:\"admin/client/manage_client\";s:4:\"icon\";s:11:\"fa fa-users\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"13\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:3;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"5\";s:5:\"label\";s:7:\"mailbox\";s:4:\"link\";s:13:\"admin/mailbox\";s:4:\"icon\";s:16:\"fa fa-envelope-o\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:4;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"6\";s:5:\"label\";s:7:\"tickets\";s:4:\"link\";s:13:\"admin/tickets\";s:4:\"icon\";s:12:\"fa fa-ticket\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2018-06-08 13:39:39\";s:6:\"status\";s:1:\"1\";}i:5;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"12\";s:5:\"label\";s:5:\"sales\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:19:\"fa fa-shopping-cart\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"9\";s:4:\"time\";s:19:\"2017-06-10 14:02:58\";s:6:\"status\";s:1:\"1\";}i:6;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"13\";s:5:\"label\";s:7:\"invoice\";s:4:\"link\";s:28:\"admin/invoice/manage_invoice\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-04-23 19:57:23\";s:6:\"status\";s:1:\"1\";}i:7;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"14\";s:5:\"label\";s:9:\"estimates\";s:4:\"link\";s:15:\"admin/estimates\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-06-10 14:02:05\";s:6:\"status\";s:1:\"1\";}i:8;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"15\";s:5:\"label\";s:17:\"payments_received\";s:4:\"link\";s:26:\"admin/invoice/all_payments\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-23 19:57:24\";s:6:\"status\";s:1:\"1\";}i:9;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"16\";s:5:\"label\";s:9:\"tax_rates\";s:4:\"link\";s:23:\"admin/invoice/tax_rates\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-01-07 07:05:16\";s:6:\"status\";s:1:\"1\";}i:10;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"21\";s:5:\"label\";s:10:\"quotations\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:11:\"fa fa-paste\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:11;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"22\";s:5:\"label\";s:15:\"quotations_list\";s:4:\"link\";s:16:\"admin/quotations\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"21\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-05-18 16:49:03\";s:6:\"status\";s:1:\"1\";}i:12;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"23\";s:5:\"label\";s:15:\"quotations_form\";s:4:\"link\";s:32:\"admin/quotations/quotations_form\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"21\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:13;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"24\";s:5:\"label\";s:4:\"user\";s:4:\"link\";s:20:\"admin/user/user_list\";s:4:\"icon\";s:11:\"fa fa-users\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"25\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:14;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"25\";s:5:\"label\";s:8:\"settings\";s:4:\"link\";s:14:\"admin/settings\";s:4:\"icon\";s:10:\"fa fa-cogs\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"26\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:15;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"26\";s:5:\"label\";s:15:\"database_backup\";s:4:\"link\";s:30:\"admin/settings/database_backup\";s:4:\"icon\";s:14:\"fa fa-database\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"27\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:16;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"29\";s:5:\"label\";s:17:\"transactions_menu\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:16:\"fa fa-building-o\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"12\";s:4:\"time\";s:19:\"2018-05-13 12:27:58\";s:6:\"status\";s:1:\"1\";}i:17;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"30\";s:5:\"label\";s:7:\"deposit\";s:4:\"link\";s:26:\"admin/transactions/deposit\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-05-13 12:28:33\";s:6:\"status\";s:1:\"1\";}i:18;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"31\";s:5:\"label\";s:7:\"expense\";s:4:\"link\";s:26:\"admin/transactions/expense\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-05-13 12:28:37\";s:6:\"status\";s:1:\"1\";}i:19;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"32\";s:5:\"label\";s:8:\"transfer\";s:4:\"link\";s:27:\"admin/transactions/transfer\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-05-13 12:28:40\";s:6:\"status\";s:1:\"1\";}i:20;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"33\";s:5:\"label\";s:19:\"transactions_report\";s:4:\"link\";s:38:\"admin/transactions/transactions_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2018-05-13 12:28:44\";s:6:\"status\";s:1:\"1\";}i:21;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"34\";s:5:\"label\";s:13:\"balance_sheet\";s:4:\"link\";s:32:\"admin/transactions/balance_sheet\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-05-13 12:28:47\";s:6:\"status\";s:1:\"1\";}i:22;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"36\";s:5:\"label\";s:9:\"bank_cash\";s:4:\"link\";s:28:\"admin/account/manage_account\";s:4:\"icon\";s:11:\"fa fa-money\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2018-05-13 12:28:51\";s:6:\"status\";s:1:\"1\";}i:23;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"39\";s:5:\"label\";s:5:\"items\";s:4:\"link\";s:22:\"admin/items/items_list\";s:4:\"icon\";s:10:\"fa fa-cube\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2019-05-04 18:49:50\";s:6:\"status\";s:1:\"1\";}i:24;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"42\";s:5:\"label\";s:6:\"report\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:15:\"fa fa-bar-chart\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"24\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:25;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"43\";s:5:\"label\";s:17:\"account_statement\";s:4:\"link\";s:30:\"admin/report/account_statement\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:26;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"44\";s:5:\"label\";s:13:\"income_report\";s:4:\"link\";s:26:\"admin/report/income_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:27;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"45\";s:5:\"label\";s:14:\"expense_report\";s:4:\"link\";s:27:\"admin/report/expense_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:28;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"46\";s:5:\"label\";s:14:\"income_expense\";s:4:\"link\";s:27:\"admin/report/income_expense\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:29;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"47\";s:5:\"label\";s:16:\"date_wise_report\";s:4:\"link\";s:29:\"admin/report/date_wise_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:30;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"48\";s:5:\"label\";s:10:\"all_income\";s:4:\"link\";s:23:\"admin/report/all_income\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:31;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"49\";s:5:\"label\";s:11:\"all_expense\";s:4:\"link\";s:24:\"admin/report/all_expense\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:32;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"50\";s:5:\"label\";s:15:\"all_transaction\";s:4:\"link\";s:28:\"admin/report/all_transaction\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:33;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"51\";s:5:\"label\";s:17:\"recurring_invoice\";s:4:\"link\";s:31:\"admin/invoice/recurring_invoice\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-06-10 14:02:05\";s:6:\"status\";s:1:\"1\";}i:34;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"52\";s:5:\"label\";s:15:\"transfer_report\";s:4:\"link\";s:34:\"admin/transactions/transfer_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-05-13 12:28:59\";s:6:\"status\";s:1:\"1\";}i:35;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"53\";s:5:\"label\";s:15:\"report_by_month\";s:4:\"link\";s:28:\"admin/report/report_by_month\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:36;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"54\";s:5:\"label\";s:5:\"tasks\";s:4:\"link\";s:20:\"admin/tasks/all_task\";s:4:\"icon\";s:11:\"fa fa-tasks\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:37;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"55\";s:5:\"label\";s:5:\"leads\";s:4:\"link\";s:11:\"admin/leads\";s:4:\"icon\";s:12:\"fa fa-rocket\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:38;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"56\";s:5:\"label\";s:13:\"opportunities\";s:4:\"link\";s:19:\"admin/opportunities\";s:4:\"icon\";s:12:\"fa fa-filter\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:39;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"57\";s:5:\"label\";s:8:\"projects\";s:4:\"link\";s:14:\"admin/projects\";s:4:\"icon\";s:19:\"fa fa-folder-open-o\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:40;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"58\";s:5:\"label\";s:4:\"bugs\";s:4:\"link\";s:10:\"admin/bugs\";s:4:\"icon\";s:9:\"fa fa-bug\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:41;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"59\";s:5:\"label\";s:7:\"project\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:19:\"fa fa-folder-open-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:42;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"60\";s:5:\"label\";s:12:\"tasks_report\";s:4:\"link\";s:25:\"admin/report/tasks_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:43;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"61\";s:5:\"label\";s:11:\"bugs_report\";s:4:\"link\";s:24:\"admin/report/bugs_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:44;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"62\";s:5:\"label\";s:14:\"tickets_report\";s:4:\"link\";s:27:\"admin/report/tickets_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:45;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"63\";s:5:\"label\";s:13:\"client_report\";s:4:\"link\";s:26:\"admin/report/client_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2018-01-07 07:09:40\";s:6:\"status\";s:1:\"1\";}i:46;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"66\";s:5:\"label\";s:16:\"tasks_assignment\";s:4:\"link\";s:29:\"admin/report/tasks_assignment\";s:4:\"icon\";s:18:\"fa fa-dot-circle-o\";s:6:\"parent\";s:2:\"59\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:47;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"67\";s:5:\"label\";s:15:\"bugs_assignment\";s:4:\"link\";s:28:\"admin/report/bugs_assignment\";s:4:\"icon\";s:18:\"fa fa-dot-circle-o\";s:6:\"parent\";s:2:\"59\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:48;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"68\";s:5:\"label\";s:14:\"project_report\";s:4:\"link\";s:27:\"admin/report/project_report\";s:4:\"icon\";s:18:\"fa fa-dot-circle-o\";s:6:\"parent\";s:2:\"59\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:49;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"69\";s:5:\"label\";s:13:\"goal_tracking\";s:4:\"link\";s:19:\"admin/goal_tracking\";s:4:\"icon\";s:12:\"fa fa-shield\";s:6:\"parent\";s:2:\"73\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-06-10 14:05:47\";s:6:\"status\";s:1:\"1\";}i:50;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"70\";s:5:\"label\";s:11:\"departments\";s:4:\"link\";s:17:\"admin/departments\";s:4:\"icon\";s:17:\"fa fa-user-secret\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"14\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:51;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"71\";s:5:\"label\";s:7:\"holiday\";s:4:\"link\";s:13:\"admin/holiday\";s:4:\"icon\";s:21:\"fa fa-calendar-plus-o\";s:6:\"parent\";s:2:\"73\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-06-10 14:05:47\";s:6:\"status\";s:1:\"1\";}i:52;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"72\";s:5:\"label\";s:16:\"leave_management\";s:4:\"link\";s:22:\"admin/leave_management\";s:4:\"icon\";s:11:\"fa fa-plane\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"20\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:53;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"73\";s:5:\"label\";s:9:\"utilities\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:10:\"fa fa-gift\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"23\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:54;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"74\";s:5:\"label\";s:8:\"overtime\";s:4:\"link\";s:24:\"admin/utilities/overtime\";s:4:\"icon\";s:13:\"fa fa-clock-o\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"9\";s:4:\"time\";s:19:\"2017-06-10 14:04:23\";s:6:\"status\";s:1:\"1\";}i:55;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"75\";s:5:\"label\";s:12:\"office_stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:13:\"fa fa-codepen\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"15\";s:4:\"time\";s:19:\"2019-05-01 16:22:56\";s:6:\"status\";s:1:\"1\";}i:56;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"76\";s:5:\"label\";s:14:\"stock_category\";s:4:\"link\";s:26:\"admin/stock/stock_category\";s:4:\"icon\";s:13:\"fa fa-sliders\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:57;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"77\";s:5:\"label\";s:12:\"manage_stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:13:\"fa fa-archive\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-04-26 16:11:10\";s:6:\"status\";s:1:\"1\";}i:58;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"78\";s:5:\"label\";s:12:\"assign_stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:16:\"fa fa-align-left\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-26 16:11:10\";s:6:\"status\";s:1:\"1\";}i:59;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"79\";s:5:\"label\";s:12:\"stock_report\";s:4:\"link\";s:18:\"admin/stock/report\";s:4:\"icon\";s:16:\"fa fa-line-chart\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2017-04-25 18:48:25\";s:6:\"status\";s:1:\"1\";}i:60;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"81\";s:5:\"label\";s:10:\"stock_list\";s:4:\"link\";s:22:\"admin/stock/stock_list\";s:4:\"icon\";s:20:\"fa fa-stack-exchange\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-26 16:11:10\";s:6:\"status\";s:1:\"1\";}i:61;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"82\";s:5:\"label\";s:12:\"assign_stock\";s:4:\"link\";s:24:\"admin/stock/assign_stock\";s:4:\"icon\";s:16:\"fa fa-align-left\";s:6:\"parent\";s:2:\"78\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:62;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"83\";s:5:\"label\";s:19:\"assign_stock_report\";s:4:\"link\";s:31:\"admin/stock/assign_stock_report\";s:4:\"icon\";s:15:\"fa fa-bar-chart\";s:6:\"parent\";s:2:\"78\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:63;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"84\";s:5:\"label\";s:13:\"stock_history\";s:4:\"link\";s:25:\"admin/stock/stock_history\";s:4:\"icon\";s:17:\"fa fa-file-text-o\";s:6:\"parent\";s:2:\"77\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:64;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"85\";s:5:\"label\";s:11:\"performance\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:14:\"fa fa-dribbble\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"19\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:65;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"86\";s:5:\"label\";s:21:\"performance_indicator\";s:4:\"link\";s:39:\"admin/performance/performance_indicator\";s:4:\"icon\";s:12:\"fa fa-random\";s:6:\"parent\";s:2:\"85\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:66;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"87\";s:5:\"label\";s:18:\"performance_report\";s:4:\"link\";s:36:\"admin/performance/performance_report\";s:4:\"icon\";s:16:\"fa fa-calendar-o\";s:6:\"parent\";s:2:\"85\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:67;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"88\";s:5:\"label\";s:14:\"give_appraisal\";s:4:\"link\";s:44:\"admin/performance/give_performance_appraisal\";s:4:\"icon\";s:10:\"fa fa-plus\";s:6:\"parent\";s:2:\"85\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:68;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"89\";s:5:\"label\";s:7:\"payroll\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:9:\"fa fa-usd\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"18\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:69;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"90\";s:5:\"label\";s:21:\"manage_salary_details\";s:4:\"link\";s:35:\"admin/payroll/manage_salary_details\";s:4:\"icon\";s:9:\"fa fa-usd\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:70;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"91\";s:5:\"label\";s:20:\"employee_salary_list\";s:4:\"link\";s:34:\"admin/payroll/employee_salary_list\";s:4:\"icon\";s:17:\"fa fa-user-secret\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:71;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"92\";s:5:\"label\";s:12:\"make_payment\";s:4:\"link\";s:26:\"admin/payroll/make_payment\";s:4:\"icon\";s:11:\"fa fa-tasks\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:72;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"93\";s:5:\"label\";s:16:\"generate_payslip\";s:4:\"link\";s:30:\"admin/payroll/generate_payslip\";s:4:\"icon\";s:13:\"fa fa-list-ul\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:73;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"94\";s:5:\"label\";s:15:\"salary_template\";s:4:\"link\";s:29:\"admin/payroll/salary_template\";s:4:\"icon\";s:11:\"fa fa-money\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:74;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"95\";s:5:\"label\";s:11:\"hourly_rate\";s:4:\"link\";s:25:\"admin/payroll/hourly_rate\";s:4:\"icon\";s:13:\"fa fa-clock-o\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:75;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"96\";s:5:\"label\";s:15:\"payroll_summary\";s:4:\"link\";s:29:\"admin/payroll/payroll_summary\";s:4:\"icon\";s:18:\"fa fa-camera-retro\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:76;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"97\";s:5:\"label\";s:14:\"provident_fund\";s:4:\"link\";s:28:\"admin/payroll/provident_fund\";s:4:\"icon\";s:15:\"fa fa-briefcase\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2017-06-10 14:04:23\";s:6:\"status\";s:1:\"1\";}i:77;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"98\";s:5:\"label\";s:14:\"advance_salary\";s:4:\"link\";s:28:\"admin/payroll/advance_salary\";s:4:\"icon\";s:19:\"fa fa-cc-mastercard\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2017-06-10 14:04:23\";s:6:\"status\";s:1:\"1\";}i:78;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"99\";s:5:\"label\";s:14:\"employee_award\";s:4:\"link\";s:11:\"admin/award\";s:4:\"icon\";s:12:\"fa fa-trophy\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2017-06-10 14:05:47\";s:6:\"status\";s:1:\"1\";}i:79;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"100\";s:5:\"label\";s:13:\"announcements\";s:4:\"link\";s:19:\"admin/announcements\";s:4:\"icon\";s:19:\"fa fa-bullhorn icon\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"22\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:80;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"101\";s:5:\"label\";s:8:\"training\";s:4:\"link\";s:14:\"admin/training\";s:4:\"icon\";s:14:\"fa fa-suitcase\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"21\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:81;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"102\";s:5:\"label\";s:12:\"job_circular\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:11:\"fa fa-globe\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"17\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:82;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"103\";s:5:\"label\";s:11:\"jobs_posted\";s:4:\"link\";s:30:\"admin/job_circular/jobs_posted\";s:4:\"icon\";s:12:\"fa fa-ticket\";s:6:\"parent\";s:3:\"102\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:83;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"104\";s:5:\"label\";s:17:\"jobs_applications\";s:4:\"link\";s:36:\"admin/job_circular/jobs_applications\";s:4:\"icon\";s:13:\"fa fa-compass\";s:6:\"parent\";s:3:\"102\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:84;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"105\";s:5:\"label\";s:10:\"attendance\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:15:\"fa fa-file-text\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"16\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:85;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"106\";s:5:\"label\";s:18:\"timechange_request\";s:4:\"link\";s:35:\"admin/attendance/timechange_request\";s:4:\"icon\";s:16:\"fa fa-calendar-o\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:86;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"107\";s:5:\"label\";s:17:\"attendance_report\";s:4:\"link\";s:34:\"admin/attendance/attendance_report\";s:4:\"icon\";s:15:\"fa fa-file-text\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:87;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"108\";s:5:\"label\";s:12:\"time_history\";s:4:\"link\";s:29:\"admin/attendance/time_history\";s:4:\"icon\";s:13:\"fa fa-clock-o\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:88;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"109\";s:5:\"label\";s:9:\"pull-down\";s:4:\"link\";s:0:\"\";s:4:\"icon\";s:0:\"\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-31 12:43:20\";s:6:\"status\";s:1:\"0\";}i:89;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"110\";s:5:\"label\";s:11:\"filemanager\";s:4:\"link\";s:17:\"admin/filemanager\";s:4:\"icon\";s:10:\"fa fa-file\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:90;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"111\";s:5:\"label\";s:15:\"company_details\";s:4:\"link\";s:14:\"admin/settings\";s:4:\"icon\";s:23:\"fa fa-fw fa-info-circle\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-25 17:08:46\";s:6:\"status\";s:1:\"2\";}i:91;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"112\";s:5:\"label\";s:15:\"system_settings\";s:4:\"link\";s:21:\"admin/settings/system\";s:4:\"icon\";s:19:\"fa fa-fw fa-desktop\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-04-25 17:08:46\";s:6:\"status\";s:1:\"2\";}i:92;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"113\";s:5:\"label\";s:14:\"email_settings\";s:4:\"link\";s:20:\"admin/settings/email\";s:4:\"icon\";s:20:\"fa fa-fw fa-envelope\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-25 17:08:46\";s:6:\"status\";s:1:\"2\";}i:93;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"114\";s:5:\"label\";s:15:\"email_templates\";s:4:\"link\";s:24:\"admin/settings/templates\";s:4:\"icon\";s:25:\"fa fa-fw fa-pencil-square\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2021-07-30 06:18:08\";s:6:\"status\";s:1:\"2\";}i:94;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"115\";s:5:\"label\";s:17:\"email_integration\";s:4:\"link\";s:32:\"admin/settings/email_integration\";s:4:\"icon\";s:22:\"fa fa-fw fa-envelope-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2021-07-30 06:18:08\";s:6:\"status\";s:1:\"2\";}i:95;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"116\";s:5:\"label\";s:16:\"payment_settings\";s:4:\"link\";s:23:\"admin/settings/payments\";s:4:\"icon\";s:18:\"fa fa-fw fa-dollar\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:96;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"117\";s:5:\"label\";s:16:\"invoice_settings\";s:4:\"link\";s:22:\"admin/settings/invoice\";s:4:\"icon\";s:17:\"fa fa-fw fa-money\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:97;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"118\";s:5:\"label\";s:17:\"estimate_settings\";s:4:\"link\";s:23:\"admin/settings/estimate\";s:4:\"icon\";s:18:\"fa fa-fw fa-file-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:98;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"119\";s:5:\"label\";s:22:\"tickets_leads_settings\";s:4:\"link\";s:22:\"admin/settings/tickets\";s:4:\"icon\";s:18:\"fa fa-fw fa-ticket\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"14\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:99;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"120\";s:5:\"label\";s:14:\"theme_settings\";s:4:\"link\";s:20:\"admin/settings/theme\";s:4:\"icon\";s:16:\"fa fa-fw fa-code\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"20\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:100;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"121\";s:5:\"label\";s:12:\"working_days\";s:4:\"link\";s:27:\"admin/settings/working_days\";s:4:\"icon\";s:20:\"fa fa-fw fa-calendar\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"22\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:101;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"122\";s:5:\"label\";s:14:\"leave_category\";s:4:\"link\";s:29:\"admin/settings/leave_category\";s:4:\"icon\";s:21:\"fa fa-fw fa-pagelines\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"23\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:102;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"123\";s:5:\"label\";s:15:\"income_category\";s:4:\"link\";s:30:\"admin/settings/income_category\";s:4:\"icon\";s:23:\"fa fa-fw fa-certificate\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"24\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:103;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"124\";s:5:\"label\";s:16:\"expense_category\";s:4:\"link\";s:31:\"admin/settings/expense_category\";s:4:\"icon\";s:17:\"fa fa-fw fa-tasks\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"25\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:104;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"125\";s:5:\"label\";s:14:\"customer_group\";s:4:\"link\";s:29:\"admin/settings/customer_group\";s:4:\"icon\";s:17:\"fa fa-fw fa-users\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"26\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:105;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"127\";s:5:\"label\";s:11:\"lead_status\";s:4:\"link\";s:26:\"admin/settings/lead_status\";s:4:\"icon\";s:19:\"fa fa-fw fa-list-ul\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"16\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:106;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"128\";s:5:\"label\";s:11:\"lead_source\";s:4:\"link\";s:26:\"admin/settings/lead_source\";s:4:\"icon\";s:22:\"fa fa-fw fa-arrow-down\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"17\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:107;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"129\";s:5:\"label\";s:26:\"opportunities_state_reason\";s:4:\"link\";s:41:\"admin/settings/opportunities_state_reason\";s:4:\"icon\";s:24:\"fa fa-fw fa-dot-circle-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"19\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:108;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"130\";s:5:\"label\";s:12:\"custom_field\";s:4:\"link\";s:27:\"admin/settings/custom_field\";s:4:\"icon\";s:18:\"fa fa-fw fa-star-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"28\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:109;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"131\";s:5:\"label\";s:14:\"payment_method\";s:4:\"link\";s:29:\"admin/settings/payment_method\";s:4:\"icon\";s:17:\"fa fa-fw fa-money\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"29\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:110;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"132\";s:5:\"label\";s:7:\"cronjob\";s:4:\"link\";s:22:\"admin/settings/cronjob\";s:4:\"icon\";s:18:\"fa fa-fw fa-contao\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"31\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:111;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"133\";s:5:\"label\";s:15:\"menu_allocation\";s:4:\"link\";s:30:\"admin/settings/menu_allocation\";s:4:\"icon\";s:22:\"fa fa-fw fa fa-compass\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"32\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:112;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"134\";s:5:\"label\";s:12:\"notification\";s:4:\"link\";s:27:\"admin/settings/notification\";s:4:\"icon\";s:18:\"fa fa-fw fa-bell-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"33\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:113;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"135\";s:5:\"label\";s:18:\"email_notification\";s:4:\"link\";s:33:\"admin/settings/email_notification\";s:4:\"icon\";s:18:\"fa fa-fw fa-bell-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"34\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:114;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"136\";s:5:\"label\";s:15:\"database_backup\";s:4:\"link\";s:30:\"admin/settings/database_backup\";s:4:\"icon\";s:20:\"fa fa-fw fa-database\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"35\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:115;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"137\";s:5:\"label\";s:12:\"translations\";s:4:\"link\";s:27:\"admin/settings/translations\";s:4:\"icon\";s:20:\"fa fa-fw fa-language\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"36\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:116;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"138\";s:5:\"label\";s:13:\"system_update\";s:4:\"link\";s:28:\"admin/settings/system_update\";s:4:\"icon\";s:27:\"fa fa-fw fa-pencil-square-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"37\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:117;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"139\";s:5:\"label\";s:12:\"private_chat\";s:4:\"link\";s:18:\"chat/conversations\";s:4:\"icon\";s:14:\"fa fa-envelope\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"28\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:118;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"140\";s:5:\"label\";s:9:\"proposals\";s:4:\"link\";s:15:\"admin/proposals\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-01-07 07:05:16\";s:6:\"status\";s:1:\"1\";}i:119;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"141\";s:5:\"label\";s:13:\"knowledgebase\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:21:\"fa fa-question-circle\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"11\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:120;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"142\";s:5:\"label\";s:10:\"categories\";s:4:\"link\";s:30:\"admin/knowledgebase/categories\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"141\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:121;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"143\";s:5:\"label\";s:8:\"articles\";s:4:\"link\";s:28:\"admin/knowledgebase/articles\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"141\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:122;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"144\";s:5:\"label\";s:13:\"knowledgebase\";s:4:\"link\";s:19:\"admin/knowledgebase\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"141\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:123;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"145\";s:5:\"label\";s:18:\"dashboard_settings\";s:4:\"link\";s:24:\"admin/settings/dashboard\";s:4:\"icon\";s:21:\"fa fa-fw fa-dashboard\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"21\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:124;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"146\";s:5:\"label\";s:20:\"transactions_reports\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:16:\"fa fa-building-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-05-13 12:29:51\";s:6:\"status\";s:1:\"1\";}i:125;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"147\";s:5:\"label\";s:5:\"sales\";s:4:\"link\";s:25:\"admin/report/sales_report\";s:4:\"icon\";s:19:\"fa fa-shopping-cart\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-01-07 01:12:23\";s:6:\"status\";s:1:\"1\";}i:126;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"148\";s:5:\"label\";s:15:\"mark_attendance\";s:4:\"link\";s:21:\"admin/mark_attendance\";s:4:\"icon\";s:15:\"fa fa-file-text\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-03-07 06:45:25\";s:6:\"status\";s:1:\"1\";}i:127;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"149\";s:5:\"label\";s:10:\"allowed_ip\";s:4:\"link\";s:25:\"admin/settings/allowed_ip\";s:4:\"icon\";s:12:\"fa fa-server\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"27\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:128;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"150\";s:5:\"label\";s:5:\"stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:11:\"icon-layers\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2019-05-01 18:10:52\";s:6:\"status\";s:1:\"1\";}i:129;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"151\";s:5:\"label\";s:8:\"supplier\";s:4:\"link\";s:14:\"admin/supplier\";s:4:\"icon\";s:14:\"icon-briefcase\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2019-05-01 18:10:52\";s:6:\"status\";s:1:\"1\";}i:130;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"152\";s:5:\"label\";s:8:\"purchase\";s:4:\"link\";s:14:\"admin/purchase\";s:4:\"icon\";s:12:\"icon-handbag\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2019-05-01 18:10:52\";s:6:\"status\";s:1:\"1\";}i:131;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"153\";s:5:\"label\";s:12:\"return_stock\";s:4:\"link\";s:18:\"admin/return_stock\";s:4:\"icon\";s:14:\"icon-share-alt\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2019-05-05 16:19:30\";s:6:\"status\";s:1:\"1\";}i:132;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"154\";s:5:\"label\";s:16:\"purchase_payment\";s:4:\"link\";s:27:\"admin/purchase/all_payments\";s:4:\"icon\";s:16:\"icon-credit-card\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2019-05-05 13:53:11\";s:6:\"status\";s:1:\"1\";}i:133;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"155\";s:5:\"label\";s:17:\"purchase_settings\";s:4:\"link\";s:23:\"admin/settings/purchase\";s:4:\"icon\";s:18:\"fa-fw icon-handbag\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"12\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:134;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"156\";s:5:\"label\";s:11:\"credit_note\";s:4:\"link\";s:17:\"admin/credit_note\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-06-10 02:32:05\";s:6:\"status\";s:1:\"1\";}i:135;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"157\";s:5:\"label\";s:20:\"credit_note_settings\";s:4:\"link\";s:26:\"admin/settings/credit_note\";s:4:\"icon\";s:17:\"fa fa-fw fa-money\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"9\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:136;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"158\";s:5:\"label\";s:18:\"proposals_settings\";s:4:\"link\";s:24:\"admin/settings/proposals\";s:4:\"icon\";s:16:\"fa fa-fw fa-leaf\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"11\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:137;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"159\";s:5:\"label\";s:17:\"projects_settings\";s:4:\"link\";s:23:\"admin/settings/projects\";s:4:\"icon\";s:25:\"fa fa-fw fa-folder-open-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"13\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:138;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"160\";s:5:\"label\";s:4:\"tags\";s:4:\"link\";s:19:\"admin/settings/tags\";s:4:\"icon\";s:16:\"fa fa-fw fa-tags\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"30\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:139;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"161\";s:5:\"label\";s:9:\"lead_form\";s:4:\"link\";s:25:\"admin/leads/all_lead_form\";s:4:\"icon\";s:18:\"fa fa-fw fa-rocket\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"18\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:140;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"162\";s:5:\"label\";s:21:\"transactions_settings\";s:4:\"link\";s:27:\"admin/settings/transactions\";s:4:\"icon\";s:22:\"fa fa-fw fa-building-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"15\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:141;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"163\";s:5:\"label\";s:12:\"sms_settings\";s:4:\"link\";s:27:\"admin/settings/sms_settings\";s:4:\"icon\";s:20:\"fa fa-fw fa-envelope\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2021-07-30 06:18:08\";s:6:\"status\";s:1:\"2\";}i:142;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"164\";s:5:\"label\";s:9:\"pos_sales\";s:4:\"link\";s:23:\"admin/invoice/pos_sales\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2021-10-16 00:53:10\";s:6:\"status\";s:1:\"1\";}i:143;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"186\";s:5:\"label\";s:9:\"warehouse\";s:4:\"link\";s:22:\"admin/warehouse/manage\";s:4:\"icon\";s:16:\"fa fa-building-o\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2021-10-18 09:24:24\";s:6:\"status\";s:1:\"1\";}i:144;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"187\";s:5:\"label\";s:12:\"transferItem\";s:4:\"link\";s:24:\"admin/items/transferItem\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2021-10-14 11:56:08\";s:6:\"status\";s:1:\"1\";}i:145;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"203\";s:5:\"label\";s:13:\"award_setting\";s:4:\"link\";s:20:\"admin/settings/award\";s:4:\"icon\";s:10:\"fa fa-star\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"30\";s:4:\"time\";s:19:\"2022-01-19 05:51:40\";s:6:\"status\";s:1:\"2\";}i:146;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"204\";s:5:\"label\";s:18:\"award_rule_setting\";s:4:\"link\";s:34:\"admin/settings/award_rule_settingh\";s:4:\"icon\";s:10:\"fa fa-star\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"31\";s:4:\"time\";s:19:\"2022-01-19 09:53:50\";s:6:\"status\";s:1:\"2\";}i:147;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"205\";s:5:\"label\";s:22:\"award_program_settings\";s:4:\"link\";s:37:\"admin/settings/award_program_settings\";s:4:\"icon\";s:9:\"fa fa-cog\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"32\";s:4:\"time\";s:19:\"2022-01-20 09:17:30\";s:6:\"status\";s:1:\"2\";}i:148;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"206\";s:5:\"label\";s:19:\"client_award_points\";s:4:\"link\";s:27:\"admin/invoice/client_awards\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2022-01-21 01:39:41\";s:6:\"status\";s:1:\"1\";}i:149;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"207\";s:5:\"label\";s:20:\"best_selling_product\";s:4:\"link\";s:18:\"admin/best_selling\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:2:\"11\";s:4:\"time\";s:19:\"2022-01-21 06:43:52\";s:6:\"status\";s:1:\"1\";}i:150;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"209\";s:5:\"label\";s:7:\"warning\";s:4:\"link\";s:13:\"admin/warning\";s:4:\"icon\";s:13:\"fa fa-warning\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2022-08-07 12:47:01\";s:6:\"status\";s:1:\"1\";}i:151;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"210\";s:5:\"label\";s:9:\"promotion\";s:4:\"link\";s:15:\"admin/promotion\";s:4:\"icon\";s:21:\"fa fa-arrow-circle-up\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2022-08-07 12:49:28\";s:6:\"status\";s:1:\"1\";}i:152;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"211\";s:5:\"label\";s:11:\"termination\";s:4:\"link\";s:17:\"admin/termination\";s:4:\"icon\";s:12:\"fa fa-eraser\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2022-08-07 12:50:45\";s:6:\"status\";s:1:\"1\";}i:153;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"212\";s:5:\"label\";s:11:\"resignation\";s:4:\"link\";s:17:\"admin/resignation\";s:4:\"icon\";s:14:\"fa fa-scissors\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2022-08-07 12:54:31\";s:6:\"status\";s:1:\"1\";}}');
INSERT INTO `tbl_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('243df47d69e47362653558e02ac8c8174df8b01f', '136.158.120.226', 1688284598, '__ci_last_regenerate|i:1688284598;user_name|s:5:\"nimda\";email|s:26:\"erick@blickcreative.com.au\";name|s:13:\"Erick Villeta\";photo|s:26:\"uploads/default_avatar.jpg\";user_id|s:1:\"5\";last_login|N;online_time|i:1688282710;loggedin|b:1;user_type|s:1:\"1\";user_flag|s:1:\"1\";direction|s:3:\"ltr\";warehouse_id|N;designations_id|s:1:\"0\";url|s:33:\"admin/dashboard/pinned_menu_items\";menu_active_id|a:3:{i:0;s:3:\"144\";i:1;s:3:\"141\";i:2;s:1:\"0\";}user_roll|a:154:{i:0;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"1\";s:5:\"label\";s:9:\"dashboard\";s:4:\"link\";s:15:\"admin/dashboard\";s:4:\"icon\";s:15:\"fa fa-dashboard\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-04-23 01:39:36\";s:6:\"status\";s:1:\"1\";}i:1;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"2\";s:5:\"label\";s:8:\"calendar\";s:4:\"link\";s:14:\"admin/calendar\";s:4:\"icon\";s:14:\"fa fa-calendar\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-23 19:57:23\";s:6:\"status\";s:1:\"1\";}i:2;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"4\";s:5:\"label\";s:6:\"client\";s:4:\"link\";s:26:\"admin/client/manage_client\";s:4:\"icon\";s:11:\"fa fa-users\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"13\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:3;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"5\";s:5:\"label\";s:7:\"mailbox\";s:4:\"link\";s:13:\"admin/mailbox\";s:4:\"icon\";s:16:\"fa fa-envelope-o\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:4;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"6\";s:5:\"label\";s:7:\"tickets\";s:4:\"link\";s:13:\"admin/tickets\";s:4:\"icon\";s:12:\"fa fa-ticket\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2018-06-08 13:39:39\";s:6:\"status\";s:1:\"1\";}i:5;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"12\";s:5:\"label\";s:5:\"sales\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:19:\"fa fa-shopping-cart\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"9\";s:4:\"time\";s:19:\"2017-06-10 14:02:58\";s:6:\"status\";s:1:\"1\";}i:6;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"13\";s:5:\"label\";s:7:\"invoice\";s:4:\"link\";s:28:\"admin/invoice/manage_invoice\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-04-23 19:57:23\";s:6:\"status\";s:1:\"1\";}i:7;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"14\";s:5:\"label\";s:9:\"estimates\";s:4:\"link\";s:15:\"admin/estimates\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-06-10 14:02:05\";s:6:\"status\";s:1:\"1\";}i:8;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"15\";s:5:\"label\";s:17:\"payments_received\";s:4:\"link\";s:26:\"admin/invoice/all_payments\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-23 19:57:24\";s:6:\"status\";s:1:\"1\";}i:9;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"16\";s:5:\"label\";s:9:\"tax_rates\";s:4:\"link\";s:23:\"admin/invoice/tax_rates\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-01-07 07:05:16\";s:6:\"status\";s:1:\"1\";}i:10;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"21\";s:5:\"label\";s:10:\"quotations\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:11:\"fa fa-paste\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:11;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"22\";s:5:\"label\";s:15:\"quotations_list\";s:4:\"link\";s:16:\"admin/quotations\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"21\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-05-18 16:49:03\";s:6:\"status\";s:1:\"1\";}i:12;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"23\";s:5:\"label\";s:15:\"quotations_form\";s:4:\"link\";s:32:\"admin/quotations/quotations_form\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"21\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:13;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"24\";s:5:\"label\";s:4:\"user\";s:4:\"link\";s:20:\"admin/user/user_list\";s:4:\"icon\";s:11:\"fa fa-users\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"25\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:14;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"25\";s:5:\"label\";s:8:\"settings\";s:4:\"link\";s:14:\"admin/settings\";s:4:\"icon\";s:10:\"fa fa-cogs\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"26\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:15;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"26\";s:5:\"label\";s:15:\"database_backup\";s:4:\"link\";s:30:\"admin/settings/database_backup\";s:4:\"icon\";s:14:\"fa fa-database\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"27\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:16;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"29\";s:5:\"label\";s:17:\"transactions_menu\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:16:\"fa fa-building-o\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"12\";s:4:\"time\";s:19:\"2018-05-13 12:27:58\";s:6:\"status\";s:1:\"1\";}i:17;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"30\";s:5:\"label\";s:7:\"deposit\";s:4:\"link\";s:26:\"admin/transactions/deposit\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-05-13 12:28:33\";s:6:\"status\";s:1:\"1\";}i:18;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"31\";s:5:\"label\";s:7:\"expense\";s:4:\"link\";s:26:\"admin/transactions/expense\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-05-13 12:28:37\";s:6:\"status\";s:1:\"1\";}i:19;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"32\";s:5:\"label\";s:8:\"transfer\";s:4:\"link\";s:27:\"admin/transactions/transfer\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-05-13 12:28:40\";s:6:\"status\";s:1:\"1\";}i:20;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"33\";s:5:\"label\";s:19:\"transactions_report\";s:4:\"link\";s:38:\"admin/transactions/transactions_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2018-05-13 12:28:44\";s:6:\"status\";s:1:\"1\";}i:21;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"34\";s:5:\"label\";s:13:\"balance_sheet\";s:4:\"link\";s:32:\"admin/transactions/balance_sheet\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-05-13 12:28:47\";s:6:\"status\";s:1:\"1\";}i:22;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"36\";s:5:\"label\";s:9:\"bank_cash\";s:4:\"link\";s:28:\"admin/account/manage_account\";s:4:\"icon\";s:11:\"fa fa-money\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2018-05-13 12:28:51\";s:6:\"status\";s:1:\"1\";}i:23;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"39\";s:5:\"label\";s:5:\"items\";s:4:\"link\";s:22:\"admin/items/items_list\";s:4:\"icon\";s:10:\"fa fa-cube\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2019-05-04 18:49:50\";s:6:\"status\";s:1:\"1\";}i:24;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"42\";s:5:\"label\";s:6:\"report\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:15:\"fa fa-bar-chart\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"24\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:25;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"43\";s:5:\"label\";s:17:\"account_statement\";s:4:\"link\";s:30:\"admin/report/account_statement\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:26;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"44\";s:5:\"label\";s:13:\"income_report\";s:4:\"link\";s:26:\"admin/report/income_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:27;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"45\";s:5:\"label\";s:14:\"expense_report\";s:4:\"link\";s:27:\"admin/report/expense_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:28;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"46\";s:5:\"label\";s:14:\"income_expense\";s:4:\"link\";s:27:\"admin/report/income_expense\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:29;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"47\";s:5:\"label\";s:16:\"date_wise_report\";s:4:\"link\";s:29:\"admin/report/date_wise_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:30;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"48\";s:5:\"label\";s:10:\"all_income\";s:4:\"link\";s:23:\"admin/report/all_income\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:31;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"49\";s:5:\"label\";s:11:\"all_expense\";s:4:\"link\";s:24:\"admin/report/all_expense\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:32;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"50\";s:5:\"label\";s:15:\"all_transaction\";s:4:\"link\";s:28:\"admin/report/all_transaction\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:33;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"51\";s:5:\"label\";s:17:\"recurring_invoice\";s:4:\"link\";s:31:\"admin/invoice/recurring_invoice\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-06-10 14:02:05\";s:6:\"status\";s:1:\"1\";}i:34;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"52\";s:5:\"label\";s:15:\"transfer_report\";s:4:\"link\";s:34:\"admin/transactions/transfer_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-05-13 12:28:59\";s:6:\"status\";s:1:\"1\";}i:35;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"53\";s:5:\"label\";s:15:\"report_by_month\";s:4:\"link\";s:28:\"admin/report/report_by_month\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:36;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"54\";s:5:\"label\";s:5:\"tasks\";s:4:\"link\";s:20:\"admin/tasks/all_task\";s:4:\"icon\";s:11:\"fa fa-tasks\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:37;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"55\";s:5:\"label\";s:5:\"leads\";s:4:\"link\";s:11:\"admin/leads\";s:4:\"icon\";s:12:\"fa fa-rocket\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:38;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"56\";s:5:\"label\";s:13:\"opportunities\";s:4:\"link\";s:19:\"admin/opportunities\";s:4:\"icon\";s:12:\"fa fa-filter\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:39;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"57\";s:5:\"label\";s:8:\"projects\";s:4:\"link\";s:14:\"admin/projects\";s:4:\"icon\";s:19:\"fa fa-folder-open-o\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:40;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"58\";s:5:\"label\";s:4:\"bugs\";s:4:\"link\";s:10:\"admin/bugs\";s:4:\"icon\";s:9:\"fa fa-bug\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:41;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"59\";s:5:\"label\";s:7:\"project\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:19:\"fa fa-folder-open-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:42;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"60\";s:5:\"label\";s:12:\"tasks_report\";s:4:\"link\";s:25:\"admin/report/tasks_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:43;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"61\";s:5:\"label\";s:11:\"bugs_report\";s:4:\"link\";s:24:\"admin/report/bugs_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:44;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"62\";s:5:\"label\";s:14:\"tickets_report\";s:4:\"link\";s:27:\"admin/report/tickets_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:45;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"63\";s:5:\"label\";s:13:\"client_report\";s:4:\"link\";s:26:\"admin/report/client_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2018-01-07 07:09:40\";s:6:\"status\";s:1:\"1\";}i:46;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"66\";s:5:\"label\";s:16:\"tasks_assignment\";s:4:\"link\";s:29:\"admin/report/tasks_assignment\";s:4:\"icon\";s:18:\"fa fa-dot-circle-o\";s:6:\"parent\";s:2:\"59\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:47;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"67\";s:5:\"label\";s:15:\"bugs_assignment\";s:4:\"link\";s:28:\"admin/report/bugs_assignment\";s:4:\"icon\";s:18:\"fa fa-dot-circle-o\";s:6:\"parent\";s:2:\"59\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:48;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"68\";s:5:\"label\";s:14:\"project_report\";s:4:\"link\";s:27:\"admin/report/project_report\";s:4:\"icon\";s:18:\"fa fa-dot-circle-o\";s:6:\"parent\";s:2:\"59\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:49;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"69\";s:5:\"label\";s:13:\"goal_tracking\";s:4:\"link\";s:19:\"admin/goal_tracking\";s:4:\"icon\";s:12:\"fa fa-shield\";s:6:\"parent\";s:2:\"73\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-06-10 14:05:47\";s:6:\"status\";s:1:\"1\";}i:50;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"70\";s:5:\"label\";s:11:\"departments\";s:4:\"link\";s:17:\"admin/departments\";s:4:\"icon\";s:17:\"fa fa-user-secret\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"14\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:51;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"71\";s:5:\"label\";s:7:\"holiday\";s:4:\"link\";s:13:\"admin/holiday\";s:4:\"icon\";s:21:\"fa fa-calendar-plus-o\";s:6:\"parent\";s:2:\"73\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-06-10 14:05:47\";s:6:\"status\";s:1:\"1\";}i:52;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"72\";s:5:\"label\";s:16:\"leave_management\";s:4:\"link\";s:22:\"admin/leave_management\";s:4:\"icon\";s:11:\"fa fa-plane\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"20\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:53;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"73\";s:5:\"label\";s:9:\"utilities\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:10:\"fa fa-gift\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"23\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:54;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"74\";s:5:\"label\";s:8:\"overtime\";s:4:\"link\";s:24:\"admin/utilities/overtime\";s:4:\"icon\";s:13:\"fa fa-clock-o\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"9\";s:4:\"time\";s:19:\"2017-06-10 14:04:23\";s:6:\"status\";s:1:\"1\";}i:55;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"75\";s:5:\"label\";s:12:\"office_stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:13:\"fa fa-codepen\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"15\";s:4:\"time\";s:19:\"2019-05-01 16:22:56\";s:6:\"status\";s:1:\"1\";}i:56;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"76\";s:5:\"label\";s:14:\"stock_category\";s:4:\"link\";s:26:\"admin/stock/stock_category\";s:4:\"icon\";s:13:\"fa fa-sliders\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:57;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"77\";s:5:\"label\";s:12:\"manage_stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:13:\"fa fa-archive\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-04-26 16:11:10\";s:6:\"status\";s:1:\"1\";}i:58;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"78\";s:5:\"label\";s:12:\"assign_stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:16:\"fa fa-align-left\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-26 16:11:10\";s:6:\"status\";s:1:\"1\";}i:59;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"79\";s:5:\"label\";s:12:\"stock_report\";s:4:\"link\";s:18:\"admin/stock/report\";s:4:\"icon\";s:16:\"fa fa-line-chart\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2017-04-25 18:48:25\";s:6:\"status\";s:1:\"1\";}i:60;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"81\";s:5:\"label\";s:10:\"stock_list\";s:4:\"link\";s:22:\"admin/stock/stock_list\";s:4:\"icon\";s:20:\"fa fa-stack-exchange\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-26 16:11:10\";s:6:\"status\";s:1:\"1\";}i:61;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"82\";s:5:\"label\";s:12:\"assign_stock\";s:4:\"link\";s:24:\"admin/stock/assign_stock\";s:4:\"icon\";s:16:\"fa fa-align-left\";s:6:\"parent\";s:2:\"78\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:62;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"83\";s:5:\"label\";s:19:\"assign_stock_report\";s:4:\"link\";s:31:\"admin/stock/assign_stock_report\";s:4:\"icon\";s:15:\"fa fa-bar-chart\";s:6:\"parent\";s:2:\"78\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:63;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"84\";s:5:\"label\";s:13:\"stock_history\";s:4:\"link\";s:25:\"admin/stock/stock_history\";s:4:\"icon\";s:17:\"fa fa-file-text-o\";s:6:\"parent\";s:2:\"77\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:64;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"85\";s:5:\"label\";s:11:\"performance\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:14:\"fa fa-dribbble\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"19\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:65;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"86\";s:5:\"label\";s:21:\"performance_indicator\";s:4:\"link\";s:39:\"admin/performance/performance_indicator\";s:4:\"icon\";s:12:\"fa fa-random\";s:6:\"parent\";s:2:\"85\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:66;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"87\";s:5:\"label\";s:18:\"performance_report\";s:4:\"link\";s:36:\"admin/performance/performance_report\";s:4:\"icon\";s:16:\"fa fa-calendar-o\";s:6:\"parent\";s:2:\"85\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:67;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"88\";s:5:\"label\";s:14:\"give_appraisal\";s:4:\"link\";s:44:\"admin/performance/give_performance_appraisal\";s:4:\"icon\";s:10:\"fa fa-plus\";s:6:\"parent\";s:2:\"85\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:68;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"89\";s:5:\"label\";s:7:\"payroll\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:9:\"fa fa-usd\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"18\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:69;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"90\";s:5:\"label\";s:21:\"manage_salary_details\";s:4:\"link\";s:35:\"admin/payroll/manage_salary_details\";s:4:\"icon\";s:9:\"fa fa-usd\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:70;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"91\";s:5:\"label\";s:20:\"employee_salary_list\";s:4:\"link\";s:34:\"admin/payroll/employee_salary_list\";s:4:\"icon\";s:17:\"fa fa-user-secret\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:71;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"92\";s:5:\"label\";s:12:\"make_payment\";s:4:\"link\";s:26:\"admin/payroll/make_payment\";s:4:\"icon\";s:11:\"fa fa-tasks\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:72;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"93\";s:5:\"label\";s:16:\"generate_payslip\";s:4:\"link\";s:30:\"admin/payroll/generate_payslip\";s:4:\"icon\";s:13:\"fa fa-list-ul\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:73;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"94\";s:5:\"label\";s:15:\"salary_template\";s:4:\"link\";s:29:\"admin/payroll/salary_template\";s:4:\"icon\";s:11:\"fa fa-money\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:74;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"95\";s:5:\"label\";s:11:\"hourly_rate\";s:4:\"link\";s:25:\"admin/payroll/hourly_rate\";s:4:\"icon\";s:13:\"fa fa-clock-o\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:75;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"96\";s:5:\"label\";s:15:\"payroll_summary\";s:4:\"link\";s:29:\"admin/payroll/payroll_summary\";s:4:\"icon\";s:18:\"fa fa-camera-retro\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:76;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"97\";s:5:\"label\";s:14:\"provident_fund\";s:4:\"link\";s:28:\"admin/payroll/provident_fund\";s:4:\"icon\";s:15:\"fa fa-briefcase\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2017-06-10 14:04:23\";s:6:\"status\";s:1:\"1\";}i:77;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"98\";s:5:\"label\";s:14:\"advance_salary\";s:4:\"link\";s:28:\"admin/payroll/advance_salary\";s:4:\"icon\";s:19:\"fa fa-cc-mastercard\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2017-06-10 14:04:23\";s:6:\"status\";s:1:\"1\";}i:78;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"99\";s:5:\"label\";s:14:\"employee_award\";s:4:\"link\";s:11:\"admin/award\";s:4:\"icon\";s:12:\"fa fa-trophy\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2017-06-10 14:05:47\";s:6:\"status\";s:1:\"1\";}i:79;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"100\";s:5:\"label\";s:13:\"announcements\";s:4:\"link\";s:19:\"admin/announcements\";s:4:\"icon\";s:19:\"fa fa-bullhorn icon\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"22\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:80;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"101\";s:5:\"label\";s:8:\"training\";s:4:\"link\";s:14:\"admin/training\";s:4:\"icon\";s:14:\"fa fa-suitcase\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"21\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:81;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"102\";s:5:\"label\";s:12:\"job_circular\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:11:\"fa fa-globe\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"17\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:82;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"103\";s:5:\"label\";s:11:\"jobs_posted\";s:4:\"link\";s:30:\"admin/job_circular/jobs_posted\";s:4:\"icon\";s:12:\"fa fa-ticket\";s:6:\"parent\";s:3:\"102\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:83;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"104\";s:5:\"label\";s:17:\"jobs_applications\";s:4:\"link\";s:36:\"admin/job_circular/jobs_applications\";s:4:\"icon\";s:13:\"fa fa-compass\";s:6:\"parent\";s:3:\"102\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:84;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"105\";s:5:\"label\";s:10:\"attendance\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:15:\"fa fa-file-text\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"16\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:85;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"106\";s:5:\"label\";s:18:\"timechange_request\";s:4:\"link\";s:35:\"admin/attendance/timechange_request\";s:4:\"icon\";s:16:\"fa fa-calendar-o\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:86;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"107\";s:5:\"label\";s:17:\"attendance_report\";s:4:\"link\";s:34:\"admin/attendance/attendance_report\";s:4:\"icon\";s:15:\"fa fa-file-text\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:87;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"108\";s:5:\"label\";s:12:\"time_history\";s:4:\"link\";s:29:\"admin/attendance/time_history\";s:4:\"icon\";s:13:\"fa fa-clock-o\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:88;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"109\";s:5:\"label\";s:9:\"pull-down\";s:4:\"link\";s:0:\"\";s:4:\"icon\";s:0:\"\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-31 12:43:20\";s:6:\"status\";s:1:\"0\";}i:89;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"110\";s:5:\"label\";s:11:\"filemanager\";s:4:\"link\";s:17:\"admin/filemanager\";s:4:\"icon\";s:10:\"fa fa-file\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:90;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"111\";s:5:\"label\";s:15:\"company_details\";s:4:\"link\";s:14:\"admin/settings\";s:4:\"icon\";s:23:\"fa fa-fw fa-info-circle\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-25 17:08:46\";s:6:\"status\";s:1:\"2\";}i:91;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"112\";s:5:\"label\";s:15:\"system_settings\";s:4:\"link\";s:21:\"admin/settings/system\";s:4:\"icon\";s:19:\"fa fa-fw fa-desktop\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-04-25 17:08:46\";s:6:\"status\";s:1:\"2\";}i:92;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"113\";s:5:\"label\";s:14:\"email_settings\";s:4:\"link\";s:20:\"admin/settings/email\";s:4:\"icon\";s:20:\"fa fa-fw fa-envelope\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-25 17:08:46\";s:6:\"status\";s:1:\"2\";}i:93;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"114\";s:5:\"label\";s:15:\"email_templates\";s:4:\"link\";s:24:\"admin/settings/templates\";s:4:\"icon\";s:25:\"fa fa-fw fa-pencil-square\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2021-07-30 06:18:08\";s:6:\"status\";s:1:\"2\";}i:94;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"115\";s:5:\"label\";s:17:\"email_integration\";s:4:\"link\";s:32:\"admin/settings/email_integration\";s:4:\"icon\";s:22:\"fa fa-fw fa-envelope-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2021-07-30 06:18:08\";s:6:\"status\";s:1:\"2\";}i:95;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"116\";s:5:\"label\";s:16:\"payment_settings\";s:4:\"link\";s:23:\"admin/settings/payments\";s:4:\"icon\";s:18:\"fa fa-fw fa-dollar\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:96;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"117\";s:5:\"label\";s:16:\"invoice_settings\";s:4:\"link\";s:22:\"admin/settings/invoice\";s:4:\"icon\";s:17:\"fa fa-fw fa-money\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:97;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"118\";s:5:\"label\";s:17:\"estimate_settings\";s:4:\"link\";s:23:\"admin/settings/estimate\";s:4:\"icon\";s:18:\"fa fa-fw fa-file-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:98;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"119\";s:5:\"label\";s:22:\"tickets_leads_settings\";s:4:\"link\";s:22:\"admin/settings/tickets\";s:4:\"icon\";s:18:\"fa fa-fw fa-ticket\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"14\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:99;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"120\";s:5:\"label\";s:14:\"theme_settings\";s:4:\"link\";s:20:\"admin/settings/theme\";s:4:\"icon\";s:16:\"fa fa-fw fa-code\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"20\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:100;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"121\";s:5:\"label\";s:12:\"working_days\";s:4:\"link\";s:27:\"admin/settings/working_days\";s:4:\"icon\";s:20:\"fa fa-fw fa-calendar\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"22\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:101;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"122\";s:5:\"label\";s:14:\"leave_category\";s:4:\"link\";s:29:\"admin/settings/leave_category\";s:4:\"icon\";s:21:\"fa fa-fw fa-pagelines\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"23\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:102;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"123\";s:5:\"label\";s:15:\"income_category\";s:4:\"link\";s:30:\"admin/settings/income_category\";s:4:\"icon\";s:23:\"fa fa-fw fa-certificate\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"24\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:103;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"124\";s:5:\"label\";s:16:\"expense_category\";s:4:\"link\";s:31:\"admin/settings/expense_category\";s:4:\"icon\";s:17:\"fa fa-fw fa-tasks\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"25\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:104;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"125\";s:5:\"label\";s:14:\"customer_group\";s:4:\"link\";s:29:\"admin/settings/customer_group\";s:4:\"icon\";s:17:\"fa fa-fw fa-users\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"26\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:105;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"127\";s:5:\"label\";s:11:\"lead_status\";s:4:\"link\";s:26:\"admin/settings/lead_status\";s:4:\"icon\";s:19:\"fa fa-fw fa-list-ul\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"16\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:106;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"128\";s:5:\"label\";s:11:\"lead_source\";s:4:\"link\";s:26:\"admin/settings/lead_source\";s:4:\"icon\";s:22:\"fa fa-fw fa-arrow-down\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"17\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:107;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"129\";s:5:\"label\";s:26:\"opportunities_state_reason\";s:4:\"link\";s:41:\"admin/settings/opportunities_state_reason\";s:4:\"icon\";s:24:\"fa fa-fw fa-dot-circle-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"19\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:108;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"130\";s:5:\"label\";s:12:\"custom_field\";s:4:\"link\";s:27:\"admin/settings/custom_field\";s:4:\"icon\";s:18:\"fa fa-fw fa-star-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"28\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:109;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"131\";s:5:\"label\";s:14:\"payment_method\";s:4:\"link\";s:29:\"admin/settings/payment_method\";s:4:\"icon\";s:17:\"fa fa-fw fa-money\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"29\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:110;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"132\";s:5:\"label\";s:7:\"cronjob\";s:4:\"link\";s:22:\"admin/settings/cronjob\";s:4:\"icon\";s:18:\"fa fa-fw fa-contao\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"31\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:111;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"133\";s:5:\"label\";s:15:\"menu_allocation\";s:4:\"link\";s:30:\"admin/settings/menu_allocation\";s:4:\"icon\";s:22:\"fa fa-fw fa fa-compass\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"32\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:112;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"134\";s:5:\"label\";s:12:\"notification\";s:4:\"link\";s:27:\"admin/settings/notification\";s:4:\"icon\";s:18:\"fa fa-fw fa-bell-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"33\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:113;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"135\";s:5:\"label\";s:18:\"email_notification\";s:4:\"link\";s:33:\"admin/settings/email_notification\";s:4:\"icon\";s:18:\"fa fa-fw fa-bell-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"34\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:114;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"136\";s:5:\"label\";s:15:\"database_backup\";s:4:\"link\";s:30:\"admin/settings/database_backup\";s:4:\"icon\";s:20:\"fa fa-fw fa-database\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"35\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:115;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"137\";s:5:\"label\";s:12:\"translations\";s:4:\"link\";s:27:\"admin/settings/translations\";s:4:\"icon\";s:20:\"fa fa-fw fa-language\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"36\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:116;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"138\";s:5:\"label\";s:13:\"system_update\";s:4:\"link\";s:28:\"admin/settings/system_update\";s:4:\"icon\";s:27:\"fa fa-fw fa-pencil-square-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"37\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:117;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"139\";s:5:\"label\";s:12:\"private_chat\";s:4:\"link\";s:18:\"chat/conversations\";s:4:\"icon\";s:14:\"fa fa-envelope\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"28\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:118;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"140\";s:5:\"label\";s:9:\"proposals\";s:4:\"link\";s:15:\"admin/proposals\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-01-07 07:05:16\";s:6:\"status\";s:1:\"1\";}i:119;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"141\";s:5:\"label\";s:13:\"knowledgebase\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:21:\"fa fa-question-circle\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"11\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:120;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"142\";s:5:\"label\";s:10:\"categories\";s:4:\"link\";s:30:\"admin/knowledgebase/categories\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"141\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:121;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"143\";s:5:\"label\";s:8:\"articles\";s:4:\"link\";s:28:\"admin/knowledgebase/articles\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"141\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:122;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"144\";s:5:\"label\";s:13:\"knowledgebase\";s:4:\"link\";s:19:\"admin/knowledgebase\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"141\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:123;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"145\";s:5:\"label\";s:18:\"dashboard_settings\";s:4:\"link\";s:24:\"admin/settings/dashboard\";s:4:\"icon\";s:21:\"fa fa-fw fa-dashboard\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"21\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:124;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"146\";s:5:\"label\";s:20:\"transactions_reports\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:16:\"fa fa-building-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-05-13 12:29:51\";s:6:\"status\";s:1:\"1\";}i:125;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"147\";s:5:\"label\";s:5:\"sales\";s:4:\"link\";s:25:\"admin/report/sales_report\";s:4:\"icon\";s:19:\"fa fa-shopping-cart\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-01-07 01:12:23\";s:6:\"status\";s:1:\"1\";}i:126;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"148\";s:5:\"label\";s:15:\"mark_attendance\";s:4:\"link\";s:21:\"admin/mark_attendance\";s:4:\"icon\";s:15:\"fa fa-file-text\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-03-07 06:45:25\";s:6:\"status\";s:1:\"1\";}i:127;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"149\";s:5:\"label\";s:10:\"allowed_ip\";s:4:\"link\";s:25:\"admin/settings/allowed_ip\";s:4:\"icon\";s:12:\"fa fa-server\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"27\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:128;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"150\";s:5:\"label\";s:5:\"stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:11:\"icon-layers\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2019-05-01 18:10:52\";s:6:\"status\";s:1:\"1\";}i:129;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"151\";s:5:\"label\";s:8:\"supplier\";s:4:\"link\";s:14:\"admin/supplier\";s:4:\"icon\";s:14:\"icon-briefcase\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2019-05-01 18:10:52\";s:6:\"status\";s:1:\"1\";}i:130;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"152\";s:5:\"label\";s:8:\"purchase\";s:4:\"link\";s:14:\"admin/purchase\";s:4:\"icon\";s:12:\"icon-handbag\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2019-05-01 18:10:52\";s:6:\"status\";s:1:\"1\";}i:131;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"153\";s:5:\"label\";s:12:\"return_stock\";s:4:\"link\";s:18:\"admin/return_stock\";s:4:\"icon\";s:14:\"icon-share-alt\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2019-05-05 16:19:30\";s:6:\"status\";s:1:\"1\";}i:132;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"154\";s:5:\"label\";s:16:\"purchase_payment\";s:4:\"link\";s:27:\"admin/purchase/all_payments\";s:4:\"icon\";s:16:\"icon-credit-card\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2019-05-05 13:53:11\";s:6:\"status\";s:1:\"1\";}i:133;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"155\";s:5:\"label\";s:17:\"purchase_settings\";s:4:\"link\";s:23:\"admin/settings/purchase\";s:4:\"icon\";s:18:\"fa-fw icon-handbag\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"12\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:134;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"156\";s:5:\"label\";s:11:\"credit_note\";s:4:\"link\";s:17:\"admin/credit_note\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-06-10 02:32:05\";s:6:\"status\";s:1:\"1\";}i:135;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"157\";s:5:\"label\";s:20:\"credit_note_settings\";s:4:\"link\";s:26:\"admin/settings/credit_note\";s:4:\"icon\";s:17:\"fa fa-fw fa-money\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"9\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:136;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"158\";s:5:\"label\";s:18:\"proposals_settings\";s:4:\"link\";s:24:\"admin/settings/proposals\";s:4:\"icon\";s:16:\"fa fa-fw fa-leaf\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"11\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:137;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"159\";s:5:\"label\";s:17:\"projects_settings\";s:4:\"link\";s:23:\"admin/settings/projects\";s:4:\"icon\";s:25:\"fa fa-fw fa-folder-open-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"13\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:138;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"160\";s:5:\"label\";s:4:\"tags\";s:4:\"link\";s:19:\"admin/settings/tags\";s:4:\"icon\";s:16:\"fa fa-fw fa-tags\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"30\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:139;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"161\";s:5:\"label\";s:9:\"lead_form\";s:4:\"link\";s:25:\"admin/leads/all_lead_form\";s:4:\"icon\";s:18:\"fa fa-fw fa-rocket\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"18\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:140;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"162\";s:5:\"label\";s:21:\"transactions_settings\";s:4:\"link\";s:27:\"admin/settings/transactions\";s:4:\"icon\";s:22:\"fa fa-fw fa-building-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"15\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:141;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"163\";s:5:\"label\";s:12:\"sms_settings\";s:4:\"link\";s:27:\"admin/settings/sms_settings\";s:4:\"icon\";s:20:\"fa fa-fw fa-envelope\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2021-07-30 06:18:08\";s:6:\"status\";s:1:\"2\";}i:142;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"164\";s:5:\"label\";s:9:\"pos_sales\";s:4:\"link\";s:23:\"admin/invoice/pos_sales\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2021-10-16 00:53:10\";s:6:\"status\";s:1:\"1\";}i:143;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"186\";s:5:\"label\";s:9:\"warehouse\";s:4:\"link\";s:22:\"admin/warehouse/manage\";s:4:\"icon\";s:16:\"fa fa-building-o\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2021-10-18 09:24:24\";s:6:\"status\";s:1:\"1\";}i:144;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"187\";s:5:\"label\";s:12:\"transferItem\";s:4:\"link\";s:24:\"admin/items/transferItem\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2021-10-14 11:56:08\";s:6:\"status\";s:1:\"1\";}i:145;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"203\";s:5:\"label\";s:13:\"award_setting\";s:4:\"link\";s:20:\"admin/settings/award\";s:4:\"icon\";s:10:\"fa fa-star\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"30\";s:4:\"time\";s:19:\"2022-01-19 05:51:40\";s:6:\"status\";s:1:\"2\";}i:146;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"204\";s:5:\"label\";s:18:\"award_rule_setting\";s:4:\"link\";s:34:\"admin/settings/award_rule_settingh\";s:4:\"icon\";s:10:\"fa fa-star\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"31\";s:4:\"time\";s:19:\"2022-01-19 09:53:50\";s:6:\"status\";s:1:\"2\";}i:147;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"205\";s:5:\"label\";s:22:\"award_program_settings\";s:4:\"link\";s:37:\"admin/settings/award_program_settings\";s:4:\"icon\";s:9:\"fa fa-cog\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"32\";s:4:\"time\";s:19:\"2022-01-20 09:17:30\";s:6:\"status\";s:1:\"2\";}i:148;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"206\";s:5:\"label\";s:19:\"client_award_points\";s:4:\"link\";s:27:\"admin/invoice/client_awards\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2022-01-21 01:39:41\";s:6:\"status\";s:1:\"1\";}i:149;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"207\";s:5:\"label\";s:20:\"best_selling_product\";s:4:\"link\";s:18:\"admin/best_selling\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:2:\"11\";s:4:\"time\";s:19:\"2022-01-21 06:43:52\";s:6:\"status\";s:1:\"1\";}i:150;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"209\";s:5:\"label\";s:7:\"warning\";s:4:\"link\";s:13:\"admin/warning\";s:4:\"icon\";s:13:\"fa fa-warning\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2022-08-07 12:47:01\";s:6:\"status\";s:1:\"1\";}i:151;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"210\";s:5:\"label\";s:9:\"promotion\";s:4:\"link\";s:15:\"admin/promotion\";s:4:\"icon\";s:21:\"fa fa-arrow-circle-up\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2022-08-07 12:49:28\";s:6:\"status\";s:1:\"1\";}i:152;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"211\";s:5:\"label\";s:11:\"termination\";s:4:\"link\";s:17:\"admin/termination\";s:4:\"icon\";s:12:\"fa fa-eraser\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2022-08-07 12:50:45\";s:6:\"status\";s:1:\"1\";}i:153;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"212\";s:5:\"label\";s:11:\"resignation\";s:4:\"link\";s:17:\"admin/resignation\";s:4:\"icon\";s:14:\"fa fa-scissors\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2022-08-07 12:54:31\";s:6:\"status\";s:1:\"1\";}}');
INSERT INTO `tbl_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2a6d3869a2d1175fede469c3f6f3169e3c0464a7', '136.158.121.2', 1689135222, '__ci_last_regenerate|i:1689135222;menu_active_id|a:3:{i:0;s:3:\"118\";i:1;s:2:\"25\";i:2;s:1:\"0\";}user_name|s:5:\"nimda\";email|s:26:\"erick@blickcreative.com.au\";name|s:13:\"Erick Villeta\";photo|s:26:\"uploads/default_avatar.jpg\";user_id|s:1:\"5\";last_login|s:19:\"2023-07-10 11:54:34\";online_time|i:1689133478;loggedin|b:1;user_type|s:1:\"1\";user_flag|s:1:\"1\";direction|s:3:\"ltr\";warehouse_id|N;designations_id|s:1:\"0\";url|s:33:\"admin/dashboard/pinned_menu_items\";user_roll|a:154:{i:0;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"1\";s:5:\"label\";s:9:\"dashboard\";s:4:\"link\";s:15:\"admin/dashboard\";s:4:\"icon\";s:15:\"fa fa-dashboard\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-04-23 01:39:36\";s:6:\"status\";s:1:\"1\";}i:1;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"2\";s:5:\"label\";s:8:\"calendar\";s:4:\"link\";s:14:\"admin/calendar\";s:4:\"icon\";s:14:\"fa fa-calendar\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-23 19:57:23\";s:6:\"status\";s:1:\"1\";}i:2;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"4\";s:5:\"label\";s:6:\"client\";s:4:\"link\";s:26:\"admin/client/manage_client\";s:4:\"icon\";s:11:\"fa fa-users\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"13\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:3;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"5\";s:5:\"label\";s:7:\"mailbox\";s:4:\"link\";s:13:\"admin/mailbox\";s:4:\"icon\";s:16:\"fa fa-envelope-o\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:4;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"6\";s:5:\"label\";s:7:\"tickets\";s:4:\"link\";s:13:\"admin/tickets\";s:4:\"icon\";s:12:\"fa fa-ticket\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2018-06-08 13:39:39\";s:6:\"status\";s:1:\"1\";}i:5;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"12\";s:5:\"label\";s:5:\"sales\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:19:\"fa fa-shopping-cart\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"9\";s:4:\"time\";s:19:\"2017-06-10 14:02:58\";s:6:\"status\";s:1:\"1\";}i:6;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"13\";s:5:\"label\";s:7:\"invoice\";s:4:\"link\";s:28:\"admin/invoice/manage_invoice\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-04-23 19:57:23\";s:6:\"status\";s:1:\"1\";}i:7;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"14\";s:5:\"label\";s:9:\"estimates\";s:4:\"link\";s:15:\"admin/estimates\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-06-10 14:02:05\";s:6:\"status\";s:1:\"1\";}i:8;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"15\";s:5:\"label\";s:17:\"payments_received\";s:4:\"link\";s:26:\"admin/invoice/all_payments\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-23 19:57:24\";s:6:\"status\";s:1:\"1\";}i:9;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"16\";s:5:\"label\";s:9:\"tax_rates\";s:4:\"link\";s:23:\"admin/invoice/tax_rates\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-01-07 07:05:16\";s:6:\"status\";s:1:\"1\";}i:10;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"21\";s:5:\"label\";s:10:\"quotations\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:11:\"fa fa-paste\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:11;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"22\";s:5:\"label\";s:15:\"quotations_list\";s:4:\"link\";s:16:\"admin/quotations\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"21\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-05-18 16:49:03\";s:6:\"status\";s:1:\"1\";}i:12;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"23\";s:5:\"label\";s:15:\"quotations_form\";s:4:\"link\";s:32:\"admin/quotations/quotations_form\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"21\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:13;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"24\";s:5:\"label\";s:4:\"user\";s:4:\"link\";s:20:\"admin/user/user_list\";s:4:\"icon\";s:11:\"fa fa-users\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"25\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:14;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"25\";s:5:\"label\";s:8:\"settings\";s:4:\"link\";s:14:\"admin/settings\";s:4:\"icon\";s:10:\"fa fa-cogs\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"26\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:15;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"26\";s:5:\"label\";s:15:\"database_backup\";s:4:\"link\";s:30:\"admin/settings/database_backup\";s:4:\"icon\";s:14:\"fa fa-database\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"27\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:16;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"29\";s:5:\"label\";s:17:\"transactions_menu\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:16:\"fa fa-building-o\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"12\";s:4:\"time\";s:19:\"2018-05-13 12:27:58\";s:6:\"status\";s:1:\"1\";}i:17;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"30\";s:5:\"label\";s:7:\"deposit\";s:4:\"link\";s:26:\"admin/transactions/deposit\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-05-13 12:28:33\";s:6:\"status\";s:1:\"1\";}i:18;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"31\";s:5:\"label\";s:7:\"expense\";s:4:\"link\";s:26:\"admin/transactions/expense\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-05-13 12:28:37\";s:6:\"status\";s:1:\"1\";}i:19;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"32\";s:5:\"label\";s:8:\"transfer\";s:4:\"link\";s:27:\"admin/transactions/transfer\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-05-13 12:28:40\";s:6:\"status\";s:1:\"1\";}i:20;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"33\";s:5:\"label\";s:19:\"transactions_report\";s:4:\"link\";s:38:\"admin/transactions/transactions_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2018-05-13 12:28:44\";s:6:\"status\";s:1:\"1\";}i:21;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"34\";s:5:\"label\";s:13:\"balance_sheet\";s:4:\"link\";s:32:\"admin/transactions/balance_sheet\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-05-13 12:28:47\";s:6:\"status\";s:1:\"1\";}i:22;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"36\";s:5:\"label\";s:9:\"bank_cash\";s:4:\"link\";s:28:\"admin/account/manage_account\";s:4:\"icon\";s:11:\"fa fa-money\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2018-05-13 12:28:51\";s:6:\"status\";s:1:\"1\";}i:23;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"39\";s:5:\"label\";s:5:\"items\";s:4:\"link\";s:22:\"admin/items/items_list\";s:4:\"icon\";s:10:\"fa fa-cube\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2019-05-04 18:49:50\";s:6:\"status\";s:1:\"1\";}i:24;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"42\";s:5:\"label\";s:6:\"report\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:15:\"fa fa-bar-chart\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"24\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:25;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"43\";s:5:\"label\";s:17:\"account_statement\";s:4:\"link\";s:30:\"admin/report/account_statement\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:26;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"44\";s:5:\"label\";s:13:\"income_report\";s:4:\"link\";s:26:\"admin/report/income_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:27;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"45\";s:5:\"label\";s:14:\"expense_report\";s:4:\"link\";s:27:\"admin/report/expense_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:28;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"46\";s:5:\"label\";s:14:\"income_expense\";s:4:\"link\";s:27:\"admin/report/income_expense\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:29;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"47\";s:5:\"label\";s:16:\"date_wise_report\";s:4:\"link\";s:29:\"admin/report/date_wise_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:30;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"48\";s:5:\"label\";s:10:\"all_income\";s:4:\"link\";s:23:\"admin/report/all_income\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:31;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"49\";s:5:\"label\";s:11:\"all_expense\";s:4:\"link\";s:24:\"admin/report/all_expense\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:32;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"50\";s:5:\"label\";s:15:\"all_transaction\";s:4:\"link\";s:28:\"admin/report/all_transaction\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:33;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"51\";s:5:\"label\";s:17:\"recurring_invoice\";s:4:\"link\";s:31:\"admin/invoice/recurring_invoice\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-06-10 14:02:05\";s:6:\"status\";s:1:\"1\";}i:34;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"52\";s:5:\"label\";s:15:\"transfer_report\";s:4:\"link\";s:34:\"admin/transactions/transfer_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-05-13 12:28:59\";s:6:\"status\";s:1:\"1\";}i:35;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"53\";s:5:\"label\";s:15:\"report_by_month\";s:4:\"link\";s:28:\"admin/report/report_by_month\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:36;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"54\";s:5:\"label\";s:5:\"tasks\";s:4:\"link\";s:20:\"admin/tasks/all_task\";s:4:\"icon\";s:11:\"fa fa-tasks\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:37;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"55\";s:5:\"label\";s:5:\"leads\";s:4:\"link\";s:11:\"admin/leads\";s:4:\"icon\";s:12:\"fa fa-rocket\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:38;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"56\";s:5:\"label\";s:13:\"opportunities\";s:4:\"link\";s:19:\"admin/opportunities\";s:4:\"icon\";s:12:\"fa fa-filter\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:39;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"57\";s:5:\"label\";s:8:\"projects\";s:4:\"link\";s:14:\"admin/projects\";s:4:\"icon\";s:19:\"fa fa-folder-open-o\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:40;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"58\";s:5:\"label\";s:4:\"bugs\";s:4:\"link\";s:10:\"admin/bugs\";s:4:\"icon\";s:9:\"fa fa-bug\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:41;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"59\";s:5:\"label\";s:7:\"project\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:19:\"fa fa-folder-open-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:42;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"60\";s:5:\"label\";s:12:\"tasks_report\";s:4:\"link\";s:25:\"admin/report/tasks_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:43;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"61\";s:5:\"label\";s:11:\"bugs_report\";s:4:\"link\";s:24:\"admin/report/bugs_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:44;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"62\";s:5:\"label\";s:14:\"tickets_report\";s:4:\"link\";s:27:\"admin/report/tickets_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:45;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"63\";s:5:\"label\";s:13:\"client_report\";s:4:\"link\";s:26:\"admin/report/client_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2018-01-07 07:09:40\";s:6:\"status\";s:1:\"1\";}i:46;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"66\";s:5:\"label\";s:16:\"tasks_assignment\";s:4:\"link\";s:29:\"admin/report/tasks_assignment\";s:4:\"icon\";s:18:\"fa fa-dot-circle-o\";s:6:\"parent\";s:2:\"59\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:47;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"67\";s:5:\"label\";s:15:\"bugs_assignment\";s:4:\"link\";s:28:\"admin/report/bugs_assignment\";s:4:\"icon\";s:18:\"fa fa-dot-circle-o\";s:6:\"parent\";s:2:\"59\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:48;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"68\";s:5:\"label\";s:14:\"project_report\";s:4:\"link\";s:27:\"admin/report/project_report\";s:4:\"icon\";s:18:\"fa fa-dot-circle-o\";s:6:\"parent\";s:2:\"59\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:49;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"69\";s:5:\"label\";s:13:\"goal_tracking\";s:4:\"link\";s:19:\"admin/goal_tracking\";s:4:\"icon\";s:12:\"fa fa-shield\";s:6:\"parent\";s:2:\"73\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-06-10 14:05:47\";s:6:\"status\";s:1:\"1\";}i:50;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"70\";s:5:\"label\";s:11:\"departments\";s:4:\"link\";s:17:\"admin/departments\";s:4:\"icon\";s:17:\"fa fa-user-secret\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"14\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:51;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"71\";s:5:\"label\";s:7:\"holiday\";s:4:\"link\";s:13:\"admin/holiday\";s:4:\"icon\";s:21:\"fa fa-calendar-plus-o\";s:6:\"parent\";s:2:\"73\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-06-10 14:05:47\";s:6:\"status\";s:1:\"1\";}i:52;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"72\";s:5:\"label\";s:16:\"leave_management\";s:4:\"link\";s:22:\"admin/leave_management\";s:4:\"icon\";s:11:\"fa fa-plane\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"20\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:53;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"73\";s:5:\"label\";s:9:\"utilities\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:10:\"fa fa-gift\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"23\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:54;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"74\";s:5:\"label\";s:8:\"overtime\";s:4:\"link\";s:24:\"admin/utilities/overtime\";s:4:\"icon\";s:13:\"fa fa-clock-o\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"9\";s:4:\"time\";s:19:\"2017-06-10 14:04:23\";s:6:\"status\";s:1:\"1\";}i:55;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"75\";s:5:\"label\";s:12:\"office_stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:13:\"fa fa-codepen\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"15\";s:4:\"time\";s:19:\"2019-05-01 16:22:56\";s:6:\"status\";s:1:\"1\";}i:56;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"76\";s:5:\"label\";s:14:\"stock_category\";s:4:\"link\";s:26:\"admin/stock/stock_category\";s:4:\"icon\";s:13:\"fa fa-sliders\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:57;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"77\";s:5:\"label\";s:12:\"manage_stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:13:\"fa fa-archive\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-04-26 16:11:10\";s:6:\"status\";s:1:\"1\";}i:58;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"78\";s:5:\"label\";s:12:\"assign_stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:16:\"fa fa-align-left\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-26 16:11:10\";s:6:\"status\";s:1:\"1\";}i:59;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"79\";s:5:\"label\";s:12:\"stock_report\";s:4:\"link\";s:18:\"admin/stock/report\";s:4:\"icon\";s:16:\"fa fa-line-chart\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2017-04-25 18:48:25\";s:6:\"status\";s:1:\"1\";}i:60;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"81\";s:5:\"label\";s:10:\"stock_list\";s:4:\"link\";s:22:\"admin/stock/stock_list\";s:4:\"icon\";s:20:\"fa fa-stack-exchange\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-26 16:11:10\";s:6:\"status\";s:1:\"1\";}i:61;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"82\";s:5:\"label\";s:12:\"assign_stock\";s:4:\"link\";s:24:\"admin/stock/assign_stock\";s:4:\"icon\";s:16:\"fa fa-align-left\";s:6:\"parent\";s:2:\"78\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:62;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"83\";s:5:\"label\";s:19:\"assign_stock_report\";s:4:\"link\";s:31:\"admin/stock/assign_stock_report\";s:4:\"icon\";s:15:\"fa fa-bar-chart\";s:6:\"parent\";s:2:\"78\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:63;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"84\";s:5:\"label\";s:13:\"stock_history\";s:4:\"link\";s:25:\"admin/stock/stock_history\";s:4:\"icon\";s:17:\"fa fa-file-text-o\";s:6:\"parent\";s:2:\"77\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:64;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"85\";s:5:\"label\";s:11:\"performance\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:14:\"fa fa-dribbble\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"19\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:65;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"86\";s:5:\"label\";s:21:\"performance_indicator\";s:4:\"link\";s:39:\"admin/performance/performance_indicator\";s:4:\"icon\";s:12:\"fa fa-random\";s:6:\"parent\";s:2:\"85\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:66;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"87\";s:5:\"label\";s:18:\"performance_report\";s:4:\"link\";s:36:\"admin/performance/performance_report\";s:4:\"icon\";s:16:\"fa fa-calendar-o\";s:6:\"parent\";s:2:\"85\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:67;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"88\";s:5:\"label\";s:14:\"give_appraisal\";s:4:\"link\";s:44:\"admin/performance/give_performance_appraisal\";s:4:\"icon\";s:10:\"fa fa-plus\";s:6:\"parent\";s:2:\"85\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:68;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"89\";s:5:\"label\";s:7:\"payroll\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:9:\"fa fa-usd\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"18\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:69;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"90\";s:5:\"label\";s:21:\"manage_salary_details\";s:4:\"link\";s:35:\"admin/payroll/manage_salary_details\";s:4:\"icon\";s:9:\"fa fa-usd\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:70;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"91\";s:5:\"label\";s:20:\"employee_salary_list\";s:4:\"link\";s:34:\"admin/payroll/employee_salary_list\";s:4:\"icon\";s:17:\"fa fa-user-secret\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:71;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"92\";s:5:\"label\";s:12:\"make_payment\";s:4:\"link\";s:26:\"admin/payroll/make_payment\";s:4:\"icon\";s:11:\"fa fa-tasks\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:72;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"93\";s:5:\"label\";s:16:\"generate_payslip\";s:4:\"link\";s:30:\"admin/payroll/generate_payslip\";s:4:\"icon\";s:13:\"fa fa-list-ul\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:73;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"94\";s:5:\"label\";s:15:\"salary_template\";s:4:\"link\";s:29:\"admin/payroll/salary_template\";s:4:\"icon\";s:11:\"fa fa-money\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:74;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"95\";s:5:\"label\";s:11:\"hourly_rate\";s:4:\"link\";s:25:\"admin/payroll/hourly_rate\";s:4:\"icon\";s:13:\"fa fa-clock-o\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:75;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"96\";s:5:\"label\";s:15:\"payroll_summary\";s:4:\"link\";s:29:\"admin/payroll/payroll_summary\";s:4:\"icon\";s:18:\"fa fa-camera-retro\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:76;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"97\";s:5:\"label\";s:14:\"provident_fund\";s:4:\"link\";s:28:\"admin/payroll/provident_fund\";s:4:\"icon\";s:15:\"fa fa-briefcase\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2017-06-10 14:04:23\";s:6:\"status\";s:1:\"1\";}i:77;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"98\";s:5:\"label\";s:14:\"advance_salary\";s:4:\"link\";s:28:\"admin/payroll/advance_salary\";s:4:\"icon\";s:19:\"fa fa-cc-mastercard\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2017-06-10 14:04:23\";s:6:\"status\";s:1:\"1\";}i:78;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"99\";s:5:\"label\";s:14:\"employee_award\";s:4:\"link\";s:11:\"admin/award\";s:4:\"icon\";s:12:\"fa fa-trophy\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2017-06-10 14:05:47\";s:6:\"status\";s:1:\"1\";}i:79;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"100\";s:5:\"label\";s:13:\"announcements\";s:4:\"link\";s:19:\"admin/announcements\";s:4:\"icon\";s:19:\"fa fa-bullhorn icon\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"22\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:80;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"101\";s:5:\"label\";s:8:\"training\";s:4:\"link\";s:14:\"admin/training\";s:4:\"icon\";s:14:\"fa fa-suitcase\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"21\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:81;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"102\";s:5:\"label\";s:12:\"job_circular\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:11:\"fa fa-globe\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"17\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:82;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"103\";s:5:\"label\";s:11:\"jobs_posted\";s:4:\"link\";s:30:\"admin/job_circular/jobs_posted\";s:4:\"icon\";s:12:\"fa fa-ticket\";s:6:\"parent\";s:3:\"102\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:83;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"104\";s:5:\"label\";s:17:\"jobs_applications\";s:4:\"link\";s:36:\"admin/job_circular/jobs_applications\";s:4:\"icon\";s:13:\"fa fa-compass\";s:6:\"parent\";s:3:\"102\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:84;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"105\";s:5:\"label\";s:10:\"attendance\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:15:\"fa fa-file-text\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"16\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:85;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"106\";s:5:\"label\";s:18:\"timechange_request\";s:4:\"link\";s:35:\"admin/attendance/timechange_request\";s:4:\"icon\";s:16:\"fa fa-calendar-o\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:86;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"107\";s:5:\"label\";s:17:\"attendance_report\";s:4:\"link\";s:34:\"admin/attendance/attendance_report\";s:4:\"icon\";s:15:\"fa fa-file-text\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:87;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"108\";s:5:\"label\";s:12:\"time_history\";s:4:\"link\";s:29:\"admin/attendance/time_history\";s:4:\"icon\";s:13:\"fa fa-clock-o\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:88;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"109\";s:5:\"label\";s:9:\"pull-down\";s:4:\"link\";s:0:\"\";s:4:\"icon\";s:0:\"\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-31 12:43:20\";s:6:\"status\";s:1:\"0\";}i:89;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"110\";s:5:\"label\";s:11:\"filemanager\";s:4:\"link\";s:17:\"admin/filemanager\";s:4:\"icon\";s:10:\"fa fa-file\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:90;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"111\";s:5:\"label\";s:15:\"company_details\";s:4:\"link\";s:14:\"admin/settings\";s:4:\"icon\";s:23:\"fa fa-fw fa-info-circle\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-25 17:08:46\";s:6:\"status\";s:1:\"2\";}i:91;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"112\";s:5:\"label\";s:15:\"system_settings\";s:4:\"link\";s:21:\"admin/settings/system\";s:4:\"icon\";s:19:\"fa fa-fw fa-desktop\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-04-25 17:08:46\";s:6:\"status\";s:1:\"2\";}i:92;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"113\";s:5:\"label\";s:14:\"email_settings\";s:4:\"link\";s:20:\"admin/settings/email\";s:4:\"icon\";s:20:\"fa fa-fw fa-envelope\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-25 17:08:46\";s:6:\"status\";s:1:\"2\";}i:93;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"114\";s:5:\"label\";s:15:\"email_templates\";s:4:\"link\";s:24:\"admin/settings/templates\";s:4:\"icon\";s:25:\"fa fa-fw fa-pencil-square\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2021-07-30 06:18:08\";s:6:\"status\";s:1:\"2\";}i:94;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"115\";s:5:\"label\";s:17:\"email_integration\";s:4:\"link\";s:32:\"admin/settings/email_integration\";s:4:\"icon\";s:22:\"fa fa-fw fa-envelope-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2021-07-30 06:18:08\";s:6:\"status\";s:1:\"2\";}i:95;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"116\";s:5:\"label\";s:16:\"payment_settings\";s:4:\"link\";s:23:\"admin/settings/payments\";s:4:\"icon\";s:18:\"fa fa-fw fa-dollar\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:96;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"117\";s:5:\"label\";s:16:\"invoice_settings\";s:4:\"link\";s:22:\"admin/settings/invoice\";s:4:\"icon\";s:17:\"fa fa-fw fa-money\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:97;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"118\";s:5:\"label\";s:17:\"estimate_settings\";s:4:\"link\";s:23:\"admin/settings/estimate\";s:4:\"icon\";s:18:\"fa fa-fw fa-file-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:98;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"119\";s:5:\"label\";s:22:\"tickets_leads_settings\";s:4:\"link\";s:22:\"admin/settings/tickets\";s:4:\"icon\";s:18:\"fa fa-fw fa-ticket\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"14\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:99;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"120\";s:5:\"label\";s:14:\"theme_settings\";s:4:\"link\";s:20:\"admin/settings/theme\";s:4:\"icon\";s:16:\"fa fa-fw fa-code\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"20\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:100;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"121\";s:5:\"label\";s:12:\"working_days\";s:4:\"link\";s:27:\"admin/settings/working_days\";s:4:\"icon\";s:20:\"fa fa-fw fa-calendar\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"22\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:101;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"122\";s:5:\"label\";s:14:\"leave_category\";s:4:\"link\";s:29:\"admin/settings/leave_category\";s:4:\"icon\";s:21:\"fa fa-fw fa-pagelines\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"23\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:102;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"123\";s:5:\"label\";s:15:\"income_category\";s:4:\"link\";s:30:\"admin/settings/income_category\";s:4:\"icon\";s:23:\"fa fa-fw fa-certificate\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"24\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:103;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"124\";s:5:\"label\";s:16:\"expense_category\";s:4:\"link\";s:31:\"admin/settings/expense_category\";s:4:\"icon\";s:17:\"fa fa-fw fa-tasks\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"25\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:104;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"125\";s:5:\"label\";s:14:\"customer_group\";s:4:\"link\";s:29:\"admin/settings/customer_group\";s:4:\"icon\";s:17:\"fa fa-fw fa-users\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"26\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:105;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"127\";s:5:\"label\";s:11:\"lead_status\";s:4:\"link\";s:26:\"admin/settings/lead_status\";s:4:\"icon\";s:19:\"fa fa-fw fa-list-ul\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"16\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:106;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"128\";s:5:\"label\";s:11:\"lead_source\";s:4:\"link\";s:26:\"admin/settings/lead_source\";s:4:\"icon\";s:22:\"fa fa-fw fa-arrow-down\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"17\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:107;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"129\";s:5:\"label\";s:26:\"opportunities_state_reason\";s:4:\"link\";s:41:\"admin/settings/opportunities_state_reason\";s:4:\"icon\";s:24:\"fa fa-fw fa-dot-circle-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"19\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:108;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"130\";s:5:\"label\";s:12:\"custom_field\";s:4:\"link\";s:27:\"admin/settings/custom_field\";s:4:\"icon\";s:18:\"fa fa-fw fa-star-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"28\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:109;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"131\";s:5:\"label\";s:14:\"payment_method\";s:4:\"link\";s:29:\"admin/settings/payment_method\";s:4:\"icon\";s:17:\"fa fa-fw fa-money\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"29\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:110;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"132\";s:5:\"label\";s:7:\"cronjob\";s:4:\"link\";s:22:\"admin/settings/cronjob\";s:4:\"icon\";s:18:\"fa fa-fw fa-contao\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"31\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:111;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"133\";s:5:\"label\";s:15:\"menu_allocation\";s:4:\"link\";s:30:\"admin/settings/menu_allocation\";s:4:\"icon\";s:22:\"fa fa-fw fa fa-compass\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"32\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:112;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"134\";s:5:\"label\";s:12:\"notification\";s:4:\"link\";s:27:\"admin/settings/notification\";s:4:\"icon\";s:18:\"fa fa-fw fa-bell-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"33\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:113;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"135\";s:5:\"label\";s:18:\"email_notification\";s:4:\"link\";s:33:\"admin/settings/email_notification\";s:4:\"icon\";s:18:\"fa fa-fw fa-bell-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"34\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:114;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"136\";s:5:\"label\";s:15:\"database_backup\";s:4:\"link\";s:30:\"admin/settings/database_backup\";s:4:\"icon\";s:20:\"fa fa-fw fa-database\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"35\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:115;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"137\";s:5:\"label\";s:12:\"translations\";s:4:\"link\";s:27:\"admin/settings/translations\";s:4:\"icon\";s:20:\"fa fa-fw fa-language\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"36\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:116;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"138\";s:5:\"label\";s:13:\"system_update\";s:4:\"link\";s:28:\"admin/settings/system_update\";s:4:\"icon\";s:27:\"fa fa-fw fa-pencil-square-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"37\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:117;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"139\";s:5:\"label\";s:12:\"private_chat\";s:4:\"link\";s:18:\"chat/conversations\";s:4:\"icon\";s:14:\"fa fa-envelope\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"28\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:118;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"140\";s:5:\"label\";s:9:\"proposals\";s:4:\"link\";s:15:\"admin/proposals\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-01-07 07:05:16\";s:6:\"status\";s:1:\"1\";}i:119;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"141\";s:5:\"label\";s:13:\"knowledgebase\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:21:\"fa fa-question-circle\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"11\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:120;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"142\";s:5:\"label\";s:10:\"categories\";s:4:\"link\";s:30:\"admin/knowledgebase/categories\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"141\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:121;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"143\";s:5:\"label\";s:8:\"articles\";s:4:\"link\";s:28:\"admin/knowledgebase/articles\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"141\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:122;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"144\";s:5:\"label\";s:13:\"knowledgebase\";s:4:\"link\";s:19:\"admin/knowledgebase\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"141\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:123;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"145\";s:5:\"label\";s:18:\"dashboard_settings\";s:4:\"link\";s:24:\"admin/settings/dashboard\";s:4:\"icon\";s:21:\"fa fa-fw fa-dashboard\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"21\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:124;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"146\";s:5:\"label\";s:20:\"transactions_reports\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:16:\"fa fa-building-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-05-13 12:29:51\";s:6:\"status\";s:1:\"1\";}i:125;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"147\";s:5:\"label\";s:5:\"sales\";s:4:\"link\";s:25:\"admin/report/sales_report\";s:4:\"icon\";s:19:\"fa fa-shopping-cart\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-01-07 01:12:23\";s:6:\"status\";s:1:\"1\";}i:126;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"148\";s:5:\"label\";s:15:\"mark_attendance\";s:4:\"link\";s:21:\"admin/mark_attendance\";s:4:\"icon\";s:15:\"fa fa-file-text\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-03-07 06:45:25\";s:6:\"status\";s:1:\"1\";}i:127;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"149\";s:5:\"label\";s:10:\"allowed_ip\";s:4:\"link\";s:25:\"admin/settings/allowed_ip\";s:4:\"icon\";s:12:\"fa fa-server\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"27\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:128;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"150\";s:5:\"label\";s:5:\"stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:11:\"icon-layers\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2019-05-01 18:10:52\";s:6:\"status\";s:1:\"1\";}i:129;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"151\";s:5:\"label\";s:8:\"supplier\";s:4:\"link\";s:14:\"admin/supplier\";s:4:\"icon\";s:14:\"icon-briefcase\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2019-05-01 18:10:52\";s:6:\"status\";s:1:\"1\";}i:130;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"152\";s:5:\"label\";s:8:\"purchase\";s:4:\"link\";s:14:\"admin/purchase\";s:4:\"icon\";s:12:\"icon-handbag\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2019-05-01 18:10:52\";s:6:\"status\";s:1:\"1\";}i:131;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"153\";s:5:\"label\";s:12:\"return_stock\";s:4:\"link\";s:18:\"admin/return_stock\";s:4:\"icon\";s:14:\"icon-share-alt\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2019-05-05 16:19:30\";s:6:\"status\";s:1:\"1\";}i:132;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"154\";s:5:\"label\";s:16:\"purchase_payment\";s:4:\"link\";s:27:\"admin/purchase/all_payments\";s:4:\"icon\";s:16:\"icon-credit-card\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2019-05-05 13:53:11\";s:6:\"status\";s:1:\"1\";}i:133;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"155\";s:5:\"label\";s:17:\"purchase_settings\";s:4:\"link\";s:23:\"admin/settings/purchase\";s:4:\"icon\";s:18:\"fa-fw icon-handbag\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"12\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:134;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"156\";s:5:\"label\";s:11:\"credit_note\";s:4:\"link\";s:17:\"admin/credit_note\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-06-10 02:32:05\";s:6:\"status\";s:1:\"1\";}i:135;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"157\";s:5:\"label\";s:20:\"credit_note_settings\";s:4:\"link\";s:26:\"admin/settings/credit_note\";s:4:\"icon\";s:17:\"fa fa-fw fa-money\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"9\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:136;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"158\";s:5:\"label\";s:18:\"proposals_settings\";s:4:\"link\";s:24:\"admin/settings/proposals\";s:4:\"icon\";s:16:\"fa fa-fw fa-leaf\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"11\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:137;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"159\";s:5:\"label\";s:17:\"projects_settings\";s:4:\"link\";s:23:\"admin/settings/projects\";s:4:\"icon\";s:25:\"fa fa-fw fa-folder-open-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"13\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:138;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"160\";s:5:\"label\";s:4:\"tags\";s:4:\"link\";s:19:\"admin/settings/tags\";s:4:\"icon\";s:16:\"fa fa-fw fa-tags\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"30\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:139;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"161\";s:5:\"label\";s:9:\"lead_form\";s:4:\"link\";s:25:\"admin/leads/all_lead_form\";s:4:\"icon\";s:18:\"fa fa-fw fa-rocket\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"18\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:140;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"162\";s:5:\"label\";s:21:\"transactions_settings\";s:4:\"link\";s:27:\"admin/settings/transactions\";s:4:\"icon\";s:22:\"fa fa-fw fa-building-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"15\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:141;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"163\";s:5:\"label\";s:12:\"sms_settings\";s:4:\"link\";s:27:\"admin/settings/sms_settings\";s:4:\"icon\";s:20:\"fa fa-fw fa-envelope\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2021-07-30 06:18:08\";s:6:\"status\";s:1:\"2\";}i:142;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"164\";s:5:\"label\";s:9:\"pos_sales\";s:4:\"link\";s:23:\"admin/invoice/pos_sales\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2021-10-16 00:53:10\";s:6:\"status\";s:1:\"1\";}i:143;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"186\";s:5:\"label\";s:9:\"warehouse\";s:4:\"link\";s:22:\"admin/warehouse/manage\";s:4:\"icon\";s:16:\"fa fa-building-o\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2021-10-18 09:24:24\";s:6:\"status\";s:1:\"1\";}i:144;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"187\";s:5:\"label\";s:12:\"transferItem\";s:4:\"link\";s:24:\"admin/items/transferItem\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2021-10-14 11:56:08\";s:6:\"status\";s:1:\"1\";}i:145;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"203\";s:5:\"label\";s:13:\"award_setting\";s:4:\"link\";s:20:\"admin/settings/award\";s:4:\"icon\";s:10:\"fa fa-star\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"30\";s:4:\"time\";s:19:\"2022-01-19 05:51:40\";s:6:\"status\";s:1:\"2\";}i:146;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"204\";s:5:\"label\";s:18:\"award_rule_setting\";s:4:\"link\";s:34:\"admin/settings/award_rule_settingh\";s:4:\"icon\";s:10:\"fa fa-star\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"31\";s:4:\"time\";s:19:\"2022-01-19 09:53:50\";s:6:\"status\";s:1:\"2\";}i:147;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"205\";s:5:\"label\";s:22:\"award_program_settings\";s:4:\"link\";s:37:\"admin/settings/award_program_settings\";s:4:\"icon\";s:9:\"fa fa-cog\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"32\";s:4:\"time\";s:19:\"2022-01-20 09:17:30\";s:6:\"status\";s:1:\"2\";}i:148;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"206\";s:5:\"label\";s:19:\"client_award_points\";s:4:\"link\";s:27:\"admin/invoice/client_awards\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2022-01-21 01:39:41\";s:6:\"status\";s:1:\"1\";}i:149;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"207\";s:5:\"label\";s:20:\"best_selling_product\";s:4:\"link\";s:18:\"admin/best_selling\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:2:\"11\";s:4:\"time\";s:19:\"2022-01-21 06:43:52\";s:6:\"status\";s:1:\"1\";}i:150;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"209\";s:5:\"label\";s:7:\"warning\";s:4:\"link\";s:13:\"admin/warning\";s:4:\"icon\";s:13:\"fa fa-warning\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2022-08-07 12:47:01\";s:6:\"status\";s:1:\"1\";}i:151;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"210\";s:5:\"label\";s:9:\"promotion\";s:4:\"link\";s:15:\"admin/promotion\";s:4:\"icon\";s:21:\"fa fa-arrow-circle-up\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2022-08-07 12:49:28\";s:6:\"status\";s:1:\"1\";}i:152;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"211\";s:5:\"label\";s:11:\"termination\";s:4:\"link\";s:17:\"admin/termination\";s:4:\"icon\";s:12:\"fa fa-eraser\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2022-08-07 12:50:45\";s:6:\"status\";s:1:\"1\";}i:153;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"212\";s:5:\"label\";s:11:\"resignation\";s:4:\"link\";s:17:\"admin/resignation\";s:4:\"icon\";s:14:\"fa fa-scissors\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2022-08-07 12:54:31\";s:6:\"status\";s:1:\"1\";}}');
INSERT INTO `tbl_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2a7f10a0f00d318acee54bee8aed775834fab7f5', '136.158.120.226', 1688630732, '__ci_last_regenerate|i:1688630732;menu_active_id|a:3:{i:0;s:3:\"138\";i:1;s:2:\"25\";i:2;s:1:\"0\";}url|s:33:\"admin/dashboard/pinned_menu_items\";user_roll|a:154:{i:0;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"1\";s:5:\"label\";s:9:\"dashboard\";s:4:\"link\";s:15:\"admin/dashboard\";s:4:\"icon\";s:15:\"fa fa-dashboard\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-04-23 01:39:36\";s:6:\"status\";s:1:\"1\";}i:1;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"2\";s:5:\"label\";s:8:\"calendar\";s:4:\"link\";s:14:\"admin/calendar\";s:4:\"icon\";s:14:\"fa fa-calendar\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-23 19:57:23\";s:6:\"status\";s:1:\"1\";}i:2;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"4\";s:5:\"label\";s:6:\"client\";s:4:\"link\";s:26:\"admin/client/manage_client\";s:4:\"icon\";s:11:\"fa fa-users\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"13\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:3;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"5\";s:5:\"label\";s:7:\"mailbox\";s:4:\"link\";s:13:\"admin/mailbox\";s:4:\"icon\";s:16:\"fa fa-envelope-o\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:4;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"6\";s:5:\"label\";s:7:\"tickets\";s:4:\"link\";s:13:\"admin/tickets\";s:4:\"icon\";s:12:\"fa fa-ticket\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2018-06-08 13:39:39\";s:6:\"status\";s:1:\"1\";}i:5;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"12\";s:5:\"label\";s:5:\"sales\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:19:\"fa fa-shopping-cart\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"9\";s:4:\"time\";s:19:\"2017-06-10 14:02:58\";s:6:\"status\";s:1:\"1\";}i:6;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"13\";s:5:\"label\";s:7:\"invoice\";s:4:\"link\";s:28:\"admin/invoice/manage_invoice\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-04-23 19:57:23\";s:6:\"status\";s:1:\"1\";}i:7;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"14\";s:5:\"label\";s:9:\"estimates\";s:4:\"link\";s:15:\"admin/estimates\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-06-10 14:02:05\";s:6:\"status\";s:1:\"1\";}i:8;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"15\";s:5:\"label\";s:17:\"payments_received\";s:4:\"link\";s:26:\"admin/invoice/all_payments\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-23 19:57:24\";s:6:\"status\";s:1:\"1\";}i:9;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"16\";s:5:\"label\";s:9:\"tax_rates\";s:4:\"link\";s:23:\"admin/invoice/tax_rates\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-01-07 07:05:16\";s:6:\"status\";s:1:\"1\";}i:10;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"21\";s:5:\"label\";s:10:\"quotations\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:11:\"fa fa-paste\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:11;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"22\";s:5:\"label\";s:15:\"quotations_list\";s:4:\"link\";s:16:\"admin/quotations\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"21\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-05-18 16:49:03\";s:6:\"status\";s:1:\"1\";}i:12;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"23\";s:5:\"label\";s:15:\"quotations_form\";s:4:\"link\";s:32:\"admin/quotations/quotations_form\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"21\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:13;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"24\";s:5:\"label\";s:4:\"user\";s:4:\"link\";s:20:\"admin/user/user_list\";s:4:\"icon\";s:11:\"fa fa-users\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"25\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:14;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"25\";s:5:\"label\";s:8:\"settings\";s:4:\"link\";s:14:\"admin/settings\";s:4:\"icon\";s:10:\"fa fa-cogs\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"26\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:15;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"26\";s:5:\"label\";s:15:\"database_backup\";s:4:\"link\";s:30:\"admin/settings/database_backup\";s:4:\"icon\";s:14:\"fa fa-database\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"27\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:16;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"29\";s:5:\"label\";s:17:\"transactions_menu\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:16:\"fa fa-building-o\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"12\";s:4:\"time\";s:19:\"2018-05-13 12:27:58\";s:6:\"status\";s:1:\"1\";}i:17;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"30\";s:5:\"label\";s:7:\"deposit\";s:4:\"link\";s:26:\"admin/transactions/deposit\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-05-13 12:28:33\";s:6:\"status\";s:1:\"1\";}i:18;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"31\";s:5:\"label\";s:7:\"expense\";s:4:\"link\";s:26:\"admin/transactions/expense\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-05-13 12:28:37\";s:6:\"status\";s:1:\"1\";}i:19;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"32\";s:5:\"label\";s:8:\"transfer\";s:4:\"link\";s:27:\"admin/transactions/transfer\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-05-13 12:28:40\";s:6:\"status\";s:1:\"1\";}i:20;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"33\";s:5:\"label\";s:19:\"transactions_report\";s:4:\"link\";s:38:\"admin/transactions/transactions_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2018-05-13 12:28:44\";s:6:\"status\";s:1:\"1\";}i:21;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"34\";s:5:\"label\";s:13:\"balance_sheet\";s:4:\"link\";s:32:\"admin/transactions/balance_sheet\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-05-13 12:28:47\";s:6:\"status\";s:1:\"1\";}i:22;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"36\";s:5:\"label\";s:9:\"bank_cash\";s:4:\"link\";s:28:\"admin/account/manage_account\";s:4:\"icon\";s:11:\"fa fa-money\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2018-05-13 12:28:51\";s:6:\"status\";s:1:\"1\";}i:23;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"39\";s:5:\"label\";s:5:\"items\";s:4:\"link\";s:22:\"admin/items/items_list\";s:4:\"icon\";s:10:\"fa fa-cube\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2019-05-04 18:49:50\";s:6:\"status\";s:1:\"1\";}i:24;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"42\";s:5:\"label\";s:6:\"report\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:15:\"fa fa-bar-chart\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"24\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:25;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"43\";s:5:\"label\";s:17:\"account_statement\";s:4:\"link\";s:30:\"admin/report/account_statement\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:26;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"44\";s:5:\"label\";s:13:\"income_report\";s:4:\"link\";s:26:\"admin/report/income_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:27;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"45\";s:5:\"label\";s:14:\"expense_report\";s:4:\"link\";s:27:\"admin/report/expense_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:28;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"46\";s:5:\"label\";s:14:\"income_expense\";s:4:\"link\";s:27:\"admin/report/income_expense\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:29;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"47\";s:5:\"label\";s:16:\"date_wise_report\";s:4:\"link\";s:29:\"admin/report/date_wise_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:30;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"48\";s:5:\"label\";s:10:\"all_income\";s:4:\"link\";s:23:\"admin/report/all_income\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:31;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"49\";s:5:\"label\";s:11:\"all_expense\";s:4:\"link\";s:24:\"admin/report/all_expense\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:32;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"50\";s:5:\"label\";s:15:\"all_transaction\";s:4:\"link\";s:28:\"admin/report/all_transaction\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:33;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"51\";s:5:\"label\";s:17:\"recurring_invoice\";s:4:\"link\";s:31:\"admin/invoice/recurring_invoice\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-06-10 14:02:05\";s:6:\"status\";s:1:\"1\";}i:34;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"52\";s:5:\"label\";s:15:\"transfer_report\";s:4:\"link\";s:34:\"admin/transactions/transfer_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-05-13 12:28:59\";s:6:\"status\";s:1:\"1\";}i:35;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"53\";s:5:\"label\";s:15:\"report_by_month\";s:4:\"link\";s:28:\"admin/report/report_by_month\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:36;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"54\";s:5:\"label\";s:5:\"tasks\";s:4:\"link\";s:20:\"admin/tasks/all_task\";s:4:\"icon\";s:11:\"fa fa-tasks\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:37;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"55\";s:5:\"label\";s:5:\"leads\";s:4:\"link\";s:11:\"admin/leads\";s:4:\"icon\";s:12:\"fa fa-rocket\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:38;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"56\";s:5:\"label\";s:13:\"opportunities\";s:4:\"link\";s:19:\"admin/opportunities\";s:4:\"icon\";s:12:\"fa fa-filter\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:39;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"57\";s:5:\"label\";s:8:\"projects\";s:4:\"link\";s:14:\"admin/projects\";s:4:\"icon\";s:19:\"fa fa-folder-open-o\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:40;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"58\";s:5:\"label\";s:4:\"bugs\";s:4:\"link\";s:10:\"admin/bugs\";s:4:\"icon\";s:9:\"fa fa-bug\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:41;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"59\";s:5:\"label\";s:7:\"project\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:19:\"fa fa-folder-open-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:42;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"60\";s:5:\"label\";s:12:\"tasks_report\";s:4:\"link\";s:25:\"admin/report/tasks_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:43;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"61\";s:5:\"label\";s:11:\"bugs_report\";s:4:\"link\";s:24:\"admin/report/bugs_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:44;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"62\";s:5:\"label\";s:14:\"tickets_report\";s:4:\"link\";s:27:\"admin/report/tickets_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:45;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"63\";s:5:\"label\";s:13:\"client_report\";s:4:\"link\";s:26:\"admin/report/client_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2018-01-07 07:09:40\";s:6:\"status\";s:1:\"1\";}i:46;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"66\";s:5:\"label\";s:16:\"tasks_assignment\";s:4:\"link\";s:29:\"admin/report/tasks_assignment\";s:4:\"icon\";s:18:\"fa fa-dot-circle-o\";s:6:\"parent\";s:2:\"59\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:47;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"67\";s:5:\"label\";s:15:\"bugs_assignment\";s:4:\"link\";s:28:\"admin/report/bugs_assignment\";s:4:\"icon\";s:18:\"fa fa-dot-circle-o\";s:6:\"parent\";s:2:\"59\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:48;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"68\";s:5:\"label\";s:14:\"project_report\";s:4:\"link\";s:27:\"admin/report/project_report\";s:4:\"icon\";s:18:\"fa fa-dot-circle-o\";s:6:\"parent\";s:2:\"59\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:49;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"69\";s:5:\"label\";s:13:\"goal_tracking\";s:4:\"link\";s:19:\"admin/goal_tracking\";s:4:\"icon\";s:12:\"fa fa-shield\";s:6:\"parent\";s:2:\"73\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-06-10 14:05:47\";s:6:\"status\";s:1:\"1\";}i:50;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"70\";s:5:\"label\";s:11:\"departments\";s:4:\"link\";s:17:\"admin/departments\";s:4:\"icon\";s:17:\"fa fa-user-secret\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"14\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:51;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"71\";s:5:\"label\";s:7:\"holiday\";s:4:\"link\";s:13:\"admin/holiday\";s:4:\"icon\";s:21:\"fa fa-calendar-plus-o\";s:6:\"parent\";s:2:\"73\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-06-10 14:05:47\";s:6:\"status\";s:1:\"1\";}i:52;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"72\";s:5:\"label\";s:16:\"leave_management\";s:4:\"link\";s:22:\"admin/leave_management\";s:4:\"icon\";s:11:\"fa fa-plane\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"20\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:53;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"73\";s:5:\"label\";s:9:\"utilities\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:10:\"fa fa-gift\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"23\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:54;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"74\";s:5:\"label\";s:8:\"overtime\";s:4:\"link\";s:24:\"admin/utilities/overtime\";s:4:\"icon\";s:13:\"fa fa-clock-o\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"9\";s:4:\"time\";s:19:\"2017-06-10 14:04:23\";s:6:\"status\";s:1:\"1\";}i:55;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"75\";s:5:\"label\";s:12:\"office_stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:13:\"fa fa-codepen\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"15\";s:4:\"time\";s:19:\"2019-05-01 16:22:56\";s:6:\"status\";s:1:\"1\";}i:56;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"76\";s:5:\"label\";s:14:\"stock_category\";s:4:\"link\";s:26:\"admin/stock/stock_category\";s:4:\"icon\";s:13:\"fa fa-sliders\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:57;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"77\";s:5:\"label\";s:12:\"manage_stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:13:\"fa fa-archive\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-04-26 16:11:10\";s:6:\"status\";s:1:\"1\";}i:58;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"78\";s:5:\"label\";s:12:\"assign_stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:16:\"fa fa-align-left\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-26 16:11:10\";s:6:\"status\";s:1:\"1\";}i:59;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"79\";s:5:\"label\";s:12:\"stock_report\";s:4:\"link\";s:18:\"admin/stock/report\";s:4:\"icon\";s:16:\"fa fa-line-chart\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2017-04-25 18:48:25\";s:6:\"status\";s:1:\"1\";}i:60;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"81\";s:5:\"label\";s:10:\"stock_list\";s:4:\"link\";s:22:\"admin/stock/stock_list\";s:4:\"icon\";s:20:\"fa fa-stack-exchange\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-26 16:11:10\";s:6:\"status\";s:1:\"1\";}i:61;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"82\";s:5:\"label\";s:12:\"assign_stock\";s:4:\"link\";s:24:\"admin/stock/assign_stock\";s:4:\"icon\";s:16:\"fa fa-align-left\";s:6:\"parent\";s:2:\"78\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:62;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"83\";s:5:\"label\";s:19:\"assign_stock_report\";s:4:\"link\";s:31:\"admin/stock/assign_stock_report\";s:4:\"icon\";s:15:\"fa fa-bar-chart\";s:6:\"parent\";s:2:\"78\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:63;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"84\";s:5:\"label\";s:13:\"stock_history\";s:4:\"link\";s:25:\"admin/stock/stock_history\";s:4:\"icon\";s:17:\"fa fa-file-text-o\";s:6:\"parent\";s:2:\"77\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:64;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"85\";s:5:\"label\";s:11:\"performance\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:14:\"fa fa-dribbble\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"19\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:65;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"86\";s:5:\"label\";s:21:\"performance_indicator\";s:4:\"link\";s:39:\"admin/performance/performance_indicator\";s:4:\"icon\";s:12:\"fa fa-random\";s:6:\"parent\";s:2:\"85\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:66;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"87\";s:5:\"label\";s:18:\"performance_report\";s:4:\"link\";s:36:\"admin/performance/performance_report\";s:4:\"icon\";s:16:\"fa fa-calendar-o\";s:6:\"parent\";s:2:\"85\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:67;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"88\";s:5:\"label\";s:14:\"give_appraisal\";s:4:\"link\";s:44:\"admin/performance/give_performance_appraisal\";s:4:\"icon\";s:10:\"fa fa-plus\";s:6:\"parent\";s:2:\"85\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:68;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"89\";s:5:\"label\";s:7:\"payroll\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:9:\"fa fa-usd\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"18\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:69;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"90\";s:5:\"label\";s:21:\"manage_salary_details\";s:4:\"link\";s:35:\"admin/payroll/manage_salary_details\";s:4:\"icon\";s:9:\"fa fa-usd\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:70;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"91\";s:5:\"label\";s:20:\"employee_salary_list\";s:4:\"link\";s:34:\"admin/payroll/employee_salary_list\";s:4:\"icon\";s:17:\"fa fa-user-secret\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:71;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"92\";s:5:\"label\";s:12:\"make_payment\";s:4:\"link\";s:26:\"admin/payroll/make_payment\";s:4:\"icon\";s:11:\"fa fa-tasks\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:72;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"93\";s:5:\"label\";s:16:\"generate_payslip\";s:4:\"link\";s:30:\"admin/payroll/generate_payslip\";s:4:\"icon\";s:13:\"fa fa-list-ul\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:73;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"94\";s:5:\"label\";s:15:\"salary_template\";s:4:\"link\";s:29:\"admin/payroll/salary_template\";s:4:\"icon\";s:11:\"fa fa-money\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:74;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"95\";s:5:\"label\";s:11:\"hourly_rate\";s:4:\"link\";s:25:\"admin/payroll/hourly_rate\";s:4:\"icon\";s:13:\"fa fa-clock-o\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:75;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"96\";s:5:\"label\";s:15:\"payroll_summary\";s:4:\"link\";s:29:\"admin/payroll/payroll_summary\";s:4:\"icon\";s:18:\"fa fa-camera-retro\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:76;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"97\";s:5:\"label\";s:14:\"provident_fund\";s:4:\"link\";s:28:\"admin/payroll/provident_fund\";s:4:\"icon\";s:15:\"fa fa-briefcase\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2017-06-10 14:04:23\";s:6:\"status\";s:1:\"1\";}i:77;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"98\";s:5:\"label\";s:14:\"advance_salary\";s:4:\"link\";s:28:\"admin/payroll/advance_salary\";s:4:\"icon\";s:19:\"fa fa-cc-mastercard\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2017-06-10 14:04:23\";s:6:\"status\";s:1:\"1\";}i:78;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"99\";s:5:\"label\";s:14:\"employee_award\";s:4:\"link\";s:11:\"admin/award\";s:4:\"icon\";s:12:\"fa fa-trophy\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2017-06-10 14:05:47\";s:6:\"status\";s:1:\"1\";}i:79;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"100\";s:5:\"label\";s:13:\"announcements\";s:4:\"link\";s:19:\"admin/announcements\";s:4:\"icon\";s:19:\"fa fa-bullhorn icon\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"22\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:80;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"101\";s:5:\"label\";s:8:\"training\";s:4:\"link\";s:14:\"admin/training\";s:4:\"icon\";s:14:\"fa fa-suitcase\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"21\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:81;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"102\";s:5:\"label\";s:12:\"job_circular\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:11:\"fa fa-globe\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"17\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:82;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"103\";s:5:\"label\";s:11:\"jobs_posted\";s:4:\"link\";s:30:\"admin/job_circular/jobs_posted\";s:4:\"icon\";s:12:\"fa fa-ticket\";s:6:\"parent\";s:3:\"102\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:83;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"104\";s:5:\"label\";s:17:\"jobs_applications\";s:4:\"link\";s:36:\"admin/job_circular/jobs_applications\";s:4:\"icon\";s:13:\"fa fa-compass\";s:6:\"parent\";s:3:\"102\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:84;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"105\";s:5:\"label\";s:10:\"attendance\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:15:\"fa fa-file-text\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"16\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:85;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"106\";s:5:\"label\";s:18:\"timechange_request\";s:4:\"link\";s:35:\"admin/attendance/timechange_request\";s:4:\"icon\";s:16:\"fa fa-calendar-o\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:86;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"107\";s:5:\"label\";s:17:\"attendance_report\";s:4:\"link\";s:34:\"admin/attendance/attendance_report\";s:4:\"icon\";s:15:\"fa fa-file-text\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:87;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"108\";s:5:\"label\";s:12:\"time_history\";s:4:\"link\";s:29:\"admin/attendance/time_history\";s:4:\"icon\";s:13:\"fa fa-clock-o\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:88;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"109\";s:5:\"label\";s:9:\"pull-down\";s:4:\"link\";s:0:\"\";s:4:\"icon\";s:0:\"\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-31 12:43:20\";s:6:\"status\";s:1:\"0\";}i:89;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"110\";s:5:\"label\";s:11:\"filemanager\";s:4:\"link\";s:17:\"admin/filemanager\";s:4:\"icon\";s:10:\"fa fa-file\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:90;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"111\";s:5:\"label\";s:15:\"company_details\";s:4:\"link\";s:14:\"admin/settings\";s:4:\"icon\";s:23:\"fa fa-fw fa-info-circle\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-25 17:08:46\";s:6:\"status\";s:1:\"2\";}i:91;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"112\";s:5:\"label\";s:15:\"system_settings\";s:4:\"link\";s:21:\"admin/settings/system\";s:4:\"icon\";s:19:\"fa fa-fw fa-desktop\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-04-25 17:08:46\";s:6:\"status\";s:1:\"2\";}i:92;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"113\";s:5:\"label\";s:14:\"email_settings\";s:4:\"link\";s:20:\"admin/settings/email\";s:4:\"icon\";s:20:\"fa fa-fw fa-envelope\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-25 17:08:46\";s:6:\"status\";s:1:\"2\";}i:93;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"114\";s:5:\"label\";s:15:\"email_templates\";s:4:\"link\";s:24:\"admin/settings/templates\";s:4:\"icon\";s:25:\"fa fa-fw fa-pencil-square\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2021-07-30 06:18:08\";s:6:\"status\";s:1:\"2\";}i:94;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"115\";s:5:\"label\";s:17:\"email_integration\";s:4:\"link\";s:32:\"admin/settings/email_integration\";s:4:\"icon\";s:22:\"fa fa-fw fa-envelope-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2021-07-30 06:18:08\";s:6:\"status\";s:1:\"2\";}i:95;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"116\";s:5:\"label\";s:16:\"payment_settings\";s:4:\"link\";s:23:\"admin/settings/payments\";s:4:\"icon\";s:18:\"fa fa-fw fa-dollar\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:96;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"117\";s:5:\"label\";s:16:\"invoice_settings\";s:4:\"link\";s:22:\"admin/settings/invoice\";s:4:\"icon\";s:17:\"fa fa-fw fa-money\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:97;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"118\";s:5:\"label\";s:17:\"estimate_settings\";s:4:\"link\";s:23:\"admin/settings/estimate\";s:4:\"icon\";s:18:\"fa fa-fw fa-file-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:98;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"119\";s:5:\"label\";s:22:\"tickets_leads_settings\";s:4:\"link\";s:22:\"admin/settings/tickets\";s:4:\"icon\";s:18:\"fa fa-fw fa-ticket\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"14\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:99;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"120\";s:5:\"label\";s:14:\"theme_settings\";s:4:\"link\";s:20:\"admin/settings/theme\";s:4:\"icon\";s:16:\"fa fa-fw fa-code\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"20\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:100;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"121\";s:5:\"label\";s:12:\"working_days\";s:4:\"link\";s:27:\"admin/settings/working_days\";s:4:\"icon\";s:20:\"fa fa-fw fa-calendar\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"22\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:101;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"122\";s:5:\"label\";s:14:\"leave_category\";s:4:\"link\";s:29:\"admin/settings/leave_category\";s:4:\"icon\";s:21:\"fa fa-fw fa-pagelines\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"23\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:102;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"123\";s:5:\"label\";s:15:\"income_category\";s:4:\"link\";s:30:\"admin/settings/income_category\";s:4:\"icon\";s:23:\"fa fa-fw fa-certificate\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"24\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:103;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"124\";s:5:\"label\";s:16:\"expense_category\";s:4:\"link\";s:31:\"admin/settings/expense_category\";s:4:\"icon\";s:17:\"fa fa-fw fa-tasks\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"25\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:104;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"125\";s:5:\"label\";s:14:\"customer_group\";s:4:\"link\";s:29:\"admin/settings/customer_group\";s:4:\"icon\";s:17:\"fa fa-fw fa-users\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"26\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:105;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"127\";s:5:\"label\";s:11:\"lead_status\";s:4:\"link\";s:26:\"admin/settings/lead_status\";s:4:\"icon\";s:19:\"fa fa-fw fa-list-ul\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"16\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:106;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"128\";s:5:\"label\";s:11:\"lead_source\";s:4:\"link\";s:26:\"admin/settings/lead_source\";s:4:\"icon\";s:22:\"fa fa-fw fa-arrow-down\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"17\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:107;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"129\";s:5:\"label\";s:26:\"opportunities_state_reason\";s:4:\"link\";s:41:\"admin/settings/opportunities_state_reason\";s:4:\"icon\";s:24:\"fa fa-fw fa-dot-circle-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"19\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:108;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"130\";s:5:\"label\";s:12:\"custom_field\";s:4:\"link\";s:27:\"admin/settings/custom_field\";s:4:\"icon\";s:18:\"fa fa-fw fa-star-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"28\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:109;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"131\";s:5:\"label\";s:14:\"payment_method\";s:4:\"link\";s:29:\"admin/settings/payment_method\";s:4:\"icon\";s:17:\"fa fa-fw fa-money\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"29\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:110;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"132\";s:5:\"label\";s:7:\"cronjob\";s:4:\"link\";s:22:\"admin/settings/cronjob\";s:4:\"icon\";s:18:\"fa fa-fw fa-contao\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"31\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:111;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"133\";s:5:\"label\";s:15:\"menu_allocation\";s:4:\"link\";s:30:\"admin/settings/menu_allocation\";s:4:\"icon\";s:22:\"fa fa-fw fa fa-compass\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"32\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:112;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"134\";s:5:\"label\";s:12:\"notification\";s:4:\"link\";s:27:\"admin/settings/notification\";s:4:\"icon\";s:18:\"fa fa-fw fa-bell-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"33\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:113;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"135\";s:5:\"label\";s:18:\"email_notification\";s:4:\"link\";s:33:\"admin/settings/email_notification\";s:4:\"icon\";s:18:\"fa fa-fw fa-bell-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"34\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:114;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"136\";s:5:\"label\";s:15:\"database_backup\";s:4:\"link\";s:30:\"admin/settings/database_backup\";s:4:\"icon\";s:20:\"fa fa-fw fa-database\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"35\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:115;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"137\";s:5:\"label\";s:12:\"translations\";s:4:\"link\";s:27:\"admin/settings/translations\";s:4:\"icon\";s:20:\"fa fa-fw fa-language\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"36\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:116;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"138\";s:5:\"label\";s:13:\"system_update\";s:4:\"link\";s:28:\"admin/settings/system_update\";s:4:\"icon\";s:27:\"fa fa-fw fa-pencil-square-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"37\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:117;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"139\";s:5:\"label\";s:12:\"private_chat\";s:4:\"link\";s:18:\"chat/conversations\";s:4:\"icon\";s:14:\"fa fa-envelope\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"28\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:118;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"140\";s:5:\"label\";s:9:\"proposals\";s:4:\"link\";s:15:\"admin/proposals\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-01-07 07:05:16\";s:6:\"status\";s:1:\"1\";}i:119;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"141\";s:5:\"label\";s:13:\"knowledgebase\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:21:\"fa fa-question-circle\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"11\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:120;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"142\";s:5:\"label\";s:10:\"categories\";s:4:\"link\";s:30:\"admin/knowledgebase/categories\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"141\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:121;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"143\";s:5:\"label\";s:8:\"articles\";s:4:\"link\";s:28:\"admin/knowledgebase/articles\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"141\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:122;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"144\";s:5:\"label\";s:13:\"knowledgebase\";s:4:\"link\";s:19:\"admin/knowledgebase\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"141\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:123;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"145\";s:5:\"label\";s:18:\"dashboard_settings\";s:4:\"link\";s:24:\"admin/settings/dashboard\";s:4:\"icon\";s:21:\"fa fa-fw fa-dashboard\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"21\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:124;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"146\";s:5:\"label\";s:20:\"transactions_reports\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:16:\"fa fa-building-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-05-13 12:29:51\";s:6:\"status\";s:1:\"1\";}i:125;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"147\";s:5:\"label\";s:5:\"sales\";s:4:\"link\";s:25:\"admin/report/sales_report\";s:4:\"icon\";s:19:\"fa fa-shopping-cart\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-01-07 01:12:23\";s:6:\"status\";s:1:\"1\";}i:126;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"148\";s:5:\"label\";s:15:\"mark_attendance\";s:4:\"link\";s:21:\"admin/mark_attendance\";s:4:\"icon\";s:15:\"fa fa-file-text\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-03-07 06:45:25\";s:6:\"status\";s:1:\"1\";}i:127;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"149\";s:5:\"label\";s:10:\"allowed_ip\";s:4:\"link\";s:25:\"admin/settings/allowed_ip\";s:4:\"icon\";s:12:\"fa fa-server\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"27\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:128;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"150\";s:5:\"label\";s:5:\"stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:11:\"icon-layers\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2019-05-01 18:10:52\";s:6:\"status\";s:1:\"1\";}i:129;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"151\";s:5:\"label\";s:8:\"supplier\";s:4:\"link\";s:14:\"admin/supplier\";s:4:\"icon\";s:14:\"icon-briefcase\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2019-05-01 18:10:52\";s:6:\"status\";s:1:\"1\";}i:130;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"152\";s:5:\"label\";s:8:\"purchase\";s:4:\"link\";s:14:\"admin/purchase\";s:4:\"icon\";s:12:\"icon-handbag\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2019-05-01 18:10:52\";s:6:\"status\";s:1:\"1\";}i:131;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"153\";s:5:\"label\";s:12:\"return_stock\";s:4:\"link\";s:18:\"admin/return_stock\";s:4:\"icon\";s:14:\"icon-share-alt\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2019-05-05 16:19:30\";s:6:\"status\";s:1:\"1\";}i:132;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"154\";s:5:\"label\";s:16:\"purchase_payment\";s:4:\"link\";s:27:\"admin/purchase/all_payments\";s:4:\"icon\";s:16:\"icon-credit-card\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2019-05-05 13:53:11\";s:6:\"status\";s:1:\"1\";}i:133;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"155\";s:5:\"label\";s:17:\"purchase_settings\";s:4:\"link\";s:23:\"admin/settings/purchase\";s:4:\"icon\";s:18:\"fa-fw icon-handbag\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"12\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:134;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"156\";s:5:\"label\";s:11:\"credit_note\";s:4:\"link\";s:17:\"admin/credit_note\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-06-10 02:32:05\";s:6:\"status\";s:1:\"1\";}i:135;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"157\";s:5:\"label\";s:20:\"credit_note_settings\";s:4:\"link\";s:26:\"admin/settings/credit_note\";s:4:\"icon\";s:17:\"fa fa-fw fa-money\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"9\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:136;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"158\";s:5:\"label\";s:18:\"proposals_settings\";s:4:\"link\";s:24:\"admin/settings/proposals\";s:4:\"icon\";s:16:\"fa fa-fw fa-leaf\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"11\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:137;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"159\";s:5:\"label\";s:17:\"projects_settings\";s:4:\"link\";s:23:\"admin/settings/projects\";s:4:\"icon\";s:25:\"fa fa-fw fa-folder-open-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"13\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:138;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"160\";s:5:\"label\";s:4:\"tags\";s:4:\"link\";s:19:\"admin/settings/tags\";s:4:\"icon\";s:16:\"fa fa-fw fa-tags\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"30\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:139;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"161\";s:5:\"label\";s:9:\"lead_form\";s:4:\"link\";s:25:\"admin/leads/all_lead_form\";s:4:\"icon\";s:18:\"fa fa-fw fa-rocket\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"18\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:140;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"162\";s:5:\"label\";s:21:\"transactions_settings\";s:4:\"link\";s:27:\"admin/settings/transactions\";s:4:\"icon\";s:22:\"fa fa-fw fa-building-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"15\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:141;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"163\";s:5:\"label\";s:12:\"sms_settings\";s:4:\"link\";s:27:\"admin/settings/sms_settings\";s:4:\"icon\";s:20:\"fa fa-fw fa-envelope\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2021-07-30 06:18:08\";s:6:\"status\";s:1:\"2\";}i:142;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"164\";s:5:\"label\";s:9:\"pos_sales\";s:4:\"link\";s:23:\"admin/invoice/pos_sales\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2021-10-16 00:53:10\";s:6:\"status\";s:1:\"1\";}i:143;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"186\";s:5:\"label\";s:9:\"warehouse\";s:4:\"link\";s:22:\"admin/warehouse/manage\";s:4:\"icon\";s:16:\"fa fa-building-o\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2021-10-18 09:24:24\";s:6:\"status\";s:1:\"1\";}i:144;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"187\";s:5:\"label\";s:12:\"transferItem\";s:4:\"link\";s:24:\"admin/items/transferItem\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2021-10-14 11:56:08\";s:6:\"status\";s:1:\"1\";}i:145;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"203\";s:5:\"label\";s:13:\"award_setting\";s:4:\"link\";s:20:\"admin/settings/award\";s:4:\"icon\";s:10:\"fa fa-star\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"30\";s:4:\"time\";s:19:\"2022-01-19 05:51:40\";s:6:\"status\";s:1:\"2\";}i:146;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"204\";s:5:\"label\";s:18:\"award_rule_setting\";s:4:\"link\";s:34:\"admin/settings/award_rule_settingh\";s:4:\"icon\";s:10:\"fa fa-star\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"31\";s:4:\"time\";s:19:\"2022-01-19 09:53:50\";s:6:\"status\";s:1:\"2\";}i:147;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"205\";s:5:\"label\";s:22:\"award_program_settings\";s:4:\"link\";s:37:\"admin/settings/award_program_settings\";s:4:\"icon\";s:9:\"fa fa-cog\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"32\";s:4:\"time\";s:19:\"2022-01-20 09:17:30\";s:6:\"status\";s:1:\"2\";}i:148;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"206\";s:5:\"label\";s:19:\"client_award_points\";s:4:\"link\";s:27:\"admin/invoice/client_awards\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2022-01-21 01:39:41\";s:6:\"status\";s:1:\"1\";}i:149;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"207\";s:5:\"label\";s:20:\"best_selling_product\";s:4:\"link\";s:18:\"admin/best_selling\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:2:\"11\";s:4:\"time\";s:19:\"2022-01-21 06:43:52\";s:6:\"status\";s:1:\"1\";}i:150;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"209\";s:5:\"label\";s:7:\"warning\";s:4:\"link\";s:13:\"admin/warning\";s:4:\"icon\";s:13:\"fa fa-warning\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2022-08-07 12:47:01\";s:6:\"status\";s:1:\"1\";}i:151;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"210\";s:5:\"label\";s:9:\"promotion\";s:4:\"link\";s:15:\"admin/promotion\";s:4:\"icon\";s:21:\"fa fa-arrow-circle-up\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2022-08-07 12:49:28\";s:6:\"status\";s:1:\"1\";}i:152;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"211\";s:5:\"label\";s:11:\"termination\";s:4:\"link\";s:17:\"admin/termination\";s:4:\"icon\";s:12:\"fa fa-eraser\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2022-08-07 12:50:45\";s:6:\"status\";s:1:\"1\";}i:153;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"212\";s:5:\"label\";s:11:\"resignation\";s:4:\"link\";s:17:\"admin/resignation\";s:4:\"icon\";s:14:\"fa fa-scissors\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2022-08-07 12:54:31\";s:6:\"status\";s:1:\"1\";}}user_name|s:5:\"nimda\";email|s:26:\"erick@blickcreative.com.au\";name|s:13:\"Erick Villeta\";photo|s:26:\"uploads/default_avatar.jpg\";user_id|s:1:\"5\";last_login|s:19:\"2023-07-06 00:35:09\";online_time|i:1688630646;loggedin|b:1;user_type|s:1:\"1\";user_flag|s:1:\"1\";direction|s:3:\"ltr\";warehouse_id|N;designations_id|s:1:\"0\";');
INSERT INTO `tbl_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2aa2ae275349e4f4a0e87088db84b0d04b7df6cb', '136.158.121.2', 1688896449, '__ci_last_regenerate|i:1688896449;user_name|s:5:\"nimda\";email|s:26:\"erick@blickcreative.com.au\";name|s:13:\"Erick Villeta\";photo|s:26:\"uploads/default_avatar.jpg\";user_id|s:1:\"5\";last_login|s:19:\"2023-07-06 18:18:11\";online_time|i:1688808368;loggedin|b:1;user_type|s:1:\"1\";user_flag|s:1:\"1\";direction|s:3:\"ltr\";warehouse_id|N;designations_id|s:1:\"0\";url|s:33:\"admin/dashboard/pinned_menu_items\";menu_active_id|a:2:{i:0;s:1:\"4\";i:1;s:1:\"0\";}user_roll|a:154:{i:0;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"1\";s:5:\"label\";s:9:\"dashboard\";s:4:\"link\";s:15:\"admin/dashboard\";s:4:\"icon\";s:15:\"fa fa-dashboard\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-04-23 01:39:36\";s:6:\"status\";s:1:\"1\";}i:1;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"2\";s:5:\"label\";s:8:\"calendar\";s:4:\"link\";s:14:\"admin/calendar\";s:4:\"icon\";s:14:\"fa fa-calendar\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-23 19:57:23\";s:6:\"status\";s:1:\"1\";}i:2;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"4\";s:5:\"label\";s:6:\"client\";s:4:\"link\";s:26:\"admin/client/manage_client\";s:4:\"icon\";s:11:\"fa fa-users\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"13\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:3;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"5\";s:5:\"label\";s:7:\"mailbox\";s:4:\"link\";s:13:\"admin/mailbox\";s:4:\"icon\";s:16:\"fa fa-envelope-o\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:4;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"6\";s:5:\"label\";s:7:\"tickets\";s:4:\"link\";s:13:\"admin/tickets\";s:4:\"icon\";s:12:\"fa fa-ticket\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2018-06-08 13:39:39\";s:6:\"status\";s:1:\"1\";}i:5;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"12\";s:5:\"label\";s:5:\"sales\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:19:\"fa fa-shopping-cart\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"9\";s:4:\"time\";s:19:\"2017-06-10 14:02:58\";s:6:\"status\";s:1:\"1\";}i:6;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"13\";s:5:\"label\";s:7:\"invoice\";s:4:\"link\";s:28:\"admin/invoice/manage_invoice\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-04-23 19:57:23\";s:6:\"status\";s:1:\"1\";}i:7;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"14\";s:5:\"label\";s:9:\"estimates\";s:4:\"link\";s:15:\"admin/estimates\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-06-10 14:02:05\";s:6:\"status\";s:1:\"1\";}i:8;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"15\";s:5:\"label\";s:17:\"payments_received\";s:4:\"link\";s:26:\"admin/invoice/all_payments\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-23 19:57:24\";s:6:\"status\";s:1:\"1\";}i:9;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"16\";s:5:\"label\";s:9:\"tax_rates\";s:4:\"link\";s:23:\"admin/invoice/tax_rates\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-01-07 07:05:16\";s:6:\"status\";s:1:\"1\";}i:10;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"21\";s:5:\"label\";s:10:\"quotations\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:11:\"fa fa-paste\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:11;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"22\";s:5:\"label\";s:15:\"quotations_list\";s:4:\"link\";s:16:\"admin/quotations\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"21\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-05-18 16:49:03\";s:6:\"status\";s:1:\"1\";}i:12;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"23\";s:5:\"label\";s:15:\"quotations_form\";s:4:\"link\";s:32:\"admin/quotations/quotations_form\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"21\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:13;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"24\";s:5:\"label\";s:4:\"user\";s:4:\"link\";s:20:\"admin/user/user_list\";s:4:\"icon\";s:11:\"fa fa-users\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"25\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:14;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"25\";s:5:\"label\";s:8:\"settings\";s:4:\"link\";s:14:\"admin/settings\";s:4:\"icon\";s:10:\"fa fa-cogs\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"26\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:15;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"26\";s:5:\"label\";s:15:\"database_backup\";s:4:\"link\";s:30:\"admin/settings/database_backup\";s:4:\"icon\";s:14:\"fa fa-database\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"27\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:16;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"29\";s:5:\"label\";s:17:\"transactions_menu\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:16:\"fa fa-building-o\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"12\";s:4:\"time\";s:19:\"2018-05-13 12:27:58\";s:6:\"status\";s:1:\"1\";}i:17;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"30\";s:5:\"label\";s:7:\"deposit\";s:4:\"link\";s:26:\"admin/transactions/deposit\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-05-13 12:28:33\";s:6:\"status\";s:1:\"1\";}i:18;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"31\";s:5:\"label\";s:7:\"expense\";s:4:\"link\";s:26:\"admin/transactions/expense\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-05-13 12:28:37\";s:6:\"status\";s:1:\"1\";}i:19;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"32\";s:5:\"label\";s:8:\"transfer\";s:4:\"link\";s:27:\"admin/transactions/transfer\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-05-13 12:28:40\";s:6:\"status\";s:1:\"1\";}i:20;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"33\";s:5:\"label\";s:19:\"transactions_report\";s:4:\"link\";s:38:\"admin/transactions/transactions_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2018-05-13 12:28:44\";s:6:\"status\";s:1:\"1\";}i:21;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"34\";s:5:\"label\";s:13:\"balance_sheet\";s:4:\"link\";s:32:\"admin/transactions/balance_sheet\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-05-13 12:28:47\";s:6:\"status\";s:1:\"1\";}i:22;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"36\";s:5:\"label\";s:9:\"bank_cash\";s:4:\"link\";s:28:\"admin/account/manage_account\";s:4:\"icon\";s:11:\"fa fa-money\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2018-05-13 12:28:51\";s:6:\"status\";s:1:\"1\";}i:23;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"39\";s:5:\"label\";s:5:\"items\";s:4:\"link\";s:22:\"admin/items/items_list\";s:4:\"icon\";s:10:\"fa fa-cube\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2019-05-04 18:49:50\";s:6:\"status\";s:1:\"1\";}i:24;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"42\";s:5:\"label\";s:6:\"report\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:15:\"fa fa-bar-chart\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"24\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:25;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"43\";s:5:\"label\";s:17:\"account_statement\";s:4:\"link\";s:30:\"admin/report/account_statement\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:26;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"44\";s:5:\"label\";s:13:\"income_report\";s:4:\"link\";s:26:\"admin/report/income_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:27;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"45\";s:5:\"label\";s:14:\"expense_report\";s:4:\"link\";s:27:\"admin/report/expense_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:28;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"46\";s:5:\"label\";s:14:\"income_expense\";s:4:\"link\";s:27:\"admin/report/income_expense\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:29;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"47\";s:5:\"label\";s:16:\"date_wise_report\";s:4:\"link\";s:29:\"admin/report/date_wise_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:30;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"48\";s:5:\"label\";s:10:\"all_income\";s:4:\"link\";s:23:\"admin/report/all_income\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:31;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"49\";s:5:\"label\";s:11:\"all_expense\";s:4:\"link\";s:24:\"admin/report/all_expense\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:32;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"50\";s:5:\"label\";s:15:\"all_transaction\";s:4:\"link\";s:28:\"admin/report/all_transaction\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:33;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"51\";s:5:\"label\";s:17:\"recurring_invoice\";s:4:\"link\";s:31:\"admin/invoice/recurring_invoice\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-06-10 14:02:05\";s:6:\"status\";s:1:\"1\";}i:34;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"52\";s:5:\"label\";s:15:\"transfer_report\";s:4:\"link\";s:34:\"admin/transactions/transfer_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-05-13 12:28:59\";s:6:\"status\";s:1:\"1\";}i:35;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"53\";s:5:\"label\";s:15:\"report_by_month\";s:4:\"link\";s:28:\"admin/report/report_by_month\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:36;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"54\";s:5:\"label\";s:5:\"tasks\";s:4:\"link\";s:20:\"admin/tasks/all_task\";s:4:\"icon\";s:11:\"fa fa-tasks\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:37;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"55\";s:5:\"label\";s:5:\"leads\";s:4:\"link\";s:11:\"admin/leads\";s:4:\"icon\";s:12:\"fa fa-rocket\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:38;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"56\";s:5:\"label\";s:13:\"opportunities\";s:4:\"link\";s:19:\"admin/opportunities\";s:4:\"icon\";s:12:\"fa fa-filter\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:39;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"57\";s:5:\"label\";s:8:\"projects\";s:4:\"link\";s:14:\"admin/projects\";s:4:\"icon\";s:19:\"fa fa-folder-open-o\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:40;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"58\";s:5:\"label\";s:4:\"bugs\";s:4:\"link\";s:10:\"admin/bugs\";s:4:\"icon\";s:9:\"fa fa-bug\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:41;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"59\";s:5:\"label\";s:7:\"project\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:19:\"fa fa-folder-open-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:42;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"60\";s:5:\"label\";s:12:\"tasks_report\";s:4:\"link\";s:25:\"admin/report/tasks_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:43;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"61\";s:5:\"label\";s:11:\"bugs_report\";s:4:\"link\";s:24:\"admin/report/bugs_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:44;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"62\";s:5:\"label\";s:14:\"tickets_report\";s:4:\"link\";s:27:\"admin/report/tickets_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:45;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"63\";s:5:\"label\";s:13:\"client_report\";s:4:\"link\";s:26:\"admin/report/client_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2018-01-07 07:09:40\";s:6:\"status\";s:1:\"1\";}i:46;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"66\";s:5:\"label\";s:16:\"tasks_assignment\";s:4:\"link\";s:29:\"admin/report/tasks_assignment\";s:4:\"icon\";s:18:\"fa fa-dot-circle-o\";s:6:\"parent\";s:2:\"59\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:47;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"67\";s:5:\"label\";s:15:\"bugs_assignment\";s:4:\"link\";s:28:\"admin/report/bugs_assignment\";s:4:\"icon\";s:18:\"fa fa-dot-circle-o\";s:6:\"parent\";s:2:\"59\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:48;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"68\";s:5:\"label\";s:14:\"project_report\";s:4:\"link\";s:27:\"admin/report/project_report\";s:4:\"icon\";s:18:\"fa fa-dot-circle-o\";s:6:\"parent\";s:2:\"59\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:49;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"69\";s:5:\"label\";s:13:\"goal_tracking\";s:4:\"link\";s:19:\"admin/goal_tracking\";s:4:\"icon\";s:12:\"fa fa-shield\";s:6:\"parent\";s:2:\"73\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-06-10 14:05:47\";s:6:\"status\";s:1:\"1\";}i:50;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"70\";s:5:\"label\";s:11:\"departments\";s:4:\"link\";s:17:\"admin/departments\";s:4:\"icon\";s:17:\"fa fa-user-secret\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"14\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:51;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"71\";s:5:\"label\";s:7:\"holiday\";s:4:\"link\";s:13:\"admin/holiday\";s:4:\"icon\";s:21:\"fa fa-calendar-plus-o\";s:6:\"parent\";s:2:\"73\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-06-10 14:05:47\";s:6:\"status\";s:1:\"1\";}i:52;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"72\";s:5:\"label\";s:16:\"leave_management\";s:4:\"link\";s:22:\"admin/leave_management\";s:4:\"icon\";s:11:\"fa fa-plane\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"20\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:53;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"73\";s:5:\"label\";s:9:\"utilities\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:10:\"fa fa-gift\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"23\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:54;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"74\";s:5:\"label\";s:8:\"overtime\";s:4:\"link\";s:24:\"admin/utilities/overtime\";s:4:\"icon\";s:13:\"fa fa-clock-o\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"9\";s:4:\"time\";s:19:\"2017-06-10 14:04:23\";s:6:\"status\";s:1:\"1\";}i:55;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"75\";s:5:\"label\";s:12:\"office_stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:13:\"fa fa-codepen\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"15\";s:4:\"time\";s:19:\"2019-05-01 16:22:56\";s:6:\"status\";s:1:\"1\";}i:56;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"76\";s:5:\"label\";s:14:\"stock_category\";s:4:\"link\";s:26:\"admin/stock/stock_category\";s:4:\"icon\";s:13:\"fa fa-sliders\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:57;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"77\";s:5:\"label\";s:12:\"manage_stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:13:\"fa fa-archive\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-04-26 16:11:10\";s:6:\"status\";s:1:\"1\";}i:58;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"78\";s:5:\"label\";s:12:\"assign_stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:16:\"fa fa-align-left\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-26 16:11:10\";s:6:\"status\";s:1:\"1\";}i:59;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"79\";s:5:\"label\";s:12:\"stock_report\";s:4:\"link\";s:18:\"admin/stock/report\";s:4:\"icon\";s:16:\"fa fa-line-chart\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2017-04-25 18:48:25\";s:6:\"status\";s:1:\"1\";}i:60;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"81\";s:5:\"label\";s:10:\"stock_list\";s:4:\"link\";s:22:\"admin/stock/stock_list\";s:4:\"icon\";s:20:\"fa fa-stack-exchange\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-26 16:11:10\";s:6:\"status\";s:1:\"1\";}i:61;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"82\";s:5:\"label\";s:12:\"assign_stock\";s:4:\"link\";s:24:\"admin/stock/assign_stock\";s:4:\"icon\";s:16:\"fa fa-align-left\";s:6:\"parent\";s:2:\"78\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:62;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"83\";s:5:\"label\";s:19:\"assign_stock_report\";s:4:\"link\";s:31:\"admin/stock/assign_stock_report\";s:4:\"icon\";s:15:\"fa fa-bar-chart\";s:6:\"parent\";s:2:\"78\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:63;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"84\";s:5:\"label\";s:13:\"stock_history\";s:4:\"link\";s:25:\"admin/stock/stock_history\";s:4:\"icon\";s:17:\"fa fa-file-text-o\";s:6:\"parent\";s:2:\"77\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:64;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"85\";s:5:\"label\";s:11:\"performance\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:14:\"fa fa-dribbble\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"19\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:65;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"86\";s:5:\"label\";s:21:\"performance_indicator\";s:4:\"link\";s:39:\"admin/performance/performance_indicator\";s:4:\"icon\";s:12:\"fa fa-random\";s:6:\"parent\";s:2:\"85\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:66;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"87\";s:5:\"label\";s:18:\"performance_report\";s:4:\"link\";s:36:\"admin/performance/performance_report\";s:4:\"icon\";s:16:\"fa fa-calendar-o\";s:6:\"parent\";s:2:\"85\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:67;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"88\";s:5:\"label\";s:14:\"give_appraisal\";s:4:\"link\";s:44:\"admin/performance/give_performance_appraisal\";s:4:\"icon\";s:10:\"fa fa-plus\";s:6:\"parent\";s:2:\"85\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:68;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"89\";s:5:\"label\";s:7:\"payroll\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:9:\"fa fa-usd\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"18\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:69;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"90\";s:5:\"label\";s:21:\"manage_salary_details\";s:4:\"link\";s:35:\"admin/payroll/manage_salary_details\";s:4:\"icon\";s:9:\"fa fa-usd\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:70;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"91\";s:5:\"label\";s:20:\"employee_salary_list\";s:4:\"link\";s:34:\"admin/payroll/employee_salary_list\";s:4:\"icon\";s:17:\"fa fa-user-secret\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:71;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"92\";s:5:\"label\";s:12:\"make_payment\";s:4:\"link\";s:26:\"admin/payroll/make_payment\";s:4:\"icon\";s:11:\"fa fa-tasks\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:72;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"93\";s:5:\"label\";s:16:\"generate_payslip\";s:4:\"link\";s:30:\"admin/payroll/generate_payslip\";s:4:\"icon\";s:13:\"fa fa-list-ul\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:73;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"94\";s:5:\"label\";s:15:\"salary_template\";s:4:\"link\";s:29:\"admin/payroll/salary_template\";s:4:\"icon\";s:11:\"fa fa-money\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:74;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"95\";s:5:\"label\";s:11:\"hourly_rate\";s:4:\"link\";s:25:\"admin/payroll/hourly_rate\";s:4:\"icon\";s:13:\"fa fa-clock-o\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:75;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"96\";s:5:\"label\";s:15:\"payroll_summary\";s:4:\"link\";s:29:\"admin/payroll/payroll_summary\";s:4:\"icon\";s:18:\"fa fa-camera-retro\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:76;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"97\";s:5:\"label\";s:14:\"provident_fund\";s:4:\"link\";s:28:\"admin/payroll/provident_fund\";s:4:\"icon\";s:15:\"fa fa-briefcase\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2017-06-10 14:04:23\";s:6:\"status\";s:1:\"1\";}i:77;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"98\";s:5:\"label\";s:14:\"advance_salary\";s:4:\"link\";s:28:\"admin/payroll/advance_salary\";s:4:\"icon\";s:19:\"fa fa-cc-mastercard\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2017-06-10 14:04:23\";s:6:\"status\";s:1:\"1\";}i:78;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"99\";s:5:\"label\";s:14:\"employee_award\";s:4:\"link\";s:11:\"admin/award\";s:4:\"icon\";s:12:\"fa fa-trophy\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2017-06-10 14:05:47\";s:6:\"status\";s:1:\"1\";}i:79;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"100\";s:5:\"label\";s:13:\"announcements\";s:4:\"link\";s:19:\"admin/announcements\";s:4:\"icon\";s:19:\"fa fa-bullhorn icon\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"22\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:80;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"101\";s:5:\"label\";s:8:\"training\";s:4:\"link\";s:14:\"admin/training\";s:4:\"icon\";s:14:\"fa fa-suitcase\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"21\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:81;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"102\";s:5:\"label\";s:12:\"job_circular\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:11:\"fa fa-globe\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"17\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:82;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"103\";s:5:\"label\";s:11:\"jobs_posted\";s:4:\"link\";s:30:\"admin/job_circular/jobs_posted\";s:4:\"icon\";s:12:\"fa fa-ticket\";s:6:\"parent\";s:3:\"102\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:83;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"104\";s:5:\"label\";s:17:\"jobs_applications\";s:4:\"link\";s:36:\"admin/job_circular/jobs_applications\";s:4:\"icon\";s:13:\"fa fa-compass\";s:6:\"parent\";s:3:\"102\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:84;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"105\";s:5:\"label\";s:10:\"attendance\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:15:\"fa fa-file-text\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"16\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:85;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"106\";s:5:\"label\";s:18:\"timechange_request\";s:4:\"link\";s:35:\"admin/attendance/timechange_request\";s:4:\"icon\";s:16:\"fa fa-calendar-o\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:86;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"107\";s:5:\"label\";s:17:\"attendance_report\";s:4:\"link\";s:34:\"admin/attendance/attendance_report\";s:4:\"icon\";s:15:\"fa fa-file-text\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:87;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"108\";s:5:\"label\";s:12:\"time_history\";s:4:\"link\";s:29:\"admin/attendance/time_history\";s:4:\"icon\";s:13:\"fa fa-clock-o\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:88;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"109\";s:5:\"label\";s:9:\"pull-down\";s:4:\"link\";s:0:\"\";s:4:\"icon\";s:0:\"\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-31 12:43:20\";s:6:\"status\";s:1:\"0\";}i:89;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"110\";s:5:\"label\";s:11:\"filemanager\";s:4:\"link\";s:17:\"admin/filemanager\";s:4:\"icon\";s:10:\"fa fa-file\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:90;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"111\";s:5:\"label\";s:15:\"company_details\";s:4:\"link\";s:14:\"admin/settings\";s:4:\"icon\";s:23:\"fa fa-fw fa-info-circle\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-25 17:08:46\";s:6:\"status\";s:1:\"2\";}i:91;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"112\";s:5:\"label\";s:15:\"system_settings\";s:4:\"link\";s:21:\"admin/settings/system\";s:4:\"icon\";s:19:\"fa fa-fw fa-desktop\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-04-25 17:08:46\";s:6:\"status\";s:1:\"2\";}i:92;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"113\";s:5:\"label\";s:14:\"email_settings\";s:4:\"link\";s:20:\"admin/settings/email\";s:4:\"icon\";s:20:\"fa fa-fw fa-envelope\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-25 17:08:46\";s:6:\"status\";s:1:\"2\";}i:93;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"114\";s:5:\"label\";s:15:\"email_templates\";s:4:\"link\";s:24:\"admin/settings/templates\";s:4:\"icon\";s:25:\"fa fa-fw fa-pencil-square\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2021-07-30 06:18:08\";s:6:\"status\";s:1:\"2\";}i:94;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"115\";s:5:\"label\";s:17:\"email_integration\";s:4:\"link\";s:32:\"admin/settings/email_integration\";s:4:\"icon\";s:22:\"fa fa-fw fa-envelope-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2021-07-30 06:18:08\";s:6:\"status\";s:1:\"2\";}i:95;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"116\";s:5:\"label\";s:16:\"payment_settings\";s:4:\"link\";s:23:\"admin/settings/payments\";s:4:\"icon\";s:18:\"fa fa-fw fa-dollar\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:96;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"117\";s:5:\"label\";s:16:\"invoice_settings\";s:4:\"link\";s:22:\"admin/settings/invoice\";s:4:\"icon\";s:17:\"fa fa-fw fa-money\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:97;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"118\";s:5:\"label\";s:17:\"estimate_settings\";s:4:\"link\";s:23:\"admin/settings/estimate\";s:4:\"icon\";s:18:\"fa fa-fw fa-file-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:98;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"119\";s:5:\"label\";s:22:\"tickets_leads_settings\";s:4:\"link\";s:22:\"admin/settings/tickets\";s:4:\"icon\";s:18:\"fa fa-fw fa-ticket\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"14\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:99;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"120\";s:5:\"label\";s:14:\"theme_settings\";s:4:\"link\";s:20:\"admin/settings/theme\";s:4:\"icon\";s:16:\"fa fa-fw fa-code\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"20\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:100;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"121\";s:5:\"label\";s:12:\"working_days\";s:4:\"link\";s:27:\"admin/settings/working_days\";s:4:\"icon\";s:20:\"fa fa-fw fa-calendar\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"22\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:101;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"122\";s:5:\"label\";s:14:\"leave_category\";s:4:\"link\";s:29:\"admin/settings/leave_category\";s:4:\"icon\";s:21:\"fa fa-fw fa-pagelines\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"23\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:102;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"123\";s:5:\"label\";s:15:\"income_category\";s:4:\"link\";s:30:\"admin/settings/income_category\";s:4:\"icon\";s:23:\"fa fa-fw fa-certificate\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"24\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:103;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"124\";s:5:\"label\";s:16:\"expense_category\";s:4:\"link\";s:31:\"admin/settings/expense_category\";s:4:\"icon\";s:17:\"fa fa-fw fa-tasks\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"25\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:104;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"125\";s:5:\"label\";s:14:\"customer_group\";s:4:\"link\";s:29:\"admin/settings/customer_group\";s:4:\"icon\";s:17:\"fa fa-fw fa-users\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"26\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:105;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"127\";s:5:\"label\";s:11:\"lead_status\";s:4:\"link\";s:26:\"admin/settings/lead_status\";s:4:\"icon\";s:19:\"fa fa-fw fa-list-ul\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"16\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:106;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"128\";s:5:\"label\";s:11:\"lead_source\";s:4:\"link\";s:26:\"admin/settings/lead_source\";s:4:\"icon\";s:22:\"fa fa-fw fa-arrow-down\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"17\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:107;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"129\";s:5:\"label\";s:26:\"opportunities_state_reason\";s:4:\"link\";s:41:\"admin/settings/opportunities_state_reason\";s:4:\"icon\";s:24:\"fa fa-fw fa-dot-circle-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"19\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:108;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"130\";s:5:\"label\";s:12:\"custom_field\";s:4:\"link\";s:27:\"admin/settings/custom_field\";s:4:\"icon\";s:18:\"fa fa-fw fa-star-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"28\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:109;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"131\";s:5:\"label\";s:14:\"payment_method\";s:4:\"link\";s:29:\"admin/settings/payment_method\";s:4:\"icon\";s:17:\"fa fa-fw fa-money\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"29\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:110;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"132\";s:5:\"label\";s:7:\"cronjob\";s:4:\"link\";s:22:\"admin/settings/cronjob\";s:4:\"icon\";s:18:\"fa fa-fw fa-contao\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"31\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:111;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"133\";s:5:\"label\";s:15:\"menu_allocation\";s:4:\"link\";s:30:\"admin/settings/menu_allocation\";s:4:\"icon\";s:22:\"fa fa-fw fa fa-compass\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"32\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:112;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"134\";s:5:\"label\";s:12:\"notification\";s:4:\"link\";s:27:\"admin/settings/notification\";s:4:\"icon\";s:18:\"fa fa-fw fa-bell-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"33\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:113;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"135\";s:5:\"label\";s:18:\"email_notification\";s:4:\"link\";s:33:\"admin/settings/email_notification\";s:4:\"icon\";s:18:\"fa fa-fw fa-bell-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"34\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:114;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"136\";s:5:\"label\";s:15:\"database_backup\";s:4:\"link\";s:30:\"admin/settings/database_backup\";s:4:\"icon\";s:20:\"fa fa-fw fa-database\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"35\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:115;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"137\";s:5:\"label\";s:12:\"translations\";s:4:\"link\";s:27:\"admin/settings/translations\";s:4:\"icon\";s:20:\"fa fa-fw fa-language\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"36\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:116;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"138\";s:5:\"label\";s:13:\"system_update\";s:4:\"link\";s:28:\"admin/settings/system_update\";s:4:\"icon\";s:27:\"fa fa-fw fa-pencil-square-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"37\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:117;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"139\";s:5:\"label\";s:12:\"private_chat\";s:4:\"link\";s:18:\"chat/conversations\";s:4:\"icon\";s:14:\"fa fa-envelope\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"28\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:118;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"140\";s:5:\"label\";s:9:\"proposals\";s:4:\"link\";s:15:\"admin/proposals\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-01-07 07:05:16\";s:6:\"status\";s:1:\"1\";}i:119;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"141\";s:5:\"label\";s:13:\"knowledgebase\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:21:\"fa fa-question-circle\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"11\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:120;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"142\";s:5:\"label\";s:10:\"categories\";s:4:\"link\";s:30:\"admin/knowledgebase/categories\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"141\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:121;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"143\";s:5:\"label\";s:8:\"articles\";s:4:\"link\";s:28:\"admin/knowledgebase/articles\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"141\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:122;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"144\";s:5:\"label\";s:13:\"knowledgebase\";s:4:\"link\";s:19:\"admin/knowledgebase\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"141\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:123;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"145\";s:5:\"label\";s:18:\"dashboard_settings\";s:4:\"link\";s:24:\"admin/settings/dashboard\";s:4:\"icon\";s:21:\"fa fa-fw fa-dashboard\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"21\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:124;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"146\";s:5:\"label\";s:20:\"transactions_reports\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:16:\"fa fa-building-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-05-13 12:29:51\";s:6:\"status\";s:1:\"1\";}i:125;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"147\";s:5:\"label\";s:5:\"sales\";s:4:\"link\";s:25:\"admin/report/sales_report\";s:4:\"icon\";s:19:\"fa fa-shopping-cart\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-01-07 01:12:23\";s:6:\"status\";s:1:\"1\";}i:126;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"148\";s:5:\"label\";s:15:\"mark_attendance\";s:4:\"link\";s:21:\"admin/mark_attendance\";s:4:\"icon\";s:15:\"fa fa-file-text\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-03-07 06:45:25\";s:6:\"status\";s:1:\"1\";}i:127;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"149\";s:5:\"label\";s:10:\"allowed_ip\";s:4:\"link\";s:25:\"admin/settings/allowed_ip\";s:4:\"icon\";s:12:\"fa fa-server\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"27\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:128;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"150\";s:5:\"label\";s:5:\"stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:11:\"icon-layers\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2019-05-01 18:10:52\";s:6:\"status\";s:1:\"1\";}i:129;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"151\";s:5:\"label\";s:8:\"supplier\";s:4:\"link\";s:14:\"admin/supplier\";s:4:\"icon\";s:14:\"icon-briefcase\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2019-05-01 18:10:52\";s:6:\"status\";s:1:\"1\";}i:130;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"152\";s:5:\"label\";s:8:\"purchase\";s:4:\"link\";s:14:\"admin/purchase\";s:4:\"icon\";s:12:\"icon-handbag\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2019-05-01 18:10:52\";s:6:\"status\";s:1:\"1\";}i:131;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"153\";s:5:\"label\";s:12:\"return_stock\";s:4:\"link\";s:18:\"admin/return_stock\";s:4:\"icon\";s:14:\"icon-share-alt\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2019-05-05 16:19:30\";s:6:\"status\";s:1:\"1\";}i:132;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"154\";s:5:\"label\";s:16:\"purchase_payment\";s:4:\"link\";s:27:\"admin/purchase/all_payments\";s:4:\"icon\";s:16:\"icon-credit-card\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2019-05-05 13:53:11\";s:6:\"status\";s:1:\"1\";}i:133;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"155\";s:5:\"label\";s:17:\"purchase_settings\";s:4:\"link\";s:23:\"admin/settings/purchase\";s:4:\"icon\";s:18:\"fa-fw icon-handbag\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"12\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:134;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"156\";s:5:\"label\";s:11:\"credit_note\";s:4:\"link\";s:17:\"admin/credit_note\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-06-10 02:32:05\";s:6:\"status\";s:1:\"1\";}i:135;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"157\";s:5:\"label\";s:20:\"credit_note_settings\";s:4:\"link\";s:26:\"admin/settings/credit_note\";s:4:\"icon\";s:17:\"fa fa-fw fa-money\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"9\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:136;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"158\";s:5:\"label\";s:18:\"proposals_settings\";s:4:\"link\";s:24:\"admin/settings/proposals\";s:4:\"icon\";s:16:\"fa fa-fw fa-leaf\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"11\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:137;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"159\";s:5:\"label\";s:17:\"projects_settings\";s:4:\"link\";s:23:\"admin/settings/projects\";s:4:\"icon\";s:25:\"fa fa-fw fa-folder-open-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"13\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:138;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"160\";s:5:\"label\";s:4:\"tags\";s:4:\"link\";s:19:\"admin/settings/tags\";s:4:\"icon\";s:16:\"fa fa-fw fa-tags\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"30\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:139;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"161\";s:5:\"label\";s:9:\"lead_form\";s:4:\"link\";s:25:\"admin/leads/all_lead_form\";s:4:\"icon\";s:18:\"fa fa-fw fa-rocket\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"18\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:140;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"162\";s:5:\"label\";s:21:\"transactions_settings\";s:4:\"link\";s:27:\"admin/settings/transactions\";s:4:\"icon\";s:22:\"fa fa-fw fa-building-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"15\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:141;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"163\";s:5:\"label\";s:12:\"sms_settings\";s:4:\"link\";s:27:\"admin/settings/sms_settings\";s:4:\"icon\";s:20:\"fa fa-fw fa-envelope\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2021-07-30 06:18:08\";s:6:\"status\";s:1:\"2\";}i:142;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"164\";s:5:\"label\";s:9:\"pos_sales\";s:4:\"link\";s:23:\"admin/invoice/pos_sales\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2021-10-16 00:53:10\";s:6:\"status\";s:1:\"1\";}i:143;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"186\";s:5:\"label\";s:9:\"warehouse\";s:4:\"link\";s:22:\"admin/warehouse/manage\";s:4:\"icon\";s:16:\"fa fa-building-o\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2021-10-18 09:24:24\";s:6:\"status\";s:1:\"1\";}i:144;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"187\";s:5:\"label\";s:12:\"transferItem\";s:4:\"link\";s:24:\"admin/items/transferItem\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2021-10-14 11:56:08\";s:6:\"status\";s:1:\"1\";}i:145;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"203\";s:5:\"label\";s:13:\"award_setting\";s:4:\"link\";s:20:\"admin/settings/award\";s:4:\"icon\";s:10:\"fa fa-star\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"30\";s:4:\"time\";s:19:\"2022-01-19 05:51:40\";s:6:\"status\";s:1:\"2\";}i:146;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"204\";s:5:\"label\";s:18:\"award_rule_setting\";s:4:\"link\";s:34:\"admin/settings/award_rule_settingh\";s:4:\"icon\";s:10:\"fa fa-star\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"31\";s:4:\"time\";s:19:\"2022-01-19 09:53:50\";s:6:\"status\";s:1:\"2\";}i:147;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"205\";s:5:\"label\";s:22:\"award_program_settings\";s:4:\"link\";s:37:\"admin/settings/award_program_settings\";s:4:\"icon\";s:9:\"fa fa-cog\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"32\";s:4:\"time\";s:19:\"2022-01-20 09:17:30\";s:6:\"status\";s:1:\"2\";}i:148;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"206\";s:5:\"label\";s:19:\"client_award_points\";s:4:\"link\";s:27:\"admin/invoice/client_awards\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2022-01-21 01:39:41\";s:6:\"status\";s:1:\"1\";}i:149;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"207\";s:5:\"label\";s:20:\"best_selling_product\";s:4:\"link\";s:18:\"admin/best_selling\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:2:\"11\";s:4:\"time\";s:19:\"2022-01-21 06:43:52\";s:6:\"status\";s:1:\"1\";}i:150;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"209\";s:5:\"label\";s:7:\"warning\";s:4:\"link\";s:13:\"admin/warning\";s:4:\"icon\";s:13:\"fa fa-warning\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2022-08-07 12:47:01\";s:6:\"status\";s:1:\"1\";}i:151;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"210\";s:5:\"label\";s:9:\"promotion\";s:4:\"link\";s:15:\"admin/promotion\";s:4:\"icon\";s:21:\"fa fa-arrow-circle-up\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2022-08-07 12:49:28\";s:6:\"status\";s:1:\"1\";}i:152;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"211\";s:5:\"label\";s:11:\"termination\";s:4:\"link\";s:17:\"admin/termination\";s:4:\"icon\";s:12:\"fa fa-eraser\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2022-08-07 12:50:45\";s:6:\"status\";s:1:\"1\";}i:153;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"212\";s:5:\"label\";s:11:\"resignation\";s:4:\"link\";s:17:\"admin/resignation\";s:4:\"icon\";s:14:\"fa fa-scissors\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2022-08-07 12:54:31\";s:6:\"status\";s:1:\"1\";}}');
INSERT INTO `tbl_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2ace0b393d4c35427c870bfbe0781a9f1ba7c15d', '136.158.120.226', 1688631151, '__ci_last_regenerate|i:1688631151;menu_active_id|a:2:{i:0;s:1:\"1\";i:1;s:1:\"0\";}url|s:33:\"admin/dashboard/recent_activities\";user_roll|a:154:{i:0;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"1\";s:5:\"label\";s:9:\"dashboard\";s:4:\"link\";s:15:\"admin/dashboard\";s:4:\"icon\";s:15:\"fa fa-dashboard\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-04-23 01:39:36\";s:6:\"status\";s:1:\"1\";}i:1;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"2\";s:5:\"label\";s:8:\"calendar\";s:4:\"link\";s:14:\"admin/calendar\";s:4:\"icon\";s:14:\"fa fa-calendar\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-23 19:57:23\";s:6:\"status\";s:1:\"1\";}i:2;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"4\";s:5:\"label\";s:6:\"client\";s:4:\"link\";s:26:\"admin/client/manage_client\";s:4:\"icon\";s:11:\"fa fa-users\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"13\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:3;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"5\";s:5:\"label\";s:7:\"mailbox\";s:4:\"link\";s:13:\"admin/mailbox\";s:4:\"icon\";s:16:\"fa fa-envelope-o\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:4;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"6\";s:5:\"label\";s:7:\"tickets\";s:4:\"link\";s:13:\"admin/tickets\";s:4:\"icon\";s:12:\"fa fa-ticket\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2018-06-08 13:39:39\";s:6:\"status\";s:1:\"1\";}i:5;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"12\";s:5:\"label\";s:5:\"sales\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:19:\"fa fa-shopping-cart\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"9\";s:4:\"time\";s:19:\"2017-06-10 14:02:58\";s:6:\"status\";s:1:\"1\";}i:6;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"13\";s:5:\"label\";s:7:\"invoice\";s:4:\"link\";s:28:\"admin/invoice/manage_invoice\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-04-23 19:57:23\";s:6:\"status\";s:1:\"1\";}i:7;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"14\";s:5:\"label\";s:9:\"estimates\";s:4:\"link\";s:15:\"admin/estimates\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-06-10 14:02:05\";s:6:\"status\";s:1:\"1\";}i:8;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"15\";s:5:\"label\";s:17:\"payments_received\";s:4:\"link\";s:26:\"admin/invoice/all_payments\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-23 19:57:24\";s:6:\"status\";s:1:\"1\";}i:9;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"16\";s:5:\"label\";s:9:\"tax_rates\";s:4:\"link\";s:23:\"admin/invoice/tax_rates\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-01-07 07:05:16\";s:6:\"status\";s:1:\"1\";}i:10;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"21\";s:5:\"label\";s:10:\"quotations\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:11:\"fa fa-paste\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:11;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"22\";s:5:\"label\";s:15:\"quotations_list\";s:4:\"link\";s:16:\"admin/quotations\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"21\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-05-18 16:49:03\";s:6:\"status\";s:1:\"1\";}i:12;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"23\";s:5:\"label\";s:15:\"quotations_form\";s:4:\"link\";s:32:\"admin/quotations/quotations_form\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"21\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:13;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"24\";s:5:\"label\";s:4:\"user\";s:4:\"link\";s:20:\"admin/user/user_list\";s:4:\"icon\";s:11:\"fa fa-users\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"25\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:14;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"25\";s:5:\"label\";s:8:\"settings\";s:4:\"link\";s:14:\"admin/settings\";s:4:\"icon\";s:10:\"fa fa-cogs\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"26\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:15;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"26\";s:5:\"label\";s:15:\"database_backup\";s:4:\"link\";s:30:\"admin/settings/database_backup\";s:4:\"icon\";s:14:\"fa fa-database\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"27\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:16;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"29\";s:5:\"label\";s:17:\"transactions_menu\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:16:\"fa fa-building-o\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"12\";s:4:\"time\";s:19:\"2018-05-13 12:27:58\";s:6:\"status\";s:1:\"1\";}i:17;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"30\";s:5:\"label\";s:7:\"deposit\";s:4:\"link\";s:26:\"admin/transactions/deposit\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-05-13 12:28:33\";s:6:\"status\";s:1:\"1\";}i:18;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"31\";s:5:\"label\";s:7:\"expense\";s:4:\"link\";s:26:\"admin/transactions/expense\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-05-13 12:28:37\";s:6:\"status\";s:1:\"1\";}i:19;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"32\";s:5:\"label\";s:8:\"transfer\";s:4:\"link\";s:27:\"admin/transactions/transfer\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-05-13 12:28:40\";s:6:\"status\";s:1:\"1\";}i:20;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"33\";s:5:\"label\";s:19:\"transactions_report\";s:4:\"link\";s:38:\"admin/transactions/transactions_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2018-05-13 12:28:44\";s:6:\"status\";s:1:\"1\";}i:21;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"34\";s:5:\"label\";s:13:\"balance_sheet\";s:4:\"link\";s:32:\"admin/transactions/balance_sheet\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-05-13 12:28:47\";s:6:\"status\";s:1:\"1\";}i:22;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"36\";s:5:\"label\";s:9:\"bank_cash\";s:4:\"link\";s:28:\"admin/account/manage_account\";s:4:\"icon\";s:11:\"fa fa-money\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2018-05-13 12:28:51\";s:6:\"status\";s:1:\"1\";}i:23;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"39\";s:5:\"label\";s:5:\"items\";s:4:\"link\";s:22:\"admin/items/items_list\";s:4:\"icon\";s:10:\"fa fa-cube\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2019-05-04 18:49:50\";s:6:\"status\";s:1:\"1\";}i:24;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"42\";s:5:\"label\";s:6:\"report\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:15:\"fa fa-bar-chart\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"24\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:25;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"43\";s:5:\"label\";s:17:\"account_statement\";s:4:\"link\";s:30:\"admin/report/account_statement\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:26;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"44\";s:5:\"label\";s:13:\"income_report\";s:4:\"link\";s:26:\"admin/report/income_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:27;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"45\";s:5:\"label\";s:14:\"expense_report\";s:4:\"link\";s:27:\"admin/report/expense_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:28;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"46\";s:5:\"label\";s:14:\"income_expense\";s:4:\"link\";s:27:\"admin/report/income_expense\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:29;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"47\";s:5:\"label\";s:16:\"date_wise_report\";s:4:\"link\";s:29:\"admin/report/date_wise_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:30;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"48\";s:5:\"label\";s:10:\"all_income\";s:4:\"link\";s:23:\"admin/report/all_income\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:31;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"49\";s:5:\"label\";s:11:\"all_expense\";s:4:\"link\";s:24:\"admin/report/all_expense\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:32;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"50\";s:5:\"label\";s:15:\"all_transaction\";s:4:\"link\";s:28:\"admin/report/all_transaction\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:33;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"51\";s:5:\"label\";s:17:\"recurring_invoice\";s:4:\"link\";s:31:\"admin/invoice/recurring_invoice\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-06-10 14:02:05\";s:6:\"status\";s:1:\"1\";}i:34;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"52\";s:5:\"label\";s:15:\"transfer_report\";s:4:\"link\";s:34:\"admin/transactions/transfer_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-05-13 12:28:59\";s:6:\"status\";s:1:\"1\";}i:35;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"53\";s:5:\"label\";s:15:\"report_by_month\";s:4:\"link\";s:28:\"admin/report/report_by_month\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:36;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"54\";s:5:\"label\";s:5:\"tasks\";s:4:\"link\";s:20:\"admin/tasks/all_task\";s:4:\"icon\";s:11:\"fa fa-tasks\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:37;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"55\";s:5:\"label\";s:5:\"leads\";s:4:\"link\";s:11:\"admin/leads\";s:4:\"icon\";s:12:\"fa fa-rocket\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:38;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"56\";s:5:\"label\";s:13:\"opportunities\";s:4:\"link\";s:19:\"admin/opportunities\";s:4:\"icon\";s:12:\"fa fa-filter\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:39;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"57\";s:5:\"label\";s:8:\"projects\";s:4:\"link\";s:14:\"admin/projects\";s:4:\"icon\";s:19:\"fa fa-folder-open-o\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:40;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"58\";s:5:\"label\";s:4:\"bugs\";s:4:\"link\";s:10:\"admin/bugs\";s:4:\"icon\";s:9:\"fa fa-bug\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:41;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"59\";s:5:\"label\";s:7:\"project\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:19:\"fa fa-folder-open-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:42;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"60\";s:5:\"label\";s:12:\"tasks_report\";s:4:\"link\";s:25:\"admin/report/tasks_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:43;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"61\";s:5:\"label\";s:11:\"bugs_report\";s:4:\"link\";s:24:\"admin/report/bugs_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:44;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"62\";s:5:\"label\";s:14:\"tickets_report\";s:4:\"link\";s:27:\"admin/report/tickets_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:45;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"63\";s:5:\"label\";s:13:\"client_report\";s:4:\"link\";s:26:\"admin/report/client_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2018-01-07 07:09:40\";s:6:\"status\";s:1:\"1\";}i:46;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"66\";s:5:\"label\";s:16:\"tasks_assignment\";s:4:\"link\";s:29:\"admin/report/tasks_assignment\";s:4:\"icon\";s:18:\"fa fa-dot-circle-o\";s:6:\"parent\";s:2:\"59\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:47;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"67\";s:5:\"label\";s:15:\"bugs_assignment\";s:4:\"link\";s:28:\"admin/report/bugs_assignment\";s:4:\"icon\";s:18:\"fa fa-dot-circle-o\";s:6:\"parent\";s:2:\"59\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:48;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"68\";s:5:\"label\";s:14:\"project_report\";s:4:\"link\";s:27:\"admin/report/project_report\";s:4:\"icon\";s:18:\"fa fa-dot-circle-o\";s:6:\"parent\";s:2:\"59\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:49;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"69\";s:5:\"label\";s:13:\"goal_tracking\";s:4:\"link\";s:19:\"admin/goal_tracking\";s:4:\"icon\";s:12:\"fa fa-shield\";s:6:\"parent\";s:2:\"73\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-06-10 14:05:47\";s:6:\"status\";s:1:\"1\";}i:50;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"70\";s:5:\"label\";s:11:\"departments\";s:4:\"link\";s:17:\"admin/departments\";s:4:\"icon\";s:17:\"fa fa-user-secret\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"14\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:51;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"71\";s:5:\"label\";s:7:\"holiday\";s:4:\"link\";s:13:\"admin/holiday\";s:4:\"icon\";s:21:\"fa fa-calendar-plus-o\";s:6:\"parent\";s:2:\"73\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-06-10 14:05:47\";s:6:\"status\";s:1:\"1\";}i:52;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"72\";s:5:\"label\";s:16:\"leave_management\";s:4:\"link\";s:22:\"admin/leave_management\";s:4:\"icon\";s:11:\"fa fa-plane\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"20\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:53;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"73\";s:5:\"label\";s:9:\"utilities\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:10:\"fa fa-gift\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"23\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:54;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"74\";s:5:\"label\";s:8:\"overtime\";s:4:\"link\";s:24:\"admin/utilities/overtime\";s:4:\"icon\";s:13:\"fa fa-clock-o\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"9\";s:4:\"time\";s:19:\"2017-06-10 14:04:23\";s:6:\"status\";s:1:\"1\";}i:55;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"75\";s:5:\"label\";s:12:\"office_stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:13:\"fa fa-codepen\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"15\";s:4:\"time\";s:19:\"2019-05-01 16:22:56\";s:6:\"status\";s:1:\"1\";}i:56;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"76\";s:5:\"label\";s:14:\"stock_category\";s:4:\"link\";s:26:\"admin/stock/stock_category\";s:4:\"icon\";s:13:\"fa fa-sliders\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:57;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"77\";s:5:\"label\";s:12:\"manage_stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:13:\"fa fa-archive\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-04-26 16:11:10\";s:6:\"status\";s:1:\"1\";}i:58;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"78\";s:5:\"label\";s:12:\"assign_stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:16:\"fa fa-align-left\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-26 16:11:10\";s:6:\"status\";s:1:\"1\";}i:59;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"79\";s:5:\"label\";s:12:\"stock_report\";s:4:\"link\";s:18:\"admin/stock/report\";s:4:\"icon\";s:16:\"fa fa-line-chart\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2017-04-25 18:48:25\";s:6:\"status\";s:1:\"1\";}i:60;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"81\";s:5:\"label\";s:10:\"stock_list\";s:4:\"link\";s:22:\"admin/stock/stock_list\";s:4:\"icon\";s:20:\"fa fa-stack-exchange\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-26 16:11:10\";s:6:\"status\";s:1:\"1\";}i:61;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"82\";s:5:\"label\";s:12:\"assign_stock\";s:4:\"link\";s:24:\"admin/stock/assign_stock\";s:4:\"icon\";s:16:\"fa fa-align-left\";s:6:\"parent\";s:2:\"78\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:62;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"83\";s:5:\"label\";s:19:\"assign_stock_report\";s:4:\"link\";s:31:\"admin/stock/assign_stock_report\";s:4:\"icon\";s:15:\"fa fa-bar-chart\";s:6:\"parent\";s:2:\"78\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:63;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"84\";s:5:\"label\";s:13:\"stock_history\";s:4:\"link\";s:25:\"admin/stock/stock_history\";s:4:\"icon\";s:17:\"fa fa-file-text-o\";s:6:\"parent\";s:2:\"77\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:64;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"85\";s:5:\"label\";s:11:\"performance\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:14:\"fa fa-dribbble\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"19\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:65;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"86\";s:5:\"label\";s:21:\"performance_indicator\";s:4:\"link\";s:39:\"admin/performance/performance_indicator\";s:4:\"icon\";s:12:\"fa fa-random\";s:6:\"parent\";s:2:\"85\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:66;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"87\";s:5:\"label\";s:18:\"performance_report\";s:4:\"link\";s:36:\"admin/performance/performance_report\";s:4:\"icon\";s:16:\"fa fa-calendar-o\";s:6:\"parent\";s:2:\"85\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:67;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"88\";s:5:\"label\";s:14:\"give_appraisal\";s:4:\"link\";s:44:\"admin/performance/give_performance_appraisal\";s:4:\"icon\";s:10:\"fa fa-plus\";s:6:\"parent\";s:2:\"85\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:68;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"89\";s:5:\"label\";s:7:\"payroll\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:9:\"fa fa-usd\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"18\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:69;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"90\";s:5:\"label\";s:21:\"manage_salary_details\";s:4:\"link\";s:35:\"admin/payroll/manage_salary_details\";s:4:\"icon\";s:9:\"fa fa-usd\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:70;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"91\";s:5:\"label\";s:20:\"employee_salary_list\";s:4:\"link\";s:34:\"admin/payroll/employee_salary_list\";s:4:\"icon\";s:17:\"fa fa-user-secret\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:71;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"92\";s:5:\"label\";s:12:\"make_payment\";s:4:\"link\";s:26:\"admin/payroll/make_payment\";s:4:\"icon\";s:11:\"fa fa-tasks\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:72;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"93\";s:5:\"label\";s:16:\"generate_payslip\";s:4:\"link\";s:30:\"admin/payroll/generate_payslip\";s:4:\"icon\";s:13:\"fa fa-list-ul\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:73;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"94\";s:5:\"label\";s:15:\"salary_template\";s:4:\"link\";s:29:\"admin/payroll/salary_template\";s:4:\"icon\";s:11:\"fa fa-money\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:74;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"95\";s:5:\"label\";s:11:\"hourly_rate\";s:4:\"link\";s:25:\"admin/payroll/hourly_rate\";s:4:\"icon\";s:13:\"fa fa-clock-o\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:75;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"96\";s:5:\"label\";s:15:\"payroll_summary\";s:4:\"link\";s:29:\"admin/payroll/payroll_summary\";s:4:\"icon\";s:18:\"fa fa-camera-retro\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:76;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"97\";s:5:\"label\";s:14:\"provident_fund\";s:4:\"link\";s:28:\"admin/payroll/provident_fund\";s:4:\"icon\";s:15:\"fa fa-briefcase\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2017-06-10 14:04:23\";s:6:\"status\";s:1:\"1\";}i:77;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"98\";s:5:\"label\";s:14:\"advance_salary\";s:4:\"link\";s:28:\"admin/payroll/advance_salary\";s:4:\"icon\";s:19:\"fa fa-cc-mastercard\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2017-06-10 14:04:23\";s:6:\"status\";s:1:\"1\";}i:78;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"99\";s:5:\"label\";s:14:\"employee_award\";s:4:\"link\";s:11:\"admin/award\";s:4:\"icon\";s:12:\"fa fa-trophy\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2017-06-10 14:05:47\";s:6:\"status\";s:1:\"1\";}i:79;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"100\";s:5:\"label\";s:13:\"announcements\";s:4:\"link\";s:19:\"admin/announcements\";s:4:\"icon\";s:19:\"fa fa-bullhorn icon\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"22\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:80;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"101\";s:5:\"label\";s:8:\"training\";s:4:\"link\";s:14:\"admin/training\";s:4:\"icon\";s:14:\"fa fa-suitcase\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"21\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:81;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"102\";s:5:\"label\";s:12:\"job_circular\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:11:\"fa fa-globe\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"17\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:82;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"103\";s:5:\"label\";s:11:\"jobs_posted\";s:4:\"link\";s:30:\"admin/job_circular/jobs_posted\";s:4:\"icon\";s:12:\"fa fa-ticket\";s:6:\"parent\";s:3:\"102\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:83;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"104\";s:5:\"label\";s:17:\"jobs_applications\";s:4:\"link\";s:36:\"admin/job_circular/jobs_applications\";s:4:\"icon\";s:13:\"fa fa-compass\";s:6:\"parent\";s:3:\"102\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:84;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"105\";s:5:\"label\";s:10:\"attendance\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:15:\"fa fa-file-text\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"16\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:85;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"106\";s:5:\"label\";s:18:\"timechange_request\";s:4:\"link\";s:35:\"admin/attendance/timechange_request\";s:4:\"icon\";s:16:\"fa fa-calendar-o\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:86;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"107\";s:5:\"label\";s:17:\"attendance_report\";s:4:\"link\";s:34:\"admin/attendance/attendance_report\";s:4:\"icon\";s:15:\"fa fa-file-text\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:87;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"108\";s:5:\"label\";s:12:\"time_history\";s:4:\"link\";s:29:\"admin/attendance/time_history\";s:4:\"icon\";s:13:\"fa fa-clock-o\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:88;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"109\";s:5:\"label\";s:9:\"pull-down\";s:4:\"link\";s:0:\"\";s:4:\"icon\";s:0:\"\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-31 12:43:20\";s:6:\"status\";s:1:\"0\";}i:89;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"110\";s:5:\"label\";s:11:\"filemanager\";s:4:\"link\";s:17:\"admin/filemanager\";s:4:\"icon\";s:10:\"fa fa-file\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:90;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"111\";s:5:\"label\";s:15:\"company_details\";s:4:\"link\";s:14:\"admin/settings\";s:4:\"icon\";s:23:\"fa fa-fw fa-info-circle\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-25 17:08:46\";s:6:\"status\";s:1:\"2\";}i:91;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"112\";s:5:\"label\";s:15:\"system_settings\";s:4:\"link\";s:21:\"admin/settings/system\";s:4:\"icon\";s:19:\"fa fa-fw fa-desktop\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-04-25 17:08:46\";s:6:\"status\";s:1:\"2\";}i:92;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"113\";s:5:\"label\";s:14:\"email_settings\";s:4:\"link\";s:20:\"admin/settings/email\";s:4:\"icon\";s:20:\"fa fa-fw fa-envelope\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-25 17:08:46\";s:6:\"status\";s:1:\"2\";}i:93;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"114\";s:5:\"label\";s:15:\"email_templates\";s:4:\"link\";s:24:\"admin/settings/templates\";s:4:\"icon\";s:25:\"fa fa-fw fa-pencil-square\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2021-07-30 06:18:08\";s:6:\"status\";s:1:\"2\";}i:94;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"115\";s:5:\"label\";s:17:\"email_integration\";s:4:\"link\";s:32:\"admin/settings/email_integration\";s:4:\"icon\";s:22:\"fa fa-fw fa-envelope-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2021-07-30 06:18:08\";s:6:\"status\";s:1:\"2\";}i:95;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"116\";s:5:\"label\";s:16:\"payment_settings\";s:4:\"link\";s:23:\"admin/settings/payments\";s:4:\"icon\";s:18:\"fa fa-fw fa-dollar\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:96;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"117\";s:5:\"label\";s:16:\"invoice_settings\";s:4:\"link\";s:22:\"admin/settings/invoice\";s:4:\"icon\";s:17:\"fa fa-fw fa-money\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:97;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"118\";s:5:\"label\";s:17:\"estimate_settings\";s:4:\"link\";s:23:\"admin/settings/estimate\";s:4:\"icon\";s:18:\"fa fa-fw fa-file-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:98;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"119\";s:5:\"label\";s:22:\"tickets_leads_settings\";s:4:\"link\";s:22:\"admin/settings/tickets\";s:4:\"icon\";s:18:\"fa fa-fw fa-ticket\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"14\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:99;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"120\";s:5:\"label\";s:14:\"theme_settings\";s:4:\"link\";s:20:\"admin/settings/theme\";s:4:\"icon\";s:16:\"fa fa-fw fa-code\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"20\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:100;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"121\";s:5:\"label\";s:12:\"working_days\";s:4:\"link\";s:27:\"admin/settings/working_days\";s:4:\"icon\";s:20:\"fa fa-fw fa-calendar\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"22\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:101;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"122\";s:5:\"label\";s:14:\"leave_category\";s:4:\"link\";s:29:\"admin/settings/leave_category\";s:4:\"icon\";s:21:\"fa fa-fw fa-pagelines\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"23\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:102;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"123\";s:5:\"label\";s:15:\"income_category\";s:4:\"link\";s:30:\"admin/settings/income_category\";s:4:\"icon\";s:23:\"fa fa-fw fa-certificate\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"24\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:103;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"124\";s:5:\"label\";s:16:\"expense_category\";s:4:\"link\";s:31:\"admin/settings/expense_category\";s:4:\"icon\";s:17:\"fa fa-fw fa-tasks\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"25\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:104;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"125\";s:5:\"label\";s:14:\"customer_group\";s:4:\"link\";s:29:\"admin/settings/customer_group\";s:4:\"icon\";s:17:\"fa fa-fw fa-users\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"26\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:105;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"127\";s:5:\"label\";s:11:\"lead_status\";s:4:\"link\";s:26:\"admin/settings/lead_status\";s:4:\"icon\";s:19:\"fa fa-fw fa-list-ul\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"16\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:106;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"128\";s:5:\"label\";s:11:\"lead_source\";s:4:\"link\";s:26:\"admin/settings/lead_source\";s:4:\"icon\";s:22:\"fa fa-fw fa-arrow-down\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"17\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:107;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"129\";s:5:\"label\";s:26:\"opportunities_state_reason\";s:4:\"link\";s:41:\"admin/settings/opportunities_state_reason\";s:4:\"icon\";s:24:\"fa fa-fw fa-dot-circle-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"19\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:108;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"130\";s:5:\"label\";s:12:\"custom_field\";s:4:\"link\";s:27:\"admin/settings/custom_field\";s:4:\"icon\";s:18:\"fa fa-fw fa-star-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"28\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:109;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"131\";s:5:\"label\";s:14:\"payment_method\";s:4:\"link\";s:29:\"admin/settings/payment_method\";s:4:\"icon\";s:17:\"fa fa-fw fa-money\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"29\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:110;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"132\";s:5:\"label\";s:7:\"cronjob\";s:4:\"link\";s:22:\"admin/settings/cronjob\";s:4:\"icon\";s:18:\"fa fa-fw fa-contao\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"31\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:111;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"133\";s:5:\"label\";s:15:\"menu_allocation\";s:4:\"link\";s:30:\"admin/settings/menu_allocation\";s:4:\"icon\";s:22:\"fa fa-fw fa fa-compass\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"32\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:112;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"134\";s:5:\"label\";s:12:\"notification\";s:4:\"link\";s:27:\"admin/settings/notification\";s:4:\"icon\";s:18:\"fa fa-fw fa-bell-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"33\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:113;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"135\";s:5:\"label\";s:18:\"email_notification\";s:4:\"link\";s:33:\"admin/settings/email_notification\";s:4:\"icon\";s:18:\"fa fa-fw fa-bell-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"34\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:114;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"136\";s:5:\"label\";s:15:\"database_backup\";s:4:\"link\";s:30:\"admin/settings/database_backup\";s:4:\"icon\";s:20:\"fa fa-fw fa-database\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"35\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:115;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"137\";s:5:\"label\";s:12:\"translations\";s:4:\"link\";s:27:\"admin/settings/translations\";s:4:\"icon\";s:20:\"fa fa-fw fa-language\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"36\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:116;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"138\";s:5:\"label\";s:13:\"system_update\";s:4:\"link\";s:28:\"admin/settings/system_update\";s:4:\"icon\";s:27:\"fa fa-fw fa-pencil-square-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"37\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:117;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"139\";s:5:\"label\";s:12:\"private_chat\";s:4:\"link\";s:18:\"chat/conversations\";s:4:\"icon\";s:14:\"fa fa-envelope\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"28\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:118;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"140\";s:5:\"label\";s:9:\"proposals\";s:4:\"link\";s:15:\"admin/proposals\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-01-07 07:05:16\";s:6:\"status\";s:1:\"1\";}i:119;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"141\";s:5:\"label\";s:13:\"knowledgebase\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:21:\"fa fa-question-circle\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"11\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:120;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"142\";s:5:\"label\";s:10:\"categories\";s:4:\"link\";s:30:\"admin/knowledgebase/categories\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"141\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:121;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"143\";s:5:\"label\";s:8:\"articles\";s:4:\"link\";s:28:\"admin/knowledgebase/articles\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"141\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:122;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"144\";s:5:\"label\";s:13:\"knowledgebase\";s:4:\"link\";s:19:\"admin/knowledgebase\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"141\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:123;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"145\";s:5:\"label\";s:18:\"dashboard_settings\";s:4:\"link\";s:24:\"admin/settings/dashboard\";s:4:\"icon\";s:21:\"fa fa-fw fa-dashboard\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"21\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:124;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"146\";s:5:\"label\";s:20:\"transactions_reports\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:16:\"fa fa-building-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-05-13 12:29:51\";s:6:\"status\";s:1:\"1\";}i:125;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"147\";s:5:\"label\";s:5:\"sales\";s:4:\"link\";s:25:\"admin/report/sales_report\";s:4:\"icon\";s:19:\"fa fa-shopping-cart\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-01-07 01:12:23\";s:6:\"status\";s:1:\"1\";}i:126;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"148\";s:5:\"label\";s:15:\"mark_attendance\";s:4:\"link\";s:21:\"admin/mark_attendance\";s:4:\"icon\";s:15:\"fa fa-file-text\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-03-07 06:45:25\";s:6:\"status\";s:1:\"1\";}i:127;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"149\";s:5:\"label\";s:10:\"allowed_ip\";s:4:\"link\";s:25:\"admin/settings/allowed_ip\";s:4:\"icon\";s:12:\"fa fa-server\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"27\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:128;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"150\";s:5:\"label\";s:5:\"stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:11:\"icon-layers\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2019-05-01 18:10:52\";s:6:\"status\";s:1:\"1\";}i:129;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"151\";s:5:\"label\";s:8:\"supplier\";s:4:\"link\";s:14:\"admin/supplier\";s:4:\"icon\";s:14:\"icon-briefcase\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2019-05-01 18:10:52\";s:6:\"status\";s:1:\"1\";}i:130;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"152\";s:5:\"label\";s:8:\"purchase\";s:4:\"link\";s:14:\"admin/purchase\";s:4:\"icon\";s:12:\"icon-handbag\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2019-05-01 18:10:52\";s:6:\"status\";s:1:\"1\";}i:131;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"153\";s:5:\"label\";s:12:\"return_stock\";s:4:\"link\";s:18:\"admin/return_stock\";s:4:\"icon\";s:14:\"icon-share-alt\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2019-05-05 16:19:30\";s:6:\"status\";s:1:\"1\";}i:132;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"154\";s:5:\"label\";s:16:\"purchase_payment\";s:4:\"link\";s:27:\"admin/purchase/all_payments\";s:4:\"icon\";s:16:\"icon-credit-card\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2019-05-05 13:53:11\";s:6:\"status\";s:1:\"1\";}i:133;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"155\";s:5:\"label\";s:17:\"purchase_settings\";s:4:\"link\";s:23:\"admin/settings/purchase\";s:4:\"icon\";s:18:\"fa-fw icon-handbag\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"12\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:134;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"156\";s:5:\"label\";s:11:\"credit_note\";s:4:\"link\";s:17:\"admin/credit_note\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-06-10 02:32:05\";s:6:\"status\";s:1:\"1\";}i:135;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"157\";s:5:\"label\";s:20:\"credit_note_settings\";s:4:\"link\";s:26:\"admin/settings/credit_note\";s:4:\"icon\";s:17:\"fa fa-fw fa-money\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"9\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:136;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"158\";s:5:\"label\";s:18:\"proposals_settings\";s:4:\"link\";s:24:\"admin/settings/proposals\";s:4:\"icon\";s:16:\"fa fa-fw fa-leaf\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"11\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:137;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"159\";s:5:\"label\";s:17:\"projects_settings\";s:4:\"link\";s:23:\"admin/settings/projects\";s:4:\"icon\";s:25:\"fa fa-fw fa-folder-open-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"13\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:138;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"160\";s:5:\"label\";s:4:\"tags\";s:4:\"link\";s:19:\"admin/settings/tags\";s:4:\"icon\";s:16:\"fa fa-fw fa-tags\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"30\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:139;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"161\";s:5:\"label\";s:9:\"lead_form\";s:4:\"link\";s:25:\"admin/leads/all_lead_form\";s:4:\"icon\";s:18:\"fa fa-fw fa-rocket\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"18\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:140;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"162\";s:5:\"label\";s:21:\"transactions_settings\";s:4:\"link\";s:27:\"admin/settings/transactions\";s:4:\"icon\";s:22:\"fa fa-fw fa-building-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"15\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:141;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"163\";s:5:\"label\";s:12:\"sms_settings\";s:4:\"link\";s:27:\"admin/settings/sms_settings\";s:4:\"icon\";s:20:\"fa fa-fw fa-envelope\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2021-07-30 06:18:08\";s:6:\"status\";s:1:\"2\";}i:142;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"164\";s:5:\"label\";s:9:\"pos_sales\";s:4:\"link\";s:23:\"admin/invoice/pos_sales\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2021-10-16 00:53:10\";s:6:\"status\";s:1:\"1\";}i:143;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"186\";s:5:\"label\";s:9:\"warehouse\";s:4:\"link\";s:22:\"admin/warehouse/manage\";s:4:\"icon\";s:16:\"fa fa-building-o\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2021-10-18 09:24:24\";s:6:\"status\";s:1:\"1\";}i:144;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"187\";s:5:\"label\";s:12:\"transferItem\";s:4:\"link\";s:24:\"admin/items/transferItem\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2021-10-14 11:56:08\";s:6:\"status\";s:1:\"1\";}i:145;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"203\";s:5:\"label\";s:13:\"award_setting\";s:4:\"link\";s:20:\"admin/settings/award\";s:4:\"icon\";s:10:\"fa fa-star\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"30\";s:4:\"time\";s:19:\"2022-01-19 05:51:40\";s:6:\"status\";s:1:\"2\";}i:146;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"204\";s:5:\"label\";s:18:\"award_rule_setting\";s:4:\"link\";s:34:\"admin/settings/award_rule_settingh\";s:4:\"icon\";s:10:\"fa fa-star\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"31\";s:4:\"time\";s:19:\"2022-01-19 09:53:50\";s:6:\"status\";s:1:\"2\";}i:147;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"205\";s:5:\"label\";s:22:\"award_program_settings\";s:4:\"link\";s:37:\"admin/settings/award_program_settings\";s:4:\"icon\";s:9:\"fa fa-cog\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"32\";s:4:\"time\";s:19:\"2022-01-20 09:17:30\";s:6:\"status\";s:1:\"2\";}i:148;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"206\";s:5:\"label\";s:19:\"client_award_points\";s:4:\"link\";s:27:\"admin/invoice/client_awards\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2022-01-21 01:39:41\";s:6:\"status\";s:1:\"1\";}i:149;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"207\";s:5:\"label\";s:20:\"best_selling_product\";s:4:\"link\";s:18:\"admin/best_selling\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:2:\"11\";s:4:\"time\";s:19:\"2022-01-21 06:43:52\";s:6:\"status\";s:1:\"1\";}i:150;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"209\";s:5:\"label\";s:7:\"warning\";s:4:\"link\";s:13:\"admin/warning\";s:4:\"icon\";s:13:\"fa fa-warning\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2022-08-07 12:47:01\";s:6:\"status\";s:1:\"1\";}i:151;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"210\";s:5:\"label\";s:9:\"promotion\";s:4:\"link\";s:15:\"admin/promotion\";s:4:\"icon\";s:21:\"fa fa-arrow-circle-up\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2022-08-07 12:49:28\";s:6:\"status\";s:1:\"1\";}i:152;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"211\";s:5:\"label\";s:11:\"termination\";s:4:\"link\";s:17:\"admin/termination\";s:4:\"icon\";s:12:\"fa fa-eraser\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2022-08-07 12:50:45\";s:6:\"status\";s:1:\"1\";}i:153;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"212\";s:5:\"label\";s:11:\"resignation\";s:4:\"link\";s:17:\"admin/resignation\";s:4:\"icon\";s:14:\"fa fa-scissors\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2022-08-07 12:54:31\";s:6:\"status\";s:1:\"1\";}}user_name|s:5:\"nimda\";email|s:26:\"erick@blickcreative.com.au\";name|s:13:\"Erick Villeta\";photo|s:26:\"uploads/default_avatar.jpg\";user_id|s:1:\"5\";last_login|s:19:\"2023-07-06 00:35:09\";online_time|i:1688630646;loggedin|b:1;user_type|s:1:\"1\";user_flag|s:1:\"1\";direction|s:3:\"ltr\";warehouse_id|N;designations_id|s:1:\"0\";');
INSERT INTO `tbl_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('318ee241c9ae115b6924432fded056bf1e497411', '87.236.176.37', 1688995790, '__ci_last_regenerate|i:1688995789;menu_active_id|a:2:{i:0;s:3:\"109\";i:1;s:1:\"0\";}');
INSERT INTO `tbl_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('320168ef472091b4595afa8dc7b94ae791209aad', '87.236.176.179', 1689013409, '__ci_last_regenerate|i:1689013409;menu_active_id|a:2:{i:0;s:3:\"109\";i:1;s:1:\"0\";}');
INSERT INTO `tbl_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3230f10639ca2a8fb846339ac50eb7cee93a54d2', '162.142.125.225', 1688363392, '__ci_last_regenerate|i:1688363392;menu_active_id|a:2:{i:0;s:3:\"109\";i:1;s:1:\"0\";}');
INSERT INTO `tbl_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3429f6aadf48941c964660b94b9181bd7ead051d', '136.158.121.2', 1689138945, '__ci_last_regenerate|i:1689138945;menu_active_id|a:3:{i:0;s:2:\"39\";i:1;s:3:\"150\";i:2;s:1:\"0\";}user_name|s:5:\"nimda\";email|s:26:\"erick@blickcreative.com.au\";name|s:13:\"Erick Villeta\";photo|s:26:\"uploads/default_avatar.jpg\";user_id|s:1:\"5\";last_login|s:19:\"2023-07-10 11:54:34\";online_time|i:1689133478;loggedin|b:1;user_type|s:1:\"1\";user_flag|s:1:\"1\";direction|s:3:\"ltr\";warehouse_id|N;designations_id|s:1:\"0\";url|s:33:\"admin/dashboard/pinned_menu_items\";user_roll|a:154:{i:0;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"1\";s:5:\"label\";s:9:\"dashboard\";s:4:\"link\";s:15:\"admin/dashboard\";s:4:\"icon\";s:15:\"fa fa-dashboard\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-04-23 01:39:36\";s:6:\"status\";s:1:\"1\";}i:1;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"2\";s:5:\"label\";s:8:\"calendar\";s:4:\"link\";s:14:\"admin/calendar\";s:4:\"icon\";s:14:\"fa fa-calendar\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-23 19:57:23\";s:6:\"status\";s:1:\"1\";}i:2;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"4\";s:5:\"label\";s:6:\"client\";s:4:\"link\";s:26:\"admin/client/manage_client\";s:4:\"icon\";s:11:\"fa fa-users\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"13\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:3;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"5\";s:5:\"label\";s:7:\"mailbox\";s:4:\"link\";s:13:\"admin/mailbox\";s:4:\"icon\";s:16:\"fa fa-envelope-o\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:4;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"6\";s:5:\"label\";s:7:\"tickets\";s:4:\"link\";s:13:\"admin/tickets\";s:4:\"icon\";s:12:\"fa fa-ticket\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2018-06-08 13:39:39\";s:6:\"status\";s:1:\"1\";}i:5;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"12\";s:5:\"label\";s:5:\"sales\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:19:\"fa fa-shopping-cart\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"9\";s:4:\"time\";s:19:\"2017-06-10 14:02:58\";s:6:\"status\";s:1:\"1\";}i:6;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"13\";s:5:\"label\";s:7:\"invoice\";s:4:\"link\";s:28:\"admin/invoice/manage_invoice\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-04-23 19:57:23\";s:6:\"status\";s:1:\"1\";}i:7;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"14\";s:5:\"label\";s:9:\"estimates\";s:4:\"link\";s:15:\"admin/estimates\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-06-10 14:02:05\";s:6:\"status\";s:1:\"1\";}i:8;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"15\";s:5:\"label\";s:17:\"payments_received\";s:4:\"link\";s:26:\"admin/invoice/all_payments\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-23 19:57:24\";s:6:\"status\";s:1:\"1\";}i:9;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"16\";s:5:\"label\";s:9:\"tax_rates\";s:4:\"link\";s:23:\"admin/invoice/tax_rates\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-01-07 07:05:16\";s:6:\"status\";s:1:\"1\";}i:10;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"21\";s:5:\"label\";s:10:\"quotations\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:11:\"fa fa-paste\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:11;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"22\";s:5:\"label\";s:15:\"quotations_list\";s:4:\"link\";s:16:\"admin/quotations\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"21\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-05-18 16:49:03\";s:6:\"status\";s:1:\"1\";}i:12;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"23\";s:5:\"label\";s:15:\"quotations_form\";s:4:\"link\";s:32:\"admin/quotations/quotations_form\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"21\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:13;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"24\";s:5:\"label\";s:4:\"user\";s:4:\"link\";s:20:\"admin/user/user_list\";s:4:\"icon\";s:11:\"fa fa-users\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"25\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:14;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"25\";s:5:\"label\";s:8:\"settings\";s:4:\"link\";s:14:\"admin/settings\";s:4:\"icon\";s:10:\"fa fa-cogs\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"26\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:15;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"26\";s:5:\"label\";s:15:\"database_backup\";s:4:\"link\";s:30:\"admin/settings/database_backup\";s:4:\"icon\";s:14:\"fa fa-database\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"27\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:16;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"29\";s:5:\"label\";s:17:\"transactions_menu\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:16:\"fa fa-building-o\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"12\";s:4:\"time\";s:19:\"2018-05-13 12:27:58\";s:6:\"status\";s:1:\"1\";}i:17;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"30\";s:5:\"label\";s:7:\"deposit\";s:4:\"link\";s:26:\"admin/transactions/deposit\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-05-13 12:28:33\";s:6:\"status\";s:1:\"1\";}i:18;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"31\";s:5:\"label\";s:7:\"expense\";s:4:\"link\";s:26:\"admin/transactions/expense\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-05-13 12:28:37\";s:6:\"status\";s:1:\"1\";}i:19;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"32\";s:5:\"label\";s:8:\"transfer\";s:4:\"link\";s:27:\"admin/transactions/transfer\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-05-13 12:28:40\";s:6:\"status\";s:1:\"1\";}i:20;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"33\";s:5:\"label\";s:19:\"transactions_report\";s:4:\"link\";s:38:\"admin/transactions/transactions_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2018-05-13 12:28:44\";s:6:\"status\";s:1:\"1\";}i:21;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"34\";s:5:\"label\";s:13:\"balance_sheet\";s:4:\"link\";s:32:\"admin/transactions/balance_sheet\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-05-13 12:28:47\";s:6:\"status\";s:1:\"1\";}i:22;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"36\";s:5:\"label\";s:9:\"bank_cash\";s:4:\"link\";s:28:\"admin/account/manage_account\";s:4:\"icon\";s:11:\"fa fa-money\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2018-05-13 12:28:51\";s:6:\"status\";s:1:\"1\";}i:23;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"39\";s:5:\"label\";s:5:\"items\";s:4:\"link\";s:22:\"admin/items/items_list\";s:4:\"icon\";s:10:\"fa fa-cube\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2019-05-04 18:49:50\";s:6:\"status\";s:1:\"1\";}i:24;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"42\";s:5:\"label\";s:6:\"report\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:15:\"fa fa-bar-chart\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"24\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:25;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"43\";s:5:\"label\";s:17:\"account_statement\";s:4:\"link\";s:30:\"admin/report/account_statement\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:26;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"44\";s:5:\"label\";s:13:\"income_report\";s:4:\"link\";s:26:\"admin/report/income_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:27;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"45\";s:5:\"label\";s:14:\"expense_report\";s:4:\"link\";s:27:\"admin/report/expense_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:28;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"46\";s:5:\"label\";s:14:\"income_expense\";s:4:\"link\";s:27:\"admin/report/income_expense\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:29;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"47\";s:5:\"label\";s:16:\"date_wise_report\";s:4:\"link\";s:29:\"admin/report/date_wise_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:30;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"48\";s:5:\"label\";s:10:\"all_income\";s:4:\"link\";s:23:\"admin/report/all_income\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:31;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"49\";s:5:\"label\";s:11:\"all_expense\";s:4:\"link\";s:24:\"admin/report/all_expense\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:32;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"50\";s:5:\"label\";s:15:\"all_transaction\";s:4:\"link\";s:28:\"admin/report/all_transaction\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:33;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"51\";s:5:\"label\";s:17:\"recurring_invoice\";s:4:\"link\";s:31:\"admin/invoice/recurring_invoice\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-06-10 14:02:05\";s:6:\"status\";s:1:\"1\";}i:34;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"52\";s:5:\"label\";s:15:\"transfer_report\";s:4:\"link\";s:34:\"admin/transactions/transfer_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-05-13 12:28:59\";s:6:\"status\";s:1:\"1\";}i:35;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"53\";s:5:\"label\";s:15:\"report_by_month\";s:4:\"link\";s:28:\"admin/report/report_by_month\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:36;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"54\";s:5:\"label\";s:5:\"tasks\";s:4:\"link\";s:20:\"admin/tasks/all_task\";s:4:\"icon\";s:11:\"fa fa-tasks\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:37;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"55\";s:5:\"label\";s:5:\"leads\";s:4:\"link\";s:11:\"admin/leads\";s:4:\"icon\";s:12:\"fa fa-rocket\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:38;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"56\";s:5:\"label\";s:13:\"opportunities\";s:4:\"link\";s:19:\"admin/opportunities\";s:4:\"icon\";s:12:\"fa fa-filter\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:39;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"57\";s:5:\"label\";s:8:\"projects\";s:4:\"link\";s:14:\"admin/projects\";s:4:\"icon\";s:19:\"fa fa-folder-open-o\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:40;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"58\";s:5:\"label\";s:4:\"bugs\";s:4:\"link\";s:10:\"admin/bugs\";s:4:\"icon\";s:9:\"fa fa-bug\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:41;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"59\";s:5:\"label\";s:7:\"project\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:19:\"fa fa-folder-open-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:42;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"60\";s:5:\"label\";s:12:\"tasks_report\";s:4:\"link\";s:25:\"admin/report/tasks_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:43;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"61\";s:5:\"label\";s:11:\"bugs_report\";s:4:\"link\";s:24:\"admin/report/bugs_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:44;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"62\";s:5:\"label\";s:14:\"tickets_report\";s:4:\"link\";s:27:\"admin/report/tickets_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:45;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"63\";s:5:\"label\";s:13:\"client_report\";s:4:\"link\";s:26:\"admin/report/client_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2018-01-07 07:09:40\";s:6:\"status\";s:1:\"1\";}i:46;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"66\";s:5:\"label\";s:16:\"tasks_assignment\";s:4:\"link\";s:29:\"admin/report/tasks_assignment\";s:4:\"icon\";s:18:\"fa fa-dot-circle-o\";s:6:\"parent\";s:2:\"59\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:47;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"67\";s:5:\"label\";s:15:\"bugs_assignment\";s:4:\"link\";s:28:\"admin/report/bugs_assignment\";s:4:\"icon\";s:18:\"fa fa-dot-circle-o\";s:6:\"parent\";s:2:\"59\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:48;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"68\";s:5:\"label\";s:14:\"project_report\";s:4:\"link\";s:27:\"admin/report/project_report\";s:4:\"icon\";s:18:\"fa fa-dot-circle-o\";s:6:\"parent\";s:2:\"59\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:49;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"69\";s:5:\"label\";s:13:\"goal_tracking\";s:4:\"link\";s:19:\"admin/goal_tracking\";s:4:\"icon\";s:12:\"fa fa-shield\";s:6:\"parent\";s:2:\"73\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-06-10 14:05:47\";s:6:\"status\";s:1:\"1\";}i:50;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"70\";s:5:\"label\";s:11:\"departments\";s:4:\"link\";s:17:\"admin/departments\";s:4:\"icon\";s:17:\"fa fa-user-secret\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"14\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:51;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"71\";s:5:\"label\";s:7:\"holiday\";s:4:\"link\";s:13:\"admin/holiday\";s:4:\"icon\";s:21:\"fa fa-calendar-plus-o\";s:6:\"parent\";s:2:\"73\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-06-10 14:05:47\";s:6:\"status\";s:1:\"1\";}i:52;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"72\";s:5:\"label\";s:16:\"leave_management\";s:4:\"link\";s:22:\"admin/leave_management\";s:4:\"icon\";s:11:\"fa fa-plane\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"20\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:53;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"73\";s:5:\"label\";s:9:\"utilities\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:10:\"fa fa-gift\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"23\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:54;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"74\";s:5:\"label\";s:8:\"overtime\";s:4:\"link\";s:24:\"admin/utilities/overtime\";s:4:\"icon\";s:13:\"fa fa-clock-o\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"9\";s:4:\"time\";s:19:\"2017-06-10 14:04:23\";s:6:\"status\";s:1:\"1\";}i:55;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"75\";s:5:\"label\";s:12:\"office_stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:13:\"fa fa-codepen\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"15\";s:4:\"time\";s:19:\"2019-05-01 16:22:56\";s:6:\"status\";s:1:\"1\";}i:56;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"76\";s:5:\"label\";s:14:\"stock_category\";s:4:\"link\";s:26:\"admin/stock/stock_category\";s:4:\"icon\";s:13:\"fa fa-sliders\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:57;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"77\";s:5:\"label\";s:12:\"manage_stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:13:\"fa fa-archive\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-04-26 16:11:10\";s:6:\"status\";s:1:\"1\";}i:58;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"78\";s:5:\"label\";s:12:\"assign_stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:16:\"fa fa-align-left\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-26 16:11:10\";s:6:\"status\";s:1:\"1\";}i:59;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"79\";s:5:\"label\";s:12:\"stock_report\";s:4:\"link\";s:18:\"admin/stock/report\";s:4:\"icon\";s:16:\"fa fa-line-chart\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2017-04-25 18:48:25\";s:6:\"status\";s:1:\"1\";}i:60;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"81\";s:5:\"label\";s:10:\"stock_list\";s:4:\"link\";s:22:\"admin/stock/stock_list\";s:4:\"icon\";s:20:\"fa fa-stack-exchange\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-26 16:11:10\";s:6:\"status\";s:1:\"1\";}i:61;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"82\";s:5:\"label\";s:12:\"assign_stock\";s:4:\"link\";s:24:\"admin/stock/assign_stock\";s:4:\"icon\";s:16:\"fa fa-align-left\";s:6:\"parent\";s:2:\"78\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:62;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"83\";s:5:\"label\";s:19:\"assign_stock_report\";s:4:\"link\";s:31:\"admin/stock/assign_stock_report\";s:4:\"icon\";s:15:\"fa fa-bar-chart\";s:6:\"parent\";s:2:\"78\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:63;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"84\";s:5:\"label\";s:13:\"stock_history\";s:4:\"link\";s:25:\"admin/stock/stock_history\";s:4:\"icon\";s:17:\"fa fa-file-text-o\";s:6:\"parent\";s:2:\"77\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:64;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"85\";s:5:\"label\";s:11:\"performance\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:14:\"fa fa-dribbble\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"19\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:65;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"86\";s:5:\"label\";s:21:\"performance_indicator\";s:4:\"link\";s:39:\"admin/performance/performance_indicator\";s:4:\"icon\";s:12:\"fa fa-random\";s:6:\"parent\";s:2:\"85\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:66;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"87\";s:5:\"label\";s:18:\"performance_report\";s:4:\"link\";s:36:\"admin/performance/performance_report\";s:4:\"icon\";s:16:\"fa fa-calendar-o\";s:6:\"parent\";s:2:\"85\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:67;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"88\";s:5:\"label\";s:14:\"give_appraisal\";s:4:\"link\";s:44:\"admin/performance/give_performance_appraisal\";s:4:\"icon\";s:10:\"fa fa-plus\";s:6:\"parent\";s:2:\"85\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:68;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"89\";s:5:\"label\";s:7:\"payroll\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:9:\"fa fa-usd\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"18\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:69;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"90\";s:5:\"label\";s:21:\"manage_salary_details\";s:4:\"link\";s:35:\"admin/payroll/manage_salary_details\";s:4:\"icon\";s:9:\"fa fa-usd\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:70;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"91\";s:5:\"label\";s:20:\"employee_salary_list\";s:4:\"link\";s:34:\"admin/payroll/employee_salary_list\";s:4:\"icon\";s:17:\"fa fa-user-secret\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:71;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"92\";s:5:\"label\";s:12:\"make_payment\";s:4:\"link\";s:26:\"admin/payroll/make_payment\";s:4:\"icon\";s:11:\"fa fa-tasks\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:72;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"93\";s:5:\"label\";s:16:\"generate_payslip\";s:4:\"link\";s:30:\"admin/payroll/generate_payslip\";s:4:\"icon\";s:13:\"fa fa-list-ul\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:73;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"94\";s:5:\"label\";s:15:\"salary_template\";s:4:\"link\";s:29:\"admin/payroll/salary_template\";s:4:\"icon\";s:11:\"fa fa-money\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:74;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"95\";s:5:\"label\";s:11:\"hourly_rate\";s:4:\"link\";s:25:\"admin/payroll/hourly_rate\";s:4:\"icon\";s:13:\"fa fa-clock-o\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:75;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"96\";s:5:\"label\";s:15:\"payroll_summary\";s:4:\"link\";s:29:\"admin/payroll/payroll_summary\";s:4:\"icon\";s:18:\"fa fa-camera-retro\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:76;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"97\";s:5:\"label\";s:14:\"provident_fund\";s:4:\"link\";s:28:\"admin/payroll/provident_fund\";s:4:\"icon\";s:15:\"fa fa-briefcase\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2017-06-10 14:04:23\";s:6:\"status\";s:1:\"1\";}i:77;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"98\";s:5:\"label\";s:14:\"advance_salary\";s:4:\"link\";s:28:\"admin/payroll/advance_salary\";s:4:\"icon\";s:19:\"fa fa-cc-mastercard\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2017-06-10 14:04:23\";s:6:\"status\";s:1:\"1\";}i:78;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"99\";s:5:\"label\";s:14:\"employee_award\";s:4:\"link\";s:11:\"admin/award\";s:4:\"icon\";s:12:\"fa fa-trophy\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2017-06-10 14:05:47\";s:6:\"status\";s:1:\"1\";}i:79;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"100\";s:5:\"label\";s:13:\"announcements\";s:4:\"link\";s:19:\"admin/announcements\";s:4:\"icon\";s:19:\"fa fa-bullhorn icon\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"22\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:80;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"101\";s:5:\"label\";s:8:\"training\";s:4:\"link\";s:14:\"admin/training\";s:4:\"icon\";s:14:\"fa fa-suitcase\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"21\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:81;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"102\";s:5:\"label\";s:12:\"job_circular\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:11:\"fa fa-globe\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"17\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:82;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"103\";s:5:\"label\";s:11:\"jobs_posted\";s:4:\"link\";s:30:\"admin/job_circular/jobs_posted\";s:4:\"icon\";s:12:\"fa fa-ticket\";s:6:\"parent\";s:3:\"102\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:83;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"104\";s:5:\"label\";s:17:\"jobs_applications\";s:4:\"link\";s:36:\"admin/job_circular/jobs_applications\";s:4:\"icon\";s:13:\"fa fa-compass\";s:6:\"parent\";s:3:\"102\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:84;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"105\";s:5:\"label\";s:10:\"attendance\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:15:\"fa fa-file-text\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"16\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:85;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"106\";s:5:\"label\";s:18:\"timechange_request\";s:4:\"link\";s:35:\"admin/attendance/timechange_request\";s:4:\"icon\";s:16:\"fa fa-calendar-o\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:86;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"107\";s:5:\"label\";s:17:\"attendance_report\";s:4:\"link\";s:34:\"admin/attendance/attendance_report\";s:4:\"icon\";s:15:\"fa fa-file-text\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:87;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"108\";s:5:\"label\";s:12:\"time_history\";s:4:\"link\";s:29:\"admin/attendance/time_history\";s:4:\"icon\";s:13:\"fa fa-clock-o\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:88;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"109\";s:5:\"label\";s:9:\"pull-down\";s:4:\"link\";s:0:\"\";s:4:\"icon\";s:0:\"\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-31 12:43:20\";s:6:\"status\";s:1:\"0\";}i:89;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"110\";s:5:\"label\";s:11:\"filemanager\";s:4:\"link\";s:17:\"admin/filemanager\";s:4:\"icon\";s:10:\"fa fa-file\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:90;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"111\";s:5:\"label\";s:15:\"company_details\";s:4:\"link\";s:14:\"admin/settings\";s:4:\"icon\";s:23:\"fa fa-fw fa-info-circle\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-25 17:08:46\";s:6:\"status\";s:1:\"2\";}i:91;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"112\";s:5:\"label\";s:15:\"system_settings\";s:4:\"link\";s:21:\"admin/settings/system\";s:4:\"icon\";s:19:\"fa fa-fw fa-desktop\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-04-25 17:08:46\";s:6:\"status\";s:1:\"2\";}i:92;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"113\";s:5:\"label\";s:14:\"email_settings\";s:4:\"link\";s:20:\"admin/settings/email\";s:4:\"icon\";s:20:\"fa fa-fw fa-envelope\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-25 17:08:46\";s:6:\"status\";s:1:\"2\";}i:93;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"114\";s:5:\"label\";s:15:\"email_templates\";s:4:\"link\";s:24:\"admin/settings/templates\";s:4:\"icon\";s:25:\"fa fa-fw fa-pencil-square\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2021-07-30 06:18:08\";s:6:\"status\";s:1:\"2\";}i:94;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"115\";s:5:\"label\";s:17:\"email_integration\";s:4:\"link\";s:32:\"admin/settings/email_integration\";s:4:\"icon\";s:22:\"fa fa-fw fa-envelope-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2021-07-30 06:18:08\";s:6:\"status\";s:1:\"2\";}i:95;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"116\";s:5:\"label\";s:16:\"payment_settings\";s:4:\"link\";s:23:\"admin/settings/payments\";s:4:\"icon\";s:18:\"fa fa-fw fa-dollar\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:96;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"117\";s:5:\"label\";s:16:\"invoice_settings\";s:4:\"link\";s:22:\"admin/settings/invoice\";s:4:\"icon\";s:17:\"fa fa-fw fa-money\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:97;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"118\";s:5:\"label\";s:17:\"estimate_settings\";s:4:\"link\";s:23:\"admin/settings/estimate\";s:4:\"icon\";s:18:\"fa fa-fw fa-file-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:98;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"119\";s:5:\"label\";s:22:\"tickets_leads_settings\";s:4:\"link\";s:22:\"admin/settings/tickets\";s:4:\"icon\";s:18:\"fa fa-fw fa-ticket\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"14\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:99;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"120\";s:5:\"label\";s:14:\"theme_settings\";s:4:\"link\";s:20:\"admin/settings/theme\";s:4:\"icon\";s:16:\"fa fa-fw fa-code\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"20\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:100;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"121\";s:5:\"label\";s:12:\"working_days\";s:4:\"link\";s:27:\"admin/settings/working_days\";s:4:\"icon\";s:20:\"fa fa-fw fa-calendar\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"22\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:101;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"122\";s:5:\"label\";s:14:\"leave_category\";s:4:\"link\";s:29:\"admin/settings/leave_category\";s:4:\"icon\";s:21:\"fa fa-fw fa-pagelines\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"23\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:102;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"123\";s:5:\"label\";s:15:\"income_category\";s:4:\"link\";s:30:\"admin/settings/income_category\";s:4:\"icon\";s:23:\"fa fa-fw fa-certificate\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"24\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:103;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"124\";s:5:\"label\";s:16:\"expense_category\";s:4:\"link\";s:31:\"admin/settings/expense_category\";s:4:\"icon\";s:17:\"fa fa-fw fa-tasks\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"25\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:104;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"125\";s:5:\"label\";s:14:\"customer_group\";s:4:\"link\";s:29:\"admin/settings/customer_group\";s:4:\"icon\";s:17:\"fa fa-fw fa-users\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"26\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:105;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"127\";s:5:\"label\";s:11:\"lead_status\";s:4:\"link\";s:26:\"admin/settings/lead_status\";s:4:\"icon\";s:19:\"fa fa-fw fa-list-ul\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"16\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:106;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"128\";s:5:\"label\";s:11:\"lead_source\";s:4:\"link\";s:26:\"admin/settings/lead_source\";s:4:\"icon\";s:22:\"fa fa-fw fa-arrow-down\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"17\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:107;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"129\";s:5:\"label\";s:26:\"opportunities_state_reason\";s:4:\"link\";s:41:\"admin/settings/opportunities_state_reason\";s:4:\"icon\";s:24:\"fa fa-fw fa-dot-circle-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"19\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:108;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"130\";s:5:\"label\";s:12:\"custom_field\";s:4:\"link\";s:27:\"admin/settings/custom_field\";s:4:\"icon\";s:18:\"fa fa-fw fa-star-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"28\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:109;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"131\";s:5:\"label\";s:14:\"payment_method\";s:4:\"link\";s:29:\"admin/settings/payment_method\";s:4:\"icon\";s:17:\"fa fa-fw fa-money\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"29\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:110;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"132\";s:5:\"label\";s:7:\"cronjob\";s:4:\"link\";s:22:\"admin/settings/cronjob\";s:4:\"icon\";s:18:\"fa fa-fw fa-contao\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"31\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:111;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"133\";s:5:\"label\";s:15:\"menu_allocation\";s:4:\"link\";s:30:\"admin/settings/menu_allocation\";s:4:\"icon\";s:22:\"fa fa-fw fa fa-compass\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"32\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:112;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"134\";s:5:\"label\";s:12:\"notification\";s:4:\"link\";s:27:\"admin/settings/notification\";s:4:\"icon\";s:18:\"fa fa-fw fa-bell-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"33\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:113;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"135\";s:5:\"label\";s:18:\"email_notification\";s:4:\"link\";s:33:\"admin/settings/email_notification\";s:4:\"icon\";s:18:\"fa fa-fw fa-bell-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"34\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:114;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"136\";s:5:\"label\";s:15:\"database_backup\";s:4:\"link\";s:30:\"admin/settings/database_backup\";s:4:\"icon\";s:20:\"fa fa-fw fa-database\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"35\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:115;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"137\";s:5:\"label\";s:12:\"translations\";s:4:\"link\";s:27:\"admin/settings/translations\";s:4:\"icon\";s:20:\"fa fa-fw fa-language\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"36\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:116;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"138\";s:5:\"label\";s:13:\"system_update\";s:4:\"link\";s:28:\"admin/settings/system_update\";s:4:\"icon\";s:27:\"fa fa-fw fa-pencil-square-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"37\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:117;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"139\";s:5:\"label\";s:12:\"private_chat\";s:4:\"link\";s:18:\"chat/conversations\";s:4:\"icon\";s:14:\"fa fa-envelope\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"28\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:118;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"140\";s:5:\"label\";s:9:\"proposals\";s:4:\"link\";s:15:\"admin/proposals\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-01-07 07:05:16\";s:6:\"status\";s:1:\"1\";}i:119;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"141\";s:5:\"label\";s:13:\"knowledgebase\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:21:\"fa fa-question-circle\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"11\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:120;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"142\";s:5:\"label\";s:10:\"categories\";s:4:\"link\";s:30:\"admin/knowledgebase/categories\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"141\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:121;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"143\";s:5:\"label\";s:8:\"articles\";s:4:\"link\";s:28:\"admin/knowledgebase/articles\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"141\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:122;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"144\";s:5:\"label\";s:13:\"knowledgebase\";s:4:\"link\";s:19:\"admin/knowledgebase\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"141\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:123;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"145\";s:5:\"label\";s:18:\"dashboard_settings\";s:4:\"link\";s:24:\"admin/settings/dashboard\";s:4:\"icon\";s:21:\"fa fa-fw fa-dashboard\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"21\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:124;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"146\";s:5:\"label\";s:20:\"transactions_reports\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:16:\"fa fa-building-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-05-13 12:29:51\";s:6:\"status\";s:1:\"1\";}i:125;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"147\";s:5:\"label\";s:5:\"sales\";s:4:\"link\";s:25:\"admin/report/sales_report\";s:4:\"icon\";s:19:\"fa fa-shopping-cart\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-01-07 01:12:23\";s:6:\"status\";s:1:\"1\";}i:126;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"148\";s:5:\"label\";s:15:\"mark_attendance\";s:4:\"link\";s:21:\"admin/mark_attendance\";s:4:\"icon\";s:15:\"fa fa-file-text\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-03-07 06:45:25\";s:6:\"status\";s:1:\"1\";}i:127;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"149\";s:5:\"label\";s:10:\"allowed_ip\";s:4:\"link\";s:25:\"admin/settings/allowed_ip\";s:4:\"icon\";s:12:\"fa fa-server\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"27\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:128;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"150\";s:5:\"label\";s:5:\"stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:11:\"icon-layers\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2019-05-01 18:10:52\";s:6:\"status\";s:1:\"1\";}i:129;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"151\";s:5:\"label\";s:8:\"supplier\";s:4:\"link\";s:14:\"admin/supplier\";s:4:\"icon\";s:14:\"icon-briefcase\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2019-05-01 18:10:52\";s:6:\"status\";s:1:\"1\";}i:130;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"152\";s:5:\"label\";s:8:\"purchase\";s:4:\"link\";s:14:\"admin/purchase\";s:4:\"icon\";s:12:\"icon-handbag\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2019-05-01 18:10:52\";s:6:\"status\";s:1:\"1\";}i:131;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"153\";s:5:\"label\";s:12:\"return_stock\";s:4:\"link\";s:18:\"admin/return_stock\";s:4:\"icon\";s:14:\"icon-share-alt\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2019-05-05 16:19:30\";s:6:\"status\";s:1:\"1\";}i:132;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"154\";s:5:\"label\";s:16:\"purchase_payment\";s:4:\"link\";s:27:\"admin/purchase/all_payments\";s:4:\"icon\";s:16:\"icon-credit-card\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2019-05-05 13:53:11\";s:6:\"status\";s:1:\"1\";}i:133;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"155\";s:5:\"label\";s:17:\"purchase_settings\";s:4:\"link\";s:23:\"admin/settings/purchase\";s:4:\"icon\";s:18:\"fa-fw icon-handbag\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"12\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:134;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"156\";s:5:\"label\";s:11:\"credit_note\";s:4:\"link\";s:17:\"admin/credit_note\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-06-10 02:32:05\";s:6:\"status\";s:1:\"1\";}i:135;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"157\";s:5:\"label\";s:20:\"credit_note_settings\";s:4:\"link\";s:26:\"admin/settings/credit_note\";s:4:\"icon\";s:17:\"fa fa-fw fa-money\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"9\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:136;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"158\";s:5:\"label\";s:18:\"proposals_settings\";s:4:\"link\";s:24:\"admin/settings/proposals\";s:4:\"icon\";s:16:\"fa fa-fw fa-leaf\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"11\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:137;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"159\";s:5:\"label\";s:17:\"projects_settings\";s:4:\"link\";s:23:\"admin/settings/projects\";s:4:\"icon\";s:25:\"fa fa-fw fa-folder-open-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"13\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:138;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"160\";s:5:\"label\";s:4:\"tags\";s:4:\"link\";s:19:\"admin/settings/tags\";s:4:\"icon\";s:16:\"fa fa-fw fa-tags\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"30\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:139;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"161\";s:5:\"label\";s:9:\"lead_form\";s:4:\"link\";s:25:\"admin/leads/all_lead_form\";s:4:\"icon\";s:18:\"fa fa-fw fa-rocket\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"18\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:140;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"162\";s:5:\"label\";s:21:\"transactions_settings\";s:4:\"link\";s:27:\"admin/settings/transactions\";s:4:\"icon\";s:22:\"fa fa-fw fa-building-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"15\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:141;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"163\";s:5:\"label\";s:12:\"sms_settings\";s:4:\"link\";s:27:\"admin/settings/sms_settings\";s:4:\"icon\";s:20:\"fa fa-fw fa-envelope\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2021-07-30 06:18:08\";s:6:\"status\";s:1:\"2\";}i:142;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"164\";s:5:\"label\";s:9:\"pos_sales\";s:4:\"link\";s:23:\"admin/invoice/pos_sales\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2021-10-16 00:53:10\";s:6:\"status\";s:1:\"1\";}i:143;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"186\";s:5:\"label\";s:9:\"warehouse\";s:4:\"link\";s:22:\"admin/warehouse/manage\";s:4:\"icon\";s:16:\"fa fa-building-o\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2021-10-18 09:24:24\";s:6:\"status\";s:1:\"1\";}i:144;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"187\";s:5:\"label\";s:12:\"transferItem\";s:4:\"link\";s:24:\"admin/items/transferItem\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2021-10-14 11:56:08\";s:6:\"status\";s:1:\"1\";}i:145;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"203\";s:5:\"label\";s:13:\"award_setting\";s:4:\"link\";s:20:\"admin/settings/award\";s:4:\"icon\";s:10:\"fa fa-star\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"30\";s:4:\"time\";s:19:\"2022-01-19 05:51:40\";s:6:\"status\";s:1:\"2\";}i:146;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"204\";s:5:\"label\";s:18:\"award_rule_setting\";s:4:\"link\";s:34:\"admin/settings/award_rule_settingh\";s:4:\"icon\";s:10:\"fa fa-star\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"31\";s:4:\"time\";s:19:\"2022-01-19 09:53:50\";s:6:\"status\";s:1:\"2\";}i:147;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"205\";s:5:\"label\";s:22:\"award_program_settings\";s:4:\"link\";s:37:\"admin/settings/award_program_settings\";s:4:\"icon\";s:9:\"fa fa-cog\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"32\";s:4:\"time\";s:19:\"2022-01-20 09:17:30\";s:6:\"status\";s:1:\"2\";}i:148;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"206\";s:5:\"label\";s:19:\"client_award_points\";s:4:\"link\";s:27:\"admin/invoice/client_awards\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2022-01-21 01:39:41\";s:6:\"status\";s:1:\"1\";}i:149;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"207\";s:5:\"label\";s:20:\"best_selling_product\";s:4:\"link\";s:18:\"admin/best_selling\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:2:\"11\";s:4:\"time\";s:19:\"2022-01-21 06:43:52\";s:6:\"status\";s:1:\"1\";}i:150;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"209\";s:5:\"label\";s:7:\"warning\";s:4:\"link\";s:13:\"admin/warning\";s:4:\"icon\";s:13:\"fa fa-warning\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2022-08-07 12:47:01\";s:6:\"status\";s:1:\"1\";}i:151;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"210\";s:5:\"label\";s:9:\"promotion\";s:4:\"link\";s:15:\"admin/promotion\";s:4:\"icon\";s:21:\"fa fa-arrow-circle-up\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2022-08-07 12:49:28\";s:6:\"status\";s:1:\"1\";}i:152;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"211\";s:5:\"label\";s:11:\"termination\";s:4:\"link\";s:17:\"admin/termination\";s:4:\"icon\";s:12:\"fa fa-eraser\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2022-08-07 12:50:45\";s:6:\"status\";s:1:\"1\";}i:153;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"212\";s:5:\"label\";s:11:\"resignation\";s:4:\"link\";s:17:\"admin/resignation\";s:4:\"icon\";s:14:\"fa fa-scissors\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2022-08-07 12:54:31\";s:6:\"status\";s:1:\"1\";}}');
INSERT INTO `tbl_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('36266426807c45ab7b54b65d58fa4b671e9f67d8', '136.158.120.226', 1688531413, '__ci_last_regenerate|i:1688531413;menu_active_id|a:3:{i:0;s:3:\"112\";i:1;s:2:\"25\";i:2;s:1:\"0\";}user_name|s:5:\"nimda\";email|s:26:\"erick@blickcreative.com.au\";name|s:13:\"Erick Villeta\";photo|s:26:\"uploads/default_avatar.jpg\";user_id|s:1:\"5\";last_login|N;online_time|i:1688531159;loggedin|b:1;user_type|s:1:\"1\";user_flag|s:1:\"1\";direction|s:3:\"ltr\";warehouse_id|N;designations_id|s:1:\"0\";url|s:33:\"admin/dashboard/pinned_menu_items\";user_roll|a:154:{i:0;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"1\";s:5:\"label\";s:9:\"dashboard\";s:4:\"link\";s:15:\"admin/dashboard\";s:4:\"icon\";s:15:\"fa fa-dashboard\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-04-23 01:39:36\";s:6:\"status\";s:1:\"1\";}i:1;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"2\";s:5:\"label\";s:8:\"calendar\";s:4:\"link\";s:14:\"admin/calendar\";s:4:\"icon\";s:14:\"fa fa-calendar\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-23 19:57:23\";s:6:\"status\";s:1:\"1\";}i:2;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"4\";s:5:\"label\";s:6:\"client\";s:4:\"link\";s:26:\"admin/client/manage_client\";s:4:\"icon\";s:11:\"fa fa-users\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"13\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:3;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"5\";s:5:\"label\";s:7:\"mailbox\";s:4:\"link\";s:13:\"admin/mailbox\";s:4:\"icon\";s:16:\"fa fa-envelope-o\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:4;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"6\";s:5:\"label\";s:7:\"tickets\";s:4:\"link\";s:13:\"admin/tickets\";s:4:\"icon\";s:12:\"fa fa-ticket\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2018-06-08 13:39:39\";s:6:\"status\";s:1:\"1\";}i:5;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"12\";s:5:\"label\";s:5:\"sales\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:19:\"fa fa-shopping-cart\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"9\";s:4:\"time\";s:19:\"2017-06-10 14:02:58\";s:6:\"status\";s:1:\"1\";}i:6;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"13\";s:5:\"label\";s:7:\"invoice\";s:4:\"link\";s:28:\"admin/invoice/manage_invoice\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-04-23 19:57:23\";s:6:\"status\";s:1:\"1\";}i:7;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"14\";s:5:\"label\";s:9:\"estimates\";s:4:\"link\";s:15:\"admin/estimates\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-06-10 14:02:05\";s:6:\"status\";s:1:\"1\";}i:8;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"15\";s:5:\"label\";s:17:\"payments_received\";s:4:\"link\";s:26:\"admin/invoice/all_payments\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-23 19:57:24\";s:6:\"status\";s:1:\"1\";}i:9;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"16\";s:5:\"label\";s:9:\"tax_rates\";s:4:\"link\";s:23:\"admin/invoice/tax_rates\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-01-07 07:05:16\";s:6:\"status\";s:1:\"1\";}i:10;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"21\";s:5:\"label\";s:10:\"quotations\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:11:\"fa fa-paste\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:11;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"22\";s:5:\"label\";s:15:\"quotations_list\";s:4:\"link\";s:16:\"admin/quotations\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"21\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-05-18 16:49:03\";s:6:\"status\";s:1:\"1\";}i:12;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"23\";s:5:\"label\";s:15:\"quotations_form\";s:4:\"link\";s:32:\"admin/quotations/quotations_form\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"21\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:13;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"24\";s:5:\"label\";s:4:\"user\";s:4:\"link\";s:20:\"admin/user/user_list\";s:4:\"icon\";s:11:\"fa fa-users\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"25\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:14;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"25\";s:5:\"label\";s:8:\"settings\";s:4:\"link\";s:14:\"admin/settings\";s:4:\"icon\";s:10:\"fa fa-cogs\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"26\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:15;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"26\";s:5:\"label\";s:15:\"database_backup\";s:4:\"link\";s:30:\"admin/settings/database_backup\";s:4:\"icon\";s:14:\"fa fa-database\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"27\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:16;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"29\";s:5:\"label\";s:17:\"transactions_menu\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:16:\"fa fa-building-o\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"12\";s:4:\"time\";s:19:\"2018-05-13 12:27:58\";s:6:\"status\";s:1:\"1\";}i:17;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"30\";s:5:\"label\";s:7:\"deposit\";s:4:\"link\";s:26:\"admin/transactions/deposit\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-05-13 12:28:33\";s:6:\"status\";s:1:\"1\";}i:18;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"31\";s:5:\"label\";s:7:\"expense\";s:4:\"link\";s:26:\"admin/transactions/expense\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-05-13 12:28:37\";s:6:\"status\";s:1:\"1\";}i:19;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"32\";s:5:\"label\";s:8:\"transfer\";s:4:\"link\";s:27:\"admin/transactions/transfer\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-05-13 12:28:40\";s:6:\"status\";s:1:\"1\";}i:20;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"33\";s:5:\"label\";s:19:\"transactions_report\";s:4:\"link\";s:38:\"admin/transactions/transactions_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2018-05-13 12:28:44\";s:6:\"status\";s:1:\"1\";}i:21;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"34\";s:5:\"label\";s:13:\"balance_sheet\";s:4:\"link\";s:32:\"admin/transactions/balance_sheet\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-05-13 12:28:47\";s:6:\"status\";s:1:\"1\";}i:22;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"36\";s:5:\"label\";s:9:\"bank_cash\";s:4:\"link\";s:28:\"admin/account/manage_account\";s:4:\"icon\";s:11:\"fa fa-money\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2018-05-13 12:28:51\";s:6:\"status\";s:1:\"1\";}i:23;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"39\";s:5:\"label\";s:5:\"items\";s:4:\"link\";s:22:\"admin/items/items_list\";s:4:\"icon\";s:10:\"fa fa-cube\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2019-05-04 18:49:50\";s:6:\"status\";s:1:\"1\";}i:24;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"42\";s:5:\"label\";s:6:\"report\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:15:\"fa fa-bar-chart\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"24\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:25;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"43\";s:5:\"label\";s:17:\"account_statement\";s:4:\"link\";s:30:\"admin/report/account_statement\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:26;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"44\";s:5:\"label\";s:13:\"income_report\";s:4:\"link\";s:26:\"admin/report/income_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:27;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"45\";s:5:\"label\";s:14:\"expense_report\";s:4:\"link\";s:27:\"admin/report/expense_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:28;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"46\";s:5:\"label\";s:14:\"income_expense\";s:4:\"link\";s:27:\"admin/report/income_expense\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:29;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"47\";s:5:\"label\";s:16:\"date_wise_report\";s:4:\"link\";s:29:\"admin/report/date_wise_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:30;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"48\";s:5:\"label\";s:10:\"all_income\";s:4:\"link\";s:23:\"admin/report/all_income\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:31;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"49\";s:5:\"label\";s:11:\"all_expense\";s:4:\"link\";s:24:\"admin/report/all_expense\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:32;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"50\";s:5:\"label\";s:15:\"all_transaction\";s:4:\"link\";s:28:\"admin/report/all_transaction\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:33;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"51\";s:5:\"label\";s:17:\"recurring_invoice\";s:4:\"link\";s:31:\"admin/invoice/recurring_invoice\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-06-10 14:02:05\";s:6:\"status\";s:1:\"1\";}i:34;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"52\";s:5:\"label\";s:15:\"transfer_report\";s:4:\"link\";s:34:\"admin/transactions/transfer_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-05-13 12:28:59\";s:6:\"status\";s:1:\"1\";}i:35;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"53\";s:5:\"label\";s:15:\"report_by_month\";s:4:\"link\";s:28:\"admin/report/report_by_month\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:36;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"54\";s:5:\"label\";s:5:\"tasks\";s:4:\"link\";s:20:\"admin/tasks/all_task\";s:4:\"icon\";s:11:\"fa fa-tasks\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:37;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"55\";s:5:\"label\";s:5:\"leads\";s:4:\"link\";s:11:\"admin/leads\";s:4:\"icon\";s:12:\"fa fa-rocket\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:38;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"56\";s:5:\"label\";s:13:\"opportunities\";s:4:\"link\";s:19:\"admin/opportunities\";s:4:\"icon\";s:12:\"fa fa-filter\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:39;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"57\";s:5:\"label\";s:8:\"projects\";s:4:\"link\";s:14:\"admin/projects\";s:4:\"icon\";s:19:\"fa fa-folder-open-o\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:40;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"58\";s:5:\"label\";s:4:\"bugs\";s:4:\"link\";s:10:\"admin/bugs\";s:4:\"icon\";s:9:\"fa fa-bug\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:41;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"59\";s:5:\"label\";s:7:\"project\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:19:\"fa fa-folder-open-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:42;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"60\";s:5:\"label\";s:12:\"tasks_report\";s:4:\"link\";s:25:\"admin/report/tasks_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:43;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"61\";s:5:\"label\";s:11:\"bugs_report\";s:4:\"link\";s:24:\"admin/report/bugs_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:44;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"62\";s:5:\"label\";s:14:\"tickets_report\";s:4:\"link\";s:27:\"admin/report/tickets_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:45;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"63\";s:5:\"label\";s:13:\"client_report\";s:4:\"link\";s:26:\"admin/report/client_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2018-01-07 07:09:40\";s:6:\"status\";s:1:\"1\";}i:46;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"66\";s:5:\"label\";s:16:\"tasks_assignment\";s:4:\"link\";s:29:\"admin/report/tasks_assignment\";s:4:\"icon\";s:18:\"fa fa-dot-circle-o\";s:6:\"parent\";s:2:\"59\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:47;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"67\";s:5:\"label\";s:15:\"bugs_assignment\";s:4:\"link\";s:28:\"admin/report/bugs_assignment\";s:4:\"icon\";s:18:\"fa fa-dot-circle-o\";s:6:\"parent\";s:2:\"59\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:48;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"68\";s:5:\"label\";s:14:\"project_report\";s:4:\"link\";s:27:\"admin/report/project_report\";s:4:\"icon\";s:18:\"fa fa-dot-circle-o\";s:6:\"parent\";s:2:\"59\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:49;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"69\";s:5:\"label\";s:13:\"goal_tracking\";s:4:\"link\";s:19:\"admin/goal_tracking\";s:4:\"icon\";s:12:\"fa fa-shield\";s:6:\"parent\";s:2:\"73\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-06-10 14:05:47\";s:6:\"status\";s:1:\"1\";}i:50;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"70\";s:5:\"label\";s:11:\"departments\";s:4:\"link\";s:17:\"admin/departments\";s:4:\"icon\";s:17:\"fa fa-user-secret\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"14\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:51;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"71\";s:5:\"label\";s:7:\"holiday\";s:4:\"link\";s:13:\"admin/holiday\";s:4:\"icon\";s:21:\"fa fa-calendar-plus-o\";s:6:\"parent\";s:2:\"73\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-06-10 14:05:47\";s:6:\"status\";s:1:\"1\";}i:52;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"72\";s:5:\"label\";s:16:\"leave_management\";s:4:\"link\";s:22:\"admin/leave_management\";s:4:\"icon\";s:11:\"fa fa-plane\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"20\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:53;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"73\";s:5:\"label\";s:9:\"utilities\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:10:\"fa fa-gift\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"23\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:54;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"74\";s:5:\"label\";s:8:\"overtime\";s:4:\"link\";s:24:\"admin/utilities/overtime\";s:4:\"icon\";s:13:\"fa fa-clock-o\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"9\";s:4:\"time\";s:19:\"2017-06-10 14:04:23\";s:6:\"status\";s:1:\"1\";}i:55;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"75\";s:5:\"label\";s:12:\"office_stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:13:\"fa fa-codepen\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"15\";s:4:\"time\";s:19:\"2019-05-01 16:22:56\";s:6:\"status\";s:1:\"1\";}i:56;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"76\";s:5:\"label\";s:14:\"stock_category\";s:4:\"link\";s:26:\"admin/stock/stock_category\";s:4:\"icon\";s:13:\"fa fa-sliders\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:57;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"77\";s:5:\"label\";s:12:\"manage_stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:13:\"fa fa-archive\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-04-26 16:11:10\";s:6:\"status\";s:1:\"1\";}i:58;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"78\";s:5:\"label\";s:12:\"assign_stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:16:\"fa fa-align-left\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-26 16:11:10\";s:6:\"status\";s:1:\"1\";}i:59;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"79\";s:5:\"label\";s:12:\"stock_report\";s:4:\"link\";s:18:\"admin/stock/report\";s:4:\"icon\";s:16:\"fa fa-line-chart\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2017-04-25 18:48:25\";s:6:\"status\";s:1:\"1\";}i:60;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"81\";s:5:\"label\";s:10:\"stock_list\";s:4:\"link\";s:22:\"admin/stock/stock_list\";s:4:\"icon\";s:20:\"fa fa-stack-exchange\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-26 16:11:10\";s:6:\"status\";s:1:\"1\";}i:61;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"82\";s:5:\"label\";s:12:\"assign_stock\";s:4:\"link\";s:24:\"admin/stock/assign_stock\";s:4:\"icon\";s:16:\"fa fa-align-left\";s:6:\"parent\";s:2:\"78\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:62;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"83\";s:5:\"label\";s:19:\"assign_stock_report\";s:4:\"link\";s:31:\"admin/stock/assign_stock_report\";s:4:\"icon\";s:15:\"fa fa-bar-chart\";s:6:\"parent\";s:2:\"78\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:63;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"84\";s:5:\"label\";s:13:\"stock_history\";s:4:\"link\";s:25:\"admin/stock/stock_history\";s:4:\"icon\";s:17:\"fa fa-file-text-o\";s:6:\"parent\";s:2:\"77\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:64;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"85\";s:5:\"label\";s:11:\"performance\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:14:\"fa fa-dribbble\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"19\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:65;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"86\";s:5:\"label\";s:21:\"performance_indicator\";s:4:\"link\";s:39:\"admin/performance/performance_indicator\";s:4:\"icon\";s:12:\"fa fa-random\";s:6:\"parent\";s:2:\"85\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:66;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"87\";s:5:\"label\";s:18:\"performance_report\";s:4:\"link\";s:36:\"admin/performance/performance_report\";s:4:\"icon\";s:16:\"fa fa-calendar-o\";s:6:\"parent\";s:2:\"85\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:67;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"88\";s:5:\"label\";s:14:\"give_appraisal\";s:4:\"link\";s:44:\"admin/performance/give_performance_appraisal\";s:4:\"icon\";s:10:\"fa fa-plus\";s:6:\"parent\";s:2:\"85\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:68;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"89\";s:5:\"label\";s:7:\"payroll\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:9:\"fa fa-usd\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"18\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:69;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"90\";s:5:\"label\";s:21:\"manage_salary_details\";s:4:\"link\";s:35:\"admin/payroll/manage_salary_details\";s:4:\"icon\";s:9:\"fa fa-usd\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:70;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"91\";s:5:\"label\";s:20:\"employee_salary_list\";s:4:\"link\";s:34:\"admin/payroll/employee_salary_list\";s:4:\"icon\";s:17:\"fa fa-user-secret\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:71;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"92\";s:5:\"label\";s:12:\"make_payment\";s:4:\"link\";s:26:\"admin/payroll/make_payment\";s:4:\"icon\";s:11:\"fa fa-tasks\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:72;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"93\";s:5:\"label\";s:16:\"generate_payslip\";s:4:\"link\";s:30:\"admin/payroll/generate_payslip\";s:4:\"icon\";s:13:\"fa fa-list-ul\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:73;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"94\";s:5:\"label\";s:15:\"salary_template\";s:4:\"link\";s:29:\"admin/payroll/salary_template\";s:4:\"icon\";s:11:\"fa fa-money\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:74;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"95\";s:5:\"label\";s:11:\"hourly_rate\";s:4:\"link\";s:25:\"admin/payroll/hourly_rate\";s:4:\"icon\";s:13:\"fa fa-clock-o\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:75;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"96\";s:5:\"label\";s:15:\"payroll_summary\";s:4:\"link\";s:29:\"admin/payroll/payroll_summary\";s:4:\"icon\";s:18:\"fa fa-camera-retro\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:76;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"97\";s:5:\"label\";s:14:\"provident_fund\";s:4:\"link\";s:28:\"admin/payroll/provident_fund\";s:4:\"icon\";s:15:\"fa fa-briefcase\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2017-06-10 14:04:23\";s:6:\"status\";s:1:\"1\";}i:77;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"98\";s:5:\"label\";s:14:\"advance_salary\";s:4:\"link\";s:28:\"admin/payroll/advance_salary\";s:4:\"icon\";s:19:\"fa fa-cc-mastercard\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2017-06-10 14:04:23\";s:6:\"status\";s:1:\"1\";}i:78;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"99\";s:5:\"label\";s:14:\"employee_award\";s:4:\"link\";s:11:\"admin/award\";s:4:\"icon\";s:12:\"fa fa-trophy\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2017-06-10 14:05:47\";s:6:\"status\";s:1:\"1\";}i:79;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"100\";s:5:\"label\";s:13:\"announcements\";s:4:\"link\";s:19:\"admin/announcements\";s:4:\"icon\";s:19:\"fa fa-bullhorn icon\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"22\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:80;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"101\";s:5:\"label\";s:8:\"training\";s:4:\"link\";s:14:\"admin/training\";s:4:\"icon\";s:14:\"fa fa-suitcase\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"21\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:81;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"102\";s:5:\"label\";s:12:\"job_circular\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:11:\"fa fa-globe\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"17\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:82;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"103\";s:5:\"label\";s:11:\"jobs_posted\";s:4:\"link\";s:30:\"admin/job_circular/jobs_posted\";s:4:\"icon\";s:12:\"fa fa-ticket\";s:6:\"parent\";s:3:\"102\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:83;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"104\";s:5:\"label\";s:17:\"jobs_applications\";s:4:\"link\";s:36:\"admin/job_circular/jobs_applications\";s:4:\"icon\";s:13:\"fa fa-compass\";s:6:\"parent\";s:3:\"102\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:84;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"105\";s:5:\"label\";s:10:\"attendance\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:15:\"fa fa-file-text\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"16\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:85;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"106\";s:5:\"label\";s:18:\"timechange_request\";s:4:\"link\";s:35:\"admin/attendance/timechange_request\";s:4:\"icon\";s:16:\"fa fa-calendar-o\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:86;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"107\";s:5:\"label\";s:17:\"attendance_report\";s:4:\"link\";s:34:\"admin/attendance/attendance_report\";s:4:\"icon\";s:15:\"fa fa-file-text\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:87;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"108\";s:5:\"label\";s:12:\"time_history\";s:4:\"link\";s:29:\"admin/attendance/time_history\";s:4:\"icon\";s:13:\"fa fa-clock-o\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:88;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"109\";s:5:\"label\";s:9:\"pull-down\";s:4:\"link\";s:0:\"\";s:4:\"icon\";s:0:\"\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-31 12:43:20\";s:6:\"status\";s:1:\"0\";}i:89;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"110\";s:5:\"label\";s:11:\"filemanager\";s:4:\"link\";s:17:\"admin/filemanager\";s:4:\"icon\";s:10:\"fa fa-file\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:90;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"111\";s:5:\"label\";s:15:\"company_details\";s:4:\"link\";s:14:\"admin/settings\";s:4:\"icon\";s:23:\"fa fa-fw fa-info-circle\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-25 17:08:46\";s:6:\"status\";s:1:\"2\";}i:91;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"112\";s:5:\"label\";s:15:\"system_settings\";s:4:\"link\";s:21:\"admin/settings/system\";s:4:\"icon\";s:19:\"fa fa-fw fa-desktop\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-04-25 17:08:46\";s:6:\"status\";s:1:\"2\";}i:92;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"113\";s:5:\"label\";s:14:\"email_settings\";s:4:\"link\";s:20:\"admin/settings/email\";s:4:\"icon\";s:20:\"fa fa-fw fa-envelope\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-25 17:08:46\";s:6:\"status\";s:1:\"2\";}i:93;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"114\";s:5:\"label\";s:15:\"email_templates\";s:4:\"link\";s:24:\"admin/settings/templates\";s:4:\"icon\";s:25:\"fa fa-fw fa-pencil-square\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2021-07-30 06:18:08\";s:6:\"status\";s:1:\"2\";}i:94;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"115\";s:5:\"label\";s:17:\"email_integration\";s:4:\"link\";s:32:\"admin/settings/email_integration\";s:4:\"icon\";s:22:\"fa fa-fw fa-envelope-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2021-07-30 06:18:08\";s:6:\"status\";s:1:\"2\";}i:95;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"116\";s:5:\"label\";s:16:\"payment_settings\";s:4:\"link\";s:23:\"admin/settings/payments\";s:4:\"icon\";s:18:\"fa fa-fw fa-dollar\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:96;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"117\";s:5:\"label\";s:16:\"invoice_settings\";s:4:\"link\";s:22:\"admin/settings/invoice\";s:4:\"icon\";s:17:\"fa fa-fw fa-money\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:97;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"118\";s:5:\"label\";s:17:\"estimate_settings\";s:4:\"link\";s:23:\"admin/settings/estimate\";s:4:\"icon\";s:18:\"fa fa-fw fa-file-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:98;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"119\";s:5:\"label\";s:22:\"tickets_leads_settings\";s:4:\"link\";s:22:\"admin/settings/tickets\";s:4:\"icon\";s:18:\"fa fa-fw fa-ticket\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"14\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:99;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"120\";s:5:\"label\";s:14:\"theme_settings\";s:4:\"link\";s:20:\"admin/settings/theme\";s:4:\"icon\";s:16:\"fa fa-fw fa-code\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"20\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:100;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"121\";s:5:\"label\";s:12:\"working_days\";s:4:\"link\";s:27:\"admin/settings/working_days\";s:4:\"icon\";s:20:\"fa fa-fw fa-calendar\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"22\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:101;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"122\";s:5:\"label\";s:14:\"leave_category\";s:4:\"link\";s:29:\"admin/settings/leave_category\";s:4:\"icon\";s:21:\"fa fa-fw fa-pagelines\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"23\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:102;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"123\";s:5:\"label\";s:15:\"income_category\";s:4:\"link\";s:30:\"admin/settings/income_category\";s:4:\"icon\";s:23:\"fa fa-fw fa-certificate\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"24\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:103;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"124\";s:5:\"label\";s:16:\"expense_category\";s:4:\"link\";s:31:\"admin/settings/expense_category\";s:4:\"icon\";s:17:\"fa fa-fw fa-tasks\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"25\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:104;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"125\";s:5:\"label\";s:14:\"customer_group\";s:4:\"link\";s:29:\"admin/settings/customer_group\";s:4:\"icon\";s:17:\"fa fa-fw fa-users\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"26\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:105;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"127\";s:5:\"label\";s:11:\"lead_status\";s:4:\"link\";s:26:\"admin/settings/lead_status\";s:4:\"icon\";s:19:\"fa fa-fw fa-list-ul\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"16\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:106;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"128\";s:5:\"label\";s:11:\"lead_source\";s:4:\"link\";s:26:\"admin/settings/lead_source\";s:4:\"icon\";s:22:\"fa fa-fw fa-arrow-down\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"17\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:107;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"129\";s:5:\"label\";s:26:\"opportunities_state_reason\";s:4:\"link\";s:41:\"admin/settings/opportunities_state_reason\";s:4:\"icon\";s:24:\"fa fa-fw fa-dot-circle-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"19\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:108;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"130\";s:5:\"label\";s:12:\"custom_field\";s:4:\"link\";s:27:\"admin/settings/custom_field\";s:4:\"icon\";s:18:\"fa fa-fw fa-star-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"28\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:109;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"131\";s:5:\"label\";s:14:\"payment_method\";s:4:\"link\";s:29:\"admin/settings/payment_method\";s:4:\"icon\";s:17:\"fa fa-fw fa-money\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"29\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:110;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"132\";s:5:\"label\";s:7:\"cronjob\";s:4:\"link\";s:22:\"admin/settings/cronjob\";s:4:\"icon\";s:18:\"fa fa-fw fa-contao\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"31\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:111;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"133\";s:5:\"label\";s:15:\"menu_allocation\";s:4:\"link\";s:30:\"admin/settings/menu_allocation\";s:4:\"icon\";s:22:\"fa fa-fw fa fa-compass\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"32\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:112;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"134\";s:5:\"label\";s:12:\"notification\";s:4:\"link\";s:27:\"admin/settings/notification\";s:4:\"icon\";s:18:\"fa fa-fw fa-bell-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"33\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:113;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"135\";s:5:\"label\";s:18:\"email_notification\";s:4:\"link\";s:33:\"admin/settings/email_notification\";s:4:\"icon\";s:18:\"fa fa-fw fa-bell-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"34\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:114;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"136\";s:5:\"label\";s:15:\"database_backup\";s:4:\"link\";s:30:\"admin/settings/database_backup\";s:4:\"icon\";s:20:\"fa fa-fw fa-database\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"35\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:115;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"137\";s:5:\"label\";s:12:\"translations\";s:4:\"link\";s:27:\"admin/settings/translations\";s:4:\"icon\";s:20:\"fa fa-fw fa-language\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"36\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:116;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"138\";s:5:\"label\";s:13:\"system_update\";s:4:\"link\";s:28:\"admin/settings/system_update\";s:4:\"icon\";s:27:\"fa fa-fw fa-pencil-square-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"37\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:117;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"139\";s:5:\"label\";s:12:\"private_chat\";s:4:\"link\";s:18:\"chat/conversations\";s:4:\"icon\";s:14:\"fa fa-envelope\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"28\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:118;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"140\";s:5:\"label\";s:9:\"proposals\";s:4:\"link\";s:15:\"admin/proposals\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-01-07 07:05:16\";s:6:\"status\";s:1:\"1\";}i:119;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"141\";s:5:\"label\";s:13:\"knowledgebase\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:21:\"fa fa-question-circle\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"11\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:120;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"142\";s:5:\"label\";s:10:\"categories\";s:4:\"link\";s:30:\"admin/knowledgebase/categories\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"141\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:121;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"143\";s:5:\"label\";s:8:\"articles\";s:4:\"link\";s:28:\"admin/knowledgebase/articles\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"141\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:122;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"144\";s:5:\"label\";s:13:\"knowledgebase\";s:4:\"link\";s:19:\"admin/knowledgebase\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"141\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:123;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"145\";s:5:\"label\";s:18:\"dashboard_settings\";s:4:\"link\";s:24:\"admin/settings/dashboard\";s:4:\"icon\";s:21:\"fa fa-fw fa-dashboard\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"21\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:124;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"146\";s:5:\"label\";s:20:\"transactions_reports\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:16:\"fa fa-building-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-05-13 12:29:51\";s:6:\"status\";s:1:\"1\";}i:125;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"147\";s:5:\"label\";s:5:\"sales\";s:4:\"link\";s:25:\"admin/report/sales_report\";s:4:\"icon\";s:19:\"fa fa-shopping-cart\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-01-07 01:12:23\";s:6:\"status\";s:1:\"1\";}i:126;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"148\";s:5:\"label\";s:15:\"mark_attendance\";s:4:\"link\";s:21:\"admin/mark_attendance\";s:4:\"icon\";s:15:\"fa fa-file-text\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-03-07 06:45:25\";s:6:\"status\";s:1:\"1\";}i:127;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"149\";s:5:\"label\";s:10:\"allowed_ip\";s:4:\"link\";s:25:\"admin/settings/allowed_ip\";s:4:\"icon\";s:12:\"fa fa-server\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"27\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:128;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"150\";s:5:\"label\";s:5:\"stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:11:\"icon-layers\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2019-05-01 18:10:52\";s:6:\"status\";s:1:\"1\";}i:129;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"151\";s:5:\"label\";s:8:\"supplier\";s:4:\"link\";s:14:\"admin/supplier\";s:4:\"icon\";s:14:\"icon-briefcase\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2019-05-01 18:10:52\";s:6:\"status\";s:1:\"1\";}i:130;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"152\";s:5:\"label\";s:8:\"purchase\";s:4:\"link\";s:14:\"admin/purchase\";s:4:\"icon\";s:12:\"icon-handbag\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2019-05-01 18:10:52\";s:6:\"status\";s:1:\"1\";}i:131;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"153\";s:5:\"label\";s:12:\"return_stock\";s:4:\"link\";s:18:\"admin/return_stock\";s:4:\"icon\";s:14:\"icon-share-alt\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2019-05-05 16:19:30\";s:6:\"status\";s:1:\"1\";}i:132;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"154\";s:5:\"label\";s:16:\"purchase_payment\";s:4:\"link\";s:27:\"admin/purchase/all_payments\";s:4:\"icon\";s:16:\"icon-credit-card\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2019-05-05 13:53:11\";s:6:\"status\";s:1:\"1\";}i:133;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"155\";s:5:\"label\";s:17:\"purchase_settings\";s:4:\"link\";s:23:\"admin/settings/purchase\";s:4:\"icon\";s:18:\"fa-fw icon-handbag\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"12\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:134;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"156\";s:5:\"label\";s:11:\"credit_note\";s:4:\"link\";s:17:\"admin/credit_note\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-06-10 02:32:05\";s:6:\"status\";s:1:\"1\";}i:135;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"157\";s:5:\"label\";s:20:\"credit_note_settings\";s:4:\"link\";s:26:\"admin/settings/credit_note\";s:4:\"icon\";s:17:\"fa fa-fw fa-money\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"9\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:136;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"158\";s:5:\"label\";s:18:\"proposals_settings\";s:4:\"link\";s:24:\"admin/settings/proposals\";s:4:\"icon\";s:16:\"fa fa-fw fa-leaf\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"11\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:137;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"159\";s:5:\"label\";s:17:\"projects_settings\";s:4:\"link\";s:23:\"admin/settings/projects\";s:4:\"icon\";s:25:\"fa fa-fw fa-folder-open-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"13\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:138;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"160\";s:5:\"label\";s:4:\"tags\";s:4:\"link\";s:19:\"admin/settings/tags\";s:4:\"icon\";s:16:\"fa fa-fw fa-tags\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"30\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:139;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"161\";s:5:\"label\";s:9:\"lead_form\";s:4:\"link\";s:25:\"admin/leads/all_lead_form\";s:4:\"icon\";s:18:\"fa fa-fw fa-rocket\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"18\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:140;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"162\";s:5:\"label\";s:21:\"transactions_settings\";s:4:\"link\";s:27:\"admin/settings/transactions\";s:4:\"icon\";s:22:\"fa fa-fw fa-building-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"15\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:141;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"163\";s:5:\"label\";s:12:\"sms_settings\";s:4:\"link\";s:27:\"admin/settings/sms_settings\";s:4:\"icon\";s:20:\"fa fa-fw fa-envelope\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2021-07-30 06:18:08\";s:6:\"status\";s:1:\"2\";}i:142;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"164\";s:5:\"label\";s:9:\"pos_sales\";s:4:\"link\";s:23:\"admin/invoice/pos_sales\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2021-10-16 00:53:10\";s:6:\"status\";s:1:\"1\";}i:143;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"186\";s:5:\"label\";s:9:\"warehouse\";s:4:\"link\";s:22:\"admin/warehouse/manage\";s:4:\"icon\";s:16:\"fa fa-building-o\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2021-10-18 09:24:24\";s:6:\"status\";s:1:\"1\";}i:144;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"187\";s:5:\"label\";s:12:\"transferItem\";s:4:\"link\";s:24:\"admin/items/transferItem\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2021-10-14 11:56:08\";s:6:\"status\";s:1:\"1\";}i:145;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"203\";s:5:\"label\";s:13:\"award_setting\";s:4:\"link\";s:20:\"admin/settings/award\";s:4:\"icon\";s:10:\"fa fa-star\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"30\";s:4:\"time\";s:19:\"2022-01-19 05:51:40\";s:6:\"status\";s:1:\"2\";}i:146;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"204\";s:5:\"label\";s:18:\"award_rule_setting\";s:4:\"link\";s:34:\"admin/settings/award_rule_settingh\";s:4:\"icon\";s:10:\"fa fa-star\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"31\";s:4:\"time\";s:19:\"2022-01-19 09:53:50\";s:6:\"status\";s:1:\"2\";}i:147;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"205\";s:5:\"label\";s:22:\"award_program_settings\";s:4:\"link\";s:37:\"admin/settings/award_program_settings\";s:4:\"icon\";s:9:\"fa fa-cog\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"32\";s:4:\"time\";s:19:\"2022-01-20 09:17:30\";s:6:\"status\";s:1:\"2\";}i:148;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"206\";s:5:\"label\";s:19:\"client_award_points\";s:4:\"link\";s:27:\"admin/invoice/client_awards\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2022-01-21 01:39:41\";s:6:\"status\";s:1:\"1\";}i:149;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"207\";s:5:\"label\";s:20:\"best_selling_product\";s:4:\"link\";s:18:\"admin/best_selling\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:2:\"11\";s:4:\"time\";s:19:\"2022-01-21 06:43:52\";s:6:\"status\";s:1:\"1\";}i:150;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"209\";s:5:\"label\";s:7:\"warning\";s:4:\"link\";s:13:\"admin/warning\";s:4:\"icon\";s:13:\"fa fa-warning\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2022-08-07 12:47:01\";s:6:\"status\";s:1:\"1\";}i:151;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"210\";s:5:\"label\";s:9:\"promotion\";s:4:\"link\";s:15:\"admin/promotion\";s:4:\"icon\";s:21:\"fa fa-arrow-circle-up\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2022-08-07 12:49:28\";s:6:\"status\";s:1:\"1\";}i:152;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"211\";s:5:\"label\";s:11:\"termination\";s:4:\"link\";s:17:\"admin/termination\";s:4:\"icon\";s:12:\"fa fa-eraser\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2022-08-07 12:50:45\";s:6:\"status\";s:1:\"1\";}i:153;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"212\";s:5:\"label\";s:11:\"resignation\";s:4:\"link\";s:17:\"admin/resignation\";s:4:\"icon\";s:14:\"fa fa-scissors\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2022-08-07 12:54:31\";s:6:\"status\";s:1:\"1\";}}');
INSERT INTO `tbl_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('36e2cc46488f23ed4770785f0ffeea42087600a9', '136.158.120.226', 1688536708, '__ci_last_regenerate|i:1688536708;menu_active_id|a:2:{i:0;s:3:\"109\";i:1;s:1:\"0\";}');
INSERT INTO `tbl_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3d168e8ddd8398cfd9c8b5adef06f6e98a1e8da2', '136.158.120.226', 1688544708, '__ci_last_regenerate|i:1688544708;menu_active_id|a:3:{i:0;s:3:\"138\";i:1;s:2:\"25\";i:2;s:1:\"0\";}user_name|s:5:\"nimda\";email|s:26:\"erick@blickcreative.com.au\";name|s:13:\"Erick Villeta\";photo|s:26:\"uploads/default_avatar.jpg\";user_id|s:1:\"5\";last_login|N;online_time|i:1688531159;loggedin|b:1;user_type|s:1:\"1\";user_flag|s:1:\"1\";direction|s:3:\"ltr\";warehouse_id|N;designations_id|s:1:\"0\";url|s:33:\"admin/dashboard/pinned_menu_items\";user_roll|a:154:{i:0;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"1\";s:5:\"label\";s:9:\"dashboard\";s:4:\"link\";s:15:\"admin/dashboard\";s:4:\"icon\";s:15:\"fa fa-dashboard\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-04-23 01:39:36\";s:6:\"status\";s:1:\"1\";}i:1;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"2\";s:5:\"label\";s:8:\"calendar\";s:4:\"link\";s:14:\"admin/calendar\";s:4:\"icon\";s:14:\"fa fa-calendar\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-23 19:57:23\";s:6:\"status\";s:1:\"1\";}i:2;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"4\";s:5:\"label\";s:6:\"client\";s:4:\"link\";s:26:\"admin/client/manage_client\";s:4:\"icon\";s:11:\"fa fa-users\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"13\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:3;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"5\";s:5:\"label\";s:7:\"mailbox\";s:4:\"link\";s:13:\"admin/mailbox\";s:4:\"icon\";s:16:\"fa fa-envelope-o\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:4;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"6\";s:5:\"label\";s:7:\"tickets\";s:4:\"link\";s:13:\"admin/tickets\";s:4:\"icon\";s:12:\"fa fa-ticket\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2018-06-08 13:39:39\";s:6:\"status\";s:1:\"1\";}i:5;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"12\";s:5:\"label\";s:5:\"sales\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:19:\"fa fa-shopping-cart\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"9\";s:4:\"time\";s:19:\"2017-06-10 14:02:58\";s:6:\"status\";s:1:\"1\";}i:6;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"13\";s:5:\"label\";s:7:\"invoice\";s:4:\"link\";s:28:\"admin/invoice/manage_invoice\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-04-23 19:57:23\";s:6:\"status\";s:1:\"1\";}i:7;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"14\";s:5:\"label\";s:9:\"estimates\";s:4:\"link\";s:15:\"admin/estimates\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-06-10 14:02:05\";s:6:\"status\";s:1:\"1\";}i:8;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"15\";s:5:\"label\";s:17:\"payments_received\";s:4:\"link\";s:26:\"admin/invoice/all_payments\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-23 19:57:24\";s:6:\"status\";s:1:\"1\";}i:9;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"16\";s:5:\"label\";s:9:\"tax_rates\";s:4:\"link\";s:23:\"admin/invoice/tax_rates\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-01-07 07:05:16\";s:6:\"status\";s:1:\"1\";}i:10;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"21\";s:5:\"label\";s:10:\"quotations\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:11:\"fa fa-paste\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:11;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"22\";s:5:\"label\";s:15:\"quotations_list\";s:4:\"link\";s:16:\"admin/quotations\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"21\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-05-18 16:49:03\";s:6:\"status\";s:1:\"1\";}i:12;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"23\";s:5:\"label\";s:15:\"quotations_form\";s:4:\"link\";s:32:\"admin/quotations/quotations_form\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"21\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:13;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"24\";s:5:\"label\";s:4:\"user\";s:4:\"link\";s:20:\"admin/user/user_list\";s:4:\"icon\";s:11:\"fa fa-users\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"25\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:14;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"25\";s:5:\"label\";s:8:\"settings\";s:4:\"link\";s:14:\"admin/settings\";s:4:\"icon\";s:10:\"fa fa-cogs\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"26\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:15;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"26\";s:5:\"label\";s:15:\"database_backup\";s:4:\"link\";s:30:\"admin/settings/database_backup\";s:4:\"icon\";s:14:\"fa fa-database\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"27\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:16;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"29\";s:5:\"label\";s:17:\"transactions_menu\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:16:\"fa fa-building-o\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"12\";s:4:\"time\";s:19:\"2018-05-13 12:27:58\";s:6:\"status\";s:1:\"1\";}i:17;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"30\";s:5:\"label\";s:7:\"deposit\";s:4:\"link\";s:26:\"admin/transactions/deposit\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-05-13 12:28:33\";s:6:\"status\";s:1:\"1\";}i:18;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"31\";s:5:\"label\";s:7:\"expense\";s:4:\"link\";s:26:\"admin/transactions/expense\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-05-13 12:28:37\";s:6:\"status\";s:1:\"1\";}i:19;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"32\";s:5:\"label\";s:8:\"transfer\";s:4:\"link\";s:27:\"admin/transactions/transfer\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-05-13 12:28:40\";s:6:\"status\";s:1:\"1\";}i:20;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"33\";s:5:\"label\";s:19:\"transactions_report\";s:4:\"link\";s:38:\"admin/transactions/transactions_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2018-05-13 12:28:44\";s:6:\"status\";s:1:\"1\";}i:21;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"34\";s:5:\"label\";s:13:\"balance_sheet\";s:4:\"link\";s:32:\"admin/transactions/balance_sheet\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-05-13 12:28:47\";s:6:\"status\";s:1:\"1\";}i:22;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"36\";s:5:\"label\";s:9:\"bank_cash\";s:4:\"link\";s:28:\"admin/account/manage_account\";s:4:\"icon\";s:11:\"fa fa-money\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2018-05-13 12:28:51\";s:6:\"status\";s:1:\"1\";}i:23;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"39\";s:5:\"label\";s:5:\"items\";s:4:\"link\";s:22:\"admin/items/items_list\";s:4:\"icon\";s:10:\"fa fa-cube\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2019-05-04 18:49:50\";s:6:\"status\";s:1:\"1\";}i:24;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"42\";s:5:\"label\";s:6:\"report\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:15:\"fa fa-bar-chart\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"24\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:25;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"43\";s:5:\"label\";s:17:\"account_statement\";s:4:\"link\";s:30:\"admin/report/account_statement\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:26;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"44\";s:5:\"label\";s:13:\"income_report\";s:4:\"link\";s:26:\"admin/report/income_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:27;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"45\";s:5:\"label\";s:14:\"expense_report\";s:4:\"link\";s:27:\"admin/report/expense_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:28;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"46\";s:5:\"label\";s:14:\"income_expense\";s:4:\"link\";s:27:\"admin/report/income_expense\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:29;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"47\";s:5:\"label\";s:16:\"date_wise_report\";s:4:\"link\";s:29:\"admin/report/date_wise_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:30;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"48\";s:5:\"label\";s:10:\"all_income\";s:4:\"link\";s:23:\"admin/report/all_income\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:31;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"49\";s:5:\"label\";s:11:\"all_expense\";s:4:\"link\";s:24:\"admin/report/all_expense\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:32;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"50\";s:5:\"label\";s:15:\"all_transaction\";s:4:\"link\";s:28:\"admin/report/all_transaction\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:33;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"51\";s:5:\"label\";s:17:\"recurring_invoice\";s:4:\"link\";s:31:\"admin/invoice/recurring_invoice\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-06-10 14:02:05\";s:6:\"status\";s:1:\"1\";}i:34;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"52\";s:5:\"label\";s:15:\"transfer_report\";s:4:\"link\";s:34:\"admin/transactions/transfer_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-05-13 12:28:59\";s:6:\"status\";s:1:\"1\";}i:35;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"53\";s:5:\"label\";s:15:\"report_by_month\";s:4:\"link\";s:28:\"admin/report/report_by_month\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:36;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"54\";s:5:\"label\";s:5:\"tasks\";s:4:\"link\";s:20:\"admin/tasks/all_task\";s:4:\"icon\";s:11:\"fa fa-tasks\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:37;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"55\";s:5:\"label\";s:5:\"leads\";s:4:\"link\";s:11:\"admin/leads\";s:4:\"icon\";s:12:\"fa fa-rocket\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:38;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"56\";s:5:\"label\";s:13:\"opportunities\";s:4:\"link\";s:19:\"admin/opportunities\";s:4:\"icon\";s:12:\"fa fa-filter\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:39;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"57\";s:5:\"label\";s:8:\"projects\";s:4:\"link\";s:14:\"admin/projects\";s:4:\"icon\";s:19:\"fa fa-folder-open-o\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:40;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"58\";s:5:\"label\";s:4:\"bugs\";s:4:\"link\";s:10:\"admin/bugs\";s:4:\"icon\";s:9:\"fa fa-bug\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:41;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"59\";s:5:\"label\";s:7:\"project\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:19:\"fa fa-folder-open-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:42;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"60\";s:5:\"label\";s:12:\"tasks_report\";s:4:\"link\";s:25:\"admin/report/tasks_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:43;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"61\";s:5:\"label\";s:11:\"bugs_report\";s:4:\"link\";s:24:\"admin/report/bugs_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:44;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"62\";s:5:\"label\";s:14:\"tickets_report\";s:4:\"link\";s:27:\"admin/report/tickets_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:45;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"63\";s:5:\"label\";s:13:\"client_report\";s:4:\"link\";s:26:\"admin/report/client_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2018-01-07 07:09:40\";s:6:\"status\";s:1:\"1\";}i:46;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"66\";s:5:\"label\";s:16:\"tasks_assignment\";s:4:\"link\";s:29:\"admin/report/tasks_assignment\";s:4:\"icon\";s:18:\"fa fa-dot-circle-o\";s:6:\"parent\";s:2:\"59\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:47;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"67\";s:5:\"label\";s:15:\"bugs_assignment\";s:4:\"link\";s:28:\"admin/report/bugs_assignment\";s:4:\"icon\";s:18:\"fa fa-dot-circle-o\";s:6:\"parent\";s:2:\"59\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:48;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"68\";s:5:\"label\";s:14:\"project_report\";s:4:\"link\";s:27:\"admin/report/project_report\";s:4:\"icon\";s:18:\"fa fa-dot-circle-o\";s:6:\"parent\";s:2:\"59\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:49;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"69\";s:5:\"label\";s:13:\"goal_tracking\";s:4:\"link\";s:19:\"admin/goal_tracking\";s:4:\"icon\";s:12:\"fa fa-shield\";s:6:\"parent\";s:2:\"73\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-06-10 14:05:47\";s:6:\"status\";s:1:\"1\";}i:50;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"70\";s:5:\"label\";s:11:\"departments\";s:4:\"link\";s:17:\"admin/departments\";s:4:\"icon\";s:17:\"fa fa-user-secret\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"14\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:51;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"71\";s:5:\"label\";s:7:\"holiday\";s:4:\"link\";s:13:\"admin/holiday\";s:4:\"icon\";s:21:\"fa fa-calendar-plus-o\";s:6:\"parent\";s:2:\"73\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-06-10 14:05:47\";s:6:\"status\";s:1:\"1\";}i:52;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"72\";s:5:\"label\";s:16:\"leave_management\";s:4:\"link\";s:22:\"admin/leave_management\";s:4:\"icon\";s:11:\"fa fa-plane\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"20\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:53;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"73\";s:5:\"label\";s:9:\"utilities\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:10:\"fa fa-gift\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"23\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:54;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"74\";s:5:\"label\";s:8:\"overtime\";s:4:\"link\";s:24:\"admin/utilities/overtime\";s:4:\"icon\";s:13:\"fa fa-clock-o\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"9\";s:4:\"time\";s:19:\"2017-06-10 14:04:23\";s:6:\"status\";s:1:\"1\";}i:55;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"75\";s:5:\"label\";s:12:\"office_stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:13:\"fa fa-codepen\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"15\";s:4:\"time\";s:19:\"2019-05-01 16:22:56\";s:6:\"status\";s:1:\"1\";}i:56;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"76\";s:5:\"label\";s:14:\"stock_category\";s:4:\"link\";s:26:\"admin/stock/stock_category\";s:4:\"icon\";s:13:\"fa fa-sliders\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:57;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"77\";s:5:\"label\";s:12:\"manage_stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:13:\"fa fa-archive\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-04-26 16:11:10\";s:6:\"status\";s:1:\"1\";}i:58;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"78\";s:5:\"label\";s:12:\"assign_stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:16:\"fa fa-align-left\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-26 16:11:10\";s:6:\"status\";s:1:\"1\";}i:59;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"79\";s:5:\"label\";s:12:\"stock_report\";s:4:\"link\";s:18:\"admin/stock/report\";s:4:\"icon\";s:16:\"fa fa-line-chart\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2017-04-25 18:48:25\";s:6:\"status\";s:1:\"1\";}i:60;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"81\";s:5:\"label\";s:10:\"stock_list\";s:4:\"link\";s:22:\"admin/stock/stock_list\";s:4:\"icon\";s:20:\"fa fa-stack-exchange\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-26 16:11:10\";s:6:\"status\";s:1:\"1\";}i:61;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"82\";s:5:\"label\";s:12:\"assign_stock\";s:4:\"link\";s:24:\"admin/stock/assign_stock\";s:4:\"icon\";s:16:\"fa fa-align-left\";s:6:\"parent\";s:2:\"78\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:62;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"83\";s:5:\"label\";s:19:\"assign_stock_report\";s:4:\"link\";s:31:\"admin/stock/assign_stock_report\";s:4:\"icon\";s:15:\"fa fa-bar-chart\";s:6:\"parent\";s:2:\"78\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:63;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"84\";s:5:\"label\";s:13:\"stock_history\";s:4:\"link\";s:25:\"admin/stock/stock_history\";s:4:\"icon\";s:17:\"fa fa-file-text-o\";s:6:\"parent\";s:2:\"77\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:64;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"85\";s:5:\"label\";s:11:\"performance\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:14:\"fa fa-dribbble\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"19\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:65;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"86\";s:5:\"label\";s:21:\"performance_indicator\";s:4:\"link\";s:39:\"admin/performance/performance_indicator\";s:4:\"icon\";s:12:\"fa fa-random\";s:6:\"parent\";s:2:\"85\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:66;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"87\";s:5:\"label\";s:18:\"performance_report\";s:4:\"link\";s:36:\"admin/performance/performance_report\";s:4:\"icon\";s:16:\"fa fa-calendar-o\";s:6:\"parent\";s:2:\"85\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:67;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"88\";s:5:\"label\";s:14:\"give_appraisal\";s:4:\"link\";s:44:\"admin/performance/give_performance_appraisal\";s:4:\"icon\";s:10:\"fa fa-plus\";s:6:\"parent\";s:2:\"85\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:68;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"89\";s:5:\"label\";s:7:\"payroll\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:9:\"fa fa-usd\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"18\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:69;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"90\";s:5:\"label\";s:21:\"manage_salary_details\";s:4:\"link\";s:35:\"admin/payroll/manage_salary_details\";s:4:\"icon\";s:9:\"fa fa-usd\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:70;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"91\";s:5:\"label\";s:20:\"employee_salary_list\";s:4:\"link\";s:34:\"admin/payroll/employee_salary_list\";s:4:\"icon\";s:17:\"fa fa-user-secret\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:71;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"92\";s:5:\"label\";s:12:\"make_payment\";s:4:\"link\";s:26:\"admin/payroll/make_payment\";s:4:\"icon\";s:11:\"fa fa-tasks\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:72;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"93\";s:5:\"label\";s:16:\"generate_payslip\";s:4:\"link\";s:30:\"admin/payroll/generate_payslip\";s:4:\"icon\";s:13:\"fa fa-list-ul\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:73;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"94\";s:5:\"label\";s:15:\"salary_template\";s:4:\"link\";s:29:\"admin/payroll/salary_template\";s:4:\"icon\";s:11:\"fa fa-money\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:74;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"95\";s:5:\"label\";s:11:\"hourly_rate\";s:4:\"link\";s:25:\"admin/payroll/hourly_rate\";s:4:\"icon\";s:13:\"fa fa-clock-o\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:75;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"96\";s:5:\"label\";s:15:\"payroll_summary\";s:4:\"link\";s:29:\"admin/payroll/payroll_summary\";s:4:\"icon\";s:18:\"fa fa-camera-retro\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:76;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"97\";s:5:\"label\";s:14:\"provident_fund\";s:4:\"link\";s:28:\"admin/payroll/provident_fund\";s:4:\"icon\";s:15:\"fa fa-briefcase\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2017-06-10 14:04:23\";s:6:\"status\";s:1:\"1\";}i:77;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"98\";s:5:\"label\";s:14:\"advance_salary\";s:4:\"link\";s:28:\"admin/payroll/advance_salary\";s:4:\"icon\";s:19:\"fa fa-cc-mastercard\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2017-06-10 14:04:23\";s:6:\"status\";s:1:\"1\";}i:78;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"99\";s:5:\"label\";s:14:\"employee_award\";s:4:\"link\";s:11:\"admin/award\";s:4:\"icon\";s:12:\"fa fa-trophy\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2017-06-10 14:05:47\";s:6:\"status\";s:1:\"1\";}i:79;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"100\";s:5:\"label\";s:13:\"announcements\";s:4:\"link\";s:19:\"admin/announcements\";s:4:\"icon\";s:19:\"fa fa-bullhorn icon\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"22\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:80;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"101\";s:5:\"label\";s:8:\"training\";s:4:\"link\";s:14:\"admin/training\";s:4:\"icon\";s:14:\"fa fa-suitcase\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"21\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:81;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"102\";s:5:\"label\";s:12:\"job_circular\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:11:\"fa fa-globe\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"17\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:82;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"103\";s:5:\"label\";s:11:\"jobs_posted\";s:4:\"link\";s:30:\"admin/job_circular/jobs_posted\";s:4:\"icon\";s:12:\"fa fa-ticket\";s:6:\"parent\";s:3:\"102\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:83;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"104\";s:5:\"label\";s:17:\"jobs_applications\";s:4:\"link\";s:36:\"admin/job_circular/jobs_applications\";s:4:\"icon\";s:13:\"fa fa-compass\";s:6:\"parent\";s:3:\"102\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:84;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"105\";s:5:\"label\";s:10:\"attendance\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:15:\"fa fa-file-text\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"16\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:85;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"106\";s:5:\"label\";s:18:\"timechange_request\";s:4:\"link\";s:35:\"admin/attendance/timechange_request\";s:4:\"icon\";s:16:\"fa fa-calendar-o\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:86;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"107\";s:5:\"label\";s:17:\"attendance_report\";s:4:\"link\";s:34:\"admin/attendance/attendance_report\";s:4:\"icon\";s:15:\"fa fa-file-text\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:87;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"108\";s:5:\"label\";s:12:\"time_history\";s:4:\"link\";s:29:\"admin/attendance/time_history\";s:4:\"icon\";s:13:\"fa fa-clock-o\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:88;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"109\";s:5:\"label\";s:9:\"pull-down\";s:4:\"link\";s:0:\"\";s:4:\"icon\";s:0:\"\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-31 12:43:20\";s:6:\"status\";s:1:\"0\";}i:89;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"110\";s:5:\"label\";s:11:\"filemanager\";s:4:\"link\";s:17:\"admin/filemanager\";s:4:\"icon\";s:10:\"fa fa-file\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:90;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"111\";s:5:\"label\";s:15:\"company_details\";s:4:\"link\";s:14:\"admin/settings\";s:4:\"icon\";s:23:\"fa fa-fw fa-info-circle\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-25 17:08:46\";s:6:\"status\";s:1:\"2\";}i:91;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"112\";s:5:\"label\";s:15:\"system_settings\";s:4:\"link\";s:21:\"admin/settings/system\";s:4:\"icon\";s:19:\"fa fa-fw fa-desktop\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-04-25 17:08:46\";s:6:\"status\";s:1:\"2\";}i:92;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"113\";s:5:\"label\";s:14:\"email_settings\";s:4:\"link\";s:20:\"admin/settings/email\";s:4:\"icon\";s:20:\"fa fa-fw fa-envelope\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-25 17:08:46\";s:6:\"status\";s:1:\"2\";}i:93;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"114\";s:5:\"label\";s:15:\"email_templates\";s:4:\"link\";s:24:\"admin/settings/templates\";s:4:\"icon\";s:25:\"fa fa-fw fa-pencil-square\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2021-07-30 06:18:08\";s:6:\"status\";s:1:\"2\";}i:94;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"115\";s:5:\"label\";s:17:\"email_integration\";s:4:\"link\";s:32:\"admin/settings/email_integration\";s:4:\"icon\";s:22:\"fa fa-fw fa-envelope-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2021-07-30 06:18:08\";s:6:\"status\";s:1:\"2\";}i:95;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"116\";s:5:\"label\";s:16:\"payment_settings\";s:4:\"link\";s:23:\"admin/settings/payments\";s:4:\"icon\";s:18:\"fa fa-fw fa-dollar\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:96;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"117\";s:5:\"label\";s:16:\"invoice_settings\";s:4:\"link\";s:22:\"admin/settings/invoice\";s:4:\"icon\";s:17:\"fa fa-fw fa-money\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:97;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"118\";s:5:\"label\";s:17:\"estimate_settings\";s:4:\"link\";s:23:\"admin/settings/estimate\";s:4:\"icon\";s:18:\"fa fa-fw fa-file-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:98;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"119\";s:5:\"label\";s:22:\"tickets_leads_settings\";s:4:\"link\";s:22:\"admin/settings/tickets\";s:4:\"icon\";s:18:\"fa fa-fw fa-ticket\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"14\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:99;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"120\";s:5:\"label\";s:14:\"theme_settings\";s:4:\"link\";s:20:\"admin/settings/theme\";s:4:\"icon\";s:16:\"fa fa-fw fa-code\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"20\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:100;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"121\";s:5:\"label\";s:12:\"working_days\";s:4:\"link\";s:27:\"admin/settings/working_days\";s:4:\"icon\";s:20:\"fa fa-fw fa-calendar\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"22\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:101;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"122\";s:5:\"label\";s:14:\"leave_category\";s:4:\"link\";s:29:\"admin/settings/leave_category\";s:4:\"icon\";s:21:\"fa fa-fw fa-pagelines\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"23\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:102;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"123\";s:5:\"label\";s:15:\"income_category\";s:4:\"link\";s:30:\"admin/settings/income_category\";s:4:\"icon\";s:23:\"fa fa-fw fa-certificate\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"24\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:103;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"124\";s:5:\"label\";s:16:\"expense_category\";s:4:\"link\";s:31:\"admin/settings/expense_category\";s:4:\"icon\";s:17:\"fa fa-fw fa-tasks\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"25\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:104;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"125\";s:5:\"label\";s:14:\"customer_group\";s:4:\"link\";s:29:\"admin/settings/customer_group\";s:4:\"icon\";s:17:\"fa fa-fw fa-users\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"26\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:105;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"127\";s:5:\"label\";s:11:\"lead_status\";s:4:\"link\";s:26:\"admin/settings/lead_status\";s:4:\"icon\";s:19:\"fa fa-fw fa-list-ul\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"16\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:106;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"128\";s:5:\"label\";s:11:\"lead_source\";s:4:\"link\";s:26:\"admin/settings/lead_source\";s:4:\"icon\";s:22:\"fa fa-fw fa-arrow-down\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"17\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:107;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"129\";s:5:\"label\";s:26:\"opportunities_state_reason\";s:4:\"link\";s:41:\"admin/settings/opportunities_state_reason\";s:4:\"icon\";s:24:\"fa fa-fw fa-dot-circle-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"19\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:108;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"130\";s:5:\"label\";s:12:\"custom_field\";s:4:\"link\";s:27:\"admin/settings/custom_field\";s:4:\"icon\";s:18:\"fa fa-fw fa-star-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"28\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:109;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"131\";s:5:\"label\";s:14:\"payment_method\";s:4:\"link\";s:29:\"admin/settings/payment_method\";s:4:\"icon\";s:17:\"fa fa-fw fa-money\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"29\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:110;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"132\";s:5:\"label\";s:7:\"cronjob\";s:4:\"link\";s:22:\"admin/settings/cronjob\";s:4:\"icon\";s:18:\"fa fa-fw fa-contao\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"31\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:111;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"133\";s:5:\"label\";s:15:\"menu_allocation\";s:4:\"link\";s:30:\"admin/settings/menu_allocation\";s:4:\"icon\";s:22:\"fa fa-fw fa fa-compass\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"32\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:112;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"134\";s:5:\"label\";s:12:\"notification\";s:4:\"link\";s:27:\"admin/settings/notification\";s:4:\"icon\";s:18:\"fa fa-fw fa-bell-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"33\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:113;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"135\";s:5:\"label\";s:18:\"email_notification\";s:4:\"link\";s:33:\"admin/settings/email_notification\";s:4:\"icon\";s:18:\"fa fa-fw fa-bell-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"34\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:114;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"136\";s:5:\"label\";s:15:\"database_backup\";s:4:\"link\";s:30:\"admin/settings/database_backup\";s:4:\"icon\";s:20:\"fa fa-fw fa-database\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"35\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:115;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"137\";s:5:\"label\";s:12:\"translations\";s:4:\"link\";s:27:\"admin/settings/translations\";s:4:\"icon\";s:20:\"fa fa-fw fa-language\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"36\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:116;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"138\";s:5:\"label\";s:13:\"system_update\";s:4:\"link\";s:28:\"admin/settings/system_update\";s:4:\"icon\";s:27:\"fa fa-fw fa-pencil-square-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"37\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:117;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"139\";s:5:\"label\";s:12:\"private_chat\";s:4:\"link\";s:18:\"chat/conversations\";s:4:\"icon\";s:14:\"fa fa-envelope\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"28\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:118;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"140\";s:5:\"label\";s:9:\"proposals\";s:4:\"link\";s:15:\"admin/proposals\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-01-07 07:05:16\";s:6:\"status\";s:1:\"1\";}i:119;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"141\";s:5:\"label\";s:13:\"knowledgebase\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:21:\"fa fa-question-circle\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"11\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:120;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"142\";s:5:\"label\";s:10:\"categories\";s:4:\"link\";s:30:\"admin/knowledgebase/categories\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"141\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:121;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"143\";s:5:\"label\";s:8:\"articles\";s:4:\"link\";s:28:\"admin/knowledgebase/articles\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"141\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:122;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"144\";s:5:\"label\";s:13:\"knowledgebase\";s:4:\"link\";s:19:\"admin/knowledgebase\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"141\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:123;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"145\";s:5:\"label\";s:18:\"dashboard_settings\";s:4:\"link\";s:24:\"admin/settings/dashboard\";s:4:\"icon\";s:21:\"fa fa-fw fa-dashboard\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"21\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:124;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"146\";s:5:\"label\";s:20:\"transactions_reports\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:16:\"fa fa-building-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-05-13 12:29:51\";s:6:\"status\";s:1:\"1\";}i:125;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"147\";s:5:\"label\";s:5:\"sales\";s:4:\"link\";s:25:\"admin/report/sales_report\";s:4:\"icon\";s:19:\"fa fa-shopping-cart\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-01-07 01:12:23\";s:6:\"status\";s:1:\"1\";}i:126;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"148\";s:5:\"label\";s:15:\"mark_attendance\";s:4:\"link\";s:21:\"admin/mark_attendance\";s:4:\"icon\";s:15:\"fa fa-file-text\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-03-07 06:45:25\";s:6:\"status\";s:1:\"1\";}i:127;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"149\";s:5:\"label\";s:10:\"allowed_ip\";s:4:\"link\";s:25:\"admin/settings/allowed_ip\";s:4:\"icon\";s:12:\"fa fa-server\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"27\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:128;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"150\";s:5:\"label\";s:5:\"stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:11:\"icon-layers\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2019-05-01 18:10:52\";s:6:\"status\";s:1:\"1\";}i:129;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"151\";s:5:\"label\";s:8:\"supplier\";s:4:\"link\";s:14:\"admin/supplier\";s:4:\"icon\";s:14:\"icon-briefcase\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2019-05-01 18:10:52\";s:6:\"status\";s:1:\"1\";}i:130;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"152\";s:5:\"label\";s:8:\"purchase\";s:4:\"link\";s:14:\"admin/purchase\";s:4:\"icon\";s:12:\"icon-handbag\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2019-05-01 18:10:52\";s:6:\"status\";s:1:\"1\";}i:131;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"153\";s:5:\"label\";s:12:\"return_stock\";s:4:\"link\";s:18:\"admin/return_stock\";s:4:\"icon\";s:14:\"icon-share-alt\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2019-05-05 16:19:30\";s:6:\"status\";s:1:\"1\";}i:132;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"154\";s:5:\"label\";s:16:\"purchase_payment\";s:4:\"link\";s:27:\"admin/purchase/all_payments\";s:4:\"icon\";s:16:\"icon-credit-card\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2019-05-05 13:53:11\";s:6:\"status\";s:1:\"1\";}i:133;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"155\";s:5:\"label\";s:17:\"purchase_settings\";s:4:\"link\";s:23:\"admin/settings/purchase\";s:4:\"icon\";s:18:\"fa-fw icon-handbag\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"12\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:134;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"156\";s:5:\"label\";s:11:\"credit_note\";s:4:\"link\";s:17:\"admin/credit_note\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-06-10 02:32:05\";s:6:\"status\";s:1:\"1\";}i:135;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"157\";s:5:\"label\";s:20:\"credit_note_settings\";s:4:\"link\";s:26:\"admin/settings/credit_note\";s:4:\"icon\";s:17:\"fa fa-fw fa-money\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"9\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:136;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"158\";s:5:\"label\";s:18:\"proposals_settings\";s:4:\"link\";s:24:\"admin/settings/proposals\";s:4:\"icon\";s:16:\"fa fa-fw fa-leaf\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"11\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:137;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"159\";s:5:\"label\";s:17:\"projects_settings\";s:4:\"link\";s:23:\"admin/settings/projects\";s:4:\"icon\";s:25:\"fa fa-fw fa-folder-open-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"13\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:138;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"160\";s:5:\"label\";s:4:\"tags\";s:4:\"link\";s:19:\"admin/settings/tags\";s:4:\"icon\";s:16:\"fa fa-fw fa-tags\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"30\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:139;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"161\";s:5:\"label\";s:9:\"lead_form\";s:4:\"link\";s:25:\"admin/leads/all_lead_form\";s:4:\"icon\";s:18:\"fa fa-fw fa-rocket\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"18\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:140;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"162\";s:5:\"label\";s:21:\"transactions_settings\";s:4:\"link\";s:27:\"admin/settings/transactions\";s:4:\"icon\";s:22:\"fa fa-fw fa-building-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"15\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:141;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"163\";s:5:\"label\";s:12:\"sms_settings\";s:4:\"link\";s:27:\"admin/settings/sms_settings\";s:4:\"icon\";s:20:\"fa fa-fw fa-envelope\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2021-07-30 06:18:08\";s:6:\"status\";s:1:\"2\";}i:142;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"164\";s:5:\"label\";s:9:\"pos_sales\";s:4:\"link\";s:23:\"admin/invoice/pos_sales\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2021-10-16 00:53:10\";s:6:\"status\";s:1:\"1\";}i:143;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"186\";s:5:\"label\";s:9:\"warehouse\";s:4:\"link\";s:22:\"admin/warehouse/manage\";s:4:\"icon\";s:16:\"fa fa-building-o\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2021-10-18 09:24:24\";s:6:\"status\";s:1:\"1\";}i:144;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"187\";s:5:\"label\";s:12:\"transferItem\";s:4:\"link\";s:24:\"admin/items/transferItem\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2021-10-14 11:56:08\";s:6:\"status\";s:1:\"1\";}i:145;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"203\";s:5:\"label\";s:13:\"award_setting\";s:4:\"link\";s:20:\"admin/settings/award\";s:4:\"icon\";s:10:\"fa fa-star\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"30\";s:4:\"time\";s:19:\"2022-01-19 05:51:40\";s:6:\"status\";s:1:\"2\";}i:146;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"204\";s:5:\"label\";s:18:\"award_rule_setting\";s:4:\"link\";s:34:\"admin/settings/award_rule_settingh\";s:4:\"icon\";s:10:\"fa fa-star\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"31\";s:4:\"time\";s:19:\"2022-01-19 09:53:50\";s:6:\"status\";s:1:\"2\";}i:147;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"205\";s:5:\"label\";s:22:\"award_program_settings\";s:4:\"link\";s:37:\"admin/settings/award_program_settings\";s:4:\"icon\";s:9:\"fa fa-cog\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"32\";s:4:\"time\";s:19:\"2022-01-20 09:17:30\";s:6:\"status\";s:1:\"2\";}i:148;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"206\";s:5:\"label\";s:19:\"client_award_points\";s:4:\"link\";s:27:\"admin/invoice/client_awards\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2022-01-21 01:39:41\";s:6:\"status\";s:1:\"1\";}i:149;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"207\";s:5:\"label\";s:20:\"best_selling_product\";s:4:\"link\";s:18:\"admin/best_selling\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:2:\"11\";s:4:\"time\";s:19:\"2022-01-21 06:43:52\";s:6:\"status\";s:1:\"1\";}i:150;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"209\";s:5:\"label\";s:7:\"warning\";s:4:\"link\";s:13:\"admin/warning\";s:4:\"icon\";s:13:\"fa fa-warning\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2022-08-07 12:47:01\";s:6:\"status\";s:1:\"1\";}i:151;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"210\";s:5:\"label\";s:9:\"promotion\";s:4:\"link\";s:15:\"admin/promotion\";s:4:\"icon\";s:21:\"fa fa-arrow-circle-up\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2022-08-07 12:49:28\";s:6:\"status\";s:1:\"1\";}i:152;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"211\";s:5:\"label\";s:11:\"termination\";s:4:\"link\";s:17:\"admin/termination\";s:4:\"icon\";s:12:\"fa fa-eraser\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2022-08-07 12:50:45\";s:6:\"status\";s:1:\"1\";}i:153;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"212\";s:5:\"label\";s:11:\"resignation\";s:4:\"link\";s:17:\"admin/resignation\";s:4:\"icon\";s:14:\"fa fa-scissors\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2022-08-07 12:54:31\";s:6:\"status\";s:1:\"1\";}}');
INSERT INTO `tbl_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('45c1afb9a0b916d8c505a8f727d709cebb420ecb', '51.255.62.1', 1689123389, '__ci_last_regenerate|i:1689123389;menu_active_id|a:2:{i:0;s:3:\"109\";i:1;s:1:\"0\";}');
INSERT INTO `tbl_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('47ea48cff213a79cd893f45e372ce7932d1fc63b', '167.248.133.185', 1688348085, '__ci_last_regenerate|i:1688348085;menu_active_id|a:2:{i:0;s:3:\"109\";i:1;s:1:\"0\";}');
INSERT INTO `tbl_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('496f9d93b0235cee37a11ad72779275b4c37393c', '136.158.121.2', 1689135525, '__ci_last_regenerate|i:1689135525;menu_active_id|a:3:{i:0;s:3:\"142\";i:1;s:3:\"141\";i:2;s:1:\"0\";}user_name|s:5:\"nimda\";email|s:26:\"erick@blickcreative.com.au\";name|s:13:\"Erick Villeta\";photo|s:26:\"uploads/default_avatar.jpg\";user_id|s:1:\"5\";last_login|s:19:\"2023-07-10 11:54:34\";online_time|i:1689133478;loggedin|b:1;user_type|s:1:\"1\";user_flag|s:1:\"1\";direction|s:3:\"ltr\";warehouse_id|N;designations_id|s:1:\"0\";url|s:34:\"admin/knowledgebase/new_categories\";user_roll|a:154:{i:0;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"1\";s:5:\"label\";s:9:\"dashboard\";s:4:\"link\";s:15:\"admin/dashboard\";s:4:\"icon\";s:15:\"fa fa-dashboard\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-04-23 01:39:36\";s:6:\"status\";s:1:\"1\";}i:1;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"2\";s:5:\"label\";s:8:\"calendar\";s:4:\"link\";s:14:\"admin/calendar\";s:4:\"icon\";s:14:\"fa fa-calendar\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-23 19:57:23\";s:6:\"status\";s:1:\"1\";}i:2;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"4\";s:5:\"label\";s:6:\"client\";s:4:\"link\";s:26:\"admin/client/manage_client\";s:4:\"icon\";s:11:\"fa fa-users\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"13\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:3;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"5\";s:5:\"label\";s:7:\"mailbox\";s:4:\"link\";s:13:\"admin/mailbox\";s:4:\"icon\";s:16:\"fa fa-envelope-o\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:4;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"6\";s:5:\"label\";s:7:\"tickets\";s:4:\"link\";s:13:\"admin/tickets\";s:4:\"icon\";s:12:\"fa fa-ticket\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2018-06-08 13:39:39\";s:6:\"status\";s:1:\"1\";}i:5;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"12\";s:5:\"label\";s:5:\"sales\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:19:\"fa fa-shopping-cart\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"9\";s:4:\"time\";s:19:\"2017-06-10 14:02:58\";s:6:\"status\";s:1:\"1\";}i:6;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"13\";s:5:\"label\";s:7:\"invoice\";s:4:\"link\";s:28:\"admin/invoice/manage_invoice\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-04-23 19:57:23\";s:6:\"status\";s:1:\"1\";}i:7;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"14\";s:5:\"label\";s:9:\"estimates\";s:4:\"link\";s:15:\"admin/estimates\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-06-10 14:02:05\";s:6:\"status\";s:1:\"1\";}i:8;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"15\";s:5:\"label\";s:17:\"payments_received\";s:4:\"link\";s:26:\"admin/invoice/all_payments\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-23 19:57:24\";s:6:\"status\";s:1:\"1\";}i:9;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"16\";s:5:\"label\";s:9:\"tax_rates\";s:4:\"link\";s:23:\"admin/invoice/tax_rates\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-01-07 07:05:16\";s:6:\"status\";s:1:\"1\";}i:10;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"21\";s:5:\"label\";s:10:\"quotations\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:11:\"fa fa-paste\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:11;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"22\";s:5:\"label\";s:15:\"quotations_list\";s:4:\"link\";s:16:\"admin/quotations\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"21\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-05-18 16:49:03\";s:6:\"status\";s:1:\"1\";}i:12;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"23\";s:5:\"label\";s:15:\"quotations_form\";s:4:\"link\";s:32:\"admin/quotations/quotations_form\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"21\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:13;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"24\";s:5:\"label\";s:4:\"user\";s:4:\"link\";s:20:\"admin/user/user_list\";s:4:\"icon\";s:11:\"fa fa-users\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"25\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:14;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"25\";s:5:\"label\";s:8:\"settings\";s:4:\"link\";s:14:\"admin/settings\";s:4:\"icon\";s:10:\"fa fa-cogs\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"26\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:15;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"26\";s:5:\"label\";s:15:\"database_backup\";s:4:\"link\";s:30:\"admin/settings/database_backup\";s:4:\"icon\";s:14:\"fa fa-database\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"27\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:16;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"29\";s:5:\"label\";s:17:\"transactions_menu\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:16:\"fa fa-building-o\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"12\";s:4:\"time\";s:19:\"2018-05-13 12:27:58\";s:6:\"status\";s:1:\"1\";}i:17;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"30\";s:5:\"label\";s:7:\"deposit\";s:4:\"link\";s:26:\"admin/transactions/deposit\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-05-13 12:28:33\";s:6:\"status\";s:1:\"1\";}i:18;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"31\";s:5:\"label\";s:7:\"expense\";s:4:\"link\";s:26:\"admin/transactions/expense\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-05-13 12:28:37\";s:6:\"status\";s:1:\"1\";}i:19;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"32\";s:5:\"label\";s:8:\"transfer\";s:4:\"link\";s:27:\"admin/transactions/transfer\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-05-13 12:28:40\";s:6:\"status\";s:1:\"1\";}i:20;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"33\";s:5:\"label\";s:19:\"transactions_report\";s:4:\"link\";s:38:\"admin/transactions/transactions_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2018-05-13 12:28:44\";s:6:\"status\";s:1:\"1\";}i:21;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"34\";s:5:\"label\";s:13:\"balance_sheet\";s:4:\"link\";s:32:\"admin/transactions/balance_sheet\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-05-13 12:28:47\";s:6:\"status\";s:1:\"1\";}i:22;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"36\";s:5:\"label\";s:9:\"bank_cash\";s:4:\"link\";s:28:\"admin/account/manage_account\";s:4:\"icon\";s:11:\"fa fa-money\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2018-05-13 12:28:51\";s:6:\"status\";s:1:\"1\";}i:23;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"39\";s:5:\"label\";s:5:\"items\";s:4:\"link\";s:22:\"admin/items/items_list\";s:4:\"icon\";s:10:\"fa fa-cube\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2019-05-04 18:49:50\";s:6:\"status\";s:1:\"1\";}i:24;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"42\";s:5:\"label\";s:6:\"report\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:15:\"fa fa-bar-chart\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"24\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:25;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"43\";s:5:\"label\";s:17:\"account_statement\";s:4:\"link\";s:30:\"admin/report/account_statement\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:26;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"44\";s:5:\"label\";s:13:\"income_report\";s:4:\"link\";s:26:\"admin/report/income_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:27;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"45\";s:5:\"label\";s:14:\"expense_report\";s:4:\"link\";s:27:\"admin/report/expense_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:28;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"46\";s:5:\"label\";s:14:\"income_expense\";s:4:\"link\";s:27:\"admin/report/income_expense\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:29;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"47\";s:5:\"label\";s:16:\"date_wise_report\";s:4:\"link\";s:29:\"admin/report/date_wise_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:30;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"48\";s:5:\"label\";s:10:\"all_income\";s:4:\"link\";s:23:\"admin/report/all_income\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:31;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"49\";s:5:\"label\";s:11:\"all_expense\";s:4:\"link\";s:24:\"admin/report/all_expense\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:32;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"50\";s:5:\"label\";s:15:\"all_transaction\";s:4:\"link\";s:28:\"admin/report/all_transaction\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:33;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"51\";s:5:\"label\";s:17:\"recurring_invoice\";s:4:\"link\";s:31:\"admin/invoice/recurring_invoice\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-06-10 14:02:05\";s:6:\"status\";s:1:\"1\";}i:34;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"52\";s:5:\"label\";s:15:\"transfer_report\";s:4:\"link\";s:34:\"admin/transactions/transfer_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-05-13 12:28:59\";s:6:\"status\";s:1:\"1\";}i:35;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"53\";s:5:\"label\";s:15:\"report_by_month\";s:4:\"link\";s:28:\"admin/report/report_by_month\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:36;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"54\";s:5:\"label\";s:5:\"tasks\";s:4:\"link\";s:20:\"admin/tasks/all_task\";s:4:\"icon\";s:11:\"fa fa-tasks\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:37;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"55\";s:5:\"label\";s:5:\"leads\";s:4:\"link\";s:11:\"admin/leads\";s:4:\"icon\";s:12:\"fa fa-rocket\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:38;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"56\";s:5:\"label\";s:13:\"opportunities\";s:4:\"link\";s:19:\"admin/opportunities\";s:4:\"icon\";s:12:\"fa fa-filter\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:39;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"57\";s:5:\"label\";s:8:\"projects\";s:4:\"link\";s:14:\"admin/projects\";s:4:\"icon\";s:19:\"fa fa-folder-open-o\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:40;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"58\";s:5:\"label\";s:4:\"bugs\";s:4:\"link\";s:10:\"admin/bugs\";s:4:\"icon\";s:9:\"fa fa-bug\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:41;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"59\";s:5:\"label\";s:7:\"project\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:19:\"fa fa-folder-open-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:42;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"60\";s:5:\"label\";s:12:\"tasks_report\";s:4:\"link\";s:25:\"admin/report/tasks_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:43;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"61\";s:5:\"label\";s:11:\"bugs_report\";s:4:\"link\";s:24:\"admin/report/bugs_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:44;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"62\";s:5:\"label\";s:14:\"tickets_report\";s:4:\"link\";s:27:\"admin/report/tickets_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:45;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"63\";s:5:\"label\";s:13:\"client_report\";s:4:\"link\";s:26:\"admin/report/client_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2018-01-07 07:09:40\";s:6:\"status\";s:1:\"1\";}i:46;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"66\";s:5:\"label\";s:16:\"tasks_assignment\";s:4:\"link\";s:29:\"admin/report/tasks_assignment\";s:4:\"icon\";s:18:\"fa fa-dot-circle-o\";s:6:\"parent\";s:2:\"59\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:47;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"67\";s:5:\"label\";s:15:\"bugs_assignment\";s:4:\"link\";s:28:\"admin/report/bugs_assignment\";s:4:\"icon\";s:18:\"fa fa-dot-circle-o\";s:6:\"parent\";s:2:\"59\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:48;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"68\";s:5:\"label\";s:14:\"project_report\";s:4:\"link\";s:27:\"admin/report/project_report\";s:4:\"icon\";s:18:\"fa fa-dot-circle-o\";s:6:\"parent\";s:2:\"59\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:49;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"69\";s:5:\"label\";s:13:\"goal_tracking\";s:4:\"link\";s:19:\"admin/goal_tracking\";s:4:\"icon\";s:12:\"fa fa-shield\";s:6:\"parent\";s:2:\"73\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-06-10 14:05:47\";s:6:\"status\";s:1:\"1\";}i:50;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"70\";s:5:\"label\";s:11:\"departments\";s:4:\"link\";s:17:\"admin/departments\";s:4:\"icon\";s:17:\"fa fa-user-secret\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"14\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:51;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"71\";s:5:\"label\";s:7:\"holiday\";s:4:\"link\";s:13:\"admin/holiday\";s:4:\"icon\";s:21:\"fa fa-calendar-plus-o\";s:6:\"parent\";s:2:\"73\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-06-10 14:05:47\";s:6:\"status\";s:1:\"1\";}i:52;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"72\";s:5:\"label\";s:16:\"leave_management\";s:4:\"link\";s:22:\"admin/leave_management\";s:4:\"icon\";s:11:\"fa fa-plane\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"20\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:53;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"73\";s:5:\"label\";s:9:\"utilities\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:10:\"fa fa-gift\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"23\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:54;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"74\";s:5:\"label\";s:8:\"overtime\";s:4:\"link\";s:24:\"admin/utilities/overtime\";s:4:\"icon\";s:13:\"fa fa-clock-o\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"9\";s:4:\"time\";s:19:\"2017-06-10 14:04:23\";s:6:\"status\";s:1:\"1\";}i:55;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"75\";s:5:\"label\";s:12:\"office_stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:13:\"fa fa-codepen\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"15\";s:4:\"time\";s:19:\"2019-05-01 16:22:56\";s:6:\"status\";s:1:\"1\";}i:56;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"76\";s:5:\"label\";s:14:\"stock_category\";s:4:\"link\";s:26:\"admin/stock/stock_category\";s:4:\"icon\";s:13:\"fa fa-sliders\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:57;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"77\";s:5:\"label\";s:12:\"manage_stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:13:\"fa fa-archive\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-04-26 16:11:10\";s:6:\"status\";s:1:\"1\";}i:58;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"78\";s:5:\"label\";s:12:\"assign_stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:16:\"fa fa-align-left\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-26 16:11:10\";s:6:\"status\";s:1:\"1\";}i:59;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"79\";s:5:\"label\";s:12:\"stock_report\";s:4:\"link\";s:18:\"admin/stock/report\";s:4:\"icon\";s:16:\"fa fa-line-chart\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2017-04-25 18:48:25\";s:6:\"status\";s:1:\"1\";}i:60;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"81\";s:5:\"label\";s:10:\"stock_list\";s:4:\"link\";s:22:\"admin/stock/stock_list\";s:4:\"icon\";s:20:\"fa fa-stack-exchange\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-26 16:11:10\";s:6:\"status\";s:1:\"1\";}i:61;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"82\";s:5:\"label\";s:12:\"assign_stock\";s:4:\"link\";s:24:\"admin/stock/assign_stock\";s:4:\"icon\";s:16:\"fa fa-align-left\";s:6:\"parent\";s:2:\"78\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:62;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"83\";s:5:\"label\";s:19:\"assign_stock_report\";s:4:\"link\";s:31:\"admin/stock/assign_stock_report\";s:4:\"icon\";s:15:\"fa fa-bar-chart\";s:6:\"parent\";s:2:\"78\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:63;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"84\";s:5:\"label\";s:13:\"stock_history\";s:4:\"link\";s:25:\"admin/stock/stock_history\";s:4:\"icon\";s:17:\"fa fa-file-text-o\";s:6:\"parent\";s:2:\"77\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:64;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"85\";s:5:\"label\";s:11:\"performance\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:14:\"fa fa-dribbble\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"19\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:65;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"86\";s:5:\"label\";s:21:\"performance_indicator\";s:4:\"link\";s:39:\"admin/performance/performance_indicator\";s:4:\"icon\";s:12:\"fa fa-random\";s:6:\"parent\";s:2:\"85\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:66;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"87\";s:5:\"label\";s:18:\"performance_report\";s:4:\"link\";s:36:\"admin/performance/performance_report\";s:4:\"icon\";s:16:\"fa fa-calendar-o\";s:6:\"parent\";s:2:\"85\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:67;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"88\";s:5:\"label\";s:14:\"give_appraisal\";s:4:\"link\";s:44:\"admin/performance/give_performance_appraisal\";s:4:\"icon\";s:10:\"fa fa-plus\";s:6:\"parent\";s:2:\"85\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:68;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"89\";s:5:\"label\";s:7:\"payroll\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:9:\"fa fa-usd\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"18\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:69;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"90\";s:5:\"label\";s:21:\"manage_salary_details\";s:4:\"link\";s:35:\"admin/payroll/manage_salary_details\";s:4:\"icon\";s:9:\"fa fa-usd\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:70;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"91\";s:5:\"label\";s:20:\"employee_salary_list\";s:4:\"link\";s:34:\"admin/payroll/employee_salary_list\";s:4:\"icon\";s:17:\"fa fa-user-secret\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:71;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"92\";s:5:\"label\";s:12:\"make_payment\";s:4:\"link\";s:26:\"admin/payroll/make_payment\";s:4:\"icon\";s:11:\"fa fa-tasks\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:72;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"93\";s:5:\"label\";s:16:\"generate_payslip\";s:4:\"link\";s:30:\"admin/payroll/generate_payslip\";s:4:\"icon\";s:13:\"fa fa-list-ul\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:73;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"94\";s:5:\"label\";s:15:\"salary_template\";s:4:\"link\";s:29:\"admin/payroll/salary_template\";s:4:\"icon\";s:11:\"fa fa-money\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:74;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"95\";s:5:\"label\";s:11:\"hourly_rate\";s:4:\"link\";s:25:\"admin/payroll/hourly_rate\";s:4:\"icon\";s:13:\"fa fa-clock-o\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:75;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"96\";s:5:\"label\";s:15:\"payroll_summary\";s:4:\"link\";s:29:\"admin/payroll/payroll_summary\";s:4:\"icon\";s:18:\"fa fa-camera-retro\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:76;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"97\";s:5:\"label\";s:14:\"provident_fund\";s:4:\"link\";s:28:\"admin/payroll/provident_fund\";s:4:\"icon\";s:15:\"fa fa-briefcase\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2017-06-10 14:04:23\";s:6:\"status\";s:1:\"1\";}i:77;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"98\";s:5:\"label\";s:14:\"advance_salary\";s:4:\"link\";s:28:\"admin/payroll/advance_salary\";s:4:\"icon\";s:19:\"fa fa-cc-mastercard\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2017-06-10 14:04:23\";s:6:\"status\";s:1:\"1\";}i:78;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"99\";s:5:\"label\";s:14:\"employee_award\";s:4:\"link\";s:11:\"admin/award\";s:4:\"icon\";s:12:\"fa fa-trophy\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2017-06-10 14:05:47\";s:6:\"status\";s:1:\"1\";}i:79;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"100\";s:5:\"label\";s:13:\"announcements\";s:4:\"link\";s:19:\"admin/announcements\";s:4:\"icon\";s:19:\"fa fa-bullhorn icon\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"22\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:80;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"101\";s:5:\"label\";s:8:\"training\";s:4:\"link\";s:14:\"admin/training\";s:4:\"icon\";s:14:\"fa fa-suitcase\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"21\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:81;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"102\";s:5:\"label\";s:12:\"job_circular\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:11:\"fa fa-globe\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"17\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:82;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"103\";s:5:\"label\";s:11:\"jobs_posted\";s:4:\"link\";s:30:\"admin/job_circular/jobs_posted\";s:4:\"icon\";s:12:\"fa fa-ticket\";s:6:\"parent\";s:3:\"102\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:83;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"104\";s:5:\"label\";s:17:\"jobs_applications\";s:4:\"link\";s:36:\"admin/job_circular/jobs_applications\";s:4:\"icon\";s:13:\"fa fa-compass\";s:6:\"parent\";s:3:\"102\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:84;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"105\";s:5:\"label\";s:10:\"attendance\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:15:\"fa fa-file-text\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"16\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:85;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"106\";s:5:\"label\";s:18:\"timechange_request\";s:4:\"link\";s:35:\"admin/attendance/timechange_request\";s:4:\"icon\";s:16:\"fa fa-calendar-o\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:86;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"107\";s:5:\"label\";s:17:\"attendance_report\";s:4:\"link\";s:34:\"admin/attendance/attendance_report\";s:4:\"icon\";s:15:\"fa fa-file-text\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:87;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"108\";s:5:\"label\";s:12:\"time_history\";s:4:\"link\";s:29:\"admin/attendance/time_history\";s:4:\"icon\";s:13:\"fa fa-clock-o\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:88;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"109\";s:5:\"label\";s:9:\"pull-down\";s:4:\"link\";s:0:\"\";s:4:\"icon\";s:0:\"\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-31 12:43:20\";s:6:\"status\";s:1:\"0\";}i:89;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"110\";s:5:\"label\";s:11:\"filemanager\";s:4:\"link\";s:17:\"admin/filemanager\";s:4:\"icon\";s:10:\"fa fa-file\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:90;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"111\";s:5:\"label\";s:15:\"company_details\";s:4:\"link\";s:14:\"admin/settings\";s:4:\"icon\";s:23:\"fa fa-fw fa-info-circle\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-25 17:08:46\";s:6:\"status\";s:1:\"2\";}i:91;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"112\";s:5:\"label\";s:15:\"system_settings\";s:4:\"link\";s:21:\"admin/settings/system\";s:4:\"icon\";s:19:\"fa fa-fw fa-desktop\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-04-25 17:08:46\";s:6:\"status\";s:1:\"2\";}i:92;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"113\";s:5:\"label\";s:14:\"email_settings\";s:4:\"link\";s:20:\"admin/settings/email\";s:4:\"icon\";s:20:\"fa fa-fw fa-envelope\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-25 17:08:46\";s:6:\"status\";s:1:\"2\";}i:93;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"114\";s:5:\"label\";s:15:\"email_templates\";s:4:\"link\";s:24:\"admin/settings/templates\";s:4:\"icon\";s:25:\"fa fa-fw fa-pencil-square\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2021-07-30 06:18:08\";s:6:\"status\";s:1:\"2\";}i:94;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"115\";s:5:\"label\";s:17:\"email_integration\";s:4:\"link\";s:32:\"admin/settings/email_integration\";s:4:\"icon\";s:22:\"fa fa-fw fa-envelope-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2021-07-30 06:18:08\";s:6:\"status\";s:1:\"2\";}i:95;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"116\";s:5:\"label\";s:16:\"payment_settings\";s:4:\"link\";s:23:\"admin/settings/payments\";s:4:\"icon\";s:18:\"fa fa-fw fa-dollar\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:96;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"117\";s:5:\"label\";s:16:\"invoice_settings\";s:4:\"link\";s:22:\"admin/settings/invoice\";s:4:\"icon\";s:17:\"fa fa-fw fa-money\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:97;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"118\";s:5:\"label\";s:17:\"estimate_settings\";s:4:\"link\";s:23:\"admin/settings/estimate\";s:4:\"icon\";s:18:\"fa fa-fw fa-file-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:98;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"119\";s:5:\"label\";s:22:\"tickets_leads_settings\";s:4:\"link\";s:22:\"admin/settings/tickets\";s:4:\"icon\";s:18:\"fa fa-fw fa-ticket\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"14\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:99;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"120\";s:5:\"label\";s:14:\"theme_settings\";s:4:\"link\";s:20:\"admin/settings/theme\";s:4:\"icon\";s:16:\"fa fa-fw fa-code\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"20\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:100;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"121\";s:5:\"label\";s:12:\"working_days\";s:4:\"link\";s:27:\"admin/settings/working_days\";s:4:\"icon\";s:20:\"fa fa-fw fa-calendar\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"22\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:101;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"122\";s:5:\"label\";s:14:\"leave_category\";s:4:\"link\";s:29:\"admin/settings/leave_category\";s:4:\"icon\";s:21:\"fa fa-fw fa-pagelines\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"23\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:102;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"123\";s:5:\"label\";s:15:\"income_category\";s:4:\"link\";s:30:\"admin/settings/income_category\";s:4:\"icon\";s:23:\"fa fa-fw fa-certificate\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"24\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:103;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"124\";s:5:\"label\";s:16:\"expense_category\";s:4:\"link\";s:31:\"admin/settings/expense_category\";s:4:\"icon\";s:17:\"fa fa-fw fa-tasks\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"25\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:104;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"125\";s:5:\"label\";s:14:\"customer_group\";s:4:\"link\";s:29:\"admin/settings/customer_group\";s:4:\"icon\";s:17:\"fa fa-fw fa-users\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"26\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:105;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"127\";s:5:\"label\";s:11:\"lead_status\";s:4:\"link\";s:26:\"admin/settings/lead_status\";s:4:\"icon\";s:19:\"fa fa-fw fa-list-ul\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"16\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:106;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"128\";s:5:\"label\";s:11:\"lead_source\";s:4:\"link\";s:26:\"admin/settings/lead_source\";s:4:\"icon\";s:22:\"fa fa-fw fa-arrow-down\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"17\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:107;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"129\";s:5:\"label\";s:26:\"opportunities_state_reason\";s:4:\"link\";s:41:\"admin/settings/opportunities_state_reason\";s:4:\"icon\";s:24:\"fa fa-fw fa-dot-circle-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"19\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:108;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"130\";s:5:\"label\";s:12:\"custom_field\";s:4:\"link\";s:27:\"admin/settings/custom_field\";s:4:\"icon\";s:18:\"fa fa-fw fa-star-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"28\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:109;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"131\";s:5:\"label\";s:14:\"payment_method\";s:4:\"link\";s:29:\"admin/settings/payment_method\";s:4:\"icon\";s:17:\"fa fa-fw fa-money\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"29\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:110;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"132\";s:5:\"label\";s:7:\"cronjob\";s:4:\"link\";s:22:\"admin/settings/cronjob\";s:4:\"icon\";s:18:\"fa fa-fw fa-contao\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"31\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:111;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"133\";s:5:\"label\";s:15:\"menu_allocation\";s:4:\"link\";s:30:\"admin/settings/menu_allocation\";s:4:\"icon\";s:22:\"fa fa-fw fa fa-compass\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"32\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:112;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"134\";s:5:\"label\";s:12:\"notification\";s:4:\"link\";s:27:\"admin/settings/notification\";s:4:\"icon\";s:18:\"fa fa-fw fa-bell-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"33\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:113;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"135\";s:5:\"label\";s:18:\"email_notification\";s:4:\"link\";s:33:\"admin/settings/email_notification\";s:4:\"icon\";s:18:\"fa fa-fw fa-bell-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"34\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:114;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"136\";s:5:\"label\";s:15:\"database_backup\";s:4:\"link\";s:30:\"admin/settings/database_backup\";s:4:\"icon\";s:20:\"fa fa-fw fa-database\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"35\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:115;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"137\";s:5:\"label\";s:12:\"translations\";s:4:\"link\";s:27:\"admin/settings/translations\";s:4:\"icon\";s:20:\"fa fa-fw fa-language\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"36\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:116;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"138\";s:5:\"label\";s:13:\"system_update\";s:4:\"link\";s:28:\"admin/settings/system_update\";s:4:\"icon\";s:27:\"fa fa-fw fa-pencil-square-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"37\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:117;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"139\";s:5:\"label\";s:12:\"private_chat\";s:4:\"link\";s:18:\"chat/conversations\";s:4:\"icon\";s:14:\"fa fa-envelope\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"28\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:118;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"140\";s:5:\"label\";s:9:\"proposals\";s:4:\"link\";s:15:\"admin/proposals\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-01-07 07:05:16\";s:6:\"status\";s:1:\"1\";}i:119;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"141\";s:5:\"label\";s:13:\"knowledgebase\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:21:\"fa fa-question-circle\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"11\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:120;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"142\";s:5:\"label\";s:10:\"categories\";s:4:\"link\";s:30:\"admin/knowledgebase/categories\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"141\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:121;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"143\";s:5:\"label\";s:8:\"articles\";s:4:\"link\";s:28:\"admin/knowledgebase/articles\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"141\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:122;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"144\";s:5:\"label\";s:13:\"knowledgebase\";s:4:\"link\";s:19:\"admin/knowledgebase\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"141\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:123;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"145\";s:5:\"label\";s:18:\"dashboard_settings\";s:4:\"link\";s:24:\"admin/settings/dashboard\";s:4:\"icon\";s:21:\"fa fa-fw fa-dashboard\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"21\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:124;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"146\";s:5:\"label\";s:20:\"transactions_reports\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:16:\"fa fa-building-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-05-13 12:29:51\";s:6:\"status\";s:1:\"1\";}i:125;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"147\";s:5:\"label\";s:5:\"sales\";s:4:\"link\";s:25:\"admin/report/sales_report\";s:4:\"icon\";s:19:\"fa fa-shopping-cart\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-01-07 01:12:23\";s:6:\"status\";s:1:\"1\";}i:126;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"148\";s:5:\"label\";s:15:\"mark_attendance\";s:4:\"link\";s:21:\"admin/mark_attendance\";s:4:\"icon\";s:15:\"fa fa-file-text\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-03-07 06:45:25\";s:6:\"status\";s:1:\"1\";}i:127;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"149\";s:5:\"label\";s:10:\"allowed_ip\";s:4:\"link\";s:25:\"admin/settings/allowed_ip\";s:4:\"icon\";s:12:\"fa fa-server\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"27\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:128;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"150\";s:5:\"label\";s:5:\"stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:11:\"icon-layers\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2019-05-01 18:10:52\";s:6:\"status\";s:1:\"1\";}i:129;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"151\";s:5:\"label\";s:8:\"supplier\";s:4:\"link\";s:14:\"admin/supplier\";s:4:\"icon\";s:14:\"icon-briefcase\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2019-05-01 18:10:52\";s:6:\"status\";s:1:\"1\";}i:130;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"152\";s:5:\"label\";s:8:\"purchase\";s:4:\"link\";s:14:\"admin/purchase\";s:4:\"icon\";s:12:\"icon-handbag\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2019-05-01 18:10:52\";s:6:\"status\";s:1:\"1\";}i:131;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"153\";s:5:\"label\";s:12:\"return_stock\";s:4:\"link\";s:18:\"admin/return_stock\";s:4:\"icon\";s:14:\"icon-share-alt\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2019-05-05 16:19:30\";s:6:\"status\";s:1:\"1\";}i:132;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"154\";s:5:\"label\";s:16:\"purchase_payment\";s:4:\"link\";s:27:\"admin/purchase/all_payments\";s:4:\"icon\";s:16:\"icon-credit-card\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2019-05-05 13:53:11\";s:6:\"status\";s:1:\"1\";}i:133;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"155\";s:5:\"label\";s:17:\"purchase_settings\";s:4:\"link\";s:23:\"admin/settings/purchase\";s:4:\"icon\";s:18:\"fa-fw icon-handbag\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"12\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:134;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"156\";s:5:\"label\";s:11:\"credit_note\";s:4:\"link\";s:17:\"admin/credit_note\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-06-10 02:32:05\";s:6:\"status\";s:1:\"1\";}i:135;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"157\";s:5:\"label\";s:20:\"credit_note_settings\";s:4:\"link\";s:26:\"admin/settings/credit_note\";s:4:\"icon\";s:17:\"fa fa-fw fa-money\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"9\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:136;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"158\";s:5:\"label\";s:18:\"proposals_settings\";s:4:\"link\";s:24:\"admin/settings/proposals\";s:4:\"icon\";s:16:\"fa fa-fw fa-leaf\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"11\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:137;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"159\";s:5:\"label\";s:17:\"projects_settings\";s:4:\"link\";s:23:\"admin/settings/projects\";s:4:\"icon\";s:25:\"fa fa-fw fa-folder-open-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"13\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:138;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"160\";s:5:\"label\";s:4:\"tags\";s:4:\"link\";s:19:\"admin/settings/tags\";s:4:\"icon\";s:16:\"fa fa-fw fa-tags\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"30\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:139;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"161\";s:5:\"label\";s:9:\"lead_form\";s:4:\"link\";s:25:\"admin/leads/all_lead_form\";s:4:\"icon\";s:18:\"fa fa-fw fa-rocket\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"18\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:140;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"162\";s:5:\"label\";s:21:\"transactions_settings\";s:4:\"link\";s:27:\"admin/settings/transactions\";s:4:\"icon\";s:22:\"fa fa-fw fa-building-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"15\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:141;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"163\";s:5:\"label\";s:12:\"sms_settings\";s:4:\"link\";s:27:\"admin/settings/sms_settings\";s:4:\"icon\";s:20:\"fa fa-fw fa-envelope\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2021-07-30 06:18:08\";s:6:\"status\";s:1:\"2\";}i:142;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"164\";s:5:\"label\";s:9:\"pos_sales\";s:4:\"link\";s:23:\"admin/invoice/pos_sales\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2021-10-16 00:53:10\";s:6:\"status\";s:1:\"1\";}i:143;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"186\";s:5:\"label\";s:9:\"warehouse\";s:4:\"link\";s:22:\"admin/warehouse/manage\";s:4:\"icon\";s:16:\"fa fa-building-o\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2021-10-18 09:24:24\";s:6:\"status\";s:1:\"1\";}i:144;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"187\";s:5:\"label\";s:12:\"transferItem\";s:4:\"link\";s:24:\"admin/items/transferItem\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2021-10-14 11:56:08\";s:6:\"status\";s:1:\"1\";}i:145;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"203\";s:5:\"label\";s:13:\"award_setting\";s:4:\"link\";s:20:\"admin/settings/award\";s:4:\"icon\";s:10:\"fa fa-star\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"30\";s:4:\"time\";s:19:\"2022-01-19 05:51:40\";s:6:\"status\";s:1:\"2\";}i:146;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"204\";s:5:\"label\";s:18:\"award_rule_setting\";s:4:\"link\";s:34:\"admin/settings/award_rule_settingh\";s:4:\"icon\";s:10:\"fa fa-star\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"31\";s:4:\"time\";s:19:\"2022-01-19 09:53:50\";s:6:\"status\";s:1:\"2\";}i:147;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"205\";s:5:\"label\";s:22:\"award_program_settings\";s:4:\"link\";s:37:\"admin/settings/award_program_settings\";s:4:\"icon\";s:9:\"fa fa-cog\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"32\";s:4:\"time\";s:19:\"2022-01-20 09:17:30\";s:6:\"status\";s:1:\"2\";}i:148;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"206\";s:5:\"label\";s:19:\"client_award_points\";s:4:\"link\";s:27:\"admin/invoice/client_awards\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2022-01-21 01:39:41\";s:6:\"status\";s:1:\"1\";}i:149;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"207\";s:5:\"label\";s:20:\"best_selling_product\";s:4:\"link\";s:18:\"admin/best_selling\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:2:\"11\";s:4:\"time\";s:19:\"2022-01-21 06:43:52\";s:6:\"status\";s:1:\"1\";}i:150;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"209\";s:5:\"label\";s:7:\"warning\";s:4:\"link\";s:13:\"admin/warning\";s:4:\"icon\";s:13:\"fa fa-warning\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2022-08-07 12:47:01\";s:6:\"status\";s:1:\"1\";}i:151;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"210\";s:5:\"label\";s:9:\"promotion\";s:4:\"link\";s:15:\"admin/promotion\";s:4:\"icon\";s:21:\"fa fa-arrow-circle-up\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2022-08-07 12:49:28\";s:6:\"status\";s:1:\"1\";}i:152;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"211\";s:5:\"label\";s:11:\"termination\";s:4:\"link\";s:17:\"admin/termination\";s:4:\"icon\";s:12:\"fa fa-eraser\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2022-08-07 12:50:45\";s:6:\"status\";s:1:\"1\";}i:153;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"212\";s:5:\"label\";s:11:\"resignation\";s:4:\"link\";s:17:\"admin/resignation\";s:4:\"icon\";s:14:\"fa fa-scissors\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2022-08-07 12:54:31\";s:6:\"status\";s:1:\"1\";}}');
INSERT INTO `tbl_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4e220abffb96c7638a2bd31fbef4d8b879bb166f', '136.158.120.226', 1688629954, '__ci_last_regenerate|i:1688629954;user_name|s:5:\"nimda\";email|s:26:\"erick@blickcreative.com.au\";name|s:13:\"Erick Villeta\";photo|s:26:\"uploads/default_avatar.jpg\";user_id|s:1:\"5\";last_login|s:19:\"2023-07-06 00:35:09\";online_time|i:1688567722;loggedin|b:1;user_type|s:1:\"1\";user_flag|s:1:\"1\";direction|s:3:\"ltr\";warehouse_id|N;designations_id|s:1:\"0\";url|s:15:\"admin/dashboard\";menu_active_id|a:2:{i:0;s:1:\"1\";i:1;s:1:\"0\";}user_roll|a:154:{i:0;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"1\";s:5:\"label\";s:9:\"dashboard\";s:4:\"link\";s:15:\"admin/dashboard\";s:4:\"icon\";s:15:\"fa fa-dashboard\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-04-23 01:39:36\";s:6:\"status\";s:1:\"1\";}i:1;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"2\";s:5:\"label\";s:8:\"calendar\";s:4:\"link\";s:14:\"admin/calendar\";s:4:\"icon\";s:14:\"fa fa-calendar\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-23 19:57:23\";s:6:\"status\";s:1:\"1\";}i:2;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"4\";s:5:\"label\";s:6:\"client\";s:4:\"link\";s:26:\"admin/client/manage_client\";s:4:\"icon\";s:11:\"fa fa-users\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"13\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:3;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"5\";s:5:\"label\";s:7:\"mailbox\";s:4:\"link\";s:13:\"admin/mailbox\";s:4:\"icon\";s:16:\"fa fa-envelope-o\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:4;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"6\";s:5:\"label\";s:7:\"tickets\";s:4:\"link\";s:13:\"admin/tickets\";s:4:\"icon\";s:12:\"fa fa-ticket\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2018-06-08 13:39:39\";s:6:\"status\";s:1:\"1\";}i:5;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"12\";s:5:\"label\";s:5:\"sales\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:19:\"fa fa-shopping-cart\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"9\";s:4:\"time\";s:19:\"2017-06-10 14:02:58\";s:6:\"status\";s:1:\"1\";}i:6;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"13\";s:5:\"label\";s:7:\"invoice\";s:4:\"link\";s:28:\"admin/invoice/manage_invoice\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-04-23 19:57:23\";s:6:\"status\";s:1:\"1\";}i:7;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"14\";s:5:\"label\";s:9:\"estimates\";s:4:\"link\";s:15:\"admin/estimates\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-06-10 14:02:05\";s:6:\"status\";s:1:\"1\";}i:8;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"15\";s:5:\"label\";s:17:\"payments_received\";s:4:\"link\";s:26:\"admin/invoice/all_payments\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-23 19:57:24\";s:6:\"status\";s:1:\"1\";}i:9;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"16\";s:5:\"label\";s:9:\"tax_rates\";s:4:\"link\";s:23:\"admin/invoice/tax_rates\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-01-07 07:05:16\";s:6:\"status\";s:1:\"1\";}i:10;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"21\";s:5:\"label\";s:10:\"quotations\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:11:\"fa fa-paste\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:11;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"22\";s:5:\"label\";s:15:\"quotations_list\";s:4:\"link\";s:16:\"admin/quotations\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"21\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-05-18 16:49:03\";s:6:\"status\";s:1:\"1\";}i:12;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"23\";s:5:\"label\";s:15:\"quotations_form\";s:4:\"link\";s:32:\"admin/quotations/quotations_form\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"21\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:13;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"24\";s:5:\"label\";s:4:\"user\";s:4:\"link\";s:20:\"admin/user/user_list\";s:4:\"icon\";s:11:\"fa fa-users\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"25\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:14;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"25\";s:5:\"label\";s:8:\"settings\";s:4:\"link\";s:14:\"admin/settings\";s:4:\"icon\";s:10:\"fa fa-cogs\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"26\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:15;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"26\";s:5:\"label\";s:15:\"database_backup\";s:4:\"link\";s:30:\"admin/settings/database_backup\";s:4:\"icon\";s:14:\"fa fa-database\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"27\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:16;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"29\";s:5:\"label\";s:17:\"transactions_menu\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:16:\"fa fa-building-o\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"12\";s:4:\"time\";s:19:\"2018-05-13 12:27:58\";s:6:\"status\";s:1:\"1\";}i:17;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"30\";s:5:\"label\";s:7:\"deposit\";s:4:\"link\";s:26:\"admin/transactions/deposit\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-05-13 12:28:33\";s:6:\"status\";s:1:\"1\";}i:18;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"31\";s:5:\"label\";s:7:\"expense\";s:4:\"link\";s:26:\"admin/transactions/expense\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-05-13 12:28:37\";s:6:\"status\";s:1:\"1\";}i:19;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"32\";s:5:\"label\";s:8:\"transfer\";s:4:\"link\";s:27:\"admin/transactions/transfer\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-05-13 12:28:40\";s:6:\"status\";s:1:\"1\";}i:20;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"33\";s:5:\"label\";s:19:\"transactions_report\";s:4:\"link\";s:38:\"admin/transactions/transactions_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2018-05-13 12:28:44\";s:6:\"status\";s:1:\"1\";}i:21;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"34\";s:5:\"label\";s:13:\"balance_sheet\";s:4:\"link\";s:32:\"admin/transactions/balance_sheet\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-05-13 12:28:47\";s:6:\"status\";s:1:\"1\";}i:22;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"36\";s:5:\"label\";s:9:\"bank_cash\";s:4:\"link\";s:28:\"admin/account/manage_account\";s:4:\"icon\";s:11:\"fa fa-money\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2018-05-13 12:28:51\";s:6:\"status\";s:1:\"1\";}i:23;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"39\";s:5:\"label\";s:5:\"items\";s:4:\"link\";s:22:\"admin/items/items_list\";s:4:\"icon\";s:10:\"fa fa-cube\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2019-05-04 18:49:50\";s:6:\"status\";s:1:\"1\";}i:24;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"42\";s:5:\"label\";s:6:\"report\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:15:\"fa fa-bar-chart\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"24\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:25;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"43\";s:5:\"label\";s:17:\"account_statement\";s:4:\"link\";s:30:\"admin/report/account_statement\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:26;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"44\";s:5:\"label\";s:13:\"income_report\";s:4:\"link\";s:26:\"admin/report/income_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:27;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"45\";s:5:\"label\";s:14:\"expense_report\";s:4:\"link\";s:27:\"admin/report/expense_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:28;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"46\";s:5:\"label\";s:14:\"income_expense\";s:4:\"link\";s:27:\"admin/report/income_expense\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:29;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"47\";s:5:\"label\";s:16:\"date_wise_report\";s:4:\"link\";s:29:\"admin/report/date_wise_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:30;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"48\";s:5:\"label\";s:10:\"all_income\";s:4:\"link\";s:23:\"admin/report/all_income\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:31;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"49\";s:5:\"label\";s:11:\"all_expense\";s:4:\"link\";s:24:\"admin/report/all_expense\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:32;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"50\";s:5:\"label\";s:15:\"all_transaction\";s:4:\"link\";s:28:\"admin/report/all_transaction\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:33;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"51\";s:5:\"label\";s:17:\"recurring_invoice\";s:4:\"link\";s:31:\"admin/invoice/recurring_invoice\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-06-10 14:02:05\";s:6:\"status\";s:1:\"1\";}i:34;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"52\";s:5:\"label\";s:15:\"transfer_report\";s:4:\"link\";s:34:\"admin/transactions/transfer_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"29\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-05-13 12:28:59\";s:6:\"status\";s:1:\"1\";}i:35;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"53\";s:5:\"label\";s:15:\"report_by_month\";s:4:\"link\";s:28:\"admin/report/report_by_month\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"146\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:36;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"54\";s:5:\"label\";s:5:\"tasks\";s:4:\"link\";s:20:\"admin/tasks/all_task\";s:4:\"icon\";s:11:\"fa fa-tasks\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:37;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"55\";s:5:\"label\";s:5:\"leads\";s:4:\"link\";s:11:\"admin/leads\";s:4:\"icon\";s:12:\"fa fa-rocket\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:38;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"56\";s:5:\"label\";s:13:\"opportunities\";s:4:\"link\";s:19:\"admin/opportunities\";s:4:\"icon\";s:12:\"fa fa-filter\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:39;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"57\";s:5:\"label\";s:8:\"projects\";s:4:\"link\";s:14:\"admin/projects\";s:4:\"icon\";s:19:\"fa fa-folder-open-o\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:40;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"58\";s:5:\"label\";s:4:\"bugs\";s:4:\"link\";s:10:\"admin/bugs\";s:4:\"icon\";s:9:\"fa fa-bug\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:41;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"59\";s:5:\"label\";s:7:\"project\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:19:\"fa fa-folder-open-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:42;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"60\";s:5:\"label\";s:12:\"tasks_report\";s:4:\"link\";s:25:\"admin/report/tasks_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:43;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"61\";s:5:\"label\";s:11:\"bugs_report\";s:4:\"link\";s:24:\"admin/report/bugs_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:44;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"62\";s:5:\"label\";s:14:\"tickets_report\";s:4:\"link\";s:27:\"admin/report/tickets_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-01-07 07:09:39\";s:6:\"status\";s:1:\"1\";}i:45;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"63\";s:5:\"label\";s:13:\"client_report\";s:4:\"link\";s:26:\"admin/report/client_report\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2018-01-07 07:09:40\";s:6:\"status\";s:1:\"1\";}i:46;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"66\";s:5:\"label\";s:16:\"tasks_assignment\";s:4:\"link\";s:29:\"admin/report/tasks_assignment\";s:4:\"icon\";s:18:\"fa fa-dot-circle-o\";s:6:\"parent\";s:2:\"59\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:47;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"67\";s:5:\"label\";s:15:\"bugs_assignment\";s:4:\"link\";s:28:\"admin/report/bugs_assignment\";s:4:\"icon\";s:18:\"fa fa-dot-circle-o\";s:6:\"parent\";s:2:\"59\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:48;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"68\";s:5:\"label\";s:14:\"project_report\";s:4:\"link\";s:27:\"admin/report/project_report\";s:4:\"icon\";s:18:\"fa fa-dot-circle-o\";s:6:\"parent\";s:2:\"59\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:49;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"69\";s:5:\"label\";s:13:\"goal_tracking\";s:4:\"link\";s:19:\"admin/goal_tracking\";s:4:\"icon\";s:12:\"fa fa-shield\";s:6:\"parent\";s:2:\"73\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-06-10 14:05:47\";s:6:\"status\";s:1:\"1\";}i:50;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"70\";s:5:\"label\";s:11:\"departments\";s:4:\"link\";s:17:\"admin/departments\";s:4:\"icon\";s:17:\"fa fa-user-secret\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"14\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:51;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"71\";s:5:\"label\";s:7:\"holiday\";s:4:\"link\";s:13:\"admin/holiday\";s:4:\"icon\";s:21:\"fa fa-calendar-plus-o\";s:6:\"parent\";s:2:\"73\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-06-10 14:05:47\";s:6:\"status\";s:1:\"1\";}i:52;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"72\";s:5:\"label\";s:16:\"leave_management\";s:4:\"link\";s:22:\"admin/leave_management\";s:4:\"icon\";s:11:\"fa fa-plane\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"20\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:53;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"73\";s:5:\"label\";s:9:\"utilities\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:10:\"fa fa-gift\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"23\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:54;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"74\";s:5:\"label\";s:8:\"overtime\";s:4:\"link\";s:24:\"admin/utilities/overtime\";s:4:\"icon\";s:13:\"fa fa-clock-o\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"9\";s:4:\"time\";s:19:\"2017-06-10 14:04:23\";s:6:\"status\";s:1:\"1\";}i:55;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"75\";s:5:\"label\";s:12:\"office_stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:13:\"fa fa-codepen\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"15\";s:4:\"time\";s:19:\"2019-05-01 16:22:56\";s:6:\"status\";s:1:\"1\";}i:56;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"76\";s:5:\"label\";s:14:\"stock_category\";s:4:\"link\";s:26:\"admin/stock/stock_category\";s:4:\"icon\";s:13:\"fa fa-sliders\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:57;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"77\";s:5:\"label\";s:12:\"manage_stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:13:\"fa fa-archive\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-04-26 16:11:10\";s:6:\"status\";s:1:\"1\";}i:58;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"78\";s:5:\"label\";s:12:\"assign_stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:16:\"fa fa-align-left\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-26 16:11:10\";s:6:\"status\";s:1:\"1\";}i:59;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"79\";s:5:\"label\";s:12:\"stock_report\";s:4:\"link\";s:18:\"admin/stock/report\";s:4:\"icon\";s:16:\"fa fa-line-chart\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2017-04-25 18:48:25\";s:6:\"status\";s:1:\"1\";}i:60;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"81\";s:5:\"label\";s:10:\"stock_list\";s:4:\"link\";s:22:\"admin/stock/stock_list\";s:4:\"icon\";s:20:\"fa fa-stack-exchange\";s:6:\"parent\";s:2:\"75\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-26 16:11:10\";s:6:\"status\";s:1:\"1\";}i:61;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"82\";s:5:\"label\";s:12:\"assign_stock\";s:4:\"link\";s:24:\"admin/stock/assign_stock\";s:4:\"icon\";s:16:\"fa fa-align-left\";s:6:\"parent\";s:2:\"78\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:62;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"83\";s:5:\"label\";s:19:\"assign_stock_report\";s:4:\"link\";s:31:\"admin/stock/assign_stock_report\";s:4:\"icon\";s:15:\"fa fa-bar-chart\";s:6:\"parent\";s:2:\"78\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:63;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"84\";s:5:\"label\";s:13:\"stock_history\";s:4:\"link\";s:25:\"admin/stock/stock_history\";s:4:\"icon\";s:17:\"fa fa-file-text-o\";s:6:\"parent\";s:2:\"77\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:55:02\";s:6:\"status\";s:1:\"1\";}i:64;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"85\";s:5:\"label\";s:11:\"performance\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:14:\"fa fa-dribbble\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"19\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:65;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"86\";s:5:\"label\";s:21:\"performance_indicator\";s:4:\"link\";s:39:\"admin/performance/performance_indicator\";s:4:\"icon\";s:12:\"fa fa-random\";s:6:\"parent\";s:2:\"85\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:66;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"87\";s:5:\"label\";s:18:\"performance_report\";s:4:\"link\";s:36:\"admin/performance/performance_report\";s:4:\"icon\";s:16:\"fa fa-calendar-o\";s:6:\"parent\";s:2:\"85\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:67;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"88\";s:5:\"label\";s:14:\"give_appraisal\";s:4:\"link\";s:44:\"admin/performance/give_performance_appraisal\";s:4:\"icon\";s:10:\"fa fa-plus\";s:6:\"parent\";s:2:\"85\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:23\";s:6:\"status\";s:1:\"1\";}i:68;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"89\";s:5:\"label\";s:7:\"payroll\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:9:\"fa fa-usd\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"18\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:69;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"90\";s:5:\"label\";s:21:\"manage_salary_details\";s:4:\"link\";s:35:\"admin/payroll/manage_salary_details\";s:4:\"icon\";s:9:\"fa fa-usd\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:70;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"91\";s:5:\"label\";s:20:\"employee_salary_list\";s:4:\"link\";s:34:\"admin/payroll/employee_salary_list\";s:4:\"icon\";s:17:\"fa fa-user-secret\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:71;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"92\";s:5:\"label\";s:12:\"make_payment\";s:4:\"link\";s:26:\"admin/payroll/make_payment\";s:4:\"icon\";s:11:\"fa fa-tasks\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:72;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"93\";s:5:\"label\";s:16:\"generate_payslip\";s:4:\"link\";s:30:\"admin/payroll/generate_payslip\";s:4:\"icon\";s:13:\"fa fa-list-ul\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:73;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"94\";s:5:\"label\";s:15:\"salary_template\";s:4:\"link\";s:29:\"admin/payroll/salary_template\";s:4:\"icon\";s:11:\"fa fa-money\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:74;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"95\";s:5:\"label\";s:11:\"hourly_rate\";s:4:\"link\";s:25:\"admin/payroll/hourly_rate\";s:4:\"icon\";s:13:\"fa fa-clock-o\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:75;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"96\";s:5:\"label\";s:15:\"payroll_summary\";s:4:\"link\";s:29:\"admin/payroll/payroll_summary\";s:4:\"icon\";s:18:\"fa fa-camera-retro\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2017-04-23 08:06:37\";s:6:\"status\";s:1:\"1\";}i:76;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"97\";s:5:\"label\";s:14:\"provident_fund\";s:4:\"link\";s:28:\"admin/payroll/provident_fund\";s:4:\"icon\";s:15:\"fa fa-briefcase\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2017-06-10 14:04:23\";s:6:\"status\";s:1:\"1\";}i:77;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"98\";s:5:\"label\";s:14:\"advance_salary\";s:4:\"link\";s:28:\"admin/payroll/advance_salary\";s:4:\"icon\";s:19:\"fa fa-cc-mastercard\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2017-06-10 14:04:23\";s:6:\"status\";s:1:\"1\";}i:78;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"99\";s:5:\"label\";s:14:\"employee_award\";s:4:\"link\";s:11:\"admin/award\";s:4:\"icon\";s:12:\"fa fa-trophy\";s:6:\"parent\";s:2:\"89\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2017-06-10 14:05:47\";s:6:\"status\";s:1:\"1\";}i:79;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"100\";s:5:\"label\";s:13:\"announcements\";s:4:\"link\";s:19:\"admin/announcements\";s:4:\"icon\";s:19:\"fa fa-bullhorn icon\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"22\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:80;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"101\";s:5:\"label\";s:8:\"training\";s:4:\"link\";s:14:\"admin/training\";s:4:\"icon\";s:14:\"fa fa-suitcase\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"21\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:81;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"102\";s:5:\"label\";s:12:\"job_circular\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:11:\"fa fa-globe\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"17\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:82;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"103\";s:5:\"label\";s:11:\"jobs_posted\";s:4:\"link\";s:30:\"admin/job_circular/jobs_posted\";s:4:\"icon\";s:12:\"fa fa-ticket\";s:6:\"parent\";s:3:\"102\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:83;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"104\";s:5:\"label\";s:17:\"jobs_applications\";s:4:\"link\";s:36:\"admin/job_circular/jobs_applications\";s:4:\"icon\";s:13:\"fa fa-compass\";s:6:\"parent\";s:3:\"102\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:84;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"105\";s:5:\"label\";s:10:\"attendance\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:15:\"fa fa-file-text\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"16\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:85;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"106\";s:5:\"label\";s:18:\"timechange_request\";s:4:\"link\";s:35:\"admin/attendance/timechange_request\";s:4:\"icon\";s:16:\"fa fa-calendar-o\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:86;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"107\";s:5:\"label\";s:17:\"attendance_report\";s:4:\"link\";s:34:\"admin/attendance/attendance_report\";s:4:\"icon\";s:15:\"fa fa-file-text\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:87;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"108\";s:5:\"label\";s:12:\"time_history\";s:4:\"link\";s:29:\"admin/attendance/time_history\";s:4:\"icon\";s:13:\"fa fa-clock-o\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-30 08:50:21\";s:6:\"status\";s:1:\"1\";}i:88;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"109\";s:5:\"label\";s:9:\"pull-down\";s:4:\"link\";s:0:\"\";s:4:\"icon\";s:0:\"\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2016-05-31 12:43:20\";s:6:\"status\";s:1:\"0\";}i:89;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"110\";s:5:\"label\";s:11:\"filemanager\";s:4:\"link\";s:17:\"admin/filemanager\";s:4:\"icon\";s:10:\"fa fa-file\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:90;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"111\";s:5:\"label\";s:15:\"company_details\";s:4:\"link\";s:14:\"admin/settings\";s:4:\"icon\";s:23:\"fa fa-fw fa-info-circle\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-25 17:08:46\";s:6:\"status\";s:1:\"2\";}i:91;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"112\";s:5:\"label\";s:15:\"system_settings\";s:4:\"link\";s:21:\"admin/settings/system\";s:4:\"icon\";s:19:\"fa fa-fw fa-desktop\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-04-25 17:08:46\";s:6:\"status\";s:1:\"2\";}i:92;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"113\";s:5:\"label\";s:14:\"email_settings\";s:4:\"link\";s:20:\"admin/settings/email\";s:4:\"icon\";s:20:\"fa fa-fw fa-envelope\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-25 17:08:46\";s:6:\"status\";s:1:\"2\";}i:93;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"114\";s:5:\"label\";s:15:\"email_templates\";s:4:\"link\";s:24:\"admin/settings/templates\";s:4:\"icon\";s:25:\"fa fa-fw fa-pencil-square\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2021-07-30 06:18:08\";s:6:\"status\";s:1:\"2\";}i:94;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"115\";s:5:\"label\";s:17:\"email_integration\";s:4:\"link\";s:32:\"admin/settings/email_integration\";s:4:\"icon\";s:22:\"fa fa-fw fa-envelope-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2021-07-30 06:18:08\";s:6:\"status\";s:1:\"2\";}i:95;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"116\";s:5:\"label\";s:16:\"payment_settings\";s:4:\"link\";s:23:\"admin/settings/payments\";s:4:\"icon\";s:18:\"fa fa-fw fa-dollar\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:96;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"117\";s:5:\"label\";s:16:\"invoice_settings\";s:4:\"link\";s:22:\"admin/settings/invoice\";s:4:\"icon\";s:17:\"fa fa-fw fa-money\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:97;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"118\";s:5:\"label\";s:17:\"estimate_settings\";s:4:\"link\";s:23:\"admin/settings/estimate\";s:4:\"icon\";s:18:\"fa fa-fw fa-file-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:98;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"119\";s:5:\"label\";s:22:\"tickets_leads_settings\";s:4:\"link\";s:22:\"admin/settings/tickets\";s:4:\"icon\";s:18:\"fa fa-fw fa-ticket\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"14\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:99;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"120\";s:5:\"label\";s:14:\"theme_settings\";s:4:\"link\";s:20:\"admin/settings/theme\";s:4:\"icon\";s:16:\"fa fa-fw fa-code\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"20\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:100;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"121\";s:5:\"label\";s:12:\"working_days\";s:4:\"link\";s:27:\"admin/settings/working_days\";s:4:\"icon\";s:20:\"fa fa-fw fa-calendar\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"22\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:101;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"122\";s:5:\"label\";s:14:\"leave_category\";s:4:\"link\";s:29:\"admin/settings/leave_category\";s:4:\"icon\";s:21:\"fa fa-fw fa-pagelines\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"23\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:102;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"123\";s:5:\"label\";s:15:\"income_category\";s:4:\"link\";s:30:\"admin/settings/income_category\";s:4:\"icon\";s:23:\"fa fa-fw fa-certificate\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"24\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:103;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"124\";s:5:\"label\";s:16:\"expense_category\";s:4:\"link\";s:31:\"admin/settings/expense_category\";s:4:\"icon\";s:17:\"fa fa-fw fa-tasks\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"25\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:104;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"125\";s:5:\"label\";s:14:\"customer_group\";s:4:\"link\";s:29:\"admin/settings/customer_group\";s:4:\"icon\";s:17:\"fa fa-fw fa-users\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"26\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:105;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"127\";s:5:\"label\";s:11:\"lead_status\";s:4:\"link\";s:26:\"admin/settings/lead_status\";s:4:\"icon\";s:19:\"fa fa-fw fa-list-ul\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"16\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:106;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"128\";s:5:\"label\";s:11:\"lead_source\";s:4:\"link\";s:26:\"admin/settings/lead_source\";s:4:\"icon\";s:22:\"fa fa-fw fa-arrow-down\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"17\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:107;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"129\";s:5:\"label\";s:26:\"opportunities_state_reason\";s:4:\"link\";s:41:\"admin/settings/opportunities_state_reason\";s:4:\"icon\";s:24:\"fa fa-fw fa-dot-circle-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"19\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:108;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"130\";s:5:\"label\";s:12:\"custom_field\";s:4:\"link\";s:27:\"admin/settings/custom_field\";s:4:\"icon\";s:18:\"fa fa-fw fa-star-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"28\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:109;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"131\";s:5:\"label\";s:14:\"payment_method\";s:4:\"link\";s:29:\"admin/settings/payment_method\";s:4:\"icon\";s:17:\"fa fa-fw fa-money\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"29\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:110;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"132\";s:5:\"label\";s:7:\"cronjob\";s:4:\"link\";s:22:\"admin/settings/cronjob\";s:4:\"icon\";s:18:\"fa fa-fw fa-contao\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"31\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:111;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"133\";s:5:\"label\";s:15:\"menu_allocation\";s:4:\"link\";s:30:\"admin/settings/menu_allocation\";s:4:\"icon\";s:22:\"fa fa-fw fa fa-compass\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"32\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:112;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"134\";s:5:\"label\";s:12:\"notification\";s:4:\"link\";s:27:\"admin/settings/notification\";s:4:\"icon\";s:18:\"fa fa-fw fa-bell-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"33\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:113;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"135\";s:5:\"label\";s:18:\"email_notification\";s:4:\"link\";s:33:\"admin/settings/email_notification\";s:4:\"icon\";s:18:\"fa fa-fw fa-bell-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"34\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:114;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"136\";s:5:\"label\";s:15:\"database_backup\";s:4:\"link\";s:30:\"admin/settings/database_backup\";s:4:\"icon\";s:20:\"fa fa-fw fa-database\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"35\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:115;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"137\";s:5:\"label\";s:12:\"translations\";s:4:\"link\";s:27:\"admin/settings/translations\";s:4:\"icon\";s:20:\"fa fa-fw fa-language\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"36\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:116;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"138\";s:5:\"label\";s:13:\"system_update\";s:4:\"link\";s:28:\"admin/settings/system_update\";s:4:\"icon\";s:27:\"fa fa-fw fa-pencil-square-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"37\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:117;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"139\";s:5:\"label\";s:12:\"private_chat\";s:4:\"link\";s:18:\"chat/conversations\";s:4:\"icon\";s:14:\"fa fa-envelope\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"28\";s:4:\"time\";s:19:\"2018-01-07 07:05:18\";s:6:\"status\";s:1:\"1\";}i:118;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"140\";s:5:\"label\";s:9:\"proposals\";s:4:\"link\";s:15:\"admin/proposals\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2018-01-07 07:05:16\";s:6:\"status\";s:1:\"1\";}i:119;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"141\";s:5:\"label\";s:13:\"knowledgebase\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:21:\"fa fa-question-circle\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"11\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:120;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"142\";s:5:\"label\";s:10:\"categories\";s:4:\"link\";s:30:\"admin/knowledgebase/categories\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"141\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:121;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"143\";s:5:\"label\";s:8:\"articles\";s:4:\"link\";s:28:\"admin/knowledgebase/articles\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"141\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:122;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"144\";s:5:\"label\";s:13:\"knowledgebase\";s:4:\"link\";s:19:\"admin/knowledgebase\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"141\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:123;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"145\";s:5:\"label\";s:18:\"dashboard_settings\";s:4:\"link\";s:24:\"admin/settings/dashboard\";s:4:\"icon\";s:21:\"fa fa-fw fa-dashboard\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"21\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:124;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"146\";s:5:\"label\";s:20:\"transactions_reports\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:16:\"fa fa-building-o\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2018-05-13 12:29:51\";s:6:\"status\";s:1:\"1\";}i:125;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"147\";s:5:\"label\";s:5:\"sales\";s:4:\"link\";s:25:\"admin/report/sales_report\";s:4:\"icon\";s:19:\"fa fa-shopping-cart\";s:6:\"parent\";s:2:\"42\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2018-01-07 01:12:23\";s:6:\"status\";s:1:\"1\";}i:126;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"148\";s:5:\"label\";s:15:\"mark_attendance\";s:4:\"link\";s:21:\"admin/mark_attendance\";s:4:\"icon\";s:15:\"fa fa-file-text\";s:6:\"parent\";s:3:\"105\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2018-03-07 06:45:25\";s:6:\"status\";s:1:\"1\";}i:127;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"149\";s:5:\"label\";s:10:\"allowed_ip\";s:4:\"link\";s:25:\"admin/settings/allowed_ip\";s:4:\"icon\";s:12:\"fa fa-server\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"27\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:128;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"150\";s:5:\"label\";s:5:\"stock\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:11:\"icon-layers\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"8\";s:4:\"time\";s:19:\"2019-05-01 18:10:52\";s:6:\"status\";s:1:\"1\";}i:129;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"151\";s:5:\"label\";s:8:\"supplier\";s:4:\"link\";s:14:\"admin/supplier\";s:4:\"icon\";s:14:\"icon-briefcase\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2019-05-01 18:10:52\";s:6:\"status\";s:1:\"1\";}i:130;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"152\";s:5:\"label\";s:8:\"purchase\";s:4:\"link\";s:14:\"admin/purchase\";s:4:\"icon\";s:12:\"icon-handbag\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2019-05-01 18:10:52\";s:6:\"status\";s:1:\"1\";}i:131;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"153\";s:5:\"label\";s:12:\"return_stock\";s:4:\"link\";s:18:\"admin/return_stock\";s:4:\"icon\";s:14:\"icon-share-alt\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2019-05-05 16:19:30\";s:6:\"status\";s:1:\"1\";}i:132;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"154\";s:5:\"label\";s:16:\"purchase_payment\";s:4:\"link\";s:27:\"admin/purchase/all_payments\";s:4:\"icon\";s:16:\"icon-credit-card\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2019-05-05 13:53:11\";s:6:\"status\";s:1:\"1\";}i:133;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"155\";s:5:\"label\";s:17:\"purchase_settings\";s:4:\"link\";s:23:\"admin/settings/purchase\";s:4:\"icon\";s:18:\"fa-fw icon-handbag\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"12\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:134;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"156\";s:5:\"label\";s:11:\"credit_note\";s:4:\"link\";s:17:\"admin/credit_note\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-06-10 02:32:05\";s:6:\"status\";s:1:\"1\";}i:135;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"157\";s:5:\"label\";s:20:\"credit_note_settings\";s:4:\"link\";s:26:\"admin/settings/credit_note\";s:4:\"icon\";s:17:\"fa fa-fw fa-money\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"9\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:136;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"158\";s:5:\"label\";s:18:\"proposals_settings\";s:4:\"link\";s:24:\"admin/settings/proposals\";s:4:\"icon\";s:16:\"fa fa-fw fa-leaf\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"11\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:137;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"159\";s:5:\"label\";s:17:\"projects_settings\";s:4:\"link\";s:23:\"admin/settings/projects\";s:4:\"icon\";s:25:\"fa fa-fw fa-folder-open-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"13\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:138;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"160\";s:5:\"label\";s:4:\"tags\";s:4:\"link\";s:19:\"admin/settings/tags\";s:4:\"icon\";s:16:\"fa fa-fw fa-tags\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"30\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:139;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"161\";s:5:\"label\";s:9:\"lead_form\";s:4:\"link\";s:25:\"admin/leads/all_lead_form\";s:4:\"icon\";s:18:\"fa fa-fw fa-rocket\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"18\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:140;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"162\";s:5:\"label\";s:21:\"transactions_settings\";s:4:\"link\";s:27:\"admin/settings/transactions\";s:4:\"icon\";s:22:\"fa fa-fw fa-building-o\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"15\";s:4:\"time\";s:19:\"2021-07-30 06:18:09\";s:6:\"status\";s:1:\"2\";}i:141;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"163\";s:5:\"label\";s:12:\"sms_settings\";s:4:\"link\";s:27:\"admin/settings/sms_settings\";s:4:\"icon\";s:20:\"fa fa-fw fa-envelope\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2021-07-30 06:18:08\";s:6:\"status\";s:1:\"2\";}i:142;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"164\";s:5:\"label\";s:9:\"pos_sales\";s:4:\"link\";s:23:\"admin/invoice/pos_sales\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2021-10-16 00:53:10\";s:6:\"status\";s:1:\"1\";}i:143;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"186\";s:5:\"label\";s:9:\"warehouse\";s:4:\"link\";s:22:\"admin/warehouse/manage\";s:4:\"icon\";s:16:\"fa fa-building-o\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2021-10-18 09:24:24\";s:6:\"status\";s:1:\"1\";}i:144;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"187\";s:5:\"label\";s:12:\"transferItem\";s:4:\"link\";s:24:\"admin/items/transferItem\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:3:\"150\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2021-10-14 11:56:08\";s:6:\"status\";s:1:\"1\";}i:145;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"203\";s:5:\"label\";s:13:\"award_setting\";s:4:\"link\";s:20:\"admin/settings/award\";s:4:\"icon\";s:10:\"fa fa-star\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"30\";s:4:\"time\";s:19:\"2022-01-19 05:51:40\";s:6:\"status\";s:1:\"2\";}i:146;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"204\";s:5:\"label\";s:18:\"award_rule_setting\";s:4:\"link\";s:34:\"admin/settings/award_rule_settingh\";s:4:\"icon\";s:10:\"fa fa-star\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"31\";s:4:\"time\";s:19:\"2022-01-19 09:53:50\";s:6:\"status\";s:1:\"2\";}i:147;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"205\";s:5:\"label\";s:22:\"award_program_settings\";s:4:\"link\";s:37:\"admin/settings/award_program_settings\";s:4:\"icon\";s:9:\"fa fa-cog\";s:6:\"parent\";s:2:\"25\";s:4:\"sort\";s:2:\"32\";s:4:\"time\";s:19:\"2022-01-20 09:17:30\";s:6:\"status\";s:1:\"2\";}i:148;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"206\";s:5:\"label\";s:19:\"client_award_points\";s:4:\"link\";s:27:\"admin/invoice/client_awards\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2022-01-21 01:39:41\";s:6:\"status\";s:1:\"1\";}i:149;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"207\";s:5:\"label\";s:20:\"best_selling_product\";s:4:\"link\";s:18:\"admin/best_selling\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:2:\"11\";s:4:\"time\";s:19:\"2022-01-21 06:43:52\";s:6:\"status\";s:1:\"1\";}i:150;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"209\";s:5:\"label\";s:7:\"warning\";s:4:\"link\";s:13:\"admin/warning\";s:4:\"icon\";s:13:\"fa fa-warning\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2022-08-07 12:47:01\";s:6:\"status\";s:1:\"1\";}i:151;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"210\";s:5:\"label\";s:9:\"promotion\";s:4:\"link\";s:15:\"admin/promotion\";s:4:\"icon\";s:21:\"fa fa-arrow-circle-up\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"4\";s:4:\"time\";s:19:\"2022-08-07 12:49:28\";s:6:\"status\";s:1:\"1\";}i:152;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"211\";s:5:\"label\";s:11:\"termination\";s:4:\"link\";s:17:\"admin/termination\";s:4:\"icon\";s:12:\"fa fa-eraser\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2022-08-07 12:50:45\";s:6:\"status\";s:1:\"1\";}i:153;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:3:\"212\";s:5:\"label\";s:11:\"resignation\";s:4:\"link\";s:17:\"admin/resignation\";s:4:\"icon\";s:14:\"fa fa-scissors\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"6\";s:4:\"time\";s:19:\"2022-08-07 12:54:31\";s:6:\"status\";s:1:\"1\";}}');
INSERT INTO `tbl_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('54e6ebb7e45a65d085ba1f459b1e6d0a5b18efc2', '136.158.121.2', 1689136866, '__ci_last_regenerate|i:1689136866;menu_active_id|a:2:{i:0;s:2:\"25\";i:1;s:1:\"0\";}user_name|s:5:\"nimda\";email|s:26:\"erick@blickcreative.com.au\";name|s:13:\"Erick Villeta\";photo|s:26:\"uploads/default_avatar.jpg\";user_id|s:1:\"5\";last_login|s:19:\"2023-07-10 11:54:34\";online_time|i:1689133478;loggedin|b:1;user_type|s:1:\"1\";user_flag|s:1:\"1\";direction|s:3:\"ltr\";warehouse_id|N;designations_id|s:1:\"0\";url|s:33:\"admin/dashboard/pinned_menu_items\";user_roll|a:154:{i:0;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"1\";s:5:\"label\";s:9:\"dashboard\";s:4:\"link\";s:15:\"admin/dashboard\";s:4:\"icon\";s:15:\"fa fa-dashboard\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-04-23 01:39:36\";s:6:\"status\";s:1:\"1\";}i:1;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"2\";s:5:\"label\";s:8:\"calendar\";s:4:\"link\";s:14:\"admin/calendar\";s:4:\"icon\";s:14:\"fa fa-calendar\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-04-23 19:57:23\";s:6:\"status\";s:1:\"1\";}i:2;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"4\";s:5:\"label\";s:6:\"client\";s:4:\"link\";s:26:\"admin/client/manage_client\";s:4:\"icon\";s:11:\"fa fa-users\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"13\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:3;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"5\";s:5:\"label\";s:7:\"mailbox\";s:4:\"link\";s:13:\"admin/mailbox\";s:4:\"icon\";s:16:\"fa fa-envelope-o\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"2\";s:4:\"time\";s:19:\"2017-06-10 14:16:25\";s:6:\"status\";s:1:\"1\";}i:4;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:1:\"6\";s:5:\"label\";s:7:\"tickets\";s:4:\"link\";s:13:\"admin/tickets\";s:4:\"icon\";s:12:\"fa fa-ticket\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:2:\"10\";s:4:\"time\";s:19:\"2018-06-08 13:39:39\";s:6:\"status\";s:1:\"1\";}i:5;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"12\";s:5:\"label\";s:5:\"sales\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:19:\"fa fa-shopping-cart\";s:6:\"parent\";s:1:\"0\";s:4:\"sort\";s:1:\"9\";s:4:\"time\";s:19:\"2017-06-10 14:02:58\";s:6:\"status\";s:1:\"1\";}i:6;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"13\";s:5:\"label\";s:7:\"invoice\";s:4:\"link\";s:28:\"admin/invoice/manage_invoice\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-04-23 19:57:23\";s:6:\"status\";s:1:\"1\";}i:7;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"14\";s:5:\"label\";s:9:\"estimates\";s:4:\"link\";s:15:\"admin/estimates\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"1\";s:4:\"time\";s:19:\"2017-06-10 14:02:05\";s:6:\"status\";s:1:\"1\";}i:8;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"15\";s:5:\"label\";s:17:\"payments_received\";s:4:\"link\";s:26:\"admin/invoice/all_payments\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"3\";s:4:\"time\";s:19:\"2017-04-23 19:57:24\";s:6:\"status\";s:1:\"1\";}i:9;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"16\";s:5:\"label\";s:9:\"tax_rates\";s:4:\"link\";s:23:\"admin/invoice/tax_rates\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"5\";s:4:\"time\";s:19:\"2018-01-07 07:05:16\";s:6:\"status\";s:1:\"1\";}i:10;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"21\";s:5:\"label\";s:10:\"quotations\";s:4:\"link\";s:1:\"#\";s:4:\"icon\";s:11:\"fa fa-paste\";s:6:\"parent\";s:2:\"12\";s:4:\"sort\";s:1:\"7\";s:4:\"time\";s:19:\"2018-01-07 07:05:17\";s:6:\"status\";s:1:\"1\";}i:11;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"22\";s:5:\"label\";s:15:\"quotations_list\";s:4:\"link\";s:16:\"admin/quotations\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"21\";s:4:\"sort\";s:1:\"0\";s:4:\"time\";s:19:\"2017-05-18 16:49:03\";s:6:\"status\";s:1:\"1\";}i:12;O:8:\"stdClass\":8:{s:7:\"menu_id\";s:2:\"23\";s:5:\"label\";s:15:\"quotations_form\";s:4:\"link\";s:32:\"admin/quotations/quotations_form\";s:4:\"icon\";s:14:\"fa fa-circle-o\";s:6:\"parent\";s:2:\"21\";s:4:\"sort\";s:1:\"1\";s:4:\"